/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.biesenbach;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramVarUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AlphaSolver<INLOC extends IcfgLocation> {
    private final UnmodifiableTransFormula mOriginalTransFormula;
    private final ILogger mLogger;
    private final Map<Integer, Map<Term, Term>> mMatrix;
    private final Map<Integer, Map<Term, Term>> mLGS;
    private final IProgramVar[] mProgramVar;
    private final Script mScript;
    private final ManagedScript mMgScript;
    private List<Term> mVectorTerms;
    private Map<IProgramVar, TermVariable[]> mAlphaMap;
    private final TermVariable[] mAlphaN = new TermVariable[2];
    private final Map<Term, Term> mAlphaDefaultConstant = new HashMap<Term, Term>();
    private TermVariable mNVar;
    private Term mFinalTerm;
    private final Map<IProgramVar, Term> mValues = new HashMap<IProgramVar, Term>();

    public AlphaSolver(ILogger logger, UnmodifiableTransFormula loopTransFormula, ManagedScript script, Map<Integer, Map<Term, Term>> matrix, Map<Integer, Map<Term, Term>> lgs, IUltimateServiceProvider service, int loopCounter) {
        this.mMgScript = script;
        this.mScript = this.mMgScript.getScript();
        this.mOriginalTransFormula = loopTransFormula;
        this.mLogger = logger;
        Set programVar = this.mOriginalTransFormula.getAssignedVars();
        this.mProgramVar = programVar.toArray(new IProgramVar[programVar.size()]);
        this.mMatrix = matrix;
        this.mLGS = lgs;
        this.mMgScript.lock((Object)this);
        this.initAlphas(loopCounter);
        ArrayList<Term> finalTerms = new ArrayList<Term>();
        IProgramVar[] iProgramVarArray = this.mProgramVar;
        int n = this.mProgramVar.length;
        int n2 = 0;
        while (n2 < n) {
            IProgramVar pVar = iProgramVarArray[n2];
            this.mVectorTerms = new ArrayList<Term>();
            this.lgsTermN0(pVar);
            this.lgsTermN1(pVar);
            this.lgsTermN2(pVar);
            Term lgsTerm = this.mScript.term("and", this.mVectorTerms.toArray(new Term[this.mVectorTerms.size()]));
            Term pVarTerm = this.solveTerm(lgsTerm, pVar);
            finalTerms.add(pVarTerm);
            ++n2;
        }
        this.mFinalTerm = finalTerms.isEmpty() ? null : (finalTerms.size() == 1 ? (Term)finalTerms.get(0) : this.mScript.term("and", finalTerms.toArray(new Term[finalTerms.size()])));
        this.mMgScript.unlock((Object)this);
    }

    private Term solveTerm(Term term, IProgramVar pVar) {
        Term transformedTerm = Substitution.apply((ManagedScript)this.mMgScript, this.mAlphaDefaultConstant, (Term)term);
        this.mScript.push(1);
        Script.LBool result = AlphaSolver.checkSat(this.mScript, transformedTerm);
        Term finalTerm = null;
        try {
            if (result == Script.LBool.SAT) {
                Collection<Term> terms = this.mAlphaDefaultConstant.values();
                Map termvar2value = SmtUtils.getValues((Script)this.mScript, terms);
                Term zero = this.mScript.decimal("0.0");
                ArrayList<Term> multiplication = new ArrayList<Term>();
                IProgramVar[] iProgramVarArray = this.mProgramVar;
                int n = this.mProgramVar.length;
                int n2 = 0;
                while (n2 < n) {
                    IProgramVar pV = iProgramVarArray[n2];
                    if (!((Term)termvar2value.get(this.mAlphaDefaultConstant.get(this.mAlphaMap.get(pV)[0]))).equals(zero)) {
                        multiplication.add(this.mScript.term("*", new Term[]{this.mScript.term("to_int", new Term[]{(Term)termvar2value.get(this.mAlphaDefaultConstant.get(this.mAlphaMap.get(pV)[0]))}), (Term)this.mOriginalTransFormula.getInVars().get(pV)}));
                    }
                    if (!((Term)termvar2value.get(this.mAlphaDefaultConstant.get(this.mAlphaMap.get(pV)[1]))).equals(zero)) {
                        multiplication.add(this.mScript.term("*", new Term[]{this.mScript.term("to_int", new Term[]{(Term)termvar2value.get(this.mAlphaDefaultConstant.get(this.mAlphaMap.get(pV)[1]))}), (Term)this.mOriginalTransFormula.getInVars().get(pV), this.mNVar}));
                    }
                    ++n2;
                }
                Term addition = multiplication.size() == 1 ? (Term)multiplication.get(0) : this.mScript.term("+", multiplication.toArray(new Term[multiplication.size()]));
                ArrayList<Term> multiplicationN = new ArrayList<Term>();
                if (!((Term)termvar2value.get(this.mAlphaDefaultConstant.get(this.mAlphaN[0]))).equals(zero)) {
                    multiplicationN.add(this.mScript.term("*", new Term[]{(Term)termvar2value.get(this.mAlphaDefaultConstant.get(this.mAlphaN[0])), this.mScript.term("to_real", new Term[]{this.mNVar})}));
                }
                if (!((Term)termvar2value.get(this.mAlphaDefaultConstant.get(this.mAlphaN[1]))).equals(zero)) {
                    multiplicationN.add(this.mScript.term("*", new Term[]{(Term)termvar2value.get(this.mAlphaDefaultConstant.get(this.mAlphaN[1])), this.mScript.term("to_real", new Term[]{this.mNVar}), this.mScript.term("to_real", new Term[]{this.mNVar})}));
                }
                Term additionN = multiplicationN.size() == 1 ? this.mScript.term("to_int", new Term[]{(Term)multiplicationN.get(0)}) : this.mScript.term("to_int", new Term[]{this.mScript.term("+", multiplicationN.toArray(new Term[multiplicationN.size()]))});
                finalTerm = this.mScript.term("=", new Term[]{(Term)this.mOriginalTransFormula.getOutVars().get(pVar), this.mScript.term("+", new Term[]{addition, additionN})});
                this.mValues.put(pVar, this.mScript.term("+", new Term[]{addition, additionN}));
            }
        }
        finally {
            this.mScript.pop(1);
        }
        return finalTerm;
    }

    public Map<IProgramVar, Term> getValues() {
        return this.mValues;
    }

    public Term getResult() {
        return this.mFinalTerm;
    }

    public TermVariable getN() {
        return this.mNVar;
    }

    private static Script.LBool checkSat(Script script, Term term) {
        TermVariable[] vars = term.getFreeVars();
        Term[] values = new Term[vars.length];
        int i = 0;
        while (i < vars.length) {
            values[i] = AlphaSolver.termVariable2constant(script, vars[i]);
            ++i;
        }
        Term newTerm = script.let(vars, values, term);
        Script.LBool result = script.assertTerm(newTerm);
        if (result == Script.LBool.UNKNOWN) {
            result = script.checkSat();
        }
        return result;
    }

    private static Term termVariable2constant(Script script, TermVariable tv) {
        String name = String.valueOf(tv.getName()) + "_const_" + tv.hashCode();
        script.declareFun(name, Script.EMPTY_SORT_ARRAY, tv.getSort());
        return script.term(name, new Term[0]);
    }

    private void initAlphas(int loopCounter) {
        this.mAlphaMap = new HashMap<IProgramVar, TermVariable[]>();
        this.mNVar = this.mScript.variable("n", this.mScript.sort("Int", new Sort[0]));
        IProgramVar[] iProgramVarArray = this.mProgramVar;
        int n = this.mProgramVar.length;
        int n2 = 0;
        while (n2 < n) {
            IProgramVar var = iProgramVarArray[n2];
            TermVariable alphaVar = this.mScript.variable("alpha" + var.toString(), this.mScript.sort("Real", new Sort[0]));
            TermVariable alphaVarN = this.mScript.variable("alpha" + var.toString() + "n", this.mScript.sort("Real", new Sort[0]));
            TermVariable[] alphas = new TermVariable[]{alphaVar, alphaVarN};
            this.mAlphaMap.put(var, alphas);
            this.mAlphaDefaultConstant.put((Term)alphaVar, (Term)ProgramVarUtils.constructDefaultConstant((ManagedScript)this.mMgScript, (Object)this, (Sort)alphaVar.getSort(), (String)(String.valueOf(alphaVar.getName()) + loopCounter)));
            this.mAlphaDefaultConstant.put((Term)alphaVarN, (Term)ProgramVarUtils.constructDefaultConstant((ManagedScript)this.mMgScript, (Object)this, (Sort)alphaVarN.getSort(), (String)(String.valueOf(alphaVarN.getName()) + loopCounter)));
            ++n2;
        }
        this.mAlphaN[0] = this.mScript.variable("alpha_n", this.mScript.sort("Real", new Sort[0]));
        this.mAlphaN[1] = this.mScript.variable("alpha_nn", this.mScript.sort("Real", new Sort[0]));
        this.mAlphaDefaultConstant.put((Term)this.mAlphaN[0], (Term)ProgramVarUtils.constructDefaultConstant((ManagedScript)this.mMgScript, (Object)this, (Sort)this.mAlphaN[0].getSort(), (String)(String.valueOf(this.mAlphaN[0].getName()) + loopCounter)));
        this.mAlphaDefaultConstant.put((Term)this.mAlphaN[1], (Term)ProgramVarUtils.constructDefaultConstant((ManagedScript)this.mMgScript, (Object)this, (Sort)this.mAlphaN[1].getSort(), (String)(String.valueOf(this.mAlphaN[1].getName()) + loopCounter)));
    }

    private void lgsTermN0(IProgramVar var) {
        Term one = this.mScript.decimal("1.0");
        Term zero = this.mScript.decimal("0.0");
        IProgramVar[] iProgramVarArray = this.mProgramVar;
        int n = this.mProgramVar.length;
        int n2 = 0;
        while (n2 < n) {
            IProgramVar vari = iProgramVarArray[n2];
            if (vari == var) {
                this.mVectorTerms.add(this.mScript.term("=", new Term[]{this.mScript.term("*", new Term[]{one, this.mAlphaMap.get(vari)[0]}), one}));
            } else {
                this.mVectorTerms.add(this.mScript.term("=", new Term[]{this.mScript.term("*", new Term[]{one, this.mAlphaMap.get(vari)[0]}), zero}));
            }
            ++n2;
        }
    }

    private void lgsTermN1(IProgramVar var) {
        int i = 0;
        while (i < this.mMatrix.size() - 1) {
            Map<Term, Term> map = this.mMatrix.get(i);
            ArrayList<Object> list = new ArrayList<Object>();
            IProgramVar[] iProgramVarArray = this.mProgramVar;
            int n = this.mProgramVar.length;
            int n2 = 0;
            while (n2 < n) {
                IProgramVar vari = iProgramVarArray[n2];
                list.add(this.mScript.term("*", new Term[]{this.mAlphaMap.get(vari)[0], this.mScript.term("to_real", new Term[]{map.get(this.mOriginalTransFormula.getInVars().get(vari))})}));
                list.add(this.mScript.term("*", new Term[]{this.mAlphaMap.get(vari)[1], this.mScript.term("to_real", new Term[]{map.get(this.mOriginalTransFormula.getInVars().get(vari))})}));
                ++n2;
            }
            list.add(this.mAlphaN[0]);
            list.add(this.mAlphaN[1]);
            this.mVectorTerms.add(this.mScript.term("=", new Term[]{this.mScript.term("+", list.toArray(new Term[this.mProgramVar.length])), this.mScript.term("to_real", new Term[]{this.mLGS.get(i).get(this.mOriginalTransFormula.getOutVars().get(var))})}));
            ++i;
        }
    }

    private void lgsTermN2(IProgramVar var) {
        int i = this.mMatrix.size() - 1;
        Map<Term, Term> map = this.mMatrix.get(i);
        ArrayList<Term> list = new ArrayList<Term>();
        IProgramVar[] iProgramVarArray = this.mProgramVar;
        int n = this.mProgramVar.length;
        int n2 = 0;
        while (n2 < n) {
            IProgramVar vari = iProgramVarArray[n2];
            list.add(this.mScript.term("*", new Term[]{this.mAlphaMap.get(vari)[0], this.mScript.term("to_real", new Term[]{map.get(this.mOriginalTransFormula.getInVars().get(vari))})}));
            list.add(this.mScript.term("*", new Term[]{this.mAlphaMap.get(vari)[1], this.mScript.term("to_real", new Term[]{map.get(this.mOriginalTransFormula.getInVars().get(vari))}), this.mScript.decimal("2.0")}));
            ++n2;
        }
        list.add(this.mScript.term("*", new Term[]{this.mAlphaN[0], this.mScript.decimal("2.0")}));
        list.add(this.mScript.term("*", new Term[]{this.mAlphaN[1], this.mScript.decimal("4.0")}));
        this.mVectorTerms.add(this.mScript.term("=", new Term[]{this.mScript.term("+", list.toArray(new Term[this.mProgramVar.length])), this.mScript.term("to_real", new Term[]{this.mLGS.get(i).get(this.mOriginalTransFormula.getOutVars().get(var))})}));
    }
}

