/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.biesenbach;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.IIcfgTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.ILocationFactory;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.IcfgTransformationBacktranslator;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.biesenbach.AlphaSolver;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.biesenbach.LoopAccelerationMatrix;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.biesenbach.LoopExtraction;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.biesenbach.LoopInsertion;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.biesenbach.MatrixBB;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.biesenbach.SimpleLoop;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import java.util.ArrayDeque;
import java.util.Set;

public class IcfgLoopAcceleration<INLOC extends IcfgLocation, OUTLOC extends IcfgLocation>
implements IIcfgTransformer<OUTLOC> {
    final ILogger mLogger;
    final IIcfg<INLOC> mOriginalIcfg;
    final Class<OUTLOC> mOutLocationClass;
    final ILocationFactory<INLOC, OUTLOC> mFunLocFac;
    final String mNewIcfgIdentifier;
    final IcfgTransformationBacktranslator mBacktranslationTracker;
    final IUltimateServiceProvider mServices;
    final LoopAccelerationOptions mOption;
    private IIcfg<OUTLOC> mResultIcfg;

    public IcfgLoopAcceleration(ILogger logger, IIcfg<INLOC> originalIcfg, Class<OUTLOC> outLocationClass, ILocationFactory<INLOC, OUTLOC> funLocFac, String newIcfgIdentifier, IcfgTransformationBacktranslator backtranslationTracker, IUltimateServiceProvider services, LoopAccelerationOptions option) {
        this.mLogger = logger;
        this.mOriginalIcfg = originalIcfg;
        this.mOutLocationClass = outLocationClass;
        this.mFunLocFac = funLocFac;
        this.mNewIcfgIdentifier = newIcfgIdentifier;
        this.mBacktranslationTracker = backtranslationTracker;
        this.mServices = services;
        this.mOption = option;
        this.mResultIcfg = option.equals((Object)LoopAccelerationOptions.MARK_AS_OVERAPPROX) ? this.accelerat() : originalIcfg;
    }

    public <T> void printDetailedGraph(Set<T> init) {
        ArrayDeque<IcfgLocation> open = new ArrayDeque<IcfgLocation>();
        ArrayDeque<IcfgLocation> marked = new ArrayDeque<IcfgLocation>();
        for (T i : init) {
            open.add((IcfgLocation)i);
        }
        while (!open.isEmpty()) {
            IcfgLocation node = (IcfgLocation)open.pop();
            this.mLogger.info((Object)("node: " + node));
            for (IcfgEdge edge : node.getOutgoingEdges()) {
                IcfgLocation target = (IcfgLocation)edge.getTarget();
                this.mLogger.info((Object)(String.valueOf(edge.getTransformula().getFormula().toStringDirect()) + " -> " + target));
                if (marked.contains(target)) continue;
                open.add(target);
                marked.add(target);
            }
        }
    }

    private IIcfg<OUTLOC> accelerat() {
        Object originalIcfgCoppy = this.mOriginalIcfg;
        ManagedScript mMgScript = originalIcfgCoppy.getCfgSmtToolkit().getManagedScript();
        int loopCounter = 0;
        LoopExtraction loopExtraction = new LoopExtraction(this.mLogger, this.mOriginalIcfg);
        for (SimpleLoop loop : loopExtraction.getLoopTransFormulas()) {
            boolean in;
            boolean out = loop.mLoopTransFormula.getAssignedVars().size() == loop.mLoopTransFormula.getOutVars().size();
            boolean bl = in = loop.mLoopTransFormula.getAssignedVars().size() == loop.mLoopTransFormula.getInVars().size();
            if (!in || !out) {
                this.mLogger.info((Object)(loop.mLoopTransFormula.getAssignedVars() + "in != out!" + loop.mLoopTransFormula.getOutVars()));
                continue;
            }
            MatrixBB matrix = new LoopAccelerationMatrix(this.mLogger, loop.mLoopTransFormula, mMgScript).getResult();
            AlphaSolver alphaSolver = new AlphaSolver(this.mLogger, loop.mLoopTransFormula, mMgScript, matrix.getMatrix(), matrix.getLGS(), this.mServices, ++loopCounter);
            LoopInsertion<INLOC, OUTLOC> loopInsertion = new LoopInsertion<INLOC, OUTLOC>(this.mLogger, originalIcfgCoppy, this.mOutLocationClass, this.mFunLocFac, this.mNewIcfgIdentifier, this.mBacktranslationTracker, this.mServices);
            originalIcfgCoppy = loopInsertion.rejoin2(loop, alphaSolver.getResult(), alphaSolver.getValues(), alphaSolver.getN());
        }
        return originalIcfgCoppy;
    }

    @Override
    public IIcfg<OUTLOC> getResult() {
        return this.mResultIcfg;
    }

    public static enum LoopAccelerationOptions {
        THROW_EXEPTION,
        MARK_AS_OVERAPPROX,
        DO_NOT_ACCELERATE;

    }
}

