/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.biesenbach;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.biesenbach.MatrixBB;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class LoopAccelerationMatrix<INLOC extends IcfgLocation> {
    private final MatrixBB mMatrix;
    private final int mMatrixSize;
    private final UnmodifiableTransFormula mOriginalTransFormula;
    private final ManagedScript mMgScript;
    private final ILogger mLogger;
    private List<Integer> mOpenV = new ArrayList<Integer>();

    public LoopAccelerationMatrix(ILogger logger, UnmodifiableTransFormula loopTransFormula, ManagedScript script) {
        this.mLogger = logger;
        this.mMgScript = script;
        this.mMgScript.lock((Object)this);
        this.mMgScript.push((Object)this, 1);
        this.mOriginalTransFormula = loopTransFormula;
        this.mMatrixSize = this.mOriginalTransFormula.getInVars().size();
        this.mMatrix = new MatrixBB(this.mOriginalTransFormula.getInVars(), logger);
        this.fillMatrix();
        this.mMgScript.pop((Object)this, 1);
        this.mMgScript.unlock((Object)this);
    }

    private void fillMatrix() {
        boolean newVectorFound = true;
        int matrixSize = this.mOriginalTransFormula.getInVars().size();
        int i = 0;
        while (i < matrixSize) {
            this.mOpenV.add(i);
            ++i;
        }
        if (!this.findInitVector()) {
            this.accelerationFailed();
        }
        while (newVectorFound && !this.mOpenV.isEmpty()) {
            newVectorFound = false;
            ArrayList<Integer> open = new ArrayList<Integer>();
            block2: for (int vNumberOpen : this.mOpenV) {
                HashMap<Integer, Map<Term, Term>> matrix = new HashMap<Integer, Map<Term, Term>>(this.mMatrix.getMatrix());
                for (Map closedVector : matrix.values()) {
                    if (this.findVector(closedVector, vNumberOpen)) {
                        newVectorFound = true;
                        continue block2;
                    }
                    open.add(vNumberOpen);
                }
            }
            this.mOpenV = open;
        }
        if (!this.find2nVector()) {
            this.accelerationFailed();
        }
    }

    private void findSolution(int index) {
        Script script = this.mMgScript.getScript();
        HashMap<Term, Term> vector = new HashMap<Term, Term>(this.mMatrix.getMatrix().get(index));
        Term transformedTerm = Substitution.apply((ManagedScript)this.mMgScript, vector, (Term)this.mOriginalTransFormula.getFormula());
        Term closedFormula = UnmodifiableTransFormula.computeClosedFormula((Term)transformedTerm, (Map)this.mOriginalTransFormula.getInVars(), (Map)this.mOriginalTransFormula.getOutVars(), new HashSet(), (ManagedScript)this.mMgScript);
        script.push(1);
        try {
            Script.LBool result = LoopAccelerationMatrix.checkSat(script, closedFormula);
            if (result == Script.LBool.SAT) {
                ArrayList terms = new ArrayList();
                this.mOriginalTransFormula.getOutVars().entrySet().forEach(outvar -> {
                    boolean bl = terms.add(((IProgramVar)outvar.getKey()).getPrimedConstant());
                });
                Map termvar2value = SmtUtils.getValues((Script)script, terms);
                HashMap<Term, Term> m = new HashMap<Term, Term>();
                this.mOriginalTransFormula.getOutVars().entrySet().forEach(outvar -> {
                    Term term = m.put((Term)outvar.getValue(), (Term)termvar2value.get(((IProgramVar)outvar.getKey()).getPrimedConstant()));
                });
                this.mMatrix.setSolution(m, index);
            }
        }
        finally {
            script.pop(1);
        }
    }

    private boolean find2nVector() {
        Script script = this.mMgScript.getScript();
        Term ogTerm = this.mOriginalTransFormula.getFormula();
        this.mOriginalTransFormula.getAuxVars();
        HashMap newOutVars = new HashMap();
        this.mOriginalTransFormula.getOutVars().entrySet().forEach(outvar -> {
            TermVariable termVariable = newOutVars.put((IProgramVar)outvar.getKey(), script.variable(String.valueOf(((TermVariable)outvar.getValue()).toString()) + "_n", ((TermVariable)outvar.getValue()).getSort()));
        });
        HashMap vector = new HashMap();
        this.mOriginalTransFormula.getOutVars().entrySet().forEach(outvar -> {
            Term term = vector.put((Term)outvar.getValue(), (Term)newOutVars.get(outvar.getKey()));
        });
        this.mOriginalTransFormula.getInVars().entrySet().forEach(invar -> {
            Term term = vector.put((Term)invar.getValue(), (Term)this.mOriginalTransFormula.getOutVars().get(invar.getKey()));
        });
        Term newTerm = Substitution.apply((ManagedScript)this.mMgScript, vector, (Term)this.mOriginalTransFormula.getFormula());
        Term fullTerm = script.term("and", new Term[]{ogTerm, newTerm});
        Term fullClosedFormula = UnmodifiableTransFormula.computeClosedFormula((Term)fullTerm, (Map)this.mOriginalTransFormula.getInVars(), newOutVars, new HashSet(), (ManagedScript)this.mMgScript);
        script.push(1);
        Script.LBool result = LoopAccelerationMatrix.checkSat(script, fullClosedFormula);
        try {
            if (result == Script.LBool.SAT) {
                ArrayList terms = new ArrayList();
                this.mOriginalTransFormula.getInVars().entrySet().forEach(invar -> {
                    boolean bl = terms.add(((IProgramVar)invar.getKey()).getDefaultConstant());
                });
                Map termvar2value = SmtUtils.getValues((Script)script, terms);
                this.mMatrix.setVector(this.termver2valueTrasformer(termvar2value), this.mMatrixSize + 1);
            }
        }
        finally {
            script.pop(1);
        }
        Term transformedFullTerm = Substitution.apply((ManagedScript)this.mMgScript, this.mMatrix.getMatrix().get(this.mMatrixSize + 1), (Term)fullTerm);
        Term closedFullTerm = UnmodifiableTransFormula.computeClosedFormula((Term)transformedFullTerm, (Map)this.mOriginalTransFormula.getInVars(), newOutVars, new HashSet(), (ManagedScript)this.mMgScript);
        script.push(1);
        try {
            Script.LBool resultSolution = LoopAccelerationMatrix.checkSat(script, closedFullTerm);
            if (resultSolution == Script.LBool.SAT) {
                ArrayList terms = new ArrayList();
                newOutVars.entrySet().forEach(outvar -> {
                    boolean bl = terms.add(((IProgramVar)outvar.getKey()).getPrimedConstant());
                });
                Map termvar2value = SmtUtils.getValues((Script)script, terms);
                HashMap<Term, Term> m = new HashMap<Term, Term>();
                this.mOriginalTransFormula.getOutVars().entrySet().forEach(outvar -> {
                    Term term = m.put((Term)outvar.getValue(), (Term)termvar2value.get(((IProgramVar)outvar.getKey()).getPrimedConstant()));
                });
                this.mMatrix.setSolution(m, this.mMatrixSize + 1);
            }
        }
        finally {
            script.pop(1);
        }
        return result == Script.LBool.SAT;
    }

    private boolean findVector(Map<Term, Term> closedVector, int vectorNumber) {
        HashMap<Term, Term> vector = new HashMap<Term, Term>(closedVector);
        Script script = this.mMgScript.getScript();
        Map.Entry openVar = (Map.Entry)this.mOriginalTransFormula.getInVars().entrySet().stream().collect(Collectors.toList()).get(vectorNumber);
        vector.put((Term)openVar.getValue(), (Term)((IProgramVar)openVar.getKey()).getDefaultConstant());
        Term transformedTerm = Substitution.apply((ManagedScript)this.mMgScript, vector, (Term)this.mOriginalTransFormula.getFormula());
        transformedTerm = script.term("and", new Term[]{transformedTerm, script.term("distinct", new Term[]{((IProgramVar)openVar.getKey()).getDefaultConstant(), closedVector.get(openVar.getValue())})});
        script.push(1);
        Script.LBool result = LoopAccelerationMatrix.checkSat(script, transformedTerm);
        try {
            if (result == Script.LBool.SAT) {
                Map termvar2value = SmtUtils.getValues((Script)script, Collections.singleton(((IProgramVar)openVar.getKey()).getDefaultConstant()));
                vector.put((Term)openVar.getValue(), (Term)termvar2value.values().iterator().next());
                this.mMatrix.setVector(vector, vectorNumber);
                this.findSolution(vectorNumber);
            }
        }
        finally {
            script.pop(1);
        }
        return result == Script.LBool.SAT;
    }

    private Map<Term, Term> termver2valueTrasformer(Map<Term, Term> termvar2value) {
        HashMap<Term, Term> m = new HashMap<Term, Term>();
        this.mOriginalTransFormula.getInVars().entrySet().forEach(invar -> {
            Term term = m.put((Term)invar.getValue(), (Term)termvar2value.get(((IProgramVar)invar.getKey()).getDefaultConstant()));
        });
        return m;
    }

    private boolean findInitVector() {
        Script script = this.mMgScript.getScript();
        script.push(1);
        Script.LBool result = LoopAccelerationMatrix.checkSat(script, this.mOriginalTransFormula.getClosedFormula());
        try {
            if (result == Script.LBool.SAT) {
                ArrayList terms = new ArrayList();
                this.mOriginalTransFormula.getInVars().entrySet().forEach(invar -> {
                    boolean bl = terms.add(((IProgramVar)invar.getKey()).getDefaultConstant());
                });
                Map termvar2value = SmtUtils.getValues((Script)script, terms);
                this.mMatrix.setVector(this.termver2valueTrasformer(termvar2value), this.mMatrixSize);
                this.findSolution(this.mMatrixSize);
            }
        }
        finally {
            script.pop(1);
        }
        return result == Script.LBool.SAT;
    }

    private static Script.LBool checkSat(Script script, Term term) {
        TermVariable[] vars = term.getFreeVars();
        Term[] values = new Term[vars.length];
        int i = 0;
        while (i < vars.length) {
            values[i] = LoopAccelerationMatrix.termVariable2constant(script, vars[i]);
            ++i;
        }
        Term newTerm = script.let(vars, values, term);
        Script.LBool result = script.assertTerm(newTerm);
        if (result == Script.LBool.UNKNOWN) {
            result = script.checkSat();
        }
        return result;
    }

    private static Term termVariable2constant(Script script, TermVariable tv) {
        String name = String.valueOf(tv.getName()) + "_const_" + tv.hashCode();
        script.declareFun(name, Script.EMPTY_SORT_ARRAY, tv.getSort());
        return script.term(name, new Term[0]);
    }

    private void accelerationFailed() {
        this.mLogger.info((Object)"No acceleration found!");
    }

    public MatrixBB getResult() {
        return this.mMatrix;
    }
}

