/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.biesenbach;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.biesenbach.SimpleLoop;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.biesenbach.Tools;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class LoopExtraction<INLOC extends IcfgLocation, OUTLOC extends IcfgLocation> {
    private final ILogger mLogger;
    private final IIcfg<INLOC> mOriginalIcfg;
    private final ManagedScript mMgScript;
    private final Deque<SimpleLoop> mLoops;
    private final List<INLOC> mLoopHeads;

    public LoopExtraction(ILogger logger, IIcfg<INLOC> originalIcfg) {
        this.mLogger = logger;
        this.mOriginalIcfg = originalIcfg;
        CfgSmtToolkit mCfgSmtToolkit = originalIcfg.getCfgSmtToolkit();
        this.mMgScript = mCfgSmtToolkit.getManagedScript();
        this.mLoops = new ArrayDeque<SimpleLoop>();
        this.mLoopHeads = this.getLoopHeads();
        for (IcfgLocation loopHead : this.mLoopHeads) {
            Deque<IcfgEdge> path = this.getLoopPath(loopHead);
            if (path.isEmpty()) continue;
            List<Map.Entry<UnmodifiableTransFormula, IcfgLocation>> exitEdges = this.findAllExits(loopHead, path);
            UnmodifiableTransFormula pathTransformula = this.pathToTransformula(path);
            if (pathTransformula.getAssignedVars().isEmpty()) continue;
            this.mLoops.addLast(new SimpleLoop(pathTransformula, loopHead, exitEdges));
        }
    }

    private List<Map.Entry<UnmodifiableTransFormula, IcfgLocation>> findAllExits(INLOC loopHead, Deque<IcfgEdge> path) {
        ArrayList<Map.Entry<UnmodifiableTransFormula, IcfgLocation>> exitEdges = new ArrayList<Map.Entry<UnmodifiableTransFormula, IcfgLocation>>();
        for (IcfgEdge edge : loopHead.getOutgoingEdges()) {
            if (edge.getTransformula().equals(path.getFirst().getTransformula())) continue;
            AbstractMap.SimpleEntry<UnmodifiableTransFormula, IcfgLocation> entry = new AbstractMap.SimpleEntry<UnmodifiableTransFormula, IcfgLocation>(Tools.negateUnmodifiableTransFormula(this.mMgScript, edge.getTransformula()), (IcfgLocation)edge.getTarget());
            exitEdges.add(entry);
        }
        Deque<IcfgEdge> pathCopy = Tools.cloneDeque(path);
        pathCopy.removeLast();
        ArrayDeque<IcfgEdge> exitPath = new ArrayDeque<IcfgEdge>();
        while (!pathCopy.isEmpty()) {
            IcfgEdge nextEdge = pathCopy.pop();
            for (IcfgEdge outgoingEdge : ((IcfgLocation)nextEdge.getTarget()).getOutgoingEdges()) {
                if (!path.contains(outgoingEdge)) {
                    AbstractMap.SimpleEntry<UnmodifiableTransFormula, IcfgLocation> entry;
                    if (!exitPath.isEmpty()) {
                        Deque<IcfgEdge> exit = Tools.cloneDeque(exitPath);
                        UnmodifiableTransFormula pathFormula = this.pathToTransformula(exit);
                        UnmodifiableTransFormula exitPathFormula = this.instertFormula(Tools.negateUnmodifiableTransFormula(this.mMgScript, outgoingEdge.getTransformula()), pathFormula);
                        entry = new AbstractMap.SimpleEntry<UnmodifiableTransFormula, IcfgLocation>(exitPathFormula, (IcfgLocation)outgoingEdge.getTarget());
                    } else {
                        entry = new AbstractMap.SimpleEntry<UnmodifiableTransFormula, IcfgLocation>(Tools.negateUnmodifiableTransFormula(this.mMgScript, outgoingEdge.getTransformula()), (IcfgLocation)outgoingEdge.getTarget());
                    }
                    exitEdges.add(entry);
                    continue;
                }
                exitPath.add(outgoingEdge);
            }
        }
        return exitEdges;
    }

    private UnmodifiableTransFormula instertFormula(UnmodifiableTransFormula mainFormula, UnmodifiableTransFormula substituteFormula) {
        Script script = this.mMgScript.getScript();
        HashMap<Term, Term> substitute = new HashMap<Term, Term>();
        for (IProgramVar var : mainFormula.getInVars().keySet()) {
            if (!substituteFormula.getOutVars().containsKey(var)) continue;
            Term value = script.term("+", new Term[]{(Term)substituteFormula.getInVars().values().iterator().next(), Rational.ONE.toTerm(script.sort("Int", new Sort[0]))});
            substitute.put((Term)mainFormula.getInVars().get(var), value);
        }
        Term transformedExitFormula = Substitution.apply((ManagedScript)this.mMgScript, substitute, (Term)mainFormula.getFormula());
        TransFormulaBuilder tfb = new TransFormulaBuilder(substituteFormula.getInVars(), substituteFormula.getInVars(), false, mainFormula.getNonTheoryConsts(), true, (Collection)mainFormula.getBranchEncoders(), true);
        tfb.setFormula(transformedExitFormula);
        tfb.setInfeasibility(UnmodifiableTransFormula.Infeasibility.NOT_DETERMINED);
        tfb.finishConstruction(this.mMgScript);
        UnmodifiableTransFormula finalFormula = tfb.finishConstruction(this.mMgScript);
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)"-------------------------");
            this.mLogger.debug((Object)("mainFormula : " + mainFormula));
            this.mLogger.debug((Object)("substituteFormula : " + substituteFormula));
            this.mLogger.debug((Object)("subsitute : " + substitute));
            this.mLogger.debug((Object)("finalFormula : " + finalFormula));
            this.mLogger.debug((Object)"-------------------------");
        }
        return finalFormula;
    }

    public Deque<SimpleLoop> getLoopTransFormulas() {
        return this.mLoops;
    }

    private Deque<IcfgEdge> getLoopPath(INLOC loopHead) {
        Deque<Object> loopPath = new ArrayDeque<IcfgEdge>();
        ArrayDeque<Object> openLocations = new ArrayDeque<Object>();
        openLocations.addFirst(loopHead);
        ArrayList<Object> markedLocations = new ArrayList<Object>();
        markedLocations.add(loopHead);
        HashMap<Object, Deque<Object>> paths = new HashMap<Object, Deque<Object>>();
        paths.put(loopHead, new ArrayDeque());
        while (!openLocations.isEmpty()) {
            IcfgLocation location = (IcfgLocation)openLocations.removeFirst();
            for (IcfgEdge edge : location.getOutgoingEdges()) {
                IcfgLocation target = (IcfgLocation)edge.getTarget();
                if (this.mLoopHeads.contains(target) && !target.equals(loopHead)) continue;
                if (target.equals(loopHead) && loopPath.isEmpty()) {
                    ((Deque)paths.get(location)).addLast(edge);
                    loopPath = (Deque)paths.get(location);
                    continue;
                }
                if (target.equals(loopHead) && markedLocations.contains(target)) {
                    return new ArrayDeque<IcfgEdge>();
                }
                markedLocations.add(target);
                openLocations.addLast(target);
                Deque clone = Tools.cloneDeque((Deque)paths.get(location));
                clone.addLast(edge);
                paths.put(target, clone);
            }
        }
        return loopPath;
    }

    private UnmodifiableTransFormula pathToTransformula(Deque<IcfgEdge> path) {
        if (path.size() == 1) {
            return path.getFirst().getTransformula();
        }
        UnmodifiableTransFormula transformula = this.joinTransFormula(path.removeFirst().getTransformula(), path.removeFirst().getTransformula());
        for (IcfgEdge edge : path) {
            transformula = this.joinTransFormula(transformula, edge.getTransformula());
        }
        return transformula;
    }

    private UnmodifiableTransFormula joinTransFormula(UnmodifiableTransFormula first, UnmodifiableTransFormula second) {
        HashMap<Term, Term> substitute = new HashMap<Term, Term>();
        HashMap<IProgramVar, TermVariable> inVars = new HashMap<IProgramVar, TermVariable>(first.getInVars());
        for (Map.Entry inVar : second.getInVars().entrySet()) {
            if (inVars.containsKey(inVar.getKey())) continue;
            inVars.put((IProgramVar)inVar.getKey(), (TermVariable)inVar.getValue());
        }
        HashMap<IProgramVar, TermVariable> outVars = new HashMap<IProgramVar, TermVariable>(second.getOutVars());
        for (Map.Entry outVar : first.getOutVars().entrySet()) {
            if (outVars.containsKey(outVar.getKey())) continue;
            outVars.put((IProgramVar)outVar.getKey(), (TermVariable)outVar.getValue());
        }
        for (IProgramVar var : first.getOutVars().keySet()) {
            if (!second.getInVars().containsKey(var)) continue;
            substitute.put((Term)second.getInVars().get(var), (Term)first.getOutVars().get(var));
            if (!((TermVariable)second.getInVars().get(var)).equals(second.getOutVars().get(var))) continue;
            outVars.put(var, (TermVariable)first.getOutVars().get(var));
        }
        HashSet nonTheoryConsts = new HashSet();
        nonTheoryConsts.addAll(first.getNonTheoryConsts());
        nonTheoryConsts.addAll(second.getNonTheoryConsts());
        Term transformedSecond = Substitution.apply((ManagedScript)this.mMgScript, substitute, (Term)second.getFormula());
        Term jointFormula = this.mMgScript.getScript().term("and", new Term[]{first.getFormula(), transformedSecond});
        TransFormulaBuilder tfb = new TransFormulaBuilder(inVars, outVars, false, nonTheoryConsts, true, null, false);
        tfb.setFormula(jointFormula);
        tfb.setInfeasibility(UnmodifiableTransFormula.Infeasibility.NOT_DETERMINED);
        return tfb.finishConstruction(this.mMgScript);
    }

    private List<INLOC> getLoopHeads() {
        ArrayList<IcfgLocation> loopHeads = new ArrayList<IcfgLocation>();
        HashSet<IcfgLocation> markedNodes = new HashSet<IcfgLocation>();
        ArrayList openNodes = new ArrayList(this.mOriginalIcfg.getInitialNodes());
        while (!openNodes.isEmpty()) {
            IcfgLocation openNode = (IcfgLocation)openNodes.remove(0);
            if (markedNodes.contains(openNode)) {
                loopHeads.add(openNode);
            } else {
                openNode.getOutgoingEdges().forEach(edge -> {
                    if (!openNodes.contains(edge.getTarget())) {
                        openNodes.add((IcfgLocation)edge.getTarget());
                    }
                });
            }
            markedNodes.add(openNode);
        }
        return loopHeads;
    }
}

