/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.biesenbach;

import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.IPayload;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.ILocationFactory;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.IcfgTransformationBacktranslator;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.TransformedIcfgBuilder;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.biesenbach.SimpleLoop;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.BasicIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class LoopInsertion<INLOC extends IcfgLocation, OUTLOC extends IcfgLocation> {
    private final ILogger mLogger;
    private final IIcfg<INLOC> mOriginalIcfg;
    private final Class<OUTLOC> mOutLocationClass;
    private final ILocationFactory<INLOC, OUTLOC> mFunLocFac;
    private final String mNewIcfgIdentifier;
    private final IcfgTransformationBacktranslator mBacktranslationTracker;
    private final IUltimateServiceProvider mServices;
    private final ManagedScript mMgScript;
    private final Script mScript;

    public LoopInsertion(ILogger logger, IIcfg<INLOC> originalIcfg, Class<OUTLOC> outLocationClass, ILocationFactory<INLOC, OUTLOC> funLocFac, String newIcfgIdentifier, IcfgTransformationBacktranslator backtranslationTracker, IUltimateServiceProvider services) {
        this.mLogger = logger;
        this.mOriginalIcfg = originalIcfg;
        this.mOutLocationClass = outLocationClass;
        this.mFunLocFac = funLocFac;
        this.mNewIcfgIdentifier = newIcfgIdentifier;
        this.mBacktranslationTracker = backtranslationTracker;
        this.mServices = services;
        CfgSmtToolkit mCfgSmtToolkit = originalIcfg.getCfgSmtToolkit();
        this.mMgScript = mCfgSmtToolkit.getManagedScript();
        this.mScript = this.mMgScript.getScript();
    }

    public IIcfg<OUTLOC> rejoin2(SimpleLoop originalLoop, Term result, Map<IProgramVar, Term> values, TermVariable n) {
        Script script = this.mMgScript.getScript();
        Term zero = Rational.ZERO.toTerm(script.sort("Int", new Sort[0]));
        UnmodifiableTransFormula originalLoopTransFormula = originalLoop.mLoopTransFormula;
        HashMap<Map.Entry<UnmodifiableTransFormula, IcfgLocation>, UnmodifiableTransFormula> loopExits = new HashMap<Map.Entry<UnmodifiableTransFormula, IcfgLocation>, UnmodifiableTransFormula>();
        IcfgLocation loopHead = originalLoop.mHeadNode;
        for (Map.Entry<UnmodifiableTransFormula, IcfgLocation> exitEdge : originalLoop.mExitEdges) {
            UnmodifiableTransFormula exitTransformula = exitEdge.getKey();
            HashMap<Term, Term> substitute = new HashMap<Term, Term>();
            HashMap<IProgramVar, TermVariable> outVars = new HashMap<IProgramVar, TermVariable>(exitTransformula.getOutVars());
            for (IProgramVar var : originalLoopTransFormula.getOutVars().keySet()) {
                if (exitTransformula.getInVars().containsKey(var)) {
                    substitute.put((Term)exitTransformula.getInVars().get(var), values.get(var));
                    if (!((TermVariable)exitTransformula.getInVars().get(var)).equals(exitTransformula.getOutVars().get(var))) continue;
                    outVars.remove(var);
                    outVars.put(var, (TermVariable)originalLoopTransFormula.getOutVars().get(var));
                    continue;
                }
                outVars.put(var, (TermVariable)originalLoopTransFormula.getOutVars().get(var));
            }
            Term transformedExitFormula = Substitution.apply((ManagedScript)this.mMgScript, substitute, (Term)exitTransformula.getFormula());
            TermVariable j = script.variable("j", script.sort("Int", new Sort[0]));
            HashMap<TermVariable, TermVariable> substituteJ = new HashMap<TermVariable, TermVariable>();
            substituteJ.put(n, j);
            Term transformedExitFormulaJ = Substitution.apply((ManagedScript)this.mMgScript, substituteJ, (Term)transformedExitFormula);
            Term conditions = script.term("xor", new Term[]{script.term(">=", new Term[]{j, n}), script.term("or", new Term[]{script.term("<", new Term[]{j, zero}), transformedExitFormulaJ})});
            Term quantifiedFormula = script.quantifier(1, new TermVariable[]{j}, conditions, (Term[][])new Term[0][]);
            ArrayList<Term> remainingExitFormulas = new ArrayList<Term>();
            TermVariable k = script.variable("k", script.sort("Int", new Sort[0]));
            for (Map.Entry<UnmodifiableTransFormula, IcfgLocation> remainingExitEdge : originalLoop.mExitEdges) {
                UnmodifiableTransFormula remainingExitTransformula = remainingExitEdge.getKey();
                substitute = new HashMap();
                for (IProgramVar var : originalLoopTransFormula.getOutVars().keySet()) {
                    if (remainingExitTransformula.getInVars().containsKey(var)) {
                        substitute.put((Term)remainingExitTransformula.getInVars().get(var), values.get(var));
                        if (!((TermVariable)remainingExitTransformula.getInVars().get(var)).equals(remainingExitTransformula.getOutVars().get(var))) continue;
                        outVars.remove(var);
                        outVars.put(var, (TermVariable)originalLoopTransFormula.getOutVars().get(var));
                        continue;
                    }
                    outVars.put(var, (TermVariable)originalLoopTransFormula.getOutVars().get(var));
                }
                Term remainingTransformedExitFormula = Substitution.apply((ManagedScript)this.mMgScript, substitute, (Term)remainingExitTransformula.getFormula());
                HashMap<TermVariable, TermVariable> substituteK = new HashMap<TermVariable, TermVariable>();
                substituteK.put(n, k);
                Term transformedExitFormulaK = Substitution.apply((ManagedScript)this.mMgScript, substituteK, (Term)remainingTransformedExitFormula);
                remainingExitFormulas.add(transformedExitFormulaK);
            }
            Term quantifiedFormulaK = TransFormulaBuilder.getTrivialTransFormula((ManagedScript)this.mMgScript).getFormula();
            if (remainingExitFormulas.size() > 1) {
                Term additionalCondition = script.term("and", remainingExitFormulas.toArray(new Term[remainingExitFormulas.size()]));
                Term conditionsK = script.term("xor", new Term[]{script.term(">=", new Term[]{k, n}), script.term("or", new Term[]{script.term("<", new Term[]{k, zero}), additionalCondition})});
                quantifiedFormulaK = script.quantifier(1, new TermVariable[]{k}, conditionsK, (Term[][])new Term[0][]);
            }
            Term jointTerm = script.quantifier(0, new TermVariable[]{n}, script.term("and", new Term[]{quantifiedFormula, quantifiedFormulaK, result}), (Term[][])new Term[0][]);
            Term simplified = PartialQuantifierElimination.eliminateCompat((IUltimateServiceProvider)this.mServices, (ManagedScript)this.mMgScript, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA, (Term)jointTerm);
            TransFormulaBuilder tfb = new TransFormulaBuilder(originalLoopTransFormula.getInVars(), outVars, originalLoopTransFormula.getNonTheoryConsts().isEmpty(), originalLoopTransFormula.getNonTheoryConsts(), originalLoopTransFormula.getBranchEncoders().isEmpty(), (Collection)originalLoopTransFormula.getBranchEncoders(), true);
            tfb.setFormula(simplified);
            tfb.setInfeasibility(UnmodifiableTransFormula.Infeasibility.NOT_DETERMINED);
            tfb.finishConstruction(this.mMgScript);
            UnmodifiableTransFormula loop = tfb.finishConstruction(this.mMgScript);
            loopExits.put(exitEdge, loop);
        }
        this.mOriginalIcfg.getIdentifier();
        BasicIcfg resultIcfg = new BasicIcfg(this.mNewIcfgIdentifier, this.mOriginalIcfg.getCfgSmtToolkit(), this.mOutLocationClass);
        TransformedIcfgBuilder<INLOC, OUTLOC> lst = new TransformedIcfgBuilder<INLOC, OUTLOC>(this.mLogger, this.mFunLocFac, this.mBacktranslationTracker, this.mOriginalIcfg, resultIcfg);
        this.processLocations(this.mOriginalIcfg.getInitialNodes(), lst, loopHead, loopExits);
        lst.finish();
        return resultIcfg;
    }

    public IIcfg<OUTLOC> rejoin(SimpleLoop originalLoop, Term result, Map<IProgramVar, Term> values, TermVariable n) {
        Script script = this.mMgScript.getScript();
        UnmodifiableTransFormula originalLoopTransFormula = originalLoop.mLoopTransFormula;
        HashMap<Map.Entry<UnmodifiableTransFormula, IcfgLocation>, UnmodifiableTransFormula> loopExits = new HashMap<Map.Entry<UnmodifiableTransFormula, IcfgLocation>, UnmodifiableTransFormula>();
        IcfgLocation loopHead = originalLoop.mHeadNode;
        for (Map.Entry<UnmodifiableTransFormula, IcfgLocation> exitEdge : originalLoop.mExitEdges) {
            UnmodifiableTransFormula exitTransformula = exitEdge.getKey();
            HashMap<Term, Term> substitute = new HashMap<Term, Term>();
            HashMap<IProgramVar, TermVariable> outVars = new HashMap<IProgramVar, TermVariable>(exitTransformula.getOutVars());
            for (IProgramVar var : originalLoopTransFormula.getOutVars().keySet()) {
                if (exitTransformula.getInVars().containsKey(var)) {
                    substitute.put((Term)exitTransformula.getInVars().get(var), values.get(var));
                    if (!((TermVariable)exitTransformula.getInVars().get(var)).equals(exitTransformula.getOutVars().get(var))) continue;
                    outVars.remove(var);
                    outVars.put(var, (TermVariable)originalLoopTransFormula.getOutVars().get(var));
                    continue;
                }
                outVars.put(var, (TermVariable)originalLoopTransFormula.getOutVars().get(var));
            }
            Term transformedExitFormula = script.term("not", new Term[]{Substitution.apply((ManagedScript)this.mMgScript, substitute, (Term)exitTransformula.getFormula())});
            TermVariable j = script.variable("j", script.sort("Int", new Sort[0]));
            HashMap<TermVariable, TermVariable> substituteJ = new HashMap<TermVariable, TermVariable>();
            substituteJ.put(n, j);
            Term transformedExitFormulaJ = Substitution.apply((ManagedScript)this.mMgScript, substituteJ, (Term)transformedExitFormula);
            Term zero = Rational.ZERO.toTerm(script.sort("Int", new Sort[0]));
            Term conditions = script.term("xor", new Term[]{script.term(">=", new Term[]{j, n}), script.term("or", new Term[]{script.term("<", new Term[]{j, zero}), transformedExitFormulaJ})});
            Term quantifiedFormula = script.quantifier(1, new TermVariable[]{j}, conditions, (Term[][])new Term[0][]);
            Term jointTerm = script.quantifier(0, new TermVariable[]{n}, script.term("and", new Term[]{quantifiedFormula, result}), (Term[][])new Term[0][]);
            Term simplified = PartialQuantifierElimination.eliminateCompat((IUltimateServiceProvider)this.mServices, (ManagedScript)this.mMgScript, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA, (Term)jointTerm);
            TransFormulaBuilder tfb = new TransFormulaBuilder(originalLoopTransFormula.getInVars(), outVars, false, originalLoopTransFormula.getNonTheoryConsts(), true, (Collection)originalLoopTransFormula.getBranchEncoders(), true);
            tfb.setFormula(simplified);
            tfb.setInfeasibility(UnmodifiableTransFormula.Infeasibility.NOT_DETERMINED);
            tfb.finishConstruction(this.mMgScript);
            UnmodifiableTransFormula loop = tfb.finishConstruction(this.mMgScript);
            loopExits.put(exitEdge, loop);
        }
        this.mOriginalIcfg.getIdentifier();
        BasicIcfg resultIcfg = new BasicIcfg(this.mNewIcfgIdentifier, this.mOriginalIcfg.getCfgSmtToolkit(), this.mOutLocationClass);
        TransformedIcfgBuilder<INLOC, OUTLOC> lst = new TransformedIcfgBuilder<INLOC, OUTLOC>(this.mLogger, this.mFunLocFac, this.mBacktranslationTracker, this.mOriginalIcfg, resultIcfg);
        this.processLocations(this.mOriginalIcfg.getInitialNodes(), lst, loopHead, loopExits);
        lst.finish();
        return resultIcfg;
    }

    private void processLocations(Set<INLOC> init, TransformedIcfgBuilder<INLOC, OUTLOC> lst, IcfgLocation loopHead, Map<Map.Entry<UnmodifiableTransFormula, IcfgLocation>, UnmodifiableTransFormula> loopExits) {
        ArrayDeque<INLOC> open = new ArrayDeque<INLOC>(init);
        HashSet<IcfgLocation> closed = new HashSet<IcfgLocation>();
        while (!open.isEmpty()) {
            OUTLOC newTarget;
            IcfgLocation oldTarget;
            OUTLOC newSource;
            IcfgLocation oldSource = (IcfgLocation)open.removeFirst();
            if (!closed.add(oldSource)) continue;
            if (oldSource.equals((Object)loopHead)) {
                newSource = lst.createNewLocation(oldSource);
                for (Map.Entry<Object, Object> entry : loopExits.keySet()) {
                    oldTarget = (IcfgLocation)entry.getValue();
                    open.add(oldTarget);
                    newTarget = lst.createNewLocation(oldTarget);
                    lst.createNewInternalTransition(newSource, newTarget, loopExits.get(entry), null, false);
                }
                continue;
            }
            newSource = lst.createNewLocation(oldSource);
            for (IcfgEdge icfgEdge : oldSource.getOutgoingEdges()) {
                oldTarget = (IcfgLocation)icfgEdge.getTarget();
                open.add(oldTarget);
                newTarget = lst.createNewLocation(oldTarget);
                lst.createNewTransition(newSource, newTarget, icfgEdge);
            }
        }
    }

    private static IPayload getPayloadIfAvailable(IElement elem) {
        if (elem == null) {
            return null;
        }
        if (elem.hasPayload()) {
            return elem.getPayload();
        }
        return null;
    }
}

