/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProvider;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProviderProvider;
import de.uni_freiburg.informatik.ultimate.util.csv.SimpleCsvProvider;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.concurrent.TimeUnit;

public class FastUPRBenchmark
implements ICsvProviderProvider<String> {
    private final Deque<FastUPRRun> mRuns = new ArrayDeque<FastUPRRun>();
    private int mPathsFound = 0;
    private int mPathsTried = 0;
    private int mSuccesses = 0;

    public void startRun(IcfgLocation loopHead) {
        this.mRuns.add(new FastUPRRun(loopHead));
    }

    public void endRun(boolean success) {
        ++this.mPathsTried;
        if (success) {
            ++this.mSuccesses;
        }
        this.mRuns.getLast().endRun(success);
    }

    public void setPathsFound(int count) {
        this.mPathsFound = count;
    }

    static double getNanosecondsToUnit(long nanoseconds, TimeUnit unit) {
        switch (unit) {
            case NANOSECONDS: {
                return nanoseconds;
            }
            case MICROSECONDS: {
                return (double)nanoseconds / 1000.0;
            }
            case MILLISECONDS: {
                return (double)nanoseconds / 1000000.0;
            }
            case SECONDS: {
                return (double)nanoseconds / 1.0E9;
            }
            case MINUTES: {
                return (double)nanoseconds / 6.0E10;
            }
            case HOURS: {
                return (double)nanoseconds / 3.6E12;
            }
            case DAYS: {
                return (double)nanoseconds / 8.64E13;
            }
        }
        throw new IllegalArgumentException();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Benchmark Results are:\n");
        sb.append(this.createCsvProvider().toString());
        sb.append(" * FastUPR found: " + this.mPathsFound + " loopPaths and tried to accelerate " + this.mPathsTried + ".\n");
        sb.append(" * FastUPR accelerated " + this.mSuccesses + "/" + this.mPathsTried + " paths.");
        return sb.toString();
    }

    public ICsvProvider<String> createCsvProvider() {
        ArrayList<String> colHeaders = new ArrayList<String>();
        colHeaders.add("Success");
        colHeaders.add(" Time elapsed ");
        SimpleCsvProvider prov = new SimpleCsvProvider(colHeaders);
        for (FastUPRRun run : this.mRuns) {
            ArrayList<String> values = new ArrayList<String>();
            values.add(run.mSuccessful ? "TRUE" : "FALSE");
            values.add("" + (double)Math.round(100.0 * FastUPRBenchmark.getNanosecondsToUnit(run.mTimeElapsed, TimeUnit.MILLISECONDS)) / 100.0);
            prov.addRow(run.mLoopHead.toString(), values);
        }
        return prov;
    }

    private static final class FastUPRRun {
        public boolean mSuccessful;
        public final IcfgLocation mLoopHead;
        public long mTimeElapsed;
        private final long mStartTime;

        FastUPRRun(IcfgLocation head) {
            this.mLoopHead = head;
            this.mStartTime = System.nanoTime();
        }

        public void endRun(boolean success) {
            this.mSuccessful = success;
            this.mTimeElapsed = System.nanoTime() - this.mStartTime;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Loop Head:" + this.mLoopHead.toString() + ", ");
            sb.append("Success: " + this.mSuccessful + ", ");
            sb.append("Time elapsed: " + (double)Math.round(100.0 * FastUPRBenchmark.getNanosecondsToUnit(this.mTimeElapsed, TimeUnit.MILLISECONDS)) / 100.0);
            return sb.toString();
        }
    }
}

