/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr;

import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.RunningTaskInfo;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.FastUPRFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.FastUPRTermChecker;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.FastUPRUtils;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct.OctConjunction;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct.OctagonCalculator;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct.OctagonDetector;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct.OctagonTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct.ParametricOctMatrix;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialRelation;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FastUPRCore {
    private final Term mRelation;
    private final UnmodifiableTransFormula mFormula;
    private Term mResultTerm;
    private final FastUPRUtils mUtils;
    private final ManagedScript mManagedScript;
    private final IUltimateServiceProvider mServices;
    private final OctagonTransformer mOctagonTransformer;
    private final OctagonDetector mOctagonDetector;
    private final OctagonCalculator mOctagonCalculator;
    private OctConjunction mConjunc;
    private final Map<IProgramVar, TermVariable> mInVars;
    private final Map<IProgramVar, TermVariable> mOutVars;
    private List<TermVariable> mVariables;
    private final FastUPRTermChecker mTermChecker;
    private final FastUPRFormulaBuilder mFormulaBuilder;

    public FastUPRCore(UnmodifiableTransFormula formula, ManagedScript managedScript, ILogger logger, IUltimateServiceProvider services) {
        this.mServices = services;
        this.mManagedScript = managedScript;
        this.mUtils = new FastUPRUtils(logger, false);
        this.mUtils.output("==================================================");
        this.mUtils.output("== FAST UPR CORE ==");
        this.mUtils.output("==================================================");
        this.mFormula = formula;
        this.mRelation = formula.getFormula();
        for (IProgramVar p : this.mFormula.getInVars().keySet()) {
            this.mUtils.debug(p.toString());
            this.mUtils.debug(p.getTermVariable().toString());
        }
        this.mOctagonDetector = new OctagonDetector(logger, managedScript, services);
        this.mOctagonTransformer = new OctagonTransformer(this.mUtils, managedScript.getScript(), this.mOctagonDetector);
        this.mOctagonCalculator = new OctagonCalculator(this.mUtils, managedScript);
        this.mFormulaBuilder = new FastUPRFormulaBuilder(this.mUtils, this.mManagedScript, this.mOctagonCalculator, this.mOctagonTransformer, this.mServices);
        this.mTermChecker = new FastUPRTermChecker(this.mUtils, this.mManagedScript, this.mOctagonCalculator, this.mFormulaBuilder, this.mServices);
        this.mUtils.output("Formula:" + this.mFormula.toString());
        this.mInVars = new LinkedHashMap<IProgramVar, TermVariable>(this.mFormula.getInVars());
        this.mOutVars = new LinkedHashMap<IProgramVar, TermVariable>(this.mFormula.getOutVars());
        this.mVariables = new ArrayList<TermVariable>();
        if (this.mOctagonCalculator.isTrivial(this.mInVars, this.mOutVars)) {
            this.mUtils.output("Trivial TransFormula, loop does nothing.");
            this.mResultTerm = formula.getFormula();
        } else if (this.isOctagon(this.mRelation, managedScript.getScript())) {
            this.mConjunc = this.mOctagonTransformer.transform(this.mRelation);
            this.mConjunc = this.mOctagonCalculator.normalizeVarNames(this.mConjunc, this.mInVars, this.mOutVars);
            this.mUtils.debug(this.mConjunc.toString());
            this.mConjunc = this.mOctagonCalculator.removeInOutVars(this.mConjunc, this.mInVars, this.mOutVars);
            this.mUtils.debug(this.mConjunc.toString());
            this.mVariables = this.mOctagonCalculator.getSortedVariables(this.mInVars, this.mOutVars);
            this.mTermChecker.setConjunction(this.mConjunc, this.mInVars, this.mOutVars);
            this.mUtils.output(">> IS OCTAGON: STARTING PREFIX LOOP");
            this.mUtils.output("Conjunction: " + this.mConjunc.toString());
            this.prefixLoop();
        } else {
            this.mResultTerm = null;
        }
    }

    private void prefixLoop() {
        int b = 0;
        while (!this.periodLoop(b)) {
            ++b;
            if (this.mServices.getProgressMonitorService().continueProcessing()) continue;
            throw new ToolchainCanceledException(new RunningTaskInfo(this.getClass(), "the current task"));
        }
    }

    private boolean periodLoop(int b) {
        int c = 1;
        while (c <= b) {
            this.mUtils.output(">> Checking Consistency for b=" + b + ", c=" + c);
            int k = this.mTermChecker.checkConsistency(b, c);
            if (k >= 0) {
                this.mUtils.output(">> NOT CONSISTENT FOR 2 ITERATIONS: RETURNING COMPOSITION RESULT");
                this.mResultTerm = this.mFormulaBuilder.buildConsistencyResult(this.mConjunc, k * c + b - 1, this.mInVars, this.mOutVars);
                return true;
            }
            this.mUtils.output(">> CONSISTENT: CHECKING FOR PERIODICITY");
            ParametricOctMatrix difference = this.periodCheck(b, c);
            if (difference == null) {
                this.mUtils.output("PeriodCheck Not Successful.");
            } else {
                boolean forAll = this.checkForAll(difference, b, c);
                if (forAll) {
                    this.mUtils.output("ForAll Successful.");
                    this.mResultTerm = this.mFormulaBuilder.buildParametricResult(this.mConjunc, b, difference, this.mInVars, this.mOutVars, this.mVariables);
                    return true;
                }
                this.mUtils.output("ForAll Unsuccessful. Periodicity until Inconsistency.");
                boolean periodicity = this.checkPeriodicity(difference, b, c);
                if (periodicity && this.periodicityCalculation(difference, b, c)) {
                    return true;
                }
            }
            ++c;
        }
        return false;
    }

    private boolean periodicityCalculation(ParametricOctMatrix difference, int b, int c) {
        boolean consistent = true;
        int n = 0;
        while (consistent) {
            ParametricOctMatrix differenceN = difference.multiplyConstant(new BigDecimal(n));
            ParametricOctMatrix differenceN1 = difference.multiplyConstant(new BigDecimal(n + 1));
            OctConjunction rB = this.mOctagonCalculator.sequentialize(this.mConjunc, this.mInVars, this.mOutVars, b);
            ParametricOctMatrix rBMatrix = this.mOctagonTransformer.getMatrix(rB, this.mVariables);
            ParametricOctMatrix intervalMatrix = differenceN.add(rBMatrix);
            OctConjunction interval = intervalMatrix.toOctConjunction();
            OctConjunction rC = this.mOctagonCalculator.sequentialize(this.mConjunc, this.mInVars, this.mOutVars, c);
            OctConjunction intervalRC = this.mOctagonCalculator.binarySequentialize(interval, rC, this.mInVars, this.mOutVars);
            consistent = this.mTermChecker.checkTerm(intervalRC.toTerm(this.mManagedScript.getScript()));
            OctConjunction interval1 = differenceN1.add(rBMatrix).toOctConjunction();
            this.mUtils.output(intervalRC.toString());
            this.mUtils.output(intervalRC.toTerm(this.mManagedScript.getScript()).toStringDirect());
            if (!this.mTermChecker.checkTerm(this.mManagedScript.getScript().term("=", new Term[]{intervalRC.toTerm(this.mManagedScript.getScript()), interval1.toTerm(this.mManagedScript.getScript())}))) {
                return false;
            }
            ++n;
            if (this.mServices.getProgressMonitorService().continueProcessing()) continue;
            throw new ToolchainCanceledException(new RunningTaskInfo(this.getClass(), "the current task"));
        }
        this.mResultTerm = this.mFormulaBuilder.buildPeriodicityResult(this.mConjunc, difference, b, c, n, this.mInVars, this.mOutVars, this.mVariables);
        return true;
    }

    private boolean checkPeriodicity(ParametricOctMatrix difference, int b, int c) {
        Script script = this.mManagedScript.getScript();
        OctConjunction rB = this.mOctagonCalculator.sequentialize(this.mConjunc, this.mInVars, this.mOutVars, b);
        ParametricOctMatrix rBMatrix = this.mOctagonTransformer.getMatrix(rB, this.mVariables);
        ParametricOctMatrix differenceN = difference.multiplyVar("n", this.mManagedScript);
        ParametricOctMatrix intervalMatrix = differenceN.add(rBMatrix);
        OctConjunction rC = this.mOctagonCalculator.sequentialize(this.mConjunc, this.mInVars, this.mOutVars, c);
        OctConjunction interval = this.mOctagonCalculator.binarySequentialize(intervalMatrix.toOctConjunction(), rC, this.mInVars, this.mOutVars);
        Term quantified = script.quantifier(0, new TermVariable[]{differenceN.getParametricVar()}, script.term("and", new Term[]{script.term(">=", new Term[]{differenceN.getParametricVar(), script.decimal(BigDecimal.ZERO)}), interval.toTerm(script)}), (Term[][])new Term[0][]);
        return this.mTermChecker.checkQuantifiedTerm(quantified);
    }

    private ParametricOctMatrix periodCheck(int b, int c) {
        this.mUtils.output(">>> PERIOD CHECK");
        OctConjunction c0 = this.mOctagonCalculator.sequentialize(this.mConjunc, this.mInVars, this.mOutVars, b);
        OctConjunction c1 = this.mOctagonCalculator.sequentialize(this.mConjunc, this.mInVars, this.mOutVars, b + c);
        OctConjunction c2 = this.mOctagonCalculator.sequentialize(this.mConjunc, this.mInVars, this.mOutVars, b + 2 * c);
        this.mUtils.debug(c0.toString());
        this.mUtils.debug(c1.toString());
        this.mUtils.debug(c2.toString());
        ParametricOctMatrix c0Matrix = this.mOctagonTransformer.getMatrix(c0, this.mVariables);
        ParametricOctMatrix c1Matrix = this.mOctagonTransformer.getMatrix(c1, this.mVariables);
        ParametricOctMatrix c2Matrix = this.mOctagonTransformer.getMatrix(c2, this.mVariables);
        this.mUtils.debug(c0Matrix.getMatrix().toString());
        this.mUtils.debug(c1Matrix.getMatrix().toString());
        this.mUtils.debug(c2Matrix.getMatrix().toString());
        ParametricOctMatrix difference = c1Matrix.subtract(c0Matrix);
        ParametricOctMatrix difference2 = c2Matrix.subtract(c1Matrix);
        this.mUtils.debug(difference.getMatrix().toString());
        this.mUtils.debug(difference2.getMatrix().toString());
        this.mUtils.debug(difference.toOctConjunction().toString());
        this.mUtils.debug(difference2.toOctConjunction().toString());
        if (difference.isEqualTo(difference2)) {
            this.mUtils.output("> Success!");
            return difference;
        }
        return null;
    }

    private boolean checkForAll(ParametricOctMatrix difference, int b, int c) {
        this.mUtils.output(">>> FOR ALL CHECK, b=" + b + ",c=" + c);
        Script script = this.mManagedScript.getScript();
        OctConjunction rB = this.mOctagonCalculator.sequentialize(this.mConjunc, this.mInVars, this.mOutVars, b);
        OctConjunction rC = this.mOctagonCalculator.sequentialize(this.mConjunc, this.mInVars, this.mOutVars, c);
        ParametricOctMatrix rBMatrix = this.mOctagonTransformer.getMatrix(rB, this.mVariables);
        this.mUtils.debug("Creating Parametric Matrix differenceN.");
        ParametricOctMatrix differenceN = difference.multiplyVar("n", this.mManagedScript);
        this.mUtils.debug(differenceN.toOctConjunction().toString());
        this.mUtils.debug(differenceN.getMapping().toString());
        this.mUtils.debug(rBMatrix.getMapping().toString());
        this.mUtils.debug(differenceN.getMatrix().toString());
        this.mUtils.debug(rBMatrix.getMatrix().toString());
        this.mUtils.debug(differenceN.getSummands().toString());
        this.mUtils.debug(differenceN.getParametricVar().toString());
        ParametricOctMatrix intervalMatrix = differenceN.add(rBMatrix);
        this.mUtils.debug("Creating Intervals.");
        OctConjunction intervalMatrixConjunction = intervalMatrix.toOctConjunction();
        OctConjunction intervalBeginning = this.mOctagonCalculator.binarySequentialize(intervalMatrixConjunction, rC, this.mInVars, this.mOutVars);
        OctConjunction intervalEnd = intervalMatrix.toOctConjunction(1);
        this.mUtils.debug("Intervals:");
        this.mUtils.debug(intervalBeginning.toString());
        this.mUtils.debug(intervalEnd.toString());
        Term eqTerm = script.term("=", new Term[]{intervalBeginning.toTerm(script), intervalEnd.toTerm(script)});
        this.mUtils.debug("eqTerm: " + eqTerm.toString());
        Term greaterEqZero = script.term("and", new Term[]{script.term(">=", new Term[]{differenceN.getParametricVar(), script.decimal(BigDecimal.ZERO)}), eqTerm});
        Term lesserZero = script.term("<", new Term[]{differenceN.getParametricVar(), script.decimal(BigDecimal.ZERO)});
        Term quantTerm = script.quantifier(1, new TermVariable[]{differenceN.getParametricVar()}, script.term("or", new Term[]{greaterEqZero, lesserZero}), (Term[][])new Term[0][]);
        this.mUtils.debug("quantTerm: " + quantTerm.toString());
        Set<TermVariable> vars = intervalBeginning.getVariables();
        boolean isSat = this.mTermChecker.checkQuantifiedTerm(quantTerm);
        if (!isSat) {
            return false;
        }
        if (!vars.isEmpty()) {
            Term satisfiableVars = script.quantifier(0, vars.toArray(new TermVariable[0]), intervalBeginning.toTerm(script), (Term[][])new Term[0][]);
            Term satisfiable = script.quantifier(1, new TermVariable[]{differenceN.getParametricVar()}, script.term("or", new Term[]{lesserZero, satisfiableVars}), (Term[][])new Term[0][]);
            return this.mTermChecker.checkQuantifiedTerm(satisfiable);
        }
        throw new UnsupportedOperationException();
    }

    private boolean isOctagon(Term relation, Script script) {
        Term cnfRelation = SmtUtils.toCnf((IUltimateServiceProvider)this.mServices, (ManagedScript)this.mManagedScript, (Term)relation, (SmtUtils.XnfConversionTechnique)SmtUtils.XnfConversionTechnique.BOTTOM_UP_WITH_LOCAL_SIMPLIFICATION);
        this.mUtils.output("CNF");
        this.mUtils.output(cnfRelation.toString());
        Set<Term> subTerms = this.mOctagonDetector.getConjunctSubTerms(cnfRelation);
        this.mUtils.debug("Term count:" + subTerms.size());
        this.mOctagonDetector.clearChecked();
        for (Term t : subTerms) {
            PolynomialRelation polyRel = PolynomialRelation.convert((Script)script, (Term)t);
            if (polyRel == null) {
                return false;
            }
            t = polyRel.positiveNormalForm(script);
            this.mUtils.debug("Term as Positive Normal Form:");
            this.mUtils.debug(t.toString());
            if (this.mOctagonDetector.isOctTerm(t)) continue;
            return false;
        }
        return true;
    }

    public UnmodifiableTransFormula getResult() {
        if (this.mResultTerm == null) {
            throw new UnsupportedOperationException("No Result found.");
        }
        return this.mFormulaBuilder.buildTransFormula(this.mResultTerm, this.mInVars, this.mOutVars);
    }

    public UnmodifiableTransFormula getExitEdgeResult(UnmodifiableTransFormula exitEdgeFormula) {
        this.mResultTerm = this.mFormulaBuilder.getExitEdgeResult(exitEdgeFormula, this.mResultTerm, this.mInVars, this.mOutVars);
        return this.getResult();
    }
}

