/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class FastUPRDetection<INLOC extends IcfgLocation> {
    private final ILogger mLogger;
    private final List<INLOC> mLoopHeads;

    public FastUPRDetection(ILogger logger, IIcfg<INLOC> originalIcfg) {
        IIcfg<INLOC> origIcfg = Objects.requireNonNull(originalIcfg);
        this.mLogger = Objects.requireNonNull(logger);
        this.mLoopHeads = this.getLoopHeads(origIcfg);
    }

    public List<Deque<IcfgEdge>> getLoopEdgePaths() {
        ArrayList<Deque<IcfgEdge>> result = new ArrayList<Deque<IcfgEdge>>();
        for (IcfgLocation loopHead : this.mLoopHeads) {
            result.add(this.getPathEdges(loopHead));
        }
        return result;
    }

    public Map<INLOC, Deque<IcfgEdge>> getLoopEdgePathsWithLoopHead() {
        HashMap<IcfgLocation, Deque<IcfgEdge>> result = new HashMap<IcfgLocation, Deque<IcfgEdge>>();
        for (IcfgLocation loopHead : this.mLoopHeads) {
            result.put(loopHead, this.getPathEdges(loopHead));
        }
        return result;
    }

    List<Deque<INLOC>> getLoopPaths() {
        ArrayList<Deque<INLOC>> loopPaths = new ArrayList<Deque<INLOC>>();
        for (IcfgLocation loopHead : this.mLoopHeads) {
            loopPaths.add(this.getPathLocs(loopHead));
        }
        return loopPaths;
    }

    private List<INLOC> getLoopHeads(IIcfg<INLOC> originalIcfg) {
        ArrayList<IcfgLocation> loopHeads = new ArrayList<IcfgLocation>();
        Set init = originalIcfg.getInitialNodes();
        HashSet<IcfgLocation> closed = new HashSet<IcfgLocation>();
        HashSet<IcfgEdge> closedEdges = new HashSet<IcfgEdge>();
        ArrayDeque<IcfgLocation> open = new ArrayDeque<IcfgLocation>(init);
        while (!open.isEmpty()) {
            IcfgLocation currentNode = (IcfgLocation)open.removeFirst();
            closed.add(currentNode);
            for (IcfgEdge transition : currentNode.getOutgoingEdges()) {
                if (!closedEdges.add(transition)) continue;
                IcfgLocation target = (IcfgLocation)transition.getTarget();
                this.mLogger.debug((Object)("Current target:" + target.toString()));
                if (closed.contains(target)) {
                    loopHeads.add(target);
                    this.mLogger.debug((Object)("Loop head:" + target.toString()));
                    continue;
                }
                open.addLast(target);
            }
        }
        return loopHeads;
    }

    private Deque<INLOC> getPathLocs(INLOC loopHead) {
        ArrayDeque<Object> currentPath = new ArrayDeque<Object>();
        ArrayDeque<Integer> currentPathIndices = new ArrayDeque<Integer>();
        currentPath.addLast(loopHead);
        currentPathIndices.addLast(0);
        while (!currentPath.isEmpty()) {
            if (((IcfgLocation)currentPath.getLast()).getOutgoingEdges().size() > (Integer)currentPathIndices.getLast()) {
                IcfgLocation target = (IcfgLocation)((IcfgEdge)((IcfgLocation)currentPath.getLast()).getOutgoingEdges().get((Integer)currentPathIndices.getLast())).getTarget();
                int index = (Integer)currentPathIndices.removeLast();
                currentPathIndices.addLast(index + 1);
                currentPathIndices.addLast(0);
                currentPath.addLast(target);
                if (!target.equals(loopHead)) continue;
                this.mLogger.debug((Object)"Found Loop Head again!");
                return currentPath;
            }
            currentPathIndices.removeLast();
            currentPath.removeLast();
        }
        return new ArrayDeque();
    }

    private Deque<IcfgEdge> getPathEdges(INLOC loopHead) {
        HashMap<IcfgEdge, IcfgEdge> parentMap = new HashMap<IcfgEdge, IcfgEdge>();
        HashSet<IcfgEdge> checked = new HashSet<IcfgEdge>();
        ArrayDeque<IcfgEdge> toCheck = new ArrayDeque<IcfgEdge>();
        toCheck.addAll(loopHead.getOutgoingEdges());
        while (!toCheck.isEmpty()) {
            IcfgEdge current = (IcfgEdge)toCheck.pop();
            if (((IcfgLocation)current.getTarget()).equals(loopHead)) {
                return FastUPRDetection.calculatePathEdges(current, parentMap);
            }
            if (!checked.add(current)) continue;
            for (IcfgEdge child : ((IcfgLocation)current.getTarget()).getOutgoingEdges()) {
                if (current.equals(child)) continue;
                parentMap.put(child, current);
                toCheck.add(child);
            }
        }
        return new ArrayDeque<IcfgEdge>();
    }

    private static Deque<IcfgEdge> calculatePathEdges(IcfgEdge lastEdge, Map<IcfgEdge, IcfgEdge> parentMap) {
        ArrayDeque<IcfgEdge> result = new ArrayDeque<IcfgEdge>();
        HashSet<IcfgEdge> added = new HashSet<IcfgEdge>();
        IcfgEdge current = lastEdge;
        added.add(current);
        result.add(current);
        while (parentMap.containsKey(current)) {
            if (!added.contains(current = parentMap.get(current))) {
                result.addFirst(current);
                added.add(current);
                continue;
            }
            return result;
        }
        return result;
    }

    public List<INLOC> getLoopHeads() {
        return this.mLoopHeads;
    }
}

