/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.FastUPRTermTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.FastUPRUtils;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct.OctConjunction;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct.OctagonCalculator;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct.OctagonTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct.ParametricOctMatrix;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class FastUPRFormulaBuilder {
    private final FastUPRUtils mUtils;
    private final ManagedScript mManagedScript;
    private final Script mScript;
    private final OctagonCalculator mCalculator;
    private final OctagonTransformer mTransformer;
    private final FastUPRTermTransformer mTermTransformer;
    private final IUltimateServiceProvider mServices;

    public FastUPRFormulaBuilder(FastUPRUtils utils, ManagedScript mgdScript, OctagonCalculator calc, OctagonTransformer transformer, IUltimateServiceProvider services) {
        this.mUtils = utils;
        this.mManagedScript = mgdScript;
        this.mScript = mgdScript.getScript();
        this.mCalculator = calc;
        this.mTransformer = transformer;
        this.mServices = services;
        this.mTermTransformer = new FastUPRTermTransformer(this.mScript);
    }

    public UnmodifiableTransFormula buildTransFormula(Term term, Map<IProgramVar, TermVariable> inVars, Map<IProgramVar, TermVariable> outVars) {
        Term withoutInt = this.mTermTransformer.transformToInt(term);
        Term simplify = SmtUtils.simplify((ManagedScript)this.mManagedScript, (Term)withoutInt, (IUltimateServiceProvider)this.mServices, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA);
        ModifiableTransFormula modFormula = new ModifiableTransFormula(simplify);
        for (IProgramVar p : inVars.keySet()) {
            modFormula.addInVar(p, inVars.get(p));
        }
        for (IProgramVar p : outVars.keySet()) {
            modFormula.addOutVar(p, outVars.get(p));
        }
        return TransFormulaBuilder.constructCopy((ManagedScript)this.mManagedScript, (TransFormula)modFormula, Collections.emptySet(), Collections.emptySet(), Collections.emptyMap());
    }

    public Term buildConsistencyResult(OctConjunction conjunc, int count, Map<IProgramVar, TermVariable> inVars, Map<IProgramVar, TermVariable> outVars) {
        this.mUtils.output("Returning Consistency Result");
        ArrayList<Term> orTerms = new ArrayList<Term>();
        int i = 0;
        while (i <= count) {
            orTerms.add(this.mCalculator.sequentialize(conjunc, inVars, outVars, i).toTerm(this.mScript));
            ++i;
        }
        return orTerms.size() > 1 ? this.mScript.term("or", orTerms.toArray(new Term[0])) : (Term)orTerms.get(0);
    }

    public Term buildParametricResult(OctConjunction conjunc, int b, ParametricOctMatrix difference, Map<IProgramVar, TermVariable> inVars, Map<IProgramVar, TermVariable> outVars, List<TermVariable> variables) {
        ArrayList<Term> firstOrTerms = new ArrayList<Term>();
        int i = 0;
        while (i < b) {
            firstOrTerms.add(this.mCalculator.sequentialize(conjunc, inVars, outVars, i).toTerm(this.mScript));
            ++i;
        }
        Term firstOr = firstOrTerms.size() > 1 ? this.mScript.term("or", firstOrTerms.toArray(new Term[0])) : (Term)firstOrTerms.get(0);
        ArrayList<Term> secondOrTerms = new ArrayList<Term>();
        ParametricOctMatrix parametricDiff = difference.multiplyVar("k", this.mManagedScript);
        int i2 = 0;
        while (i2 < b) {
            secondOrTerms.add(this.getParametricSolutionRightSide(conjunc, b, i2, parametricDiff, inVars, outVars, variables));
            ++i2;
        }
        Term secondOr = secondOrTerms.size() > 1 ? this.mScript.term("or", secondOrTerms.toArray(new Term[0])) : (Term)secondOrTerms.get(0);
        Term secondOrQuantified = this.mScript.quantifier(0, new TermVariable[]{parametricDiff.getParametricVar()}, this.mScript.term("and", new Term[]{this.mScript.term(">=", new Term[]{parametricDiff.getParametricVar(), this.mScript.decimal(BigDecimal.ZERO)}), secondOr}), (Term[][])new Term[0][]);
        Term result = this.mScript.term("or", new Term[]{firstOr, secondOrQuantified});
        this.mUtils.output("Returning Parametric Result");
        return result;
    }

    private Term getParametricSolutionRightSide(OctConjunction conjunc, int b, int i, ParametricOctMatrix parametricDiff, Map<IProgramVar, TermVariable> inVars, Map<IProgramVar, TermVariable> outVars, List<TermVariable> variables) {
        ParametricOctMatrix rBMatrix = this.mTransformer.getMatrix(this.mCalculator.sequentialize(conjunc, inVars, outVars, b), variables);
        ParametricOctMatrix completeMatrix = parametricDiff.add(rBMatrix);
        OctConjunction firstPart = completeMatrix.toOctConjunction();
        OctConjunction result = this.mCalculator.binarySequentialize(firstPart, this.mCalculator.sequentialize(conjunc, inVars, outVars, i), inVars, outVars);
        return result.toTerm(this.mScript);
    }

    public Term buildPeriodicityResult(OctConjunction conjunc, ParametricOctMatrix difference, int b, int c, int n, Map<IProgramVar, TermVariable> inVars, Map<IProgramVar, TermVariable> outVars, List<TermVariable> variables) {
        ArrayList<Term> firstOrTerms = new ArrayList<Term>();
        int i = 0;
        while (i < b) {
            firstOrTerms.add(this.mCalculator.sequentialize(conjunc, inVars, outVars, i).toTerm(this.mScript));
            ++i;
        }
        Term firstOr = firstOrTerms.size() > 1 ? this.mScript.term("or", firstOrTerms.toArray(new Term[0])) : (Term)firstOrTerms.get(0);
        ArrayList<Term> outerOrTerms = new ArrayList<Term>();
        int k = 0;
        while (k < n) {
            ArrayList<Term> innerOrTerms = new ArrayList<Term>();
            int i2 = 0;
            while (i2 < c) {
                innerOrTerms.add(this.getInnerOrTerm(conjunc, b, i2, k, difference, inVars, outVars, variables));
                ++i2;
            }
            Term innerOr = innerOrTerms.size() > 1 ? this.mScript.term("or", innerOrTerms.toArray(new Term[0])) : (Term)innerOrTerms.get(0);
            outerOrTerms.add(innerOr);
            ++k;
        }
        Term outerOr = outerOrTerms.size() > 1 ? this.mScript.term("or", outerOrTerms.toArray(new Term[0])) : (Term)outerOrTerms.get(0);
        Term result = this.mScript.term("or", new Term[]{firstOr, outerOr});
        this.mUtils.output("Returning Periodicity Result");
        return result;
    }

    private Term getInnerOrTerm(OctConjunction conjunc, int b, int i, int n, ParametricOctMatrix difference, Map<IProgramVar, TermVariable> inVars, Map<IProgramVar, TermVariable> outVars, List<TermVariable> variables) {
        ParametricOctMatrix rBMatrix = this.mTransformer.getMatrix(this.mCalculator.sequentialize(conjunc, inVars, outVars, b), variables);
        ParametricOctMatrix differenceMultiplied = difference.multiplyConstant(new BigDecimal(n));
        ParametricOctMatrix completeMatrix = differenceMultiplied.add(rBMatrix);
        OctConjunction firstPart = completeMatrix.toOctConjunction();
        OctConjunction result = this.mCalculator.binarySequentialize(firstPart, this.mCalculator.sequentialize(conjunc, inVars, outVars, i), inVars, outVars);
        return result.toTerm(this.mScript);
    }

    private Term getIdentityRelation(Map<IProgramVar, TermVariable> inVars, Map<IProgramVar, TermVariable> outVars) {
        ArrayList<Term> terms = new ArrayList<Term>();
        for (IProgramVar p : inVars.keySet()) {
            TermVariable out;
            TermVariable in = inVars.get(p);
            if (outVars.containsKey(p)) {
                out = outVars.get(p);
            } else {
                out = this.mManagedScript.constructFreshTermVariable(String.valueOf(in.getName()) + "_out", in.getSort());
                outVars.put(p, out);
            }
            terms.add(this.mScript.term("=", new Term[]{in, out}));
        }
        for (IProgramVar p : outVars.keySet()) {
            if (inVars.containsKey(p)) continue;
            TermVariable out = outVars.get(p);
            TermVariable in = this.mManagedScript.constructFreshTermVariable(String.valueOf(out.getName()) + "_in", out.getSort());
            inVars.put(p, in);
            terms.add(this.mScript.term("=", new Term[]{in, out}));
        }
        if (terms.isEmpty()) {
            return this.mScript.term("true", new Term[0]);
        }
        if (terms.size() == 1) {
            return (Term)terms.get(0);
        }
        Term identityTerm = this.mScript.term("and", terms.toArray(new Term[0]));
        return identityTerm;
    }

    public Term getExitEdgeResult(UnmodifiableTransFormula exitEdgeFormula, Term t, Map<IProgramVar, TermVariable> inVars, Map<IProgramVar, TermVariable> outVars) {
        Term identityRelation = this.getIdentityRelation(inVars, outVars);
        Term loop = this.mScript.term("or", new Term[]{identityRelation, t});
        Term exitTerm = this.buldExitRelation(inVars, outVars, exitEdgeFormula);
        return this.mScript.term("and", new Term[]{loop, exitTerm});
    }

    private Term buldExitRelation(Map<IProgramVar, TermVariable> inVars, Map<IProgramVar, TermVariable> outVars, UnmodifiableTransFormula exitEdgeFormula) {
        Term exitTerm = exitEdgeFormula.getFormula();
        for (Map.Entry e : exitEdgeFormula.getInVars().entrySet()) {
            TermVariable outVar = outVars.get(e.getKey());
            exitTerm = this.mTermTransformer.replaceVar(exitTerm, (TermVariable)e.getValue(), outVar);
        }
        return exitTerm;
    }
}

