/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.FastUPRFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.FastUPRTermTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.FastUPRUtils;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct.OctConjunction;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct.OctagonCalculator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.Map;

public class FastUPRTermChecker {
    private final ManagedScript mManagedScript;
    private final OctagonCalculator mCalc;
    private Map<IProgramVar, TermVariable> mInVars;
    private Map<IProgramVar, TermVariable> mOutVars;
    private OctConjunction mConjunc;
    private final Script mScript;
    private final FastUPRTermTransformer mTermTransformer;

    public FastUPRTermChecker(FastUPRUtils utils, ManagedScript managedScript, OctagonCalculator calc, FastUPRFormulaBuilder formulaBuilder, IUltimateServiceProvider services) {
        this.mCalc = calc;
        this.mManagedScript = managedScript;
        this.mScript = this.mManagedScript.getScript();
        this.mTermTransformer = new FastUPRTermTransformer(this.mScript);
    }

    public void setConjunction(OctConjunction conjunc) {
        this.mConjunc = conjunc;
    }

    public void setConjunction(OctConjunction conjunc, Map<IProgramVar, TermVariable> inVars, Map<IProgramVar, TermVariable> outVars) {
        this.mConjunc = conjunc;
        this.mInVars = inVars;
        this.mOutVars = outVars;
    }

    public void setInVars(Map<IProgramVar, TermVariable> inVars) {
        this.mInVars = inVars;
    }

    public void setOutVars(Map<IProgramVar, TermVariable> outVars) {
        this.mOutVars = outVars;
    }

    public int checkConsistency(int b, int c) {
        int k = 0;
        while (k <= 2) {
            if (!this.checkSequentialized(b + k * c)) {
                return k;
            }
            ++k;
        }
        return -1;
    }

    private boolean checkSequentialized(int count) {
        Script script = this.mManagedScript.getScript();
        OctConjunction toCheck = this.mCalc.sequentialize(this.mConjunc, this.mInVars, this.mOutVars, count);
        return this.checkTerm(toCheck.toTerm(script));
    }

    public boolean checkQuantifiedTerm(Term term) {
        Term withOutReal = this.mTermTransformer.transformToInt(term);
        Script.LBool result = SmtUtils.checkSatTerm((Script)this.mScript, (Term)withOutReal);
        return result != Script.LBool.UNSAT;
    }

    public boolean checkTerm(Term term) {
        Term withOutReal = this.mTermTransformer.transformToInt(term);
        Script.LBool result = SmtUtils.checkSatTerm((Script)this.mScript, (Term)withOutReal);
        return result.equals((Object)Script.LBool.SAT);
    }
}

