/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr;

import de.uni_freiburg.informatik.ultimate.core.lib.results.StatisticsResult;
import de.uni_freiburg.informatik.ultimate.core.model.models.IModifiableMultigraphEdge;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResult;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.IIcfgTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.ILocationFactory;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.IcfgTransformationBacktranslator;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.TransformedIcfgBuilder;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.FastUPR;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.FastUPRBenchmark;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.FastUPRCore;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.FastUPRDetection;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.BasicIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgReturnTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgInternalTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProviderProvider;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class FastUPRTransformer<INLOC extends IcfgLocation, OUTLOC extends IcfgLocation>
implements IIcfgTransformer<OUTLOC> {
    private final ILogger mLogger;
    private final IIcfg<OUTLOC> mResultIcfg;
    private final ManagedScript mManagedScript;
    private final IcfgTransformationBacktranslator mBacktranslationTracker;
    private final ILocationFactory<INLOC, OUTLOC> mLocationFactory;
    private final IUltimateServiceProvider mServices;
    private final FastUPRReplacementMethod mReplacementMethod;
    private int mLoopFailures = 0;
    private int mLoops = 0;
    private final FastUPRBenchmark mBenchmark = new FastUPRBenchmark();

    public FastUPRTransformer(ILogger logger, IIcfg<INLOC> originalIcfg, Class<OUTLOC> outLocationClass, ILocationFactory<INLOC, OUTLOC> locationFactory, String newIcfgIdentifier, IcfgTransformationBacktranslator backtranslationTracker, IUltimateServiceProvider services, FastUPRReplacementMethod replaceMethod) {
        IIcfg<INLOC> origIcfg = Objects.requireNonNull(originalIcfg);
        this.mReplacementMethod = replaceMethod;
        this.mLogger = Objects.requireNonNull(logger);
        this.mLocationFactory = Objects.requireNonNull(locationFactory);
        this.mManagedScript = origIcfg.getCfgSmtToolkit().getManagedScript();
        this.mBacktranslationTracker = backtranslationTracker;
        this.mServices = services;
        this.mLogger.debug((Object)"Starting fastUPR Transformation");
        this.mResultIcfg = this.transform(origIcfg, Objects.requireNonNull(newIcfgIdentifier), Objects.requireNonNull(outLocationClass));
        this.mLogger.debug((Object)this.mBenchmark.toString());
        this.mServices.getResultService().reportResult(FastUPR.PLUGIN_ID, (IResult)new StatisticsResult("FastUPR-LoopAcceleration", "FastUPR Benchmark Results:", (ICsvProviderProvider)this.mBenchmark));
    }

    private IIcfg<OUTLOC> transform(IIcfg<INLOC> originalIcfg, String newIcfgIdentifier, Class<OUTLOC> outLocationClass) {
        this.mLogger.debug((Object)"Getting List of loop paths ...");
        FastUPRDetection<INLOC> loopDetection = new FastUPRDetection<INLOC>(this.mLogger, originalIcfg);
        List<Deque<IcfgEdge>> loopEdgePaths = loopDetection.getLoopEdgePaths();
        if (loopEdgePaths.isEmpty()) {
            this.mLogger.debug((Object)"No loop paths found");
        } else {
            this.mLogger.debug((Object)("Found " + loopEdgePaths.size() + " loop paths"));
            this.mLoops = loopEdgePaths.size();
        }
        BasicIcfg resultIcfg = new BasicIcfg(newIcfgIdentifier, originalIcfg.getCfgSmtToolkit(), outLocationClass);
        TransformedIcfgBuilder<INLOC, OUTLOC> lst = new TransformedIcfgBuilder<INLOC, OUTLOC>(this.mLogger, this.mLocationFactory, this.mBacktranslationTracker, originalIcfg, resultIcfg);
        this.mLogger.debug((Object)"Transforming loops into icfg...");
        this.getLoopIcfg(loopEdgePaths, resultIcfg, originalIcfg, lst);
        this.mLogger.debug((Object)"Icfg created.");
        return resultIcfg;
    }

    private void getLoopIcfg(List<Deque<IcfgEdge>> loopEdgePaths, BasicIcfg<OUTLOC> resultIcfg, IIcfg<INLOC> origIcfg, TransformedIcfgBuilder<INLOC, OUTLOC> lst) {
        HashMap<IcfgEdge, LoopEdgeElement> loopMapping = new HashMap<IcfgEdge, LoopEdgeElement>();
        for (Deque<IcfgEdge> path : loopEdgePaths) {
            if (path == null || path.isEmpty()) continue;
            IcfgEdge loopEdge = path.getFirst();
            this.mBenchmark.startRun((IcfgLocation)loopEdge.getSource());
            ArrayList<UnmodifiableTransFormula> formulas = new ArrayList<UnmodifiableTransFormula>();
            UnmodifiableTransFormula resultFormula = null;
            IcfgEdge assertionEdge = null;
            IcfgEdge loopEntry = null;
            IcfgEdge falseEdge = null;
            IcfgEdge loopExit = null;
            try {
                while (!path.isEmpty()) {
                    IcfgEdge edge = path.getFirst();
                    if (edge.equals(loopEdge) && edge.getTransformula().getFormula().toString().equals("true") && ((IcfgLocation)edge.getSource()).getOutgoingEdges().size() == 2) {
                        loopEntry = edge;
                        falseEdge = ((IcfgLocation)edge.getSource()).getOutgoingEdges().get(0) == edge ? (IcfgEdge)((IcfgLocation)edge.getSource()).getOutgoingEdges().get(1) : (IcfgEdge)((IcfgLocation)edge.getSource()).getOutgoingEdges().get(0);
                        path.pop();
                        continue;
                    }
                    if (((IcfgLocation)edge.getSource()).getOutgoingEdges().size() == 2 && ((IcfgEdge)((IcfgLocation)edge.getSource()).getIncomingEdges().get(0)).equals(loopEntry)) {
                        loopExit = FastUPRTransformer.findLoopExit(edge, falseEdge);
                        formulas.add(edge.getTransformula());
                        path.pop();
                        continue;
                    }
                    if (!edge.equals(loopEdge) && ((IcfgLocation)edge.getSource()).getOutgoingEdges().size() > 1) {
                        throw new IllegalArgumentException("Cannot compute nondeterministic paths.");
                    }
                    formulas.add(edge.getTransformula());
                    path.pop();
                }
                UnmodifiableTransFormula formula = TransFormulaUtils.sequentialComposition((ILogger)this.mLogger, (IUltimateServiceProvider)this.mServices, (ManagedScript)this.mManagedScript, (boolean)true, (boolean)false, (boolean)false, (SmtUtils.XnfConversionTechnique)SmtUtils.XnfConversionTechnique.BOTTOM_UP_WITH_LOCAL_SIMPLIFICATION, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA, formulas);
                FastUPRCore fastUpr = new FastUPRCore(formula, this.mManagedScript, this.mLogger, this.mServices);
                if (this.mReplacementMethod == FastUPRReplacementMethod.REPLACE_LOOP_EDGE) {
                    resultFormula = fastUpr.getResult();
                } else if (this.mReplacementMethod == FastUPRReplacementMethod.REPLACE_EXIT_EDGE) {
                    resultFormula = fastUpr.getExitEdgeResult(this.getExitEdgeFormula(loopEdge));
                }
                if (resultFormula == null) {
                    throw new IllegalArgumentException("FastUPR couldn't compute a loop acceleration.");
                }
                this.mLogger.debug((Object)("Result Formula:" + resultFormula.toString()));
                this.mBenchmark.endRun(true);
            }
            catch (Exception e) {
                this.mLogger.error((Object)"", (Throwable)e);
                loopEdge = null;
                ++this.mLoopFailures;
                this.mBenchmark.endRun(false);
            }
            if (loopEdge == null) continue;
            loopMapping.put(loopEdge, new LoopEdgeElement(loopEntry, loopEdge, loopExit, resultFormula, assertionEdge));
            String formulaString = resultFormula.getFormula().toStringDirect();
            this.mLogger.debug((Object)("resultFormula: " + formulaString));
        }
        this.mLogger.debug((Object)("FastUPR found a total of " + loopEdgePaths.size() + " loops and computed accelerated formulas for " + (this.mLoops - this.mLoopFailures) + " loops."));
        Set init = origIcfg.getInitialNodes();
        ArrayDeque open = new ArrayDeque(init);
        HashSet<IcfgLocation> closed = new HashSet<IcfgLocation>();
        this.mLogger.debug((Object)"Starting main transformation loop...");
        ArrayDeque<IcfgEdge> addLast = new ArrayDeque<IcfgEdge>();
        while (!open.isEmpty()) {
            IcfgLocation oldSource = (IcfgLocation)open.removeFirst();
            if (!closed.add(oldSource)) continue;
            OUTLOC newSource = lst.createNewLocation(oldSource);
            if (this.mReplacementMethod.equals((Object)FastUPRReplacementMethod.REPLACE_LOOP_EDGE)) {
                this.createNewLocations(oldSource, newSource, closed, open, resultIcfg, lst, loopMapping, addLast);
                continue;
            }
            if (!this.mReplacementMethod.equals((Object)FastUPRReplacementMethod.REPLACE_EXIT_EDGE)) continue;
            this.createNewLocationsWithReplaceExit(oldSource, newSource, closed, resultIcfg, lst, loopMapping, addLast);
        }
        while (!addLast.isEmpty()) {
            IcfgEdge oldEdge = (IcfgEdge)addLast.pop();
            if (oldEdge instanceof IIcfgReturnTransition && !lst.isCorrespondingCallContained((IIcfgReturnTransition)oldEdge)) {
                addLast.add(oldEdge);
                continue;
            }
            IcfgLocation oldS = (IcfgLocation)oldEdge.getSource();
            OUTLOC newS = lst.createNewLocation(oldS);
            IcfgLocation oldT = (IcfgLocation)oldEdge.getTarget();
            OUTLOC newT = lst.createNewLocation(oldT);
            lst.createNewTransition(newS, newT, oldEdge);
            if (!closed.add(oldT)) continue;
            if (this.mReplacementMethod.equals((Object)FastUPRReplacementMethod.REPLACE_LOOP_EDGE)) {
                this.createNewLocations(oldS, newS, closed, open, resultIcfg, lst, loopMapping, addLast);
                continue;
            }
            if (!this.mReplacementMethod.equals((Object)FastUPRReplacementMethod.REPLACE_EXIT_EDGE)) continue;
            this.createNewLocationsWithReplaceExit(oldS, newS, closed, resultIcfg, lst, loopMapping, addLast);
        }
    }

    private void createNewLocationsUntransformed(INLOC oldSource, OUTLOC newSource, Set<INLOC> closed, Deque<INLOC> open, TransformedIcfgBuilder<INLOC, OUTLOC> lst, Deque<IcfgEdge> addLast) {
        for (IcfgEdge oldEdge : oldSource.getOutgoingEdges()) {
            IcfgLocation oldTarget = (IcfgLocation)oldEdge.getTarget();
            open.add(oldTarget);
            OUTLOC newTarget = lst.createNewLocation(oldTarget);
            if (oldEdge instanceof IIcfgReturnTransition) {
                addLast.add(oldEdge);
                continue;
            }
            lst.createNewTransition(newSource, newTarget, oldEdge);
        }
    }

    private static IcfgEdge findLoopExit(IcfgEdge edge, IcfgEdge falseEdge) {
        for (IcfgEdge e : ((IcfgLocation)edge.getSource()).getOutgoingEdges()) {
            if (!((IcfgLocation)e.getTarget()).equals((Object)falseEdge.getTarget())) continue;
            return e;
        }
        throw new IllegalArgumentException("No exit edge found.");
    }

    private static IcfgEdge getExitEdge(IcfgEdge loopEdge) {
        IcfgLocation loc = (IcfgLocation)loopEdge.getSource();
        if (loc.getOutgoingEdges().size() != 2) {
            throw new IllegalArgumentException("Exit Edge Merging can only be done if the loop head has two outgoing edges.");
        }
        for (IcfgEdge e : loc.getOutgoingEdges()) {
            if (e.equals(loopEdge)) continue;
            return e;
        }
        throw new IllegalArgumentException("Loop Edge exists twice.");
    }

    private UnmodifiableTransFormula getExitEdgeFormula(IcfgEdge loopEdge) {
        return FastUPRTransformer.getExitEdge(loopEdge).getTransformula();
    }

    private void createNewLocations(INLOC oldSource, OUTLOC newSource, Set<INLOC> closed, Deque<INLOC> open, BasicIcfg<OUTLOC> result, TransformedIcfgBuilder<INLOC, OUTLOC> lst, Map<IcfgEdge, LoopEdgeElement> loopMapping, Deque<IcfgEdge> addLast) {
        for (IcfgEdge oldEdge : oldSource.getOutgoingEdges()) {
            if (oldEdge instanceof IIcfgReturnTransition && !lst.isCorrespondingCallContained((IIcfgReturnTransition)oldEdge)) {
                addLast.add(oldEdge);
                continue;
            }
            if (loopMapping.containsKey(oldEdge)) {
                IcfgInternalTransition newTrans;
                LoopEdgeElement element = loopMapping.get(oldEdge);
                if (element.getEntryEdge() != null && element.getExitEdge() != null) {
                    newTrans = lst.createNewInternalTransition(newSource, newSource, loopMapping.get(oldEdge).getFormula(), false);
                    newSource.addOutgoing((IModifiableMultigraphEdge)newTrans);
                    newSource.addIncoming((IModifiableMultigraphEdge)newTrans);
                    IcfgLocation oldTarget = (IcfgLocation)element.getExitEdge().getTarget();
                    OUTLOC newTarget = lst.createNewLocation(oldTarget);
                    IcfgEdge exitEdge = lst.createNewTransition(newSource, newTarget, element.getExitEdge());
                    this.mBacktranslationTracker.mapEdges((IIcfgTransition<IcfgLocation>)exitEdge, (IIcfgTransition<IcfgLocation>)element.getExitEdge());
                    open.add(oldTarget);
                    continue;
                }
                newTrans = lst.createNewInternalTransition(newSource, newSource, loopMapping.get(oldEdge).getFormula(), false);
                this.mBacktranslationTracker.mapEdges((IIcfgTransition<IcfgLocation>)newTrans, (IIcfgTransition<IcfgLocation>)oldEdge);
                continue;
            }
            IcfgLocation oldTarget = (IcfgLocation)oldEdge.getTarget();
            OUTLOC newTarget = lst.createNewLocation(oldTarget);
            lst.createNewTransition(newSource, newTarget, oldEdge);
            open.add(oldTarget);
        }
    }

    private void createNewLocationsWithReplaceExit(INLOC oldSource, OUTLOC newSource, Set<INLOC> closed, BasicIcfg<OUTLOC> result, TransformedIcfgBuilder<INLOC, OUTLOC> lst, Map<IcfgEdge, LoopEdgeElement> loopMapping, Deque<IcfgEdge> addLast) {
        for (IcfgEdge e : loopMapping.keySet()) {
            if (!((IcfgLocation)e.getSource()).equals(oldSource)) continue;
            IcfgEdge exit = FastUPRTransformer.getExitEdge(e);
            IcfgLocation oldTarget = (IcfgLocation)exit.getTarget();
            OUTLOC newTarget = lst.createNewLocation(oldTarget);
            IcfgInternalTransition newEdge = lst.createNewInternalTransition(newSource, newTarget, loopMapping.get(e).getFormula(), false);
            this.mBacktranslationTracker.mapEdges((IIcfgTransition<IcfgLocation>)e, (IIcfgTransition<IcfgLocation>)newEdge);
        }
        for (IcfgEdge oldEdge : oldSource.getOutgoingEdges()) {
            if (oldEdge instanceof IIcfgReturnTransition && !lst.isCorrespondingCallContained((IIcfgReturnTransition)oldEdge)) {
                addLast.add(oldEdge);
                continue;
            }
            if (loopMapping.containsKey(oldEdge)) continue;
            IcfgLocation oldTarget = (IcfgLocation)oldEdge.getTarget();
            OUTLOC newTarget = lst.createNewLocation(oldTarget);
            lst.createNewTransition(newSource, newTarget, oldEdge);
            if (!closed.add(oldTarget)) continue;
            this.createNewLocationsWithReplaceExit(oldTarget, newTarget, closed, result, lst, loopMapping, addLast);
        }
    }

    @Override
    public IIcfg<OUTLOC> getResult() {
        return this.mResultIcfg;
    }

    public int getSuccessfulAccelerations() {
        return this.mLoops - this.mLoopFailures;
    }

    public int getTotalLoopsFound() {
        return this.mLoops;
    }

    public static enum FastUPRReplacementMethod {
        REPLACE_LOOP_EDGE,
        REPLACE_EXIT_EDGE;

    }

    private class LoopEdgeElement {
        public final IcfgEdge mEntryEdge;
        public final IcfgEdge mLoopEdge;
        public final IcfgEdge mExitEdge;
        public final UnmodifiableTransFormula mResultFormula;
        public final IcfgEdge mAssertionExit;

        public LoopEdgeElement(IcfgEdge entry, IcfgEdge loopEdge, IcfgEdge exit, UnmodifiableTransFormula result, IcfgEdge assertionexit) {
            this.mEntryEdge = entry;
            this.mLoopEdge = loopEdge;
            this.mExitEdge = exit;
            this.mResultFormula = result;
            this.mAssertionExit = assertionexit;
        }

        public IcfgEdge getEntryEdge() {
            return this.mEntryEdge;
        }

        public IcfgEdge getLoopEdge() {
            return this.mLoopEdge;
        }

        public UnmodifiableTransFormula getFormula() {
            return this.mResultFormula;
        }

        public IcfgEdge getAssertionExt() {
            return this.mAssertionExit;
        }

        public IcfgEdge getExitEdge() {
            return this.mExitEdge;
        }
    }
}

