/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.FastUPRUtils;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct.OctTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class OctConjunction {
    private final ArrayList<OctTerm> mTerms = new ArrayList();
    private Set<TermVariable> mCachedVariables = new LinkedHashSet<TermVariable>();

    public void addTerm(OctTerm octagonTerm) {
        if (octagonTerm == null) {
            return;
        }
        this.mTerms.add(octagonTerm);
        this.mCachedVariables = null;
    }

    public void removeTerm(OctTerm octagonTerm) {
        this.mTerms.remove(octagonTerm);
        this.mCachedVariables = null;
    }

    public List<OctTerm> getTerms() {
        return this.mTerms;
    }

    public int getVariableCount() {
        return this.getVariables().size();
    }

    public Set<TermVariable> getVariables() {
        if (this.mCachedVariables != null) {
            return this.mCachedVariables;
        }
        LinkedHashSet<TermVariable> variables = new LinkedHashSet<TermVariable>();
        for (OctTerm t : this.mTerms) {
            if (t.isOneVar()) {
                variables.add(t.getFirstVar());
                continue;
            }
            variables.add(t.getFirstVar());
            variables.add(t.getSecondVar());
        }
        this.mCachedVariables = variables;
        return variables;
    }

    public String toString() {
        if (this.mTerms.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder("(" + this.mTerms.get(0).toString() + ")");
        int i = 1;
        while (i < this.mTerms.size()) {
            sb.append(" and (" + this.mTerms.get(i).toString() + ")");
            ++i;
        }
        return sb.toString();
    }

    public Term toTerm(Script script, FastUPRUtils utils) {
        if (this.isEmpty()) {
            return script.term("true", new Term[0]);
        }
        ArrayList<Term> terms = new ArrayList<Term>();
        for (OctTerm t : this.mTerms) {
            utils.debug("OctTerm: " + t.toString());
            terms.add(t.toTerm(script));
            utils.debug("Term: " + t.toTerm(script).toString());
        }
        Term[] termArray = new Term[terms.size()];
        termArray = terms.toArray(termArray);
        Term result = script.term("and", termArray);
        utils.debug(result.toString());
        return result;
    }

    public Term toTerm(Script script) {
        if (this.isEmpty()) {
            return script.term("true", new Term[0]);
        }
        ArrayList<Term> terms = new ArrayList<Term>();
        for (OctTerm t : this.mTerms) {
            terms.add(t.toTerm(script));
        }
        Term[] termArray = new Term[terms.size()];
        if ((termArray = terms.toArray(termArray)).length == 1) {
            return termArray[0];
        }
        return script.term("and", termArray);
    }

    public boolean isEmpty() {
        return this.mTerms.isEmpty();
    }
}

