/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.math.BigInteger;

public abstract class OctTerm {
    protected final TermVariable mFirstVar;
    protected final TermVariable mSecondVar;
    protected final boolean mFirstNegative;
    protected final boolean mSecondNegative;
    protected final Object mValue;

    public OctTerm(Object value, TermVariable firstVar, boolean firstNegative, TermVariable secondVar, boolean secondNegative) {
        this.mValue = value;
        this.mFirstVar = firstVar;
        this.mFirstNegative = firstNegative;
        this.mSecondVar = secondVar;
        this.mSecondNegative = secondNegative;
    }

    public OctTerm(Object value, TermVariable firstVar, boolean firstNegative) {
        this.mValue = value;
        this.mFirstVar = firstVar;
        this.mFirstNegative = firstNegative;
        this.mSecondVar = firstVar;
        this.mSecondNegative = firstNegative;
    }

    public Term toTerm(Script script) {
        Term leftTerm = this.leftTerm(script);
        Term rightTerm = this.rightTerm(script);
        return script.term("<=", new Term[]{leftTerm, rightTerm});
    }

    protected Term leftTerm(Script script) {
        if (this.isOneVar()) {
            return script.term("*", new Term[]{this.isFirstNegative() ? SmtUtils.constructIntValue((Script)script, (BigInteger)BigInteger.valueOf(-2L)) : SmtUtils.constructIntValue((Script)script, (BigInteger)BigInteger.valueOf(2L)), this.mFirstVar});
        }
        return script.term("+", new Term[]{this.isFirstNegative() ? script.term("*", new Term[]{script.decimal("-1"), this.mFirstVar}) : this.mFirstVar, this.isSecondNegative() ? script.term("*", new Term[]{script.decimal("-1"), this.mSecondVar}) : this.mSecondVar});
    }

    protected abstract Term rightTerm(Script var1);

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isOneVar()) {
            sb.append(String.valueOf(this.isFirstNegative() ? "-" : "") + "2*" + this.mFirstVar.toString());
        } else {
            sb.append(String.valueOf(this.isFirstNegative() ? "-" : "") + this.mFirstVar.toString() + " + " + (this.isSecondNegative() ? "-" : "") + this.mSecondVar.toString());
        }
        sb.append(" <= ");
        sb.append(this.rightString());
        return sb.toString();
    }

    protected abstract String rightString();

    public abstract Object getValue();

    public boolean isOneVar() {
        return this.mFirstNegative == this.mSecondNegative && this.mFirstVar == this.mSecondVar;
    }

    public TermVariable getFirstVar() {
        return this.mFirstVar;
    }

    public TermVariable getSecondVar() {
        return this.mSecondVar;
    }

    public boolean isFirstNegative() {
        return this.mFirstNegative;
    }

    public boolean isSecondNegative() {
        return this.mSecondNegative;
    }
}

