/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.FastUPRUtils;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct.OctConjunction;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct.OctTerm;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct.OctagonFactory;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct.OctagonSubstitution;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct.OctagonSubstitutionTerm;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct.ParametricOctValue;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.logic.NonRecursive;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OctagonCalculator
extends NonRecursive {
    private final FastUPRUtils mUtils;
    private final ManagedScript mManagedScript;

    public OctagonCalculator(FastUPRUtils utils, ManagedScript mgdScript) {
        this.mUtils = utils;
        this.mManagedScript = mgdScript;
    }

    public OctConjunction removeInOutVars(OctConjunction conjunc, Map<IProgramVar, TermVariable> inVars, Map<IProgramVar, TermVariable> outVars) {
        OctConjunction result = conjunc;
        for (Map.Entry<IProgramVar, TermVariable> e : inVars.entrySet()) {
            if (!outVars.containsValue(e.getValue())) continue;
            Sort varSort = this.mManagedScript.getScript().sort("Int", new Sort[0]);
            String inName = "oct_" + e.getKey().toString() + "_in";
            TermVariable inVar = this.mManagedScript.constructFreshTermVariable(inName, varSort);
            String outName = "oct_" + e.getKey().toString() + "_out";
            TermVariable outVar = this.mManagedScript.constructFreshTermVariable(outName, varSort);
            result = OctagonCalculator.replaceInOutVars(result, e.getValue(), inVar);
            result = OctagonCalculator.getInOutVarTerms(result, inVar, outVar);
            inVars.put(e.getKey(), inVar);
            outVars.put(e.getKey(), outVar);
        }
        return result;
    }

    private static OctConjunction getInOutVarTerms(OctConjunction conjunc, TermVariable inVar, TermVariable outVar) {
        OctConjunction result = conjunc;
        result.addTerm(OctagonFactory.createTwoVarOctTerm(BigDecimal.ZERO, inVar, false, outVar, true));
        result.addTerm(OctagonFactory.createTwoVarOctTerm(BigDecimal.ZERO, inVar, true, outVar, false));
        return result;
    }

    private static OctConjunction replaceInOutVars(OctConjunction conjunc, TermVariable inOutVar, TermVariable inVar) {
        OctConjunction result = new OctConjunction();
        for (OctTerm t : conjunc.getTerms()) {
            if (t.isOneVar() && t.getFirstVar().equals(inOutVar)) {
                result.addTerm(OctagonFactory.createOneVarOctTerm(t.getValue(), inVar, t.isFirstNegative()));
                continue;
            }
            if (t.getFirstVar().equals(inOutVar)) {
                result.addTerm(OctagonFactory.createTwoVarOctTerm(t.getValue(), inVar, t.isFirstNegative(), t.getSecondVar(), t.isSecondNegative()));
                continue;
            }
            if (t.getSecondVar().equals(inOutVar)) {
                result.addTerm(OctagonFactory.createTwoVarOctTerm(t.getValue(), t.getFirstVar(), t.isFirstNegative(), inVar, t.isSecondNegative()));
                continue;
            }
            result.addTerm(t);
        }
        return result;
    }

    public OctConjunction normalizeVarNames(OctConjunction conjunc, Map<IProgramVar, TermVariable> inVars, Map<IProgramVar, TermVariable> outVars) {
        TermVariable newVar;
        String name;
        this.mUtils.debug("Normalizing VarNames for:");
        this.mUtils.debug(conjunc.toString());
        OctConjunction result = conjunc;
        Sort varSort = this.mManagedScript.getScript().sort("Int", new Sort[0]);
        for (IProgramVar p : inVars.keySet()) {
            if (outVars.containsKey(p) && outVars.get(p).equals(inVars.get(p))) {
                name = "oct_" + p.toString() + "_inout";
                newVar = this.mManagedScript.constructFreshTermVariable(name, varSort);
                result = this.replaceVars(result, inVars.get(p), newVar);
                inVars.put(p, newVar);
                outVars.put(p, newVar);
            } else {
                name = "oct_" + p.toString() + "_in";
                newVar = this.mManagedScript.constructFreshTermVariable(name, varSort);
                result = this.replaceVars(result, inVars.get(p), newVar);
                inVars.put(p, newVar);
            }
            this.mUtils.debug(inVars.toString());
        }
        for (IProgramVar p : outVars.keySet()) {
            if (!outVars.containsKey(p) || outVars.get(p).equals(inVars.get(p))) continue;
            name = "oct_" + p.toString() + "_out";
            newVar = this.mManagedScript.constructFreshTermVariable(name, varSort);
            result = this.replaceVars(result, outVars.get(p), newVar);
            outVars.put(p, newVar);
        }
        this.mUtils.debug(result.toString());
        return result;
    }

    private OctConjunction replaceVars(OctConjunction conjunc, TermVariable oldVar, TermVariable newVar) {
        this.mUtils.debug("Replacing " + oldVar.toString() + " with " + newVar.toString());
        OctConjunction result = new OctConjunction();
        for (OctTerm t : conjunc.getTerms()) {
            OctTerm newTerm;
            this.mUtils.debug("Replacing in:");
            this.mUtils.debug(t.toString());
            boolean replaceFirst = false;
            boolean replaceSecond = false;
            if (t.getFirstVar().equals(oldVar)) {
                this.mUtils.debug(String.valueOf(t.getFirstVar().toString()) + " = " + oldVar.toString());
                replaceFirst = true;
            }
            if (t.getSecondVar().equals(oldVar)) {
                this.mUtils.debug(String.valueOf(t.getSecondVar().toString()) + " = " + oldVar.toString());
                replaceSecond = true;
            }
            if (t.isOneVar()) {
                newTerm = OctagonFactory.createOneVarOctTerm(t.getValue(), replaceFirst ? newVar : t.getFirstVar(), t.isFirstNegative());
                result.addTerm(newTerm);
                this.mUtils.debug(newTerm.toString());
            } else {
                newTerm = OctagonFactory.createTwoVarOctTerm(t.getValue(), replaceFirst ? newVar : t.getFirstVar(), t.isFirstNegative(), replaceSecond ? newVar : t.getSecondVar(), t.isSecondNegative());
                result.addTerm(newTerm);
                this.mUtils.debug(newTerm.toString());
            }
            this.mUtils.debug(">> replaced.");
        }
        this.mUtils.debug(">>> All replaced.");
        return result;
    }

    public OctConjunction sequentialize(OctConjunction conjunc, Map<IProgramVar, TermVariable> inVars, Map<IProgramVar, TermVariable> outVars, int count) {
        this.mUtils.debug("Sequentializing " + count + " times:" + conjunc.toString());
        LinkedHashSet<TermVariable> variables = new LinkedHashSet<TermVariable>();
        LinkedHashSet<TermVariable> inVarSet = new LinkedHashSet<TermVariable>();
        LinkedHashSet<TermVariable> outVarSet = new LinkedHashSet<TermVariable>();
        OctagonCalculator.getVariableSets(inVarSet, outVarSet, variables, inVars, outVars);
        OctConjunction result = conjunc;
        this.mUtils.debug("> Getting Variable Mapping:");
        this.mUtils.debug("inVars: " + inVars.toString());
        this.mUtils.debug("outVars: " + outVars.toString());
        Map<TermVariable, TermVariable> termMapping = OctagonCalculator.getTermMapping(inVars, outVars);
        Map<TermVariable, TermVariable> reverseTermMapping = OctagonCalculator.getReverseTermMapping(termMapping);
        this.mUtils.debug(termMapping.toString());
        int i = 0;
        while (i < count - 1) {
            this.mUtils.debug("Binary Sequentialize > " + (i + 1));
            result = this.binarySequentialize(result, conjunc, inVarSet, outVarSet, reverseTermMapping);
            this.mUtils.debug(result.toString());
            ++i;
        }
        this.mUtils.debug("Result: " + result.toString());
        return result;
    }

    private static void getVariableSets(Set<TermVariable> inVarSet, Set<TermVariable> outVarSet, Set<TermVariable> variableSet, Map<IProgramVar, TermVariable> inVarMap, Map<IProgramVar, TermVariable> outVarMap) {
        TermVariable value;
        assert (variableSet.isEmpty() && inVarSet.isEmpty() && outVarSet.isEmpty());
        for (Map.Entry<IProgramVar, TermVariable> p : inVarMap.entrySet()) {
            value = p.getValue();
            variableSet.add(value);
            inVarSet.add(value);
        }
        for (Map.Entry<IProgramVar, TermVariable> p : outVarMap.entrySet()) {
            value = p.getValue();
            variableSet.add(value);
            if (inVarSet.contains(value)) {
                inVarSet.remove(value);
                continue;
            }
            outVarSet.add(value);
        }
    }

    public OctConjunction binarySequentialize(OctConjunction first, OctConjunction second, Map<IProgramVar, TermVariable> inVars, Map<IProgramVar, TermVariable> outVars) {
        LinkedHashSet<TermVariable> variables = new LinkedHashSet<TermVariable>();
        LinkedHashSet<TermVariable> inVarSet = new LinkedHashSet<TermVariable>();
        LinkedHashSet<TermVariable> outVarSet = new LinkedHashSet<TermVariable>();
        OctagonCalculator.getVariableSets(inVarSet, outVarSet, variables, inVars, outVars);
        Map<TermVariable, TermVariable> termMapping = OctagonCalculator.getTermMapping(inVars, outVars);
        Map<TermVariable, TermVariable> reverseTermMapping = OctagonCalculator.getReverseTermMapping(termMapping);
        return this.binarySequentialize(first, second, inVarSet, outVarSet, reverseTermMapping);
    }

    private OctConjunction binarySequentialize(OctConjunction first, OctConjunction second, Set<TermVariable> inVarSet, Set<TermVariable> outVarSet, Map<TermVariable, TermVariable> variableMapping) {
        LinkedHashMap<TermVariable, OctagonSubstitution> firstSubstitutions = new LinkedHashMap<TermVariable, OctagonSubstitution>();
        for (TermVariable t : outVarSet) {
            firstSubstitutions.put(t, OctagonCalculator.getSubstitution(t, first));
        }
        this.mUtils.debug(((Object)firstSubstitutions).toString());
        Set<SubstitutionTermContainer> secondContainers = this.substituteInVars(this.getContainers(second), inVarSet, variableMapping);
        this.mUtils.debug("> Result:");
        this.mUtils.debug(secondContainers.toString());
        OctConjunction secondSubstituted = this.substitute(secondContainers, outVarSet, firstSubstitutions);
        this.mUtils.debug(second.toString());
        this.mUtils.debug(">> Substitutions finished.");
        OctConjunction inputConstraints = OctagonCalculator.getInputConstraints(first, inVarSet);
        OctConjunction outputConstraints = OctagonCalculator.getOutputConstraints(second, outVarSet);
        this.mUtils.debug(inputConstraints.toString());
        OctConjunction constraints = OctagonCalculator.conjunction(inputConstraints, outputConstraints);
        return OctagonCalculator.conjunction(secondSubstituted, constraints);
    }

    private static OctConjunction getOutputConstraints(OctConjunction second, Set<TermVariable> outVarSet) {
        OctConjunction result = new OctConjunction();
        for (OctTerm t : second.getTerms()) {
            if (!outVarSet.contains(t.getFirstVar()) || !outVarSet.contains(t.getSecondVar())) continue;
            result.addTerm(t);
        }
        return result;
    }

    private static OctConjunction getInputConstraints(OctConjunction first, Set<TermVariable> inVarSet) {
        OctConjunction result = new OctConjunction();
        for (OctTerm t : first.getTerms()) {
            if (!inVarSet.contains(t.getFirstVar()) || !inVarSet.contains(t.getSecondVar())) continue;
            result.addTerm(t);
        }
        return result;
    }

    private Set<SubstitutionTermContainer> getContainers(OctConjunction second) {
        LinkedHashSet<SubstitutionTermContainer> result = new LinkedHashSet<SubstitutionTermContainer>();
        for (OctTerm t : second.getTerms()) {
            result.add(new SubstitutionTermContainer(t));
        }
        return result;
    }

    private Set<SubstitutionTermContainer> substituteInVars(Set<SubstitutionTermContainer> terms, Set<TermVariable> varSet, Map<TermVariable, TermVariable> variableMapping) {
        this.mUtils.debug("> Subsituting inVars with outVars");
        this.mUtils.debug("Variable Set: " + varSet.toString());
        this.mUtils.debug("Variable Mapping: " + variableMapping.toString());
        LinkedHashSet<SubstitutionTermContainer> result = new LinkedHashSet<SubstitutionTermContainer>();
        this.mUtils.debug(terms.toString());
        for (SubstitutionTermContainer c : terms) {
            SubstitutionTermContainer container;
            OctTerm newTerm;
            TermVariable firstVar;
            OctTerm t = c.getTerm();
            this.mUtils.debug("Replacing in Term:" + t.toString());
            if (t.isOneVar()) {
                firstVar = t.getFirstVar();
                if (varSet.contains(firstVar)) {
                    firstVar = variableMapping.get(firstVar);
                }
                newTerm = OctagonFactory.createOneVarOctTerm(t.getValue(), firstVar, t.isFirstNegative());
                this.mUtils.debug("New Term:" + newTerm.toString());
                container = new SubstitutionTermContainer(newTerm, false);
            } else {
                firstVar = t.getFirstVar();
                TermVariable secondVar = t.getSecondVar();
                boolean firstLocked = true;
                boolean secondLocked = true;
                if (varSet.contains(firstVar)) {
                    firstVar = variableMapping.get(firstVar);
                    firstLocked = false;
                }
                if (varSet.contains(secondVar)) {
                    secondVar = variableMapping.get(secondVar);
                    secondLocked = false;
                }
                newTerm = OctagonFactory.createTwoVarOctTerm(t.getValue(), firstVar, t.isFirstNegative(), secondVar, t.isSecondNegative());
                this.mUtils.debug("New Term:" + newTerm.toString());
                container = new SubstitutionTermContainer(newTerm, firstLocked, secondLocked);
            }
            result.add(container);
        }
        this.mUtils.debug("InVars substituted.");
        return result;
    }

    private OctConjunction substitute(Set<SubstitutionTermContainer> terms, Set<TermVariable> varSet, Map<TermVariable, OctagonSubstitution> substitutions) {
        this.mUtils.debug("> Substituting a set of variables.");
        this.mUtils.debug("varSet:" + varSet.toString());
        OctConjunction result = new OctConjunction();
        LinkedHashSet<OctTerm> resultSet = new LinkedHashSet<OctTerm>();
        for (SubstitutionTermContainer c : terms) {
            OctTerm t = c.getTerm();
            this.mUtils.debug("-Substituting in: " + t.toString());
            this.mUtils.debug(c.isFirstLocked());
            if (varSet.contains(t.getFirstVar()) && !c.isFirstLocked()) {
                if (!t.isOneVar() && varSet.contains(t.getSecondVar()) && !c.isSecondLocked()) {
                    resultSet.addAll(this.getTermSubstitutions(t, substitutions, 0));
                    continue;
                }
                resultSet.addAll(this.getTermSubstitutions(t, substitutions, 1));
                continue;
            }
            if (varSet.contains(t.getSecondVar()) && !c.isSecondLocked()) {
                resultSet.addAll(this.getTermSubstitutions(t, substitutions, 2));
                continue;
            }
            resultSet.add(t);
        }
        for (OctTerm t : resultSet) {
            result.addTerm(t);
        }
        return result;
    }

    private Set<OctTerm> getTermSubstitutions(OctTerm t, Map<TermVariable, OctagonSubstitution> substitutions, int which) {
        LinkedHashSet<OctTerm> result = new LinkedHashSet<OctTerm>();
        if (which != 0) {
            TermVariable toReplace = which == 1 ? t.getFirstVar() : t.getSecondVar();
            boolean negative = which == 1 ? t.isFirstNegative() : t.isSecondNegative();
            this.mUtils.debug("Variable " + which + ": " + toReplace.toString());
            Set<OctagonSubstitutionTerm> subs = negative ? substitutions.get(toReplace).getLesserSubsitutions() : substitutions.get(toReplace).getGreaterSubsitutions();
            this.mUtils.debug("Substitutions: " + subs.toString());
            for (OctagonSubstitutionTerm sub : subs) {
                OctTerm newTerm = this.getTermFromSubsitution(t, sub, which);
                if (newTerm == null) continue;
                result.add(newTerm);
            }
        } else {
            TermVariable replaceFirst = t.getFirstVar();
            TermVariable replaceSecond = t.getSecondVar();
            boolean firstNegative = t.isFirstNegative();
            boolean secondNegative = t.isSecondNegative();
            this.mUtils.debug(String.valueOf(replaceFirst.toString()) + " and " + replaceSecond.toString());
            LinkedHashSet<OctTerm> tempResults = new LinkedHashSet<OctTerm>();
            Set<OctagonSubstitutionTerm> subs = firstNegative ? substitutions.get(replaceFirst).getLesserSubsitutions() : substitutions.get(replaceFirst).getGreaterSubsitutions();
            for (OctagonSubstitutionTerm sub : subs) {
                OctTerm newTerm = this.getTermFromSubsitution(t, sub, 1);
                if (newTerm == null) continue;
                tempResults.add(newTerm);
            }
            subs = secondNegative ? substitutions.get(replaceSecond).getLesserSubsitutions() : substitutions.get(replaceSecond).getGreaterSubsitutions();
            for (OctTerm tempTerm : tempResults) {
                for (OctagonSubstitutionTerm sub : subs) {
                    OctTerm newTerm = this.getTermFromSubsitution(tempTerm, sub, tempTerm.getFirstVar().equals(replaceSecond) ? 1 : 2);
                    if (newTerm == null) continue;
                    result.add(newTerm);
                }
            }
        }
        return result;
    }

    private OctTerm getTermFromSubsitution(OctTerm t, OctagonSubstitutionTerm sub, int which) {
        this.mUtils.debug("-Building new substituted Term from " + t.toString() + " with substitution " + sub.toString());
        OctTerm result = t.isOneVar() ? (sub.isZeroVar() ? null : OctagonFactory.createOneVarOctTerm(this.getSubsitutionValue(t.getValue(), sub.getValue(), 0), sub.getVar(), sub.isVarNegative())) : (sub.isZeroVar() ? OctagonFactory.createOneVarOctTerm(this.getSubsitutionValue(t.getValue(), sub.getValue(), 1), which == 1 ? t.getSecondVar() : t.getFirstVar(), which == 1 ? t.isSecondNegative() : t.isFirstNegative()) : OctagonFactory.createTwoVarOctTerm(this.getSubsitutionValue(t.getValue(), sub.getValue(), 2), which == 1 ? t.getSecondVar() : t.getFirstVar(), which == 1 ? t.isSecondNegative() : t.isFirstNegative(), sub.getVar(), sub.isVarNegative()));
        this.mUtils.debug("-Result: " + (result != null ? result.toString() : "null"));
        return result;
    }

    private Object getSubsitutionValue(Object value1, Object value2, int i) {
        if (i == 2) {
            return OctagonCalculator.addValues(value1, value2);
        }
        if (i == 1) {
            return OctagonCalculator.addValues(value1, value2, new BigDecimal(2), BigDecimal.ONE);
        }
        return OctagonCalculator.addValues(value1, value2, BigDecimal.ONE, new BigDecimal(2));
    }

    private static Object addValues(Object value1, Object value2) {
        return OctagonCalculator.addValues(value1, value2, BigDecimal.ONE, BigDecimal.ONE);
    }

    private static Object addValues(Object value1, Object value2, BigDecimal one, BigDecimal two) {
        Object finalValue1 = value1;
        Object finalValue2 = value2;
        if (finalValue1 instanceof ParametricOctValue) {
            finalValue1 = ((ParametricOctValue)finalValue1).multipy(one);
            finalValue2 = finalValue2 instanceof ParametricOctValue ? ((ParametricOctValue)finalValue2).multipy(two) : ((BigDecimal)finalValue2).multiply(two);
            return ((ParametricOctValue)finalValue1).add(finalValue2);
        }
        if (finalValue2 instanceof ParametricOctValue) {
            finalValue2 = ((ParametricOctValue)finalValue2).multipy(two);
            finalValue1 = finalValue1 instanceof ParametricOctValue ? ((ParametricOctValue)finalValue1).multipy(one) : ((BigDecimal)finalValue1).multiply(one);
            return ((ParametricOctValue)finalValue2).add(finalValue1);
        }
        finalValue1 = ((BigDecimal)finalValue1).multiply(one);
        finalValue2 = ((BigDecimal)finalValue2).multiply(two);
        return ((BigDecimal)finalValue1).add((BigDecimal)finalValue2);
    }

    private static OctConjunction conjunction(OctConjunction first, OctConjunction second) {
        OctConjunction result = new OctConjunction();
        for (OctTerm t : first.getTerms()) {
            result.addTerm(t);
        }
        for (OctTerm t : second.getTerms()) {
            result.addTerm(t);
        }
        return result;
    }

    private static Map<TermVariable, TermVariable> getTermMapping(Map<IProgramVar, TermVariable> inVars, Map<IProgramVar, TermVariable> outVars) {
        LinkedHashMap<TermVariable, TermVariable> result = new LinkedHashMap<TermVariable, TermVariable>();
        for (Map.Entry<IProgramVar, TermVariable> p : outVars.entrySet()) {
            TermVariable outVar = p.getValue();
            TermVariable inVar = inVars.get(p.getKey());
            if (outVar == null || inVar == null) continue;
            result.put(outVar, inVar);
        }
        return result;
    }

    public static Map<TermVariable, TermVariable> getReverseTermMapping(Map<TermVariable, TermVariable> termMapping) {
        LinkedHashMap<TermVariable, TermVariable> result = new LinkedHashMap<TermVariable, TermVariable>();
        for (TermVariable t : termMapping.keySet()) {
            result.put(termMapping.get(t), t);
        }
        return result;
    }

    private static OctagonSubstitution getSubstitution(TermVariable var, OctConjunction conjunc) {
        OctagonSubstitution result = new OctagonSubstitution(var);
        for (OctTerm t : conjunc.getTerms()) {
            result.addSubstitution(t);
        }
        return result;
    }

    public List<TermVariable> getSortedVariables(Map<IProgramVar, TermVariable> inVarMap, Map<IProgramVar, TermVariable> outVarMap) {
        LinkedHashSet<TermVariable> inVars = new LinkedHashSet<TermVariable>();
        LinkedHashSet<TermVariable> outVars = new LinkedHashSet<TermVariable>();
        LinkedHashSet<TermVariable> mixedVars = new LinkedHashSet<TermVariable>();
        for (IProgramVar p : inVarMap.keySet()) {
            inVars.add(inVarMap.get(p));
        }
        for (IProgramVar p : outVarMap.keySet()) {
            if (!inVars.contains(outVarMap.get(p))) {
                outVars.add(outVarMap.get(p));
                continue;
            }
            inVars.remove(outVarMap.get(p));
            mixedVars.add(outVarMap.get(p));
        }
        Comparator compare = (one, other) -> one.toString().compareTo(other.toString());
        ArrayList inVarList = new ArrayList(inVars);
        ArrayList outVarList = new ArrayList(outVars);
        ArrayList mixedVarList = new ArrayList(mixedVars);
        Collections.sort(inVarList, compare);
        Collections.sort(mixedVarList, compare);
        Collections.sort(outVarList, compare);
        inVarList.addAll(mixedVarList);
        inVarList.addAll(outVarList);
        ArrayList<TermVariable> sorted = new ArrayList<TermVariable>();
        sorted.addAll(inVarList);
        return sorted;
    }

    public FastUPRUtils getUtils() {
        return this.mUtils;
    }

    public boolean isTrivial(Map<IProgramVar, TermVariable> inVars, Map<IProgramVar, TermVariable> outVars) {
        for (Map.Entry<IProgramVar, TermVariable> e : inVars.entrySet()) {
            if (outVars.containsValue(e.getValue())) continue;
            return false;
        }
        for (Map.Entry<IProgramVar, TermVariable> e : outVars.entrySet()) {
            if (inVars.containsValue(e.getValue())) continue;
            return false;
        }
        return true;
    }

    private static class SubstitutionTermContainer {
        private final OctTerm mTerm;
        private final boolean mFirstLocked;
        private final boolean mSecondLocked;

        SubstitutionTermContainer(OctTerm term) {
            this(term, true, true);
        }

        SubstitutionTermContainer(OctTerm term, boolean locked) {
            this(term, locked, true);
        }

        SubstitutionTermContainer(OctTerm term, boolean first, boolean second) {
            this.mTerm = term;
            this.mFirstLocked = first;
            this.mSecondLocked = second;
        }

        public String toString() {
            return this.mTerm.toString();
        }

        OctTerm getTerm() {
            return this.mTerm;
        }

        boolean isFirstLocked() {
            return this.mFirstLocked;
        }

        boolean isSecondLocked() {
            return this.mSecondLocked;
        }
    }
}

