/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.NonRecursive;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class OctagonDetector
extends NonRecursive {
    private final HashSet<Term> mCheckedTerms;
    private final HashSet<Term> mSubTerms;
    private final HashSet<TermVariable> mCurrentVars;
    private final boolean mOctagon;
    private boolean mIsOctTerm;
    private final ManagedScript mManagedScript;
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;

    public OctagonDetector(ILogger logger, ManagedScript managedScript, IUltimateServiceProvider services) {
        this.mLogger = logger;
        this.mCheckedTerms = new HashSet();
        this.mSubTerms = new HashSet();
        this.mCurrentVars = new HashSet();
        this.mOctagon = true;
        this.mManagedScript = managedScript;
        this.mServices = services;
    }

    public Set<Term> getConjunctSubTerms(Term t) {
        Term cnfRelation = SmtUtils.toCnf((IUltimateServiceProvider)this.mServices, (ManagedScript)this.mManagedScript, (Term)t, (SmtUtils.XnfConversionTechnique)SmtUtils.XnfConversionTechnique.BOTTOM_UP_WITH_LOCAL_SIMPLIFICATION);
        this.mCheckedTerms.clear();
        this.run(new ConjunctionWalker(cnfRelation));
        return this.mSubTerms;
    }

    private void addConjunctTerms(Term t) {
        this.mLogger.debug((Object)("Current Term:" + t.toString()));
        if (this.mCheckedTerms.contains(t)) {
            this.mLogger.debug((Object)"Already checked");
            return;
        }
        if (t instanceof ApplicationTerm) {
            this.mLogger.debug((Object)"ApplicationTerm");
            ApplicationTerm aT = (ApplicationTerm)t;
            if (aT.getFunction().getName().compareTo("and") == 0) {
                this.mCheckedTerms.add(t);
                this.mLogger.debug((Object)("> with function name = " + aT.getFunction().getName()));
                Term[] termArray = aT.getParameters();
                int n = termArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Term arg = termArray[n2];
                    this.enqueueWalker(new ConjunctionWalker(arg));
                    ++n2;
                }
                return;
            }
        }
        this.mLogger.debug((Object)"Other Term or other Application Term");
        this.mSubTerms.add(t);
        this.mCheckedTerms.add(t);
    }

    public boolean isOctTerm(Term t) {
        this.mCheckedTerms.clear();
        this.mIsOctTerm = true;
        this.mCurrentVars.clear();
        this.run(new OctagonDetectionWalker(t));
        this.mLogger.debug((Object)(this.mIsOctTerm ? "Term is Oct" : "Term is NOT Oct"));
        return this.mIsOctTerm;
    }

    /*
     * Unable to fully structure code
     */
    private void check(Term t) {
        block9: {
            block8: {
                if (!this.mIsOctTerm) {
                    return;
                }
                this.mLogger.debug((Object)("Checking Term:" + t.toString()));
                if (!(t instanceof TermVariable)) break block8;
                this.mCurrentVars.add((TermVariable)t);
                if (this.mCurrentVars.size() > 2) {
                    this.mIsOctTerm = false;
                }
                break block9;
            }
            if (!(t instanceof ApplicationTerm)) ** GOTO lbl27
            aT = (ApplicationTerm)t;
            functionName = aT.getFunction().getName();
            validNames = Arrays.asList(new String[]{"<=", "<", ">", ">=", "=", "+"});
            if (validNames.contains(functionName)) {
                var8_5 = aT.getParameters();
                var7_6 = var8_5.length;
                var6_7 = 0;
                while (var6_7 < var7_6) {
                    arg = var8_5[var6_7];
                    this.enqueueWalker(new OctagonDetectionWalker(arg));
                    ++var6_7;
                }
            } else {
                this.mIsOctTerm = false;
                return;
lbl27:
                // 1 sources

                if (t instanceof ConstantTerm) {
                    return;
                }
                if (t instanceof AnnotatedTerm) {
                    this.enqueueWalker(new OctagonDetectionWalker(((AnnotatedTerm)t).getSubterm()));
                } else {
                    this.mIsOctTerm = false;
                    return;
                }
            }
        }
    }

    public void clearChecked() {
        this.mCheckedTerms.clear();
    }

    public Set<Term> getSubTerms() {
        return this.mSubTerms;
    }

    public boolean isOctagon() {
        return this.mOctagon;
    }

    private static class ConjunctionWalker
    implements NonRecursive.Walker {
        private final Term mTerm;

        public ConjunctionWalker(Term t) {
            this.mTerm = t;
        }

        public void walk(NonRecursive engine) {
            ((OctagonDetector)engine).addConjunctTerms(this.mTerm);
        }
    }

    private static class OctagonDetectionWalker
    implements NonRecursive.Walker {
        private final Term mTerm;

        OctagonDetectionWalker(Term t) {
            this.mTerm = t;
        }

        public void walk(NonRecursive engine) {
            ((OctagonDetector)engine).check(this.mTerm);
        }
    }
}

