/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct.OctTerm;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct.OctagonSubstitutionTerm;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.LinkedHashSet;
import java.util.Set;

class OctagonSubstitution {
    private final TermVariable mVar;
    private final Set<OctagonSubstitutionTerm> mGreaterEqThan;
    private final Set<OctagonSubstitutionTerm> mLesserEqThan;

    protected OctagonSubstitution(TermVariable var) {
        this.mVar = var;
        this.mGreaterEqThan = new LinkedHashSet<OctagonSubstitutionTerm>();
        this.mLesserEqThan = new LinkedHashSet<OctagonSubstitutionTerm>();
    }

    void addSubstitution(OctTerm term) {
        if (term.getFirstVar().equals(this.mVar)) {
            this.addSubstitution(term, true);
        } else if (term.getSecondVar().equals(this.mVar)) {
            this.addSubstitution(term, false);
        }
    }

    void addSubstitution(OctTerm term, boolean first) {
        OctagonSubstitutionTerm subTerm;
        boolean greater = false;
        if (first) {
            subTerm = term.isOneVar() ? new OctagonSubstitutionTerm(term.getValue()) : new OctagonSubstitutionTerm(term.getValue(), term.getSecondVar(), term.isSecondNegative());
            if (term.isFirstNegative()) {
                greater = true;
            }
        } else {
            subTerm = new OctagonSubstitutionTerm(term.getValue(), term.getFirstVar(), term.isFirstNegative());
            if (term.isSecondNegative()) {
                greater = true;
            }
        }
        this.addSubstitution(subTerm, greater);
    }

    void addSubstitution(OctagonSubstitutionTerm term, boolean greater) {
        if (greater) {
            this.mGreaterEqThan.add(term);
        } else {
            this.mLesserEqThan.add(term);
        }
    }

    Set<OctagonSubstitutionTerm> getGreaterSubsitutions() {
        return this.mGreaterEqThan;
    }

    Set<OctagonSubstitutionTerm> getLesserSubsitutions() {
        return this.mLesserEqThan;
    }

    public String toString() {
        if (this.mGreaterEqThan.isEmpty() && this.mLesserEqThan.isEmpty()) {
            return " > Substitution for " + this.mVar.toString() + " empty. \n";
        }
        StringBuilder sb = new StringBuilder(" > Substitution for " + this.mVar.toString() + ":\n");
        sb.append("Greater Equal Than: ");
        for (OctagonSubstitutionTerm t : this.mGreaterEqThan) {
            sb.append(String.valueOf(t.toString()) + "; ");
        }
        sb.append("\nLesser Equal Than: ");
        for (OctagonSubstitutionTerm t : this.mLesserEqThan) {
            sb.append(String.valueOf(t.toString()) + "; ");
        }
        sb.append("\n");
        return sb.toString();
    }
}

