/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.FastUPRUtils;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct.OctConjunction;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct.OctTerm;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct.OctagonDetector;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct.OctagonFactory;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct.ParametricOctMatrix;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct.ParametricOctTerm;
import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.NonRecursive;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class OctagonTransformer
extends NonRecursive {
    private final HashSet<Term> mCheckedTerms;
    private TermVariable mFirstVar;
    private TermVariable mSecondVar;
    private boolean mFirstNegative;
    private boolean mSecondNegative;
    private final OctagonDetector mOctagonDetector;
    private BigDecimal mValue;
    private InequalityType mType;
    private final Script mScript;
    private final HashSet<Term> mAdditionalTerms;
    private final FastUPRUtils mUtils;

    public OctagonTransformer(FastUPRUtils utils, Script script, OctagonDetector detector) {
        this.mOctagonDetector = detector;
        this.mUtils = utils;
        this.mCheckedTerms = new HashSet();
        this.mValue = new BigDecimal(0);
        this.mScript = script;
        this.mAdditionalTerms = new HashSet();
    }

    public OctConjunction transform(Term term) {
        return this.transform(this.mOctagonDetector.getConjunctSubTerms(term));
    }

    public OctConjunction transform(Set<Term> terms) {
        this.mCheckedTerms.clear();
        this.mAdditionalTerms.clear();
        this.mUtils.debug("Starting Term to OctagonTransformation");
        OctConjunction octagon = new OctConjunction();
        for (Term t : terms) {
            this.mUtils.debug("Getting Value from:" + t.toString());
            this.resetTerm();
            this.run(new OctagonTermWalker(t, InequalitySide.NONE));
            if (this.mType == InequalityType.LESSER) {
                this.mValue = this.mValue.subtract(new BigDecimal(1));
            }
            this.mUtils.debug("Value is:" + this.mValue.toString());
            if (this.mFirstVar == null) {
                this.mUtils.debug("ERROR");
                continue;
            }
            if (this.mSecondVar == null) {
                this.mValue = this.mValue.multiply(new BigDecimal(2));
                octagon.addTerm(OctagonFactory.createOneVarOctTerm(this.mValue, this.mFirstVar, this.mFirstNegative));
                continue;
            }
            octagon.addTerm(OctagonFactory.createTwoVarOctTerm(this.mValue, this.mFirstVar, this.mFirstNegative, this.mSecondVar, this.mSecondNegative));
        }
        for (Term t : this.mAdditionalTerms) {
            this.mUtils.debug("Getting Value from:" + t.toString());
            this.resetTerm();
            this.run(new OctagonTermWalker(t, InequalitySide.NONE));
            if (this.mType == InequalityType.LESSER) {
                this.mValue = this.mValue.subtract(new BigDecimal(1));
            }
            this.mUtils.debug("Value is:" + this.mValue.toString());
            if (this.mFirstVar == null) {
                this.mUtils.debug("ERROR");
                continue;
            }
            if (this.mSecondVar == null) {
                this.mValue = this.mValue.multiply(new BigDecimal(2));
                octagon.addTerm(OctagonFactory.createOneVarOctTerm(this.mValue, this.mFirstVar, this.mFirstNegative));
                continue;
            }
            octagon.addTerm(OctagonFactory.createTwoVarOctTerm(this.mValue, this.mFirstVar, this.mFirstNegative, this.mSecondVar, this.mSecondNegative));
        }
        this.mUtils.debug("Octagon:");
        this.mUtils.debug(octagon.toString());
        return octagon;
    }

    public ParametricOctMatrix getMatrix(OctConjunction conjunc, List<TermVariable> variables) {
        this.mUtils.debug(">> Converting OctagonConjunction to Matrix");
        this.mUtils.debug("> Conjunction: " + conjunc.toString());
        List<OctTerm> terms = conjunc.getTerms();
        ParametricOctMatrix result = new ParametricOctMatrix(variables.size());
        for (TermVariable termVariable : variables) {
            result.addVar(termVariable);
        }
        this.mUtils.debug(result.getMapping().toString());
        this.mUtils.debug("Created ParametricOctMatrix of size " + variables.size() * 2);
        for (OctTerm octTerm : terms) {
            if (octTerm instanceof ParametricOctTerm) {
                this.mUtils.getLogger().fatal((Object)"Parametric to Matrix Conversion not supported", (Throwable)new UnsupportedOperationException());
            }
            if (octTerm.isOneVar()) {
                result.setValue(octTerm.getValue(), octTerm.getFirstVar(), octTerm.isFirstNegative());
                continue;
            }
            result.setValue(octTerm.getValue(), octTerm.getFirstVar(), octTerm.isFirstNegative(), octTerm.getSecondVar(), octTerm.isSecondNegative());
        }
        return result;
    }

    private void addValue(ConstantTerm t, boolean negate) {
        BigDecimal value = BigDecimal.ZERO;
        if (t.getValue() instanceof Rational) {
            if (((Rational)t.getValue()).denominator().equals(BigInteger.ONE)) {
                value = new BigDecimal(((Rational)t.getValue()).numerator());
            }
        } else if (t.getValue() instanceof BigDecimal) {
            value = (BigDecimal)t.getValue();
        } else if (t.getValue() instanceof BigInteger) {
            value = new BigDecimal((BigInteger)t.getValue());
        }
        if (negate) {
            value = value.negate();
        }
        this.mValue = this.mValue.add(value);
    }

    private void addVariable(TermVariable var, boolean negative) {
        if (this.mFirstVar == null) {
            this.mFirstVar = var;
            this.mFirstNegative = negative;
        } else if (this.mSecondVar == null) {
            this.mSecondVar = var;
            this.mSecondNegative = negative;
        }
    }

    private void resetTerm() {
        this.mFirstVar = null;
        this.mSecondVar = null;
        this.mFirstNegative = false;
        this.mSecondNegative = false;
        this.mValue = new BigDecimal(0);
    }

    private void transformTerm(Term t, boolean negate) {
        this.mUtils.debug("> Walking over neutral Term: " + (negate ? "not: " : " " + t.toString()));
        if (this.mCheckedTerms.contains(t)) {
            return;
        }
        if (t instanceof ApplicationTerm) {
            ApplicationTerm aT = (ApplicationTerm)t;
            String functionName = aT.getFunction().getName();
            this.mUtils.debug(">> Application of type: " + functionName);
            Term term = t;
            if (functionName.compareTo("<") == 0) {
                this.mType = InequalityType.LESSER;
                term = aT;
            } else if (functionName.compareTo(">") == 0) {
                this.mType = InequalityType.LESSER;
                term = this.mScript.term("<", new Term[]{aT.getParameters()[1], aT.getParameters()[0]});
            } else if (functionName.compareTo("<=") == 0) {
                this.mType = InequalityType.LESSER_EQUAL;
                term = aT;
            } else if (functionName.compareTo(">=") == 0) {
                this.mType = InequalityType.LESSER_EQUAL;
                term = this.mScript.term("<=", new Term[]{aT.getParameters()[1], aT.getParameters()[0]});
            } else {
                if (functionName.compareTo("not") == 0) {
                    this.enqueueWalker(new OctagonTermWalker(aT.getParameters()[0], true));
                    return;
                }
                if (functionName.compareTo("=") == 0) {
                    this.mUtils.debug(">> EQUALITY");
                    Term first = this.mScript.term("<=", new Term[]{aT.getParameters()[0], aT.getParameters()[1]});
                    Term second = this.mScript.term("<=", new Term[]{aT.getParameters()[1], aT.getParameters()[0]});
                    this.enqueueWalker(new OctagonTermWalker(first, false));
                    this.mAdditionalTerms.add(second);
                    return;
                }
            }
            ApplicationTerm appTerm = (ApplicationTerm)term;
            if (negate) {
                if (this.mType == InequalityType.LESSER) {
                    appTerm = (ApplicationTerm)this.mScript.term("<=", new Term[]{appTerm.getParameters()[1], appTerm.getParameters()[0]});
                    this.mType = InequalityType.LESSER_EQUAL;
                } else {
                    appTerm = (ApplicationTerm)this.mScript.term("<", new Term[]{appTerm.getParameters()[1], appTerm.getParameters()[0]});
                    this.mType = InequalityType.LESSER;
                }
            }
            Term leftSide = appTerm.getParameters()[0];
            Term rightSide = appTerm.getParameters()[1];
            this.enqueueWalker(new OctagonTermWalker(leftSide, InequalitySide.LEFT));
            this.enqueueWalker(new OctagonTermWalker(rightSide, InequalitySide.RIGHT));
            return;
        }
        if (t instanceof AnnotatedTerm) {
            this.enqueueWalker(new OctagonTermWalker(((AnnotatedTerm)t).getSubterm(), InequalitySide.NONE));
            return;
        }
    }

    private void transformTermSide(Term t, InequalitySide side, boolean negate) {
        this.mUtils.debug("> Walking over " + (Object)((Object)side) + " Term: " + t.toString());
        this.mUtils.debug("Type: " + t.getClass().toString());
        if (t instanceof ApplicationTerm) {
            ApplicationTerm aT = (ApplicationTerm)t;
            String functionName = aT.getFunction().getName();
            this.mUtils.debug(">> Application of type: " + functionName);
            if (functionName.compareTo("-") == 0) {
                if (aT.getParameters().length == 1) {
                    this.enqueueWalker(new OctagonTermWalker(aT.getParameters()[0], side, !negate));
                } else if (aT.getParameters().length == 2) {
                    this.enqueueWalker(new OctagonTermWalker(aT.getParameters()[0], side, negate));
                    this.enqueueWalker(new OctagonTermWalker(aT.getParameters()[1], side, !negate));
                }
            } else if (functionName.compareTo("+") == 0) {
                Term[] termArray = aT.getParameters();
                int n = termArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Term arg = termArray[n2];
                    this.enqueueWalker(new OctagonTermWalker(arg, side, negate));
                    ++n2;
                }
            } else {
                functionName.compareTo("*");
            }
            return;
        }
        if (t instanceof TermVariable) {
            this.mUtils.debug(">> Variable");
            if (side == InequalitySide.LEFT) {
                this.addVariable((TermVariable)t, negate);
            } else {
                this.addVariable((TermVariable)t, !negate);
            }
            return;
        }
        if (t instanceof ConstantTerm) {
            this.mUtils.debug(">> Constant");
            if (side == InequalitySide.RIGHT) {
                this.addValue((ConstantTerm)t, negate);
            } else {
                this.addValue((ConstantTerm)t, !negate);
            }
            return;
        }
        if (t instanceof AnnotatedTerm) {
            this.enqueueWalker(new OctagonTermWalker(((AnnotatedTerm)t).getSubterm(), side));
            return;
        }
    }

    private static enum InequalitySide {
        NONE,
        LEFT,
        RIGHT;

    }

    private static enum InequalityType {
        NONE,
        LESSER,
        LESSER_EQUAL;

    }

    private static class OctagonTermWalker
    implements NonRecursive.Walker {
        private final Term mTerm;
        private final InequalitySide mSide;
        private final boolean mNegate;

        OctagonTermWalker(Term t, InequalitySide side) {
            this(t, side, false);
        }

        OctagonTermWalker(Term t, InequalitySide side, boolean negate) {
            this.mTerm = t;
            this.mSide = side;
            this.mNegate = negate;
        }

        OctagonTermWalker(Term t, boolean b) {
            this(t, InequalitySide.NONE, b);
        }

        public void walk(NonRecursive engine) {
            if (this.mSide == InequalitySide.NONE) {
                ((OctagonTransformer)engine).transformTerm(this.mTerm, this.mNegate);
            } else {
                ((OctagonTransformer)engine).transformTermSide(this.mTerm, this.mSide, this.mNegate);
            }
        }
    }
}

