/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct.OctConjunction;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct.OctTerm;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct.OctagonFactory;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct.ParametricOctValue;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.relational.octagon.OctMatrix;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.relational.octagon.OctValue;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;

public class ParametricOctMatrix {
    private ILogger mLogger;
    private OctMatrix mMatrix;
    private OctMatrix mSummands;
    private TermVariable mParametricVar;
    private boolean mParametric;
    private int mSize;
    private int mNextMaxValue = 0;
    private final Map<TermVariable, Integer> mVariableMapping;
    private final Map<Integer, TermVariable> mReverseMapping;
    public static final BiFunction<OctValue, OctValue, OctValue> sAddIgnoreInf = (x, y) -> {
        if (x.isInfinity() && y.isInfinity()) {
            return OctValue.INFINITY;
        }
        OctValue newX = x.isInfinity() ? OctValue.ZERO : x;
        OctValue newY = y.isInfinity() ? OctValue.ZERO : y;
        return newX.add(newY);
    };

    public ParametricOctMatrix() {
        this(0);
    }

    public ParametricOctMatrix(int size) {
        this.mVariableMapping = new HashMap<TermVariable, Integer>();
        this.mReverseMapping = new HashMap<Integer, TermVariable>();
        this.mSize = size;
        this.mParametric = false;
        this.mMatrix = new OctMatrix(size);
        this.mMatrix.fill(OctValue.INFINITY);
    }

    public ParametricOctMatrix(OctMatrix matrix, Map<TermVariable, Integer> mapping) {
        this.mSize = matrix.getSize();
        this.mMatrix = matrix.copy();
        this.mVariableMapping = mapping;
        this.mReverseMapping = new HashMap<Integer, TermVariable>();
        this.reverseMapping();
        this.mParametric = false;
    }

    public ParametricOctMatrix(OctMatrix matrix, Map<TermVariable, Integer> mapping, TermVariable var) {
        this.mSize = matrix.getSize();
        this.mMatrix = matrix.copy();
        this.mVariableMapping = mapping;
        this.mReverseMapping = new HashMap<Integer, TermVariable>();
        this.reverseMapping();
        this.mParametric = true;
        this.mSummands = new OctMatrix(matrix.variables());
        this.mSummands.fill(OctValue.INFINITY);
        this.mParametricVar = var;
    }

    public ParametricOctMatrix(OctMatrix matrix, OctMatrix summands, Map<TermVariable, Integer> mapping, TermVariable var) {
        this(matrix, mapping, var);
        this.mSummands = summands.copy();
        this.mParametric = true;
    }

    public void setLogger(ILogger logger) {
        this.mLogger = logger;
    }

    public ParametricOctMatrix add(ParametricOctMatrix summand) {
        if (!this.mappingMatch(summand)) {
            throw new IllegalArgumentException("Matrices need equal Mapping");
        }
        if (this.isParametric() || summand.isParametric()) {
            return this.parametricAdd(summand);
        }
        return new ParametricOctMatrix(this.mMatrix.add(summand.getMatrix()), this.mVariableMapping);
    }

    private ParametricOctMatrix parametricAdd(ParametricOctMatrix summand) {
        ParametricOctMatrix result;
        if (this.mParametric && !summand.isParametric()) {
            result = new ParametricOctMatrix(this.getMatrix(), this.addMatrices(this.getSummands(), summand.getMatrix(), true), this.getMapping(), this.getParametricVar());
            this.debug("Set Summands of result");
        } else if (!this.mParametric && summand.isParametric()) {
            this.debug("Matrix is not parametric, summand is.");
            result = summand.copy();
            result.mSummands = this.mMatrix.add(summand.getSummands());
        } else {
            this.debug("Both are parametric.");
            if (!this.mParametricVar.equals(summand.getParametricVar())) {
                throw new IllegalArgumentException("Matrices need the same parametric variable");
            }
            result = this.copy();
            result.mSummands = this.mSummands.add(summand.getSummands());
            result.mMatrix = this.mMatrix.add(summand.getMatrix());
        }
        return result;
    }

    public ParametricOctMatrix subtract(ParametricOctMatrix matrix) {
        if (this.mParametric || matrix.isParametric()) {
            throw new UnsupportedOperationException("Matrix is parametric");
        }
        this.debug("Subtraction");
        OctMatrix negated = ParametricOctMatrix.negateOctMatrix(matrix.getMatrix());
        this.debug("negated");
        this.debug(this.mSize);
        this.debug(matrix.getSize());
        ParametricOctMatrix result = new ParametricOctMatrix(this.mMatrix.add(negated), this.mVariableMapping);
        this.debug("...finished.");
        return result;
    }

    private static OctMatrix negateOctMatrix(OctMatrix matrix) {
        OctMatrix result = matrix.copy();
        int row = 0;
        while (row < 2 * matrix.variables()) {
            int col = 0;
            while (col < (row / 2 + 1) * 2) {
                result.set(row, col, matrix.get(row, col).negateIfNotInfinity());
                ++col;
            }
            ++row;
        }
        return result;
    }

    public boolean isEqualTo(ParametricOctMatrix other) {
        if (other == null) {
            return false;
        }
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        ParametricOctMatrix otherMatrix = other;
        if (this.isParametric() != otherMatrix.isParametric()) {
            return false;
        }
        if (!this.getMatrix().isEqualTo(otherMatrix.getMatrix())) {
            return false;
        }
        this.debug(this.isParametric());
        this.debug(this.getParametricVar() == null);
        if (this.isParametric() && otherMatrix.isParametric()) {
            if (!this.getParametricVar().equals(otherMatrix.getParametricVar())) {
                return false;
            }
            if (!this.getSummands().isEqualTo(otherMatrix.getSummands())) {
                return false;
            }
        }
        if (!this.mVariableMapping.equals(otherMatrix.getMapping())) {
            return false;
        }
        Object j = new Object();
        j.hashCode();
        return true;
    }

    public ParametricOctMatrix multiplyVar(String varname, ManagedScript mManagedScript) {
        if (this.isParametric()) {
            throw new IllegalArgumentException("Octagon already parametric.");
        }
        TermVariable var = mManagedScript.constructFreshTermVariable(varname, mManagedScript.getScript().sort("Int", new Sort[0]));
        return this.multipyVar(var);
    }

    public ParametricOctMatrix multipyVar(TermVariable var) {
        return new ParametricOctMatrix(this.mMatrix, this.mVariableMapping, var);
    }

    public ParametricOctMatrix multiplyConstant(BigDecimal bigDecimal) {
        OctMatrix newMatrix = this.mMatrix.copy();
        int row = 0;
        while (row < 2 * this.mMatrix.variables()) {
            int col = 0;
            while (col < (row / 2 + 1) * 2) {
                OctValue newValue = this.mMatrix.get(row, col).isInfinity() ? OctValue.INFINITY : new OctValue(this.mMatrix.get(row, col).getValue().multiply(bigDecimal));
                newMatrix.set(row, col, newValue);
                ++col;
            }
            ++row;
        }
        if (!this.mParametric) {
            return new ParametricOctMatrix(newMatrix, this.mVariableMapping);
        }
        OctMatrix newSummands = this.mSummands.copy();
        int row2 = 0;
        while (row2 < 2 * this.mSummands.variables()) {
            int col = 0;
            while (col < (row2 / 2 + 1) * 2) {
                newSummands.set(row2, col, this.mSummands.get(row2, col).isInfinity() ? OctValue.INFINITY : new OctValue(this.mSummands.get(row2, col).getValue().multiply(bigDecimal)));
                ++col;
            }
            ++row2;
        }
        return new ParametricOctMatrix(newMatrix, newSummands, this.mVariableMapping, this.mParametricVar);
    }

    private OctMatrix addMatrices(OctMatrix first, OctMatrix second, boolean infAsZero) {
        if (!infAsZero) {
            return first.add(second);
        }
        return first.elementwiseOperation(second, sAddIgnoreInf);
    }

    public int addVar(TermVariable var) {
        this.debug("Adding " + var.toString() + " to Mapping");
        this.mVariableMapping.put(var, this.mNextMaxValue);
        this.reverseMapping(var);
        if (this.mSize < this.mVariableMapping.size()) {
            this.debug("Size too small. " + this.mSize + " " + this.mVariableMapping.size() * 2);
            this.mMatrix = this.mMatrix.addVariables(1);
            this.mSize = this.mVariableMapping.size();
            assert (this.mSize == this.mMatrix.getSize()) : "ERROR MATRIX SIZES DO NOT MATCH";
        }
        this.mNextMaxValue += 2;
        return this.mVariableMapping.get(var);
    }

    public void setValue(Object value, TermVariable var, boolean negative) {
        this.setValue(value, var, negative, var, negative);
    }

    public void setValue(Object value, TermVariable firstVar, boolean firstNegative, TermVariable secondVar, boolean secondNegative) {
        int column;
        int row;
        this.debug("Setting value: " + value.toString());
        this.debug("FirstVar: " + firstVar.toString());
        this.debug("SecondVar: " + secondVar.toString());
        if (this.mVariableMapping.containsKey(firstVar)) {
            row = this.mVariableMapping.get(firstVar);
            this.debug("Row already known: " + row);
        } else {
            row = this.addVar(firstVar);
            this.debug("Row new Variable: " + row);
        }
        if (firstVar.equals(secondVar)) {
            column = row;
        } else if (this.mVariableMapping.containsKey(secondVar)) {
            column = this.mVariableMapping.get(secondVar);
            this.debug("Column already known: " + column);
        } else {
            column = this.addVar(secondVar);
            this.debug("Column new Variable: " + column);
        }
        if (firstNegative) {
            ++row;
        }
        if (!secondNegative) {
            ++column;
        }
        this.debug("Setting [" + row + "," + column + "] = " + value.toString());
        this.setValue(row, column, (BigDecimal)value);
    }

    private void setValue(int row, int column, BigDecimal value) {
        this.mMatrix.setMin(row, column, new OctValue(value));
    }

    private void reverseMapping() {
        for (TermVariable t : this.mVariableMapping.keySet()) {
            this.mReverseMapping.put(this.mVariableMapping.get(t), t);
        }
    }

    private void reverseMapping(TermVariable t) {
        this.mReverseMapping.put(this.mVariableMapping.get(t), t);
    }

    public OctConjunction toOctConjunction() {
        return this.toOctConjunction(0);
    }

    public OctConjunction toOctConjunction(int i) {
        this.debug("Converting to Octagon conjunction");
        OctConjunction conjunct = new OctConjunction();
        ArrayList<OctTerm> conjunctTerms = new ArrayList<OctTerm>();
        int row = 0;
        while (row < 2 * this.varCount()) {
            int col = 0;
            while (col < (row / 2 + 1) * 2) {
                OctValue summand;
                this.debug("Row, Col: " + row + ", " + col);
                OctValue coefficient = this.mMatrix.get(row, col);
                this.debug(coefficient.toString());
                OctValue octValue = summand = this.mParametric ? this.mSummands.get(row, col) : OctValue.INFINITY;
                if (!coefficient.isInfinity() || !summand.isInfinity()) {
                    if (coefficient.isInfinity()) {
                        conjunctTerms.add(this.toNonParametricTerm(summand, row, col));
                    } else if (this.mParametric) {
                        conjunctTerms.add(this.toParametricTerm(coefficient, summand, row, col, i));
                    } else if (summand.isInfinity()) {
                        conjunctTerms.add(this.toNonParametricTerm(coefficient, row, col));
                    }
                }
                ++col;
            }
            ++row;
        }
        for (OctTerm t : conjunctTerms) {
            conjunct.addTerm(t);
        }
        return conjunct;
    }

    private OctTerm toNonParametricTerm(OctValue value, int row, int col) {
        boolean secondNegative;
        boolean firstNegative = row % 2 != 0;
        boolean bl = secondNegative = col % 2 == 0;
        if ((row & 1) != 0) {
            --row;
        }
        if ((col & 1) != 0) {
            --col;
        }
        return OctagonFactory.createTwoVarOctTerm(value.getValue(), this.mReverseMapping.get(row), firstNegative, this.mReverseMapping.get(col), secondNegative);
    }

    private OctTerm toParametricTerm(OctValue coefficient, OctValue summand, int row, int col, int i) {
        boolean secondNegative;
        boolean firstNegative = row % 2 != 0;
        boolean bl = secondNegative = col % 2 == 0;
        if ((row & 1) != 0) {
            --row;
        }
        if ((col & 1) != 0) {
            --col;
        }
        ParametricOctValue value = new ParametricOctValue(coefficient.getValue(), summand.isInfinity() ? BigDecimal.ZERO : summand.getValue(), this.mParametricVar, new BigDecimal(i));
        return OctagonFactory.createTwoVarOctTerm(value, this.mReverseMapping.get(row), firstNegative, this.mReverseMapping.get(col), secondNegative);
    }

    public Term toTerm(Script script) {
        return this.toOctConjunction().toTerm(script);
    }

    public OctMatrix getMatrix() {
        return this.mMatrix.copy();
    }

    public int getSize() {
        return this.mSize;
    }

    public int varCount() {
        this.mVariableMapping.size();
        int cfr_ignored_0 = this.mSize / 2;
        return this.mVariableMapping.size();
    }

    public boolean isParametric() {
        return this.mParametric;
    }

    public TermVariable getParametricVar() {
        if (!this.isParametric()) {
            return null;
        }
        return this.mParametricVar;
    }

    public OctMatrix getSummands() {
        if (!this.isParametric()) {
            return null;
        }
        return this.mSummands.copy();
    }

    public Object getValue(int row, int col) {
        if (this.mParametric) {
            OctValue value1 = this.mMatrix.get(row, col);
            if (value1.equals((Object)OctValue.INFINITY)) {
                return null;
            }
            OctValue value2 = this.mSummands.get(row, col);
            if (value2.equals((Object)OctValue.INFINITY)) {
                return new ParametricOctValue(value1.getValue(), BigDecimal.ZERO, this.mParametricVar);
            }
            return new ParametricOctValue(value1.getValue(), value2.getValue(), this.mParametricVar);
        }
        OctValue value = this.mMatrix.get(row, col);
        if (value.equals((Object)OctValue.INFINITY)) {
            return null;
        }
        return value.getValue();
    }

    public Map<TermVariable, Integer> getMapping() {
        return this.mVariableMapping;
    }

    public ParametricOctMatrix copy() {
        if (this.mParametric) {
            return new ParametricOctMatrix(this.mMatrix, this.mSummands, this.mVariableMapping, this.mParametricVar);
        }
        return new ParametricOctMatrix(this.mMatrix, this.mVariableMapping);
    }

    public String toString() {
        String result = "ParametricOctMatrix";
        if (this.isParametric()) {
            result = String.valueOf(result) + " with parametric Variable " + this.mParametricVar.toString() + ":\n";
            result = String.valueOf(result) + "Coefficients: \n";
            result = String.valueOf(result) + this.mMatrix.toString();
            result = String.valueOf(result) + "\n";
            result = String.valueOf(result) + "Summands: \n";
            result = String.valueOf(result) + this.mSummands.toString();
        } else {
            result = String.valueOf(result) + ":\n";
            result = String.valueOf(result) + this.mMatrix.toString();
        }
        result = String.valueOf(result) + "\n VariableMapping: " + this.mVariableMapping.toString();
        return result;
    }

    private boolean mappingMatch(ParametricOctMatrix summand) {
        return summand.getMapping().equals(this.mVariableMapping);
    }

    private void debug(Object obj) {
        if (this.mLogger != null) {
            this.mLogger.debug(obj);
        }
    }
}

