/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct;

import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.math.BigDecimal;

public class ParametricOctValue {
    private final BigDecimal mCoefficient;
    private final BigDecimal mSummand;
    private final TermVariable mVar;
    private final BigDecimal mIncrement;

    ParametricOctValue() {
        this.mCoefficient = new BigDecimal("0");
        this.mSummand = new BigDecimal("0");
        this.mVar = null;
        this.mIncrement = null;
    }

    ParametricOctValue(BigDecimal coefficient, BigDecimal summand, TermVariable parametricVar) {
        this(coefficient, summand, parametricVar, BigDecimal.ZERO);
    }

    ParametricOctValue(BigDecimal coefficient, BigDecimal summand, TermVariable parametricVar, BigDecimal increment) {
        this.mCoefficient = coefficient;
        this.mSummand = summand;
        this.mVar = parametricVar;
        this.mIncrement = increment;
    }

    BigDecimal getCoefficient() {
        return this.mCoefficient;
    }

    BigDecimal getSummand() {
        return this.mSummand;
    }

    TermVariable getVariable() {
        return this.mVar;
    }

    BigDecimal getIncrement() {
        return this.mIncrement;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(String.valueOf(this.mCoefficient.toString()) + " * ");
        if (this.mIncrement.equals(BigDecimal.ZERO)) {
            sb.append(this.mVar.toString());
        } else {
            sb.append("(" + this.mVar.toString() + "+" + this.mIncrement.toString() + ")");
        }
        sb.append(" + " + this.mSummand.toString());
        return sb.toString();
    }

    public ParametricOctValue add(ParametricOctValue value) {
        return new ParametricOctValue(this.mCoefficient.add(value.getCoefficient()), this.mSummand.add(value.getSummand()), this.mVar, this.mIncrement);
    }

    public ParametricOctValue add(BigDecimal value) {
        return new ParametricOctValue(this.mCoefficient, this.mSummand.add(value), this.mVar, this.mIncrement);
    }

    public ParametricOctValue multipy(BigDecimal value) {
        return new ParametricOctValue(this.mCoefficient.multiply(value), this.mSummand.multiply(value), this.mVar, this.mIncrement);
    }

    public Object add(Object value) {
        if (value instanceof ParametricOctValue) {
            return this.add((ParametricOctValue)value);
        }
        return this.add((BigDecimal)value);
    }

    public Term getTerm(Script script) {
        TermVariable inner = this.mIncrement.equals(BigDecimal.ZERO) ? this.mVar : script.term("+", new Term[]{this.mVar, script.decimal(this.mIncrement)});
        Term coeff = this.mCoefficient.equals(BigDecimal.ZERO) ? script.decimal(BigDecimal.ZERO) : script.term("*", new Term[]{script.decimal(this.mCoefficient), inner});
        return this.mSummand.equals(BigDecimal.ZERO) ? coeff : script.term("+", new Term[]{coeff, script.decimal(this.mSummand)});
    }
}

