/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct.OctTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.math.BigDecimal;

public class StandardOctTerm
extends OctTerm {
    public StandardOctTerm(BigDecimal constant, TermVariable firstVar, boolean firstNegative, TermVariable secondVar, boolean secondNegative) {
        super(constant, firstVar, firstNegative, secondVar, secondNegative);
    }

    public StandardOctTerm(BigDecimal constant, TermVariable firstVar, boolean firstNegative) {
        super(constant, firstVar, firstNegative);
    }

    @Override
    public BigDecimal getValue() {
        return (BigDecimal)this.mValue;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getLeftString());
        sb.append(" <= ");
        sb.append(this.getRightString());
        return sb.toString();
    }

    private String getLeftString() {
        if (this.mFirstVar == null || this.mSecondVar == null) {
            return "Found wrong var";
        }
        if (this.isOneVar()) {
            return String.valueOf(this.mFirstNegative ? "-" : "") + "2*" + this.mFirstVar.toString();
        }
        return String.valueOf(this.mFirstNegative ? "-" : "") + this.mFirstVar.toString() + (this.mSecondNegative ? " -" : " +") + this.mSecondVar.toString();
    }

    private String getRightString() {
        return this.mValue.toString();
    }

    @Override
    protected Term rightTerm(Script script) {
        return script.decimal(this.getValue());
    }

    @Override
    protected String rightString() {
        return this.getValue().toString();
    }
}

