/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.jordan;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.jordan.PolynomialTermMatrix;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.jordan.QuadraticMatrix;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.AffineTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.IPolynomialTerm;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class JordanAcceleratedUpdate {
    private JordanAcceleratedUpdate() {
    }

    static HashMap<Term, Integer> determineMatrixIndices(LinearUpdate linearUpdate) {
        HashMap<Term, Integer> varMatrixIndex = new HashMap<Term, Integer>();
        int i = 0;
        for (TermVariable updatedVar : linearUpdate.getUpdateMap().keySet()) {
            assert (!varMatrixIndex.containsKey(updatedVar)) : "cannot add same variable twice";
            varMatrixIndex.put((Term)updatedVar, i);
            ++i;
        }
        for (Term var : linearUpdate.getReadonlyVariables()) {
            assert (!varMatrixIndex.containsKey(var)) : "cannot add same variable twice";
            varMatrixIndex.put(var, i);
            ++i;
        }
        return varMatrixIndex;
    }

    static QuadraticMatrix computeUpdateMatrix(LinearUpdate linearUpdate, HashMap<Term, Integer> varMatrixIndexMap) {
        int n = varMatrixIndexMap.size() + 1;
        QuadraticMatrix updateMatrix = QuadraticMatrix.constructIdentityMatrix(n);
        for (Map.Entry<TermVariable, AffineTerm> update : linearUpdate.getUpdateMap().entrySet()) {
            JordanAcceleratedUpdate.fillMatrixRow(updateMatrix, varMatrixIndexMap, update.getValue(), update.getKey());
            int j = 0;
            while (j < n) {
                if (updateMatrix.getEntry(varMatrixIndexMap.get(update.getKey()), j) == null) {
                    return null;
                }
                ++j;
            }
        }
        return updateMatrix;
    }

    private static void fillMatrixRow(QuadraticMatrix updateMatrix, HashMap<Term, Integer> varMatrixIndexMap, AffineTerm affineRhs, TermVariable tv) {
        int n = updateMatrix.getDimension() - 1;
        updateMatrix.setEntry(n, n, BigInteger.valueOf(1L));
        updateMatrix.setEntry(varMatrixIndexMap.get(tv), varMatrixIndexMap.get(tv), BigInteger.valueOf(0L));
        for (Term termVar : varMatrixIndexMap.keySet()) {
            updateMatrix.setEntry(varMatrixIndexMap.get(tv), varMatrixIndexMap.get(termVar), JordanAcceleratedUpdate.determineCoefficient(affineRhs, termVar));
            if (updateMatrix.getEntry(varMatrixIndexMap.get(tv), varMatrixIndexMap.get(termVar)) == null) break;
            updateMatrix.setEntry(varMatrixIndexMap.get(tv), n, JordanAcceleratedUpdate.determineConstant((IPolynomialTerm)affineRhs));
        }
    }

    private static BigInteger determineCoefficient(AffineTerm affineRhs, Term termVar) {
        Rational coefficient = (Rational)affineRhs.getVariable2Coefficient().get(termVar);
        if (coefficient != null) {
            if (!coefficient.isIntegral()) {
                throw new AssertionError((Object)"Some coefficient is not integral.");
            }
            return coefficient.numerator();
        }
        return BigInteger.ZERO;
    }

    private static BigInteger determineConstant(IPolynomialTerm polyRhs) {
        Rational constant = polyRhs.getConstant();
        if (!constant.denominator().equals(BigInteger.valueOf(1L))) {
            throw new AssertionError((Object)"Constant in some term is not integral.");
        }
        return constant.numerator();
    }

    static boolean isAlternatingClosedFormRequired(QuadraticMatrix.JordanTransformationResult jordanUpdate) {
        boolean minus1isEigenvalue = jordanUpdate.getJordanBlockSizes().containsKey((Object)-1);
        boolean ev1hasBlockGreater2 = JordanAcceleratedUpdate.hasEv1JordanBlockStrictlyGreater2(jordanUpdate);
        return minus1isEigenvalue || ev1hasBlockGreater2;
    }

    private static boolean hasEv1JordanBlockStrictlyGreater2(QuadraticMatrix.JordanTransformationResult jordanUpdate) {
        boolean ev1hasBlockGreater2 = false;
        Iterator iterator = jordanUpdate.getJordanBlockSizes().get((Object)1).keySet().iterator();
        while (iterator.hasNext()) {
            int blockSize = (Integer)iterator.next();
            if (blockSize <= 2 || (Integer)jordanUpdate.getJordanBlockSizes().get((Object)1).get(blockSize) == 0) continue;
            ev1hasBlockGreater2 = true;
        }
        return ev1hasBlockGreater2;
    }

    static HashMap<TermVariable, Term> constructClosedForm(ManagedScript mgdScript, LinearUpdate linearUpdate, HashMap<Term, Integer> varMatrixIndexMap, QuadraticMatrix.JordanTransformationResult jordanUpdate, TermVariable it, TermVariable itHalf, boolean itEven, boolean restrictedVersionPossible) {
        PolynomialTermMatrix closedFormMatrix = PolynomialTermMatrix.computeClosedFormMatrix(mgdScript, jordanUpdate, it, itHalf, itEven, restrictedVersionPossible);
        HashMap<TermVariable, Term> closedFormMap = JordanAcceleratedUpdate.constructClosedForm(mgdScript, closedFormMatrix, linearUpdate, varMatrixIndexMap);
        return closedFormMap;
    }

    private static HashMap<TermVariable, Term> constructClosedForm(ManagedScript mgdScript, PolynomialTermMatrix closedFormMatrix, LinearUpdate linearUpdate, HashMap<Term, Integer> var2MatrixIndex) {
        Term[] matrixIndex2Var = new Term[var2MatrixIndex.size()];
        Iterator<Term> iterator = var2MatrixIndex.keySet().iterator();
        while (iterator.hasNext()) {
            Term var;
            matrixIndex2Var[var2MatrixIndex.get((Object)var).intValue()] = var = iterator.next();
        }
        HashMap<TermVariable, Term> closedForm = new HashMap<TermVariable, Term>();
        for (TermVariable tv : linearUpdate.getUpdateMap().keySet()) {
            Term sum = JordanAcceleratedUpdate.constructClosedForm(mgdScript, closedFormMatrix, var2MatrixIndex, matrixIndex2Var, tv);
            closedForm.put(tv, sum);
        }
        return closedForm;
    }

    private static Term constructClosedForm(ManagedScript mgdScript, PolynomialTermMatrix closedFormMatrix, HashMap<Term, Integer> var2MatrixIndex, Term[] matrixIndex2Var, TermVariable tv) {
        int varIndex = var2MatrixIndex.get(tv);
        int n = closedFormMatrix.getDimension();
        Term[] summands = new Term[n];
        int current = 0;
        int j = 0;
        while (j < n - 1) {
            Rational entryRational;
            if (!closedFormMatrix.getEntry(varIndex, j).isConstant() || (entryRational = closedFormMatrix.getEntry(varIndex, j).getConstant()).numerator().intValue() != 0) {
                summands[current] = closedFormMatrix.getEntry(varIndex, j).isConstant() ? ((entryRational = closedFormMatrix.getEntry(varIndex, j).getConstant()).numerator().intValue() == 1 && entryRational.denominator().intValue() == 1 ? matrixIndex2Var[j] : mgdScript.getScript().term("*", new Term[]{closedFormMatrix.getEntry(varIndex, j).toTerm(mgdScript.getScript()), matrixIndex2Var[j]})) : mgdScript.getScript().term("*", new Term[]{closedFormMatrix.getEntry(varIndex, j).toTerm(mgdScript.getScript()), matrixIndex2Var[j]});
                ++current;
            }
            ++j;
        }
        if (closedFormMatrix.getEntry(varIndex, n - 1).isConstant()) {
            Rational entryRational = closedFormMatrix.getEntry(varIndex, n - 1).getConstant();
            if (entryRational.numerator().intValue() != 0) {
                summands[current] = closedFormMatrix.getEntry(varIndex, n - 1).toTerm(mgdScript.getScript());
                ++current;
            }
        } else {
            summands[current] = closedFormMatrix.getEntry(varIndex, n - 1).toTerm(mgdScript.getScript());
            ++current;
        }
        Term sum = mgdScript.getScript().numeral(BigInteger.ZERO);
        sum = current == 0 ? mgdScript.getScript().numeral(BigInteger.ZERO) : (current == 1 ? summands[0] : mgdScript.getScript().term("+", Arrays.copyOfRange(summands, 0, current)));
        return sum;
    }

    static boolean isBlockSizeConsistent(int numberOfAssignedVariables, int numberOfReadonlyVariables, QuadraticMatrix.JordanTransformationResult jordanUpdate) {
        int blockSizeSum = 0;
        for (Triple triple : jordanUpdate.getJordanBlockSizes().entrySet()) {
            blockSizeSum += (Integer)triple.getSecond() * (Integer)triple.getThird();
        }
        return numberOfAssignedVariables + numberOfReadonlyVariables + 1 == blockSizeSum;
    }

    public static class LinearUpdate {
        Map<TermVariable, AffineTerm> mUpdateMap;
        Set<Term> mReadonlyVariables;

        public LinearUpdate(Map<TermVariable, AffineTerm> updateMap, Set<Term> readonlyVariables) {
            this.mUpdateMap = updateMap;
            this.mReadonlyVariables = readonlyVariables;
        }

        public Map<TermVariable, AffineTerm> getUpdateMap() {
            return this.mUpdateMap;
        }

        public Set<Term> getReadonlyVariables() {
            return this.mReadonlyVariables;
        }
    }
}

