/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.jordan;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.LoopAccelerationUtils;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.jordan.JordanAcceleratedUpdate;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.jordan.JordanLoopAccelerationStatisticsGenerator;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.jordan.QuadraticMatrix;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.SimultaneousUpdate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.PureSubstitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSelect;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms.NnfTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.AffineTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.IPolynomialTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.Monomial;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialTermTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierPusher;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Util;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class JordanLoopAcceleration {
    private static final boolean CONCATENATE_WITH_NEGATION_OF_GUARD = false;
    private static final boolean REFLEXIVE_TRANSITIVE_CLOSURE = false;

    private JordanLoopAcceleration() {
    }

    public static JordanLoopAccelerationResult accelerateLoop(IUltimateServiceProvider services, ManagedScript mgdScript, UnmodifiableTransFormula loopTransFormula, boolean quantifyItFinExplicitly) {
        SimultaneousUpdate su;
        ILogger logger = services.getLoggingService().getLogger(JordanLoopAcceleration.class);
        try {
            su = SimultaneousUpdate.fromTransFormula((IUltimateServiceProvider)services, (TransFormula)loopTransFormula, (ManagedScript)mgdScript);
        }
        catch (SimultaneousUpdate.SimultaneousUpdateException e) {
            JordanLoopAccelerationStatisticsGenerator jlasg = new JordanLoopAccelerationStatisticsGenerator(-1, -1, -1, (NestedMap2<Integer, Integer, Integer>)new NestedMap2());
            return new JordanLoopAccelerationResult(JordanLoopAccelerationResult.AccelerationStatus.SIMULTANEOUS_UPDATE_FAILED, e.getMessage(), null, jlasg);
        }
        int numberOfAssignedVariables = su.getDeterministicAssignment().size();
        su.getDeterministicArrayWrites().size();
        int numberOfHavocedVariables = su.getHavocedVars().size();
        Set<Sort> nonIntegerSorts = JordanLoopAcceleration.getNonIntegerSorts(su.getDeterministicAssignment().keySet());
        if (!nonIntegerSorts.isEmpty()) {
            JordanLoopAccelerationStatisticsGenerator jlasg = new JordanLoopAccelerationStatisticsGenerator(numberOfAssignedVariables, numberOfHavocedVariables, -1, (NestedMap2<Integer, Integer, Integer>)new NestedMap2());
            String errorMessage = "Some updated variables are of non-integer sorts : " + nonIntegerSorts;
            return new JordanLoopAccelerationResult(JordanLoopAccelerationResult.AccelerationStatus.NONINTEGER_UPDATE, errorMessage, null, jlasg);
        }
        Pair<JordanAcceleratedUpdate.LinearUpdate, String> pair = JordanLoopAcceleration.extractLinearUpdate(mgdScript, su);
        if (pair.getFirst() == null) {
            assert (pair.getSecond() != null);
            JordanLoopAccelerationStatisticsGenerator jlasg = new JordanLoopAccelerationStatisticsGenerator(numberOfAssignedVariables, numberOfHavocedVariables, -1, (NestedMap2<Integer, Integer, Integer>)new NestedMap2());
            return new JordanLoopAccelerationResult(JordanLoopAccelerationResult.AccelerationStatus.NONLINEAR_UPDATE, (String)pair.getSecond(), null, jlasg);
        }
        int numberOfReadonlyVariables = ((JordanAcceleratedUpdate.LinearUpdate)pair.getFirst()).getReadonlyVariables().size();
        HashMap<Term, Integer> varMatrixIndexMap = JordanAcceleratedUpdate.determineMatrixIndices((JordanAcceleratedUpdate.LinearUpdate)pair.getFirst());
        QuadraticMatrix updateMatrix = JordanAcceleratedUpdate.computeUpdateMatrix((JordanAcceleratedUpdate.LinearUpdate)pair.getFirst(), varMatrixIndexMap);
        QuadraticMatrix.JordanTransformationResult jordanUpdate = updateMatrix.constructJordanTransformation();
        if (jordanUpdate.getStatus() == QuadraticMatrix.JordanTransformationResult.JordanTransformationStatus.UNSUPPORTED_EIGENVALUES) {
            JordanLoopAccelerationStatisticsGenerator jlasg = new JordanLoopAccelerationStatisticsGenerator(numberOfAssignedVariables, numberOfHavocedVariables, numberOfReadonlyVariables, (NestedMap2<Integer, Integer, Integer>)new NestedMap2());
            return new JordanLoopAccelerationResult(JordanLoopAccelerationResult.AccelerationStatus.UNSUPPORTED_EIGENVALUES, null, null, jlasg);
        }
        assert (JordanAcceleratedUpdate.isBlockSizeConsistent(numberOfAssignedVariables, numberOfReadonlyVariables, jordanUpdate)) : "inconsistent blocksize";
        boolean isAlternatingClosedFormRequired = JordanAcceleratedUpdate.isAlternatingClosedFormRequired(jordanUpdate);
        UnmodifiableTransFormula loopAccelerationFormula = JordanLoopAcceleration.createLoopAccelerationFormula(logger, services, mgdScript, su, (JordanAcceleratedUpdate.LinearUpdate)pair.getFirst(), varMatrixIndexMap, jordanUpdate, loopTransFormula, true, quantifyItFinExplicitly, isAlternatingClosedFormRequired);
        JordanLoopAccelerationStatisticsGenerator jlasg = new JordanLoopAccelerationStatisticsGenerator(numberOfAssignedVariables, numberOfHavocedVariables, numberOfReadonlyVariables, jordanUpdate.getJordanBlockSizes());
        if (isAlternatingClosedFormRequired) {
            jlasg.reportAlternatingAcceleration();
        } else {
            jlasg.reportSequentialAcceleration();
        }
        if (QuantifierUtils.isQuantifierFree((Term)loopAccelerationFormula.getFormula())) {
            jlasg.reportQuantifierFreeResult();
        }
        return new JordanLoopAccelerationResult(JordanLoopAccelerationResult.AccelerationStatus.SUCCESS, null, loopAccelerationFormula, jlasg);
    }

    private static Pair<JordanAcceleratedUpdate.LinearUpdate, String> extractLinearUpdate(ManagedScript mgdScript, SimultaneousUpdate su) {
        HashSet<TermVariable> termVariablesOfModified = new HashSet<TermVariable>();
        for (Map.Entry update : su.getDeterministicAssignment().entrySet()) {
            termVariablesOfModified.add(((IProgramVar)update.getKey()).getTermVariable());
        }
        for (IProgramVar pv : su.getHavocedVars()) {
            termVariablesOfModified.add(pv.getTermVariable());
        }
        HashSet<Term> readonlyVariables = new HashSet<Term>();
        HashMap<TermVariable, AffineTerm> updateMap = new HashMap<TermVariable, AffineTerm>();
        for (Map.Entry<IProgramVar, Term> entry : su.getDeterministicAssignment().entrySet()) {
            Triple<AffineTerm, Set<Term>, String> triple = JordanLoopAcceleration.extractLinearUpdate(mgdScript, termVariablesOfModified, entry);
            if (triple.getFirst() == null) {
                assert (triple.getSecond() == null);
                assert (triple.getThird() != null);
                return new Pair(null, (Object)((String)triple.getThird()));
            }
            assert (triple.getSecond() != null);
            assert (triple.getThird() == null);
            updateMap.put(entry.getKey().getTermVariable(), (AffineTerm)triple.getFirst());
            readonlyVariables.addAll((Collection)triple.getSecond());
        }
        return new Pair((Object)new JordanAcceleratedUpdate.LinearUpdate(updateMap, readonlyVariables), null);
    }

    private static Triple<AffineTerm, Set<Term>, String> extractLinearUpdate(ManagedScript mgdScript, Set<TermVariable> termVariablesOfModified, Map.Entry<IProgramVar, Term> update) {
        IPolynomialTerm polyRhs = (IPolynomialTerm)new PolynomialTermTransformer(mgdScript.getScript()).transform(update.getValue());
        HashMap<Term, Rational> variables2coeffcient = new HashMap<Term, Rational>();
        HashSet<Term> readonlyVariables = new HashSet<Term>();
        for (Map.Entry entry : polyRhs.getMonomial2Coefficient().entrySet()) {
            Term monomialAsTerm = ((Monomial)entry.getKey()).toTerm(mgdScript.getScript());
            if (!termVariablesOfModified.contains(monomialAsTerm)) {
                TermVariable termVariableOfModified = JordanLoopAcceleration.containsTermVariableOfModified(termVariablesOfModified, monomialAsTerm);
                if (termVariableOfModified != null) {
                    String errorMessage = String.format("Monomial contains modified variable. Monomial %s, Variable %s", monomialAsTerm, termVariableOfModified);
                    return new Triple(null, null, (Object)errorMessage);
                }
                readonlyVariables.add(monomialAsTerm);
            }
            variables2coeffcient.put(monomialAsTerm, (Rational)entry.getValue());
        }
        AffineTerm affineTerm = new AffineTerm(polyRhs.getSort(), polyRhs.getConstant(), variables2coeffcient);
        return new Triple((Object)affineTerm, readonlyVariables, null);
    }

    private static TermVariable containsTermVariableOfModified(Set<TermVariable> termVariablesOfModified, Term monomialAsTerm) {
        TermVariable[] termVariableArray = monomialAsTerm.getFreeVars();
        int n = termVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            TermVariable tv = termVariableArray[n2];
            if (termVariablesOfModified.contains(tv)) {
                return tv;
            }
            ++n2;
        }
        return null;
    }

    private static Set<Sort> getNonIntegerSorts(Set<IProgramVar> programVariables) {
        HashSet<Sort> result = new HashSet<Sort>();
        for (IProgramVar pv : programVariables) {
            if (SmtSortUtils.isIntSort((Sort)pv.getSort())) continue;
            result.add(pv.getSort());
        }
        return result;
    }

    private static ClosedFormOfUpdate computeClosedFormOfUpdate(ManagedScript mgdScript, SimultaneousUpdate su, JordanAcceleratedUpdate.LinearUpdate linearUpdate, HashMap<Term, Integer> varMatrixIndexMap, QuadraticMatrix.JordanTransformationResult jordanUpdate, TermVariable it, TermVariable itHalf, Map<IProgramVar, TermVariable> inVars, boolean itEven, boolean restrictedVersionPossible) {
        for (Triple triple : su.getDeterministicArrayWrites().entrySet()) {
            for (Term entry : (ArrayIndex)triple.getSecond()) {
                for (TermVariable tv : Arrays.asList(entry.getFreeVars())) {
                    if (!SmtSortUtils.isArraySort((Sort)tv.getSort())) continue;
                    throw new UnsupportedOperationException("ArrayIndex contains modified variable");
                }
            }
        }
        HashMap<TermVariable, Term> closedFormWithInvarsMap = new HashMap<TermVariable, Term>();
        HashMap<TermVariable, Term> closedFormMap = JordanAcceleratedUpdate.constructClosedForm(mgdScript, linearUpdate, varMatrixIndexMap, jordanUpdate, it, itHalf, itEven, restrictedVersionPossible);
        HashMap<TermVariable, Term> defaultTv2inVar = new HashMap<TermVariable, Term>();
        for (Map.Entry<IProgramVar, TermVariable> entry : inVars.entrySet()) {
            defaultTv2inVar.put(entry.getKey().getTermVariable(), (Term)entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : closedFormMap.entrySet()) {
            closedFormWithInvarsMap.put((TermVariable)entry.getKey(), Substitution.apply((ManagedScript)mgdScript, defaultTv2inVar, (Term)((Term)entry.getValue())));
        }
        HashMap<IProgramVar, Term> closedFormForProgramVar = new HashMap<IProgramVar, Term>();
        for (IProgramVar pv : su.getDeterministicAssignment().keySet()) {
            closedFormForProgramVar.put(pv, (Term)closedFormWithInvarsMap.get(pv.getTermVariable()));
        }
        NestedMap2<IProgramVar, ArrayIndex, Term> array2Index2values = JordanLoopAcceleration.applySubstitutionToIndexAndValue(mgdScript, closedFormWithInvarsMap, (NestedMap2<IProgramVar, ArrayIndex, Term>)su.getDeterministicArrayWrites());
        JordanLoopAcceleration.checkIndices(mgdScript, array2Index2values, it);
        return new ClosedFormOfUpdate(closedFormForProgramVar, array2Index2values);
    }

    private static void checkIndices(ManagedScript mgdScript, NestedMap2<IProgramVar, ArrayIndex, Term> array2Index2values, TermVariable it) {
        for (Triple triple : array2Index2values.entrySet()) {
            JordanLoopAcceleration.checkIndex(mgdScript, (ArrayIndex)triple.getSecond(), it);
        }
    }

    private static void checkIndex(ManagedScript mgdScript, ArrayIndex index, TermVariable it) {
        List<IPolynomialTerm> polyIndex = index.stream().map(x -> PolynomialTermTransformer.convert((Script)mgdScript.getScript(), (Term)x)).collect(Collectors.toList());
        if (JordanLoopAcceleration.isStrictlyMonotone(polyIndex, it)) {
            return;
        }
        throw new UnsupportedOperationException("Index not moving: " + index);
    }

    private static boolean isStrictlyMonotone(List<IPolynomialTerm> polyIndex, TermVariable it) {
        boolean strictlyMonotone = false;
        for (IPolynomialTerm poly : polyIndex) {
            for (Map.Entry entry : poly.getMonomial2Coefficient().entrySet()) {
                Monomial.Occurrence occ = ((Monomial)entry.getKey()).isExclusiveVariable((Term)it);
                if (occ == Monomial.Occurrence.NON_EXCLUSIVE_OR_SUBTERM) {
                    throw new UnsupportedOperationException("Probably not monotone: " + entry.getKey());
                }
                if (occ != Monomial.Occurrence.AS_EXCLUSIVE_VARIABlE) continue;
                strictlyMonotone = true;
            }
        }
        return strictlyMonotone;
    }

    private static NestedMap2<IProgramVar, ArrayIndex, Term> applySubstitutionToIndexAndValue(ManagedScript mgdScript, Map<? extends Term, ? extends Term> substitutionMapping, NestedMap2<IProgramVar, ArrayIndex, Term> array2Index2Value) {
        NestedMap2 result = new NestedMap2();
        for (Triple triple : array2Index2Value.entrySet()) {
            List newIndexEntries = ((ArrayIndex)triple.getSecond()).stream().map(x -> Substitution.apply((ManagedScript)mgdScript, (Map)substitutionMapping, (Term)x)).collect(Collectors.toList());
            ArrayIndex newArrayIndex = new ArrayIndex(newIndexEntries);
            Term newValue = Substitution.apply((ManagedScript)mgdScript, substitutionMapping, (Term)((Term)triple.getThird()));
            result.put((Object)((IProgramVar)triple.getFirst()), (Object)newArrayIndex, (Object)newValue);
        }
        return result;
    }

    private static Term constructGuardOfClosedForm(ManagedScript mgdScript, UnmodifiableTransFormula guardTf, Map<IProgramVar, Term> closedFormOfUpdate, Map<IProgramVar, TermVariable> havocVarReplacements) {
        HashMap<IProgramVar, Object> map = new HashMap<IProgramVar, Object>();
        for (IProgramVar pv : guardTf.getInVars().keySet()) {
            Term updateTerm = closedFormOfUpdate.get(pv);
            if (updateTerm != null) {
                map.put(pv, updateTerm);
                continue;
            }
            TermVariable auxVar = havocVarReplacements.get(pv);
            if (auxVar != null) {
                map.put(pv, auxVar);
                continue;
            }
            map.put(pv, (Term)guardTf.getInVars().get(pv));
        }
        return TransFormulaUtils.renameInvars((TransFormula)guardTf, (ManagedScript)mgdScript, map);
    }

    private static UnmodifiableTransFormula createLoopAccelerationFormula(ILogger logger, IUltimateServiceProvider services, ManagedScript mgdScript, SimultaneousUpdate su, JordanAcceleratedUpdate.LinearUpdate linearUpdate, HashMap<Term, Integer> varMatrixIndexMap, QuadraticMatrix.JordanTransformationResult jordanUpdate, UnmodifiableTransFormula loopTransFormula, boolean restrictedVersionPossible, boolean quantifyItFinExplicitly, boolean isAlternatingClosedFormRequired) {
        Term transitiveClosure;
        TermVariable itFin;
        UnmodifiableTransFormula guardTf = TransFormulaUtils.computeGuard((UnmodifiableTransFormula)loopTransFormula, (ManagedScript)mgdScript, (IUltimateServiceProvider)services);
        HashMap<IProgramVar, TermVariable> newInVars = new HashMap<IProgramVar, TermVariable>(loopTransFormula.getInVars());
        Term xPrimeEqualsX = JordanLoopAcceleration.constructXPrimeEqualsX(mgdScript, newInVars, loopTransFormula.getOutVars());
        if (isAlternatingClosedFormRequired) {
            if (!su.getDeterministicArrayWrites().isEmpty()) {
                throw new UnsupportedOperationException("If alternating form is required we do not yet support arrays");
            }
            itFin = mgdScript.constructFreshTermVariable("itFinHalf", SmtSortUtils.getIntSort((Script)mgdScript.getScript()));
            transitiveClosure = JordanLoopAcceleration.createLoopAccelerationTermAlternating(logger, services, mgdScript, su, linearUpdate, varMatrixIndexMap, jordanUpdate, loopTransFormula, guardTf, itFin, newInVars);
        } else {
            itFin = mgdScript.constructFreshTermVariable("itFin", SmtSortUtils.getIntSort((Script)mgdScript.getScript()));
            transitiveClosure = JordanLoopAcceleration.createLoopAccelerationTermSequential(logger, services, mgdScript, su, linearUpdate, varMatrixIndexMap, jordanUpdate, loopTransFormula, guardTf, restrictedVersionPossible, itFin, newInVars);
        }
        Term accelerationTerm = transitiveClosure;
        UnmodifiableTransFormula loopAccelerationFormula = JordanLoopAcceleration.buildAccelerationTransFormula(logger, mgdScript, services, loopTransFormula, accelerationTerm, quantifyItFinExplicitly, itFin, newInVars);
        assert (LoopAccelerationUtils.checkSomePropertiesOfLoopAccelerationFormula(services, mgdScript, loopTransFormula, loopAccelerationFormula, false));
        return loopAccelerationFormula;
    }

    private static UnmodifiableTransFormula buildAccelerationTransFormula(ILogger logger, ManagedScript mgdScript, IUltimateServiceProvider services, UnmodifiableTransFormula loopTransFormula, Term loopAccelerationTerm, boolean quantifyItFinExplicitly, TermVariable itFin, Map<IProgramVar, TermVariable> inVars) {
        UnmodifiableTransFormula loopAccelerationFormula;
        Term nnf = new NnfTransformer(mgdScript, services, NnfTransformer.QuantifierHandling.KEEP).transform(loopAccelerationTerm);
        Term loopAccelerationFormulaWithoutQuantifiers = PartialQuantifierElimination.eliminateCompat((IUltimateServiceProvider)services, (ManagedScript)mgdScript, (boolean)true, (QuantifierPusher.PqeTechniques)QuantifierPusher.PqeTechniques.ALL, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.NONE, (Term)nnf);
        Term simplified = SmtUtils.simplify((ManagedScript)mgdScript, (Term)loopAccelerationFormulaWithoutQuantifiers, (Term)mgdScript.term(null, "true", new Term[0]), (IUltimateServiceProvider)services, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA);
        if (quantifyItFinExplicitly) {
            TransFormulaBuilder tfb = new TransFormulaBuilder(inVars, loopTransFormula.getOutVars(), loopTransFormula.getNonTheoryConsts().isEmpty(), loopTransFormula.getNonTheoryConsts(), loopTransFormula.getBranchEncoders().isEmpty(), (Collection)loopTransFormula.getBranchEncoders(), loopTransFormula.getAuxVars().isEmpty());
            tfb.setInfeasibility(loopTransFormula.isInfeasible());
            Term quantified = SmtUtils.quantifier((Script)mgdScript.getScript(), (int)0, Collections.singleton(itFin), (Term)simplified);
            tfb.setFormula(quantified);
            loopAccelerationFormula = tfb.finishConstruction(mgdScript);
        } else {
            TransFormulaBuilder tfb = new TransFormulaBuilder(inVars, loopTransFormula.getOutVars(), loopTransFormula.getNonTheoryConsts().isEmpty(), loopTransFormula.getNonTheoryConsts(), loopTransFormula.getBranchEncoders().isEmpty(), (Collection)loopTransFormula.getBranchEncoders(), false);
            tfb.addAuxVar(itFin);
            tfb.setInfeasibility(loopTransFormula.isInfeasible());
            tfb.setFormula(simplified);
            loopAccelerationFormula = tfb.finishConstruction(mgdScript);
        }
        return loopAccelerationFormula;
    }

    private static Term createLoopAccelerationTermSequential(ILogger logger, IUltimateServiceProvider services, ManagedScript mgdScript, SimultaneousUpdate su, JordanAcceleratedUpdate.LinearUpdate linearUpdate, HashMap<Term, Integer> varMatrixIndexMap, QuadraticMatrix.JordanTransformationResult jordanUpdate, UnmodifiableTransFormula loopTransFormula, UnmodifiableTransFormula guardTf, boolean restrictedVersionPossible, TermVariable itFin, Map<IProgramVar, TermVariable> inVars) {
        Script script = mgdScript.getScript();
        ClosedFormOfUpdate closedFormItFinTuple = JordanLoopAcceleration.computeClosedFormOfUpdate(mgdScript, su, linearUpdate, varMatrixIndexMap, jordanUpdate, itFin, null, loopTransFormula.getInVars(), true, restrictedVersionPossible);
        Map<IProgramVar, Term> closedFormItFin = closedFormItFinTuple.getScalarUpdates();
        ArrayList<Term> conjuncts = new ArrayList<Term>();
        Term firstConjunct = script.term(">", new Term[]{itFin, script.numeral(BigInteger.ZERO)});
        conjuncts.add(firstConjunct);
        TermVariable it = mgdScript.constructFreshTermVariable("it", SmtSortUtils.getIntSort((Script)script));
        Term leftSideOfImpl = JordanLoopAcceleration.constructIterationRange(script, BigInteger.ONE, it, BigInteger.ONE, itFin);
        ClosedFormOfUpdate closedFormIt = JordanLoopAcceleration.computeClosedFormOfUpdate(mgdScript, su, linearUpdate, varMatrixIndexMap, jordanUpdate, it, null, inVars, true, restrictedVersionPossible);
        Term guardOfClosedFormIt = JordanLoopAcceleration.constructGuardAfterIntermediateIterations(mgdScript, su.getHavocedVars(), guardTf, closedFormIt.getScalarUpdates());
        Term implication = Util.implies((Script)script, (Term[])new Term[]{leftSideOfImpl, guardOfClosedFormIt});
        HashSet<TermVariable> itSet = new HashSet<TermVariable>();
        itSet.add(it);
        Term fourthConjunct = SmtUtils.quantifier((Script)script, (int)1, itSet, (Term)implication);
        conjuncts.add(fourthConjunct);
        List<Term> arrayConstraints = JordanLoopAcceleration.constructArrayUpdateConstraints(services, mgdScript, loopTransFormula, itFin, it, closedFormIt);
        conjuncts.addAll(arrayConstraints);
        Term xPrimed = JordanLoopAcceleration.constructClosedUpdateConstraint(script, loopTransFormula, su, closedFormItFin);
        conjuncts.add(xPrimed);
        conjuncts.add(guardTf.getFormula());
        Term transitiveClosure = SmtUtils.and((Script)script, conjuncts);
        return transitiveClosure;
    }

    private static List<Term> constructArrayUpdateConstraints(IUltimateServiceProvider services, ManagedScript mgdScript, UnmodifiableTransFormula loopTransFormula, TermVariable itFin, TermVariable it, ClosedFormOfUpdate closedFormIt) {
        Script script = mgdScript.getScript();
        ArrayList<Term> arrayUpdateConstraints = new ArrayList<Term>();
        for (IProgramVar array : closedFormIt.getArrayUpdates().keySet()) {
            Set entries = closedFormIt.getArrayUpdates().get((Object)array).entrySet();
            if (entries.size() > 1) {
                throw new UnsupportedOperationException("several updates per array");
            }
            Map.Entry entry = entries.iterator().next();
            ArrayIndex index = (ArrayIndex)entry.getKey();
            Term value = (Term)entry.getValue();
            List<TermVariable> idx = JordanLoopAcceleration.constructIdxTermVariables(mgdScript, index.size());
            Term eq1 = SmtUtils.pairwiseEquality((Script)script, idx, (List)index);
            Term iterationRange = JordanLoopAcceleration.constructIterationRange(script, BigInteger.ZERO, it, BigInteger.ONE, itFin);
            Term inRangeIndexEquality = SmtUtils.and((Script)script, (Term[])new Term[]{iterationRange, eq1});
            Term valueUpdate = SmtUtils.equality((Script)script, (Term[])new Term[]{new MultiDimensionalSelect((Term)loopTransFormula.getOutVars().get(array), new ArrayIndex(idx), script).toTerm(script), value});
            Term impl1 = SmtUtils.implies((Script)script, (Term)inRangeIndexEquality, (Term)valueUpdate);
            Term quantified = SmtUtils.quantifier((Script)script, (int)1, Collections.singleton(it), (Term)impl1);
            Term conjunct1 = PartialQuantifierElimination.eliminate((IUltimateServiceProvider)services, (ManagedScript)mgdScript, (Term)quantified, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA);
            Term valueConstancy = SmtUtils.equality((Script)script, (Term[])new Term[]{new MultiDimensionalSelect((Term)loopTransFormula.getOutVars().get(array), new ArrayIndex(idx), script).toTerm(script), new MultiDimensionalSelect((Term)loopTransFormula.getInVars().get(array), new ArrayIndex(idx), script).toTerm(script)});
            Term existsInRangeEquality = SmtUtils.quantifier((Script)script, (int)0, Collections.singleton(it), (Term)inRangeIndexEquality);
            Term quantified2 = SmtUtils.implies((Script)script, (Term)SmtUtils.not((Script)mgdScript.getScript(), (Term)existsInRangeEquality), (Term)valueConstancy);
            Term conjunct2 = PartialQuantifierElimination.eliminate((IUltimateServiceProvider)services, (ManagedScript)mgdScript, (Term)quantified2, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA);
            Term conjunction = SmtUtils.and((Script)script, (Term[])new Term[]{conjunct1, conjunct2});
            Term all2 = SmtUtils.quantifier((Script)script, (int)1, idx, (Term)conjunction);
            arrayUpdateConstraints.add(all2);
        }
        return arrayUpdateConstraints;
    }

    private static List<TermVariable> constructIdxTermVariables(ManagedScript mgdScript, int dimension) {
        assert (dimension >= 1);
        Sort intSort = SmtSortUtils.getIntSort((Script)mgdScript.getScript());
        if (dimension == 1) {
            return Collections.singletonList(mgdScript.constructFreshTermVariable("idx", intSort));
        }
        if (dimension == 2) {
            return Arrays.asList(mgdScript.constructFreshTermVariable("idxDim1", intSort), mgdScript.constructFreshTermVariable("idxDim2", intSort));
        }
        throw new UnsupportedOperationException("Dimension not yet supported: " + dimension);
    }

    private static Term constructIterationRange(Script script, BigInteger lb, TermVariable it, BigInteger ubo, TermVariable itFin) {
        Term itGreaterLowerBould = script.term("<=", new Term[]{script.numeral(lb), it});
        Term itSmallerItFinMinusUbo = script.term("<=", new Term[]{it, SmtUtils.minus((Script)script, (Term[])new Term[]{itFin, script.numeral(ubo)})});
        return Util.and((Script)script, (Term[])new Term[]{itGreaterLowerBould, itSmallerItFinMinusUbo});
    }

    private static Term constructGuardAfterIntermediateIterations(ManagedScript mgdScript, Set<IProgramVar> havocedVars, UnmodifiableTransFormula guardTf, Map<IProgramVar, Term> closedFormIt) {
        HashMap<IProgramVar, TermVariable> havocReplacements = JordanLoopAcceleration.constructHavocReplacementsForIntermediateIteration(mgdScript, havocedVars);
        HashSet havocVarSet = new HashSet(havocReplacements.values());
        Term guardOfClosedFormItUnquantified = JordanLoopAcceleration.constructGuardOfClosedForm(mgdScript, guardTf, closedFormIt, havocReplacements);
        return SmtUtils.quantifier((Script)mgdScript.getScript(), (int)0, havocVarSet, (Term)guardOfClosedFormItUnquantified);
    }

    private static Term constructGuardAfterFinalIteration(ManagedScript mgdScript, Set<IProgramVar> havocedVars, Map<IProgramVar, TermVariable> outVars, UnmodifiableTransFormula guardTf, Map<IProgramVar, Term> closedFormItFin) {
        HashMap<IProgramVar, TermVariable> havocReplacements = JordanLoopAcceleration.constructHavocReplacementsForFinalIteration(havocedVars, outVars);
        return JordanLoopAcceleration.constructGuardOfClosedForm(mgdScript, guardTf, closedFormItFin, havocReplacements);
    }

    private static HashMap<IProgramVar, TermVariable> constructHavocReplacementsForIntermediateIteration(ManagedScript mgdScript, Set<IProgramVar> havocedVars) {
        HashMap<IProgramVar, TermVariable> havocReplacements = new HashMap<IProgramVar, TermVariable>();
        for (IProgramVar pv : havocedVars) {
            String varName = String.valueOf(pv.getTermVariable().getName()) + "_havocIntermIteration";
            havocReplacements.put(pv, mgdScript.variable(varName, pv.getSort()));
        }
        return havocReplacements;
    }

    private static HashMap<IProgramVar, TermVariable> constructHavocReplacementsForFinalIteration(Set<IProgramVar> havocedVars, Map<IProgramVar, TermVariable> outVars) {
        HashMap<IProgramVar, TermVariable> havocReplacements = new HashMap<IProgramVar, TermVariable>();
        for (IProgramVar pv : havocedVars) {
            havocReplacements.put(pv, outVars.get(pv));
        }
        return havocReplacements;
    }

    private static Term constructClosedUpdateConstraint(Script script, UnmodifiableTransFormula loopTf, SimultaneousUpdate su, Map<IProgramVar, Term> closedForm) {
        ArrayList<Term> equalities = new ArrayList<Term>();
        for (Map.Entry entry : su.getDeterministicAssignment().entrySet()) {
            Term lhs = (Term)loopTf.getOutVars().get(entry.getKey());
            Term rhs = closedForm.get(entry.getKey());
            Term equality = SmtUtils.binaryEquality((Script)script, (Term)lhs, (Term)rhs);
            equalities.add(equality);
        }
        return SmtUtils.and((Script)script, equalities);
    }

    @Deprecated
    private static Term constructArrayUpdateEquality(Script script, Map<IProgramVar, TermVariable> outVars, NestedMap2<IProgramVar, ArrayIndex, Term> arrayUpdates) {
        ArrayList<Term> terms = new ArrayList<Term>();
        for (Triple triple : arrayUpdates.entrySet()) {
            TermVariable arrayOutVar = outVars.get(triple.getFirst());
            MultiDimensionalSelect mds = new MultiDimensionalSelect((Term)arrayOutVar, (ArrayIndex)triple.getSecond(), script);
            terms.add(SmtUtils.equality((Script)script, (Term[])new Term[]{mds.toTerm(script), (Term)triple.getThird()}));
        }
        return SmtUtils.and((Script)script, terms);
    }

    private static Term createLoopAccelerationTermAlternating(ILogger logger, IUltimateServiceProvider services, ManagedScript mgdScript, SimultaneousUpdate su, JordanAcceleratedUpdate.LinearUpdate linearUpdate, HashMap<Term, Integer> varMatrixIndexMap, QuadraticMatrix.JordanTransformationResult jordanUpdate, UnmodifiableTransFormula loopTransFormula, UnmodifiableTransFormula guardTf, TermVariable itFinHalf, Map<IProgramVar, TermVariable> inVars) {
        Script script = mgdScript.getScript();
        Sort sort = SmtSortUtils.getIntSort((Script)script);
        Term itFinHalfGreater0 = script.term(">", new Term[]{itFinHalf, script.numeral(BigInteger.ZERO)});
        ClosedFormOfUpdate closedFormEvenItFin = JordanLoopAcceleration.computeClosedFormOfUpdate(mgdScript, su, linearUpdate, varMatrixIndexMap, jordanUpdate, null, itFinHalf, inVars, true, false);
        Term guardOfClosedFormEvenItFin = JordanLoopAcceleration.constructGuardAfterFinalIteration(mgdScript, su.getHavocedVars(), loopTransFormula.getOutVars(), guardTf, closedFormEvenItFin.getScalarUpdates());
        ClosedFormOfUpdate closedFormOddItFin = JordanLoopAcceleration.computeClosedFormOfUpdate(mgdScript, su, linearUpdate, varMatrixIndexMap, jordanUpdate, null, itFinHalf, inVars, false, false);
        Term guardOfClosedFormOddItFin = JordanLoopAcceleration.constructGuardAfterFinalIteration(mgdScript, su.getHavocedVars(), loopTransFormula.getOutVars(), guardTf, closedFormOddItFin.getScalarUpdates());
        TermVariable itHalf = mgdScript.constructFreshTermVariable("itHalf", sort);
        Term oneLeqItHalf = script.term("<=", new Term[]{script.numeral(BigInteger.ONE), itHalf});
        Term itHalfLeqItFinHalfM1 = script.term("<=", new Term[]{itHalf, script.term("-", new Term[]{itFinHalf, script.numeral(BigInteger.ONE)})});
        Term forallTerm1Implication1Left = Util.and((Script)script, (Term[])new Term[]{oneLeqItHalf, itHalfLeqItFinHalfM1});
        ClosedFormOfUpdate closedFormEvenIt = JordanLoopAcceleration.computeClosedFormOfUpdate(mgdScript, su, linearUpdate, varMatrixIndexMap, jordanUpdate, null, itHalf, inVars, true, false);
        Term guardOfClosedFormEvenIt = JordanLoopAcceleration.constructGuardAfterIntermediateIterations(mgdScript, su.getHavocedVars(), guardTf, closedFormEvenIt.getScalarUpdates());
        Term forallTerm1Implication1 = Util.implies((Script)script, (Term[])new Term[]{forallTerm1Implication1Left, guardOfClosedFormEvenIt});
        Term zeroLeqItHalf = script.term("<=", new Term[]{script.numeral(BigInteger.ZERO), itHalf});
        Term forallTerm1Implication2Left = Util.and((Script)script, (Term[])new Term[]{zeroLeqItHalf, itHalfLeqItFinHalfM1});
        ClosedFormOfUpdate closedFormOddIt = JordanLoopAcceleration.computeClosedFormOfUpdate(mgdScript, su, linearUpdate, varMatrixIndexMap, jordanUpdate, null, itHalf, inVars, false, false);
        Term guardOfClosedFormOddIt = JordanLoopAcceleration.constructGuardAfterIntermediateIterations(mgdScript, su.getHavocedVars(), guardTf, closedFormOddIt.getScalarUpdates());
        Term forallTerm1Implication2 = Util.implies((Script)script, (Term[])new Term[]{forallTerm1Implication2Left, guardOfClosedFormOddIt});
        Term forallTermConjunction1 = Util.and((Script)script, (Term[])new Term[]{forallTerm1Implication1, forallTerm1Implication2});
        HashSet<TermVariable> itHalfSet = new HashSet<TermVariable>();
        itHalfSet.add(itHalf);
        Term forallTerm1 = SmtUtils.quantifier((Script)script, (int)1, itHalfSet, (Term)forallTermConjunction1);
        Term itHalfLeqItFinHalf = script.term("<=", new Term[]{itHalf, itFinHalf});
        Term forallTerm2Implication1Left = Util.and((Script)script, (Term[])new Term[]{oneLeqItHalf, itHalfLeqItFinHalf});
        Term forallTerm2Implication1 = Util.implies((Script)script, (Term[])new Term[]{forallTerm2Implication1Left, guardOfClosedFormEvenIt});
        Term forallTerm2Implication2 = Util.implies((Script)script, (Term[])new Term[]{forallTerm1Implication2Left, guardOfClosedFormOddIt});
        Term forallTermConjunction2 = Util.and((Script)script, (Term[])new Term[]{forallTerm2Implication1, forallTerm2Implication2});
        Term forallTerm2 = SmtUtils.quantifier((Script)script, (int)1, itHalfSet, (Term)forallTermConjunction2);
        Term xPrimedEven = JordanLoopAcceleration.constructClosedUpdateConstraint(script, loopTransFormula, su, closedFormEvenItFin.getScalarUpdates());
        Term xPrimedOdd = JordanLoopAcceleration.constructClosedUpdateConstraint(script, loopTransFormula, su, closedFormOddItFin.getScalarUpdates());
        ArrayList<Term> innerConjuncts1 = new ArrayList<Term>();
        innerConjuncts1.add(itFinHalfGreater0);
        innerConjuncts1.add(guardTf.getFormula());
        innerConjuncts1.add(forallTerm1);
        innerConjuncts1.add(xPrimedEven);
        Term innerConjunction1 = SmtUtils.and((Script)script, innerConjuncts1);
        Term itFinHalfGeq0 = script.term(">=", new Term[]{itFinHalf, script.numeral(BigInteger.ZERO)});
        ArrayList<Term> innerConjuncts2 = new ArrayList<Term>();
        innerConjuncts2.add(itFinHalfGeq0);
        innerConjuncts2.add(guardTf.getFormula());
        innerConjuncts2.add(forallTerm2);
        innerConjuncts2.add(xPrimedOdd);
        Term innerConjunction2 = SmtUtils.and((Script)script, innerConjuncts2);
        Term disjunction = Util.or((Script)script, (Term[])new Term[]{innerConjunction1, innerConjunction2});
        return disjunction;
    }

    private static Term constructXPrimeEqualsX(ManagedScript mgdScript, Map<IProgramVar, TermVariable> modifiableInVars, Map<IProgramVar, TermVariable> outVars) {
        Term[] xPrimeEqualsXArray = new Term[outVars.size()];
        int k = 0;
        for (IProgramVar outVar : outVars.keySet()) {
            if (!modifiableInVars.containsKey(outVar)) {
                TermVariable inVar = mgdScript.constructFreshTermVariable(outVar.getGloballyUniqueId(), outVar.getTermVariable().getSort());
                modifiableInVars.put(outVar, inVar);
            }
            xPrimeEqualsXArray[k] = mgdScript.term(null, "=", new Term[]{(Term)outVars.get(outVar), (Term)modifiableInVars.get(outVar)});
            ++k;
        }
        Term xPrimeEqualsX = Util.and((Script)mgdScript.getScript(), (Term[])xPrimeEqualsXArray);
        return xPrimeEqualsX;
    }

    private static boolean checkCorrectnessOfQuantifierElimination(ILogger logger, Script script, Term quantifiedFormula, Term formulaWithoutQuantifiers) {
        if (Util.checkSat((Script)script, (Term)Util.and((Script)script, (Term[])new Term[]{quantifiedFormula, Util.not((Script)script, (Term)formulaWithoutQuantifiers)})) == Script.LBool.SAT) {
            throw new AssertionError((Object)"Something went wrong in quantifier elimination.");
        }
        if (Util.checkSat((Script)script, (Term)Util.and((Script)script, (Term[])new Term[]{quantifiedFormula, Util.not((Script)script, (Term)formulaWithoutQuantifiers)})) == Script.LBool.UNKNOWN) {
            logger.warn((Object)"Unable to prove correctness of quantifier elimination.");
        }
        if (Util.checkSat((Script)script, (Term)Util.and((Script)script, (Term[])new Term[]{formulaWithoutQuantifiers, Util.not((Script)script, (Term)quantifiedFormula)})) == Script.LBool.SAT) {
            throw new AssertionError((Object)"Something went wrong in quantifier elimination.");
        }
        if (Util.checkSat((Script)script, (Term)Util.and((Script)script, (Term[])new Term[]{formulaWithoutQuantifiers, Util.not((Script)script, (Term)quantifiedFormula)})) == Script.LBool.UNKNOWN) {
            logger.warn((Object)"Unable to prove correctness of quantifier elimination.");
        }
        return true;
    }

    private static boolean checkPropertiesOfLoopAccelerationFormula(ILogger logger, IUltimateServiceProvider services, ManagedScript mgdScript, UnmodifiableTransFormula loopTransFormula, Map<IProgramVar, TermVariable> inVars, Term loopAccelerationTerm, UnmodifiableTransFormula guardTf, Term xPrimeEqualsX, Term guardOfClosedFormEven, Term guardOfClosedFormOdd, TermVariable it, boolean restrictedVersion) {
        Script script = mgdScript.getScript();
        Term nnf = new NnfTransformer(mgdScript, services, NnfTransformer.QuantifierHandling.KEEP).transform(loopAccelerationTerm);
        Term loopAccelerationFormulaWithoutQuantifiers = PartialQuantifierElimination.eliminateCompat((IUltimateServiceProvider)services, (ManagedScript)mgdScript, (boolean)true, (QuantifierPusher.PqeTechniques)QuantifierPusher.PqeTechniques.ALL, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.NONE, (Term)nnf);
        Term simplified = SmtUtils.simplify((ManagedScript)mgdScript, (Term)loopAccelerationFormulaWithoutQuantifiers, (Term)mgdScript.term(null, "true", new Term[0]), (IUltimateServiceProvider)services, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA);
        assert (JordanLoopAcceleration.checkCorrectnessOfQuantifierElimination(logger, script, loopAccelerationTerm, simplified));
        script.echo(new QuotedObject("Check if formula equivalent to false"));
        if (Util.checkSat((Script)script, (Term)loopAccelerationTerm) == Script.LBool.UNSAT) {
            logger.warn((Object)"Reflexive-transitive closure is equivalent to false");
        }
        Term notLoopAccFormula = Util.not((Script)script, (Term)simplified);
        Term notGuard = Util.not((Script)script, (Term)guardTf.getFormula());
        HashMap<TermVariable, ConstantTerm> substitutionMapping1 = new HashMap<TermVariable, ConstantTerm>();
        if (restrictedVersion) {
            substitutionMapping1.put(it, (ConstantTerm)script.numeral(BigInteger.ONE));
        } else {
            substitutionMapping1.put(it, (ConstantTerm)script.numeral(BigInteger.ZERO));
        }
        Term guardOfClosedForm1 = Substitution.apply((ManagedScript)mgdScript, substitutionMapping1, (Term)guardOfClosedFormOdd);
        Term notGuardOfClosedForm1 = Util.not((Script)script, (Term)guardOfClosedForm1);
        if (Util.checkSat((Script)script, (Term)Util.and((Script)script, (Term[])new Term[]{loopTransFormula.getFormula(), notGuardOfClosedForm1, notLoopAccFormula})) == Script.LBool.UNKNOWN) {
            logger.warn((Object)"Unable to prove that computed reflexive-transitive closure contains relation itself.");
        }
        if (Util.checkSat((Script)script, (Term)Util.and((Script)script, (Term[])new Term[]{loopTransFormula.getFormula(), notGuardOfClosedForm1, notLoopAccFormula})) == Script.LBool.SAT) {
            throw new AssertionError((Object)"Computed reflexive-transitive closure does not contain relation itself.Something went wrong in computation of loop acceleration formula.");
        }
        ArrayList<UnmodifiableTransFormula> loopTransFormulaList = new ArrayList<UnmodifiableTransFormula>();
        loopTransFormulaList.add(loopTransFormula);
        loopTransFormulaList.add(loopTransFormula);
        UnmodifiableTransFormula sequentialComposition = TransFormulaUtils.sequentialComposition((ILogger)logger, (IUltimateServiceProvider)services, (ManagedScript)mgdScript, (boolean)true, (boolean)true, (boolean)false, (SmtUtils.XnfConversionTechnique)SmtUtils.XnfConversionTechnique.BOTTOM_UP_WITH_LOCAL_SIMPLIFICATION, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.NONE, loopTransFormulaList);
        HashMap<TermVariable, TermVariable> substitutionMappingSc = new HashMap<TermVariable, TermVariable>();
        for (IProgramVar iVar : sequentialComposition.getInVars().keySet()) {
            substitutionMappingSc.put((TermVariable)sequentialComposition.getInVars().get(iVar), inVars.get(iVar));
        }
        for (IProgramVar iVar : sequentialComposition.getOutVars().keySet()) {
            substitutionMappingSc.put((TermVariable)sequentialComposition.getOutVars().get(iVar), (TermVariable)loopTransFormula.getOutVars().get(iVar));
        }
        Term sequentialCompositionSubst = Substitution.apply((ManagedScript)mgdScript, substitutionMappingSc, (Term)sequentialComposition.getFormula());
        HashMap<TermVariable, ConstantTerm> substitutionMapping2 = new HashMap<TermVariable, ConstantTerm>();
        if (restrictedVersion) {
            substitutionMapping2.put(it, (ConstantTerm)script.numeral(BigInteger.TWO));
        } else {
            substitutionMapping2.put(it, (ConstantTerm)script.numeral(BigInteger.ONE));
        }
        PureSubstitution subst2 = new PureSubstitution(script, substitutionMapping2);
        Term notGuardOfClosedForm2 = Util.not((Script)script, (Term)subst2.transform(guardOfClosedFormEven));
        if (Util.checkSat((Script)script, (Term)Util.and((Script)script, (Term[])new Term[]{sequentialCompositionSubst, notGuardOfClosedForm2, notLoopAccFormula})) == Script.LBool.UNKNOWN) {
            logger.warn((Object)"Unable to prove that computed reflexive-transitive closure contains sequentialcomposition of relation with itself.");
        }
        if (Util.checkSat((Script)script, (Term)Util.and((Script)script, (Term[])new Term[]{sequentialCompositionSubst, notGuardOfClosedForm2, notLoopAccFormula})) == Script.LBool.SAT) {
            throw new AssertionError((Object)"Computed reflexive-transitive closure does not contain sequential composition of relation with itself. Something went wrong in computation of loop acceleration formula.");
        }
        if (Util.checkSat((Script)script, (Term)Util.and((Script)script, (Term[])new Term[]{simplified, Util.not((Script)script, (Term)xPrimeEqualsX), notGuard})) == Script.LBool.UNKNOWN) {
            logger.warn((Object)"Unable to prove that havoc of all variables is a superset of the reflexivetransitive closure.");
        }
        if (Util.checkSat((Script)script, (Term)Util.and((Script)script, (Term[])new Term[]{simplified, Util.not((Script)script, (Term)xPrimeEqualsX), notGuard})) == Script.LBool.SAT) {
            throw new AssertionError((Object)"Havoc of all variables is not a superset of the reflexive transitive closure.Something went wrong in computation of loop acceleration formula.");
        }
        return true;
    }

    public static class ClosedFormOfUpdate {
        final Map<IProgramVar, Term> mScalarUpdates;
        final NestedMap2<IProgramVar, ArrayIndex, Term> mArrayUpdates;

        public ClosedFormOfUpdate(Map<IProgramVar, Term> scalarUpdates, NestedMap2<IProgramVar, ArrayIndex, Term> arrayUpdates) {
            this.mScalarUpdates = scalarUpdates;
            this.mArrayUpdates = arrayUpdates;
        }

        public Map<IProgramVar, Term> getScalarUpdates() {
            return this.mScalarUpdates;
        }

        public NestedMap2<IProgramVar, ArrayIndex, Term> getArrayUpdates() {
            return this.mArrayUpdates;
        }
    }

    public static class JordanLoopAccelerationResult {
        private final AccelerationStatus mAccelerationStatus;
        private final String mErrorMessage;
        private final UnmodifiableTransFormula mTransFormula;
        private final JordanLoopAccelerationStatisticsGenerator mJordanLoopAccelerationStatistics;

        public JordanLoopAccelerationResult(AccelerationStatus accelerationStatus, String errorMessage, UnmodifiableTransFormula transFormula, JordanLoopAccelerationStatisticsGenerator jordanLoopAccelerationStatistics) {
            this.mAccelerationStatus = accelerationStatus;
            this.mErrorMessage = errorMessage;
            this.mTransFormula = transFormula;
            this.mJordanLoopAccelerationStatistics = jordanLoopAccelerationStatistics;
        }

        public AccelerationStatus getAccelerationStatus() {
            return this.mAccelerationStatus;
        }

        public String getErrorMessage() {
            return this.mErrorMessage;
        }

        public UnmodifiableTransFormula getTransFormula() {
            return this.mTransFormula;
        }

        public JordanLoopAccelerationStatisticsGenerator getJordanLoopAccelerationStatistics() {
            return this.mJordanLoopAccelerationStatistics;
        }

        public static enum AccelerationStatus {
            SUCCESS,
            SIMULTANEOUS_UPDATE_FAILED,
            NONINTEGER_UPDATE,
            NONLINEAR_UPDATE,
            UNSUPPORTED_EIGENVALUES;

        }
    }
}

