/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.jordan;

import de.uni_freiburg.informatik.ultimate.core.lib.results.StatisticsResult;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResult;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.IIcfgTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.ILocationFactory;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.ITransformulaTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.IcfgTransformationBacktranslator;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.IcfgTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.CopyingTransformulaTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.jordan.JordanLoopAcceleration;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProviderProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.StatisticsData;

public class JordanLoopAccelerationIcfgTransformer<INLOC extends IcfgLocation, OUTLOC extends IcfgLocation>
implements IIcfgTransformer<OUTLOC> {
    private final ILogger mLogger;
    private final IIcfg<INLOC> mOriginalIcfg;
    private final ITransformulaTransformer mTransformer;
    private final IUltimateServiceProvider mServices;
    private final IIcfg<OUTLOC> mResult;

    public JordanLoopAccelerationIcfgTransformer(ILogger logger, IIcfg<INLOC> originalIcfg, Class<OUTLOC> outLocationClass, ILocationFactory<INLOC, OUTLOC> funLocFac, String newIcfgIdentifier, IcfgTransformationBacktranslator backtranslationTracker, IUltimateServiceProvider services) {
        this.mLogger = logger;
        this.mOriginalIcfg = originalIcfg;
        this.mServices = services;
        this.mTransformer = new JordanLoopAccelerationTransformer(this.mLogger, originalIcfg.getCfgSmtToolkit().getManagedScript(), originalIcfg.getCfgSmtToolkit());
        this.mResult = new IcfgTransformer<INLOC, OUTLOC>(this.mLogger, originalIcfg, funLocFac, backtranslationTracker, outLocationClass, newIcfgIdentifier, this.mTransformer).getResult();
    }

    @Override
    public IIcfg<OUTLOC> getResult() {
        return this.mResult;
    }

    private final class JordanLoopAccelerationTransformer
    extends CopyingTransformulaTransformer {
        public JordanLoopAccelerationTransformer(ILogger logger, ManagedScript managedScript, CfgSmtToolkit oldToolkit) {
            super(logger, managedScript, oldToolkit);
        }

        @Override
        public ITransformulaTransformer.TransformulaTransformationResult transform(IIcfgTransition<? extends IcfgLocation> oldEdge, UnmodifiableTransFormula tf) {
            if (oldEdge.getSource() == oldEdge.getTarget()) {
                UnmodifiableTransFormula oldTf = oldEdge.getTransformula();
                JordanLoopAcceleration.JordanLoopAccelerationResult jlar = JordanLoopAcceleration.accelerateLoop(JordanLoopAccelerationIcfgTransformer.this.mServices, JordanLoopAccelerationIcfgTransformer.this.mOriginalIcfg.getCfgSmtToolkit().getManagedScript(), oldTf, true);
                JordanLoopAccelerationIcfgTransformer.this.mLogger.info((Object)("Jordan loop acceleration statistics: " + jlar.getJordanLoopAccelerationStatistics()));
                if (jlar.getAccelerationStatus() == JordanLoopAcceleration.JordanLoopAccelerationResult.AccelerationStatus.SUCCESS) {
                    JordanLoopAccelerationIcfgTransformer.this.mLogger.info("Accelerated %s to %s", new Object[]{oldTf, jlar.getTransFormula()});
                    StatisticsData statistics = new StatisticsData();
                    statistics.aggregateBenchmarkData((IStatisticsDataProvider)jlar.getJordanLoopAccelerationStatistics());
                    JordanLoopAccelerationIcfgTransformer.this.mServices.getResultService().reportResult("IcfgTransformer", (IResult)new StatisticsResult("IcfgTransformer", "Jordan loop acceleration statistics", (ICsvProviderProvider)statistics));
                    return new ITransformulaTransformer.TransformulaTransformationResult(jlar.getTransFormula());
                }
                throw new IllegalArgumentException((Object)((Object)jlar.getAccelerationStatus()) + " " + jlar.getErrorMessage());
            }
            return super.transform(oldEdge, tf);
        }
    }
}

