/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.jordan;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.jordan.JordanLoopAccelerationDefinitions;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.jordan.JordanLoopAccelerationStatisticsType;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsType;
import java.util.Collection;

public class JordanLoopAccelerationStatisticsGenerator
implements IStatisticsDataProvider {
    private final int mNumberOfAssignedVariables;
    private final int mNumberOfHavocedVariables;
    private final int mNumberOfReadonlyVariables;
    private final NestedMap2<Integer, Integer, Integer> mEigenvalues;
    private int mSequentialAcceleration;
    private int mQuantifierFreeResult;
    private int mAlternatingAcceleration;

    public JordanLoopAccelerationStatisticsGenerator(int numberOfAssignedVariables, int numberOfHavocedVariables, int numberOfReadonlyVariables, NestedMap2<Integer, Integer, Integer> eigenvalues) {
        this.mNumberOfAssignedVariables = numberOfAssignedVariables;
        this.mNumberOfHavocedVariables = numberOfHavocedVariables;
        this.mNumberOfReadonlyVariables = numberOfReadonlyVariables;
        this.mEigenvalues = eigenvalues;
        this.mSequentialAcceleration = 0;
        this.mQuantifierFreeResult = 0;
        this.mAlternatingAcceleration = 0;
    }

    public Object getValue(String key) {
        JordanLoopAccelerationDefinitions keyEnum = Enum.valueOf(JordanLoopAccelerationDefinitions.class, key);
        switch (keyEnum) {
            case AssignedVariables: {
                return this.mNumberOfAssignedVariables;
            }
            case HavocedVariables: {
                return this.mNumberOfHavocedVariables;
            }
            case ReadonlyVariables: {
                return this.mNumberOfReadonlyVariables;
            }
            case Eigenvalues: {
                return this.mEigenvalues;
            }
            case SequentialAcceleration: {
                return this.mSequentialAcceleration;
            }
            case QuantifierFreeResult: {
                return this.mQuantifierFreeResult;
            }
            case AlternatingAcceleration: {
                return this.mAlternatingAcceleration;
            }
        }
        throw new AssertionError((Object)"unknown data");
    }

    public IStatisticsType getBenchmarkType() {
        return JordanLoopAccelerationStatisticsType.getInstance();
    }

    public Collection<String> getKeys() {
        return this.getBenchmarkType().getKeys();
    }

    public void reportSequentialAcceleration() {
        ++this.mSequentialAcceleration;
    }

    public void reportAlternatingAcceleration() {
        ++this.mAlternatingAcceleration;
    }

    public void reportQuantifierFreeResult() {
        ++this.mQuantifierFreeResult;
    }

    public String toString() {
        return this.getBenchmarkType().prettyprintBenchmarkData((IStatisticsDataProvider)this);
    }
}

