/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.jordan;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.jordan.QuadraticMatrix;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.jordan.RationalMatrix;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.AbstractGeneralizedAffineTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.AffineTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.IPolynomialTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialTerm;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import java.math.BigInteger;

public class PolynomialTermMatrix {
    private final int mDimension;
    private final IPolynomialTerm[][] mEntries;
    private BigInteger mDenominator;

    public PolynomialTermMatrix(BigInteger denominator, IPolynomialTerm[][] matrixEntries) {
        int numberOfRows = matrixEntries.length;
        int i = 0;
        while (i < numberOfRows) {
            if (numberOfRows != matrixEntries[i].length) {
                throw new AssertionError((Object)"Some matrix is not quadratic");
            }
            ++i;
        }
        this.mEntries = matrixEntries;
        this.mDimension = numberOfRows;
        this.mDenominator = denominator;
    }

    private static PolynomialTermMatrix constructConstantZeroMatrix(ManagedScript mgdScript, int n) {
        Script script = mgdScript.getScript();
        IPolynomialTerm[][] zeroMatrixEntries = new IPolynomialTerm[n][n];
        Sort sort = SmtSortUtils.getIntSort((Script)script);
        AffineTerm zero = AffineTerm.constructConstant((Sort)sort, (Rational)Rational.ZERO);
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                zeroMatrixEntries[i][j] = zero;
                ++j;
            }
            ++i;
        }
        PolynomialTermMatrix zeroMatrix = new PolynomialTermMatrix(BigInteger.ONE, zeroMatrixEntries);
        return zeroMatrix;
    }

    public static PolynomialTermMatrix rationalMatrix2TermMatrix(Script script, RationalMatrix matrix) {
        int n = matrix.getIntMatrix().getDimension();
        Sort sort = SmtSortUtils.getIntSort((Script)script);
        IPolynomialTerm[][] termMatrixEntries = new IPolynomialTerm[n][n];
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                Rational entry = Rational.valueOf((BigInteger)matrix.getIntMatrix().getEntry(i, j), (BigInteger)BigInteger.ONE);
                termMatrixEntries[i][j] = AffineTerm.constructConstant((Sort)sort, (Rational)entry);
                ++j;
            }
            ++i;
        }
        PolynomialTermMatrix termMatrix = new PolynomialTermMatrix(matrix.getDenominator(), termMatrixEntries);
        return termMatrix;
    }

    private static IPolynomialTerm constructBinomialCoefficientNumerator(Script script, TermVariable it, TermVariable itHalf, int k, int blockSize, boolean itEven, boolean restrictedVersionPossible) {
        Sort sort = SmtSortUtils.getIntSort((Script)script);
        IPolynomialTerm iterCount = PolynomialTermMatrix.constructIterationCounter(script, restrictedVersionPossible, itEven, it, itHalf);
        if (k == 0) {
            return AffineTerm.constructConstant((Sort)sort, (Rational)Rational.valueOf((BigInteger)PolynomialTermMatrix.computeFacultyWithStartValue(1, blockSize - 1), (BigInteger)BigInteger.ONE));
        }
        if (k == 1) {
            return PolynomialTerm.mulPolynomials((IPolynomialTerm)AffineTerm.constructConstant((Sort)sort, (Rational)Rational.valueOf((BigInteger)PolynomialTermMatrix.computeFacultyWithStartValue(1, blockSize - 1), (BigInteger)BigInteger.ONE)), (IPolynomialTerm)iterCount);
        }
        AffineTerm facultyFactor = AffineTerm.constructConstant((Sort)sort, (Rational)Rational.valueOf((BigInteger)PolynomialTermMatrix.computeFacultyWithStartValue(k + 1, blockSize - 1), (BigInteger)BigInteger.ONE));
        IPolynomialTerm varMinusKFaculty = PolynomialTerm.mulPolynomials((IPolynomialTerm)facultyFactor, (IPolynomialTerm)iterCount);
        int i = 1;
        while (i < k) {
            AffineTerm constant = AffineTerm.constructConstant((Sort)sort, (Rational)Rational.valueOf((BigInteger)BigInteger.valueOf(-i), (BigInteger)BigInteger.ONE));
            AbstractGeneralizedAffineTerm varMinusConstant = PolynomialTerm.sum((IPolynomialTerm[])new IPolynomialTerm[]{iterCount, constant});
            varMinusKFaculty = PolynomialTerm.mulPolynomials((IPolynomialTerm)varMinusKFaculty, (IPolynomialTerm)varMinusConstant);
            ++i;
        }
        return varMinusKFaculty;
    }

    private static IPolynomialTerm constructIterationCounter(Script script, boolean restrictedVersionPossible, boolean itEven, TermVariable it, TermVariable itHalf) {
        Sort sort = SmtSortUtils.getIntSort((Script)script);
        Object result = restrictedVersionPossible ? AffineTerm.constructVariable((Term)it) : (itEven ? PolynomialTerm.mulPolynomials((IPolynomialTerm)AffineTerm.constructConstant((Sort)sort, (Rational)Rational.TWO), (IPolynomialTerm)AffineTerm.constructVariable((Term)itHalf)) : PolynomialTerm.sum((IPolynomialTerm[])new IPolynomialTerm[]{PolynomialTerm.mulPolynomials((IPolynomialTerm)AffineTerm.constructConstant((Sort)sort, (Rational)Rational.TWO), (IPolynomialTerm)AffineTerm.constructVariable((Term)itHalf)), AffineTerm.constructConstant((Sort)sort, (Rational)Rational.ONE)}));
        return result;
    }

    private static BigInteger computeFacultyWithStartValue(int start, int k) {
        BigInteger faculty = BigInteger.ONE;
        int i = start;
        while (i <= k) {
            faculty = faculty.multiply(BigInteger.valueOf(i));
            ++i;
        }
        return faculty;
    }

    private static PolynomialTermMatrix createBlock(ManagedScript mgdScript, TermVariable it, TermVariable itHalf, int lambda, int blockSize, boolean itEven, boolean restrictedVersionPossible) {
        Script script = mgdScript.getScript();
        PolynomialTermMatrix block = PolynomialTermMatrix.constructConstantZeroMatrix(mgdScript, blockSize);
        if (lambda == 1) {
            int j = 0;
            while (j < blockSize) {
                block.mEntries[0][j] = PolynomialTermMatrix.constructBinomialCoefficientNumerator(script, it, itHalf, j, blockSize, itEven, restrictedVersionPossible);
                if (j != 0) {
                    int i = 1;
                    while (i < blockSize) {
                        block.mEntries[i][j] = block.mEntries[i - 1][j - 1];
                        ++i;
                    }
                }
                ++j;
            }
            block.mDenominator = PolynomialTermMatrix.computeFacultyWithStartValue(1, blockSize - 1);
        } else if (lambda == -1) {
            Sort sort = SmtSortUtils.getIntSort((Script)script);
            int j = 0;
            while (j < blockSize) {
                block.mEntries[0][j] = j % 2 == 0 ? PolynomialTermMatrix.constructBinomialCoefficientNumerator(script, it, itHalf, j, blockSize, itEven, restrictedVersionPossible) : PolynomialTerm.mulPolynomials((IPolynomialTerm)PolynomialTermMatrix.constructBinomialCoefficientNumerator(script, it, itHalf, j, blockSize, itEven, restrictedVersionPossible), (IPolynomialTerm)AffineTerm.constructConstant((Sort)sort, (Rational)Rational.valueOf((BigInteger)BigInteger.valueOf(-1L), (BigInteger)BigInteger.ONE)));
                if (j != 0) {
                    int i = j;
                    while (i < blockSize) {
                        block.mEntries[i][j] = block.mEntries[i - 1][j - 1];
                        ++i;
                    }
                }
                ++j;
            }
            block.mDenominator = PolynomialTermMatrix.computeFacultyWithStartValue(1, blockSize - 1);
        }
        return block;
    }

    private void addBlockToJordanPower(ManagedScript mgdScript, PolynomialTermMatrix block, int start) {
        int l;
        if (this.mDimension < block.mDimension + start) {
            throw new AssertionError((Object)"Block does not fit into matrix");
        }
        Sort sort = SmtSortUtils.getIntSort((Script)mgdScript.getScript());
        int s = block.mDimension;
        BigInteger gcd = Rational.gcd((BigInteger)this.mDenominator, (BigInteger)block.mDenominator);
        int i = 0;
        while (i < s) {
            int j = 0;
            while (j < s) {
                this.mEntries[i + start][j + start] = PolynomialTerm.mulPolynomials((IPolynomialTerm)block.mEntries[i][j], (IPolynomialTerm)AffineTerm.constructConstant((Sort)sort, (Rational)Rational.valueOf((BigInteger)this.mDenominator.divide(gcd), (BigInteger)BigInteger.ONE)));
                ++j;
            }
            ++i;
        }
        this.mDenominator = this.mDenominator.multiply(block.mDenominator.divide(gcd));
        int k = 0;
        while (k < start) {
            l = 0;
            while (l < this.mDimension) {
                this.mEntries[k][l] = PolynomialTerm.mulPolynomials((IPolynomialTerm)this.mEntries[k][l], (IPolynomialTerm)AffineTerm.constructConstant((Sort)sort, (Rational)Rational.valueOf((BigInteger)block.mDenominator.divide(gcd), (BigInteger)BigInteger.ONE)));
                ++l;
            }
            ++k;
        }
        k = start + s;
        while (k < this.mDimension) {
            l = 0;
            while (l < this.mDimension) {
                this.mEntries[k][l] = PolynomialTerm.mulPolynomials((IPolynomialTerm)this.mEntries[k][l], (IPolynomialTerm)AffineTerm.constructConstant((Sort)sort, (Rational)Rational.valueOf((BigInteger)block.mDenominator.divide(gcd), (BigInteger)BigInteger.ONE)));
                ++l;
            }
            ++k;
        }
    }

    public static PolynomialTermMatrix jordan2JordanPower(ManagedScript mgdScript, TermVariable it, TermVariable itHalf, boolean itEven, QuadraticMatrix.JordanTransformationResult jordan, boolean restrictedVersionPossible) {
        int n = jordan.getJnf().getDimension();
        PolynomialTermMatrix jordanPower = PolynomialTermMatrix.constructConstantZeroMatrix(mgdScript, n);
        NestedMap2<Integer, Integer, Integer> jordanBlockSizes = jordan.getJordanBlockSizes();
        int current = 0;
        int e = -1;
        while (e <= 1) {
            if (jordanBlockSizes.get((Object)e) != null) {
                for (Integer blockSize : jordanBlockSizes.get((Object)e).keySet()) {
                    if (blockSize == null) continue;
                    int occ = 1;
                    while (occ <= (Integer)jordanBlockSizes.get((Object)e, (Object)blockSize)) {
                        PolynomialTermMatrix block = PolynomialTermMatrix.createBlock(mgdScript, it, itHalf, e, blockSize, itEven, restrictedVersionPossible);
                        jordanPower.addBlockToJordanPower(mgdScript, block, current);
                        current += blockSize.intValue();
                        ++occ;
                    }
                }
            }
            ++e;
        }
        return jordanPower;
    }

    public static PolynomialTermMatrix computeClosedFormMatrix(ManagedScript mgdScript, QuadraticMatrix.JordanTransformationResult jordanUpdate, TermVariable it, TermVariable itHalf, boolean itEven, boolean restrictedVersionPossible) {
        Rational constant;
        int j;
        int i;
        AffineTerm denom;
        PolynomialTermMatrix tmp;
        PolynomialTermMatrix jordanUpdatePower;
        int n = jordanUpdate.getJnf().getDimension();
        Script script = mgdScript.getScript();
        Sort sort = SmtSortUtils.getIntSort((Script)script);
        RationalMatrix modalUpdate = jordanUpdate.getModal();
        RationalMatrix inverseModalUpdate = jordanUpdate.getInverseModal();
        PolynomialTermMatrix closedFormMatrix = PolynomialTermMatrix.constructConstantZeroMatrix(mgdScript, n);
        if (restrictedVersionPossible) {
            jordanUpdatePower = PolynomialTermMatrix.jordan2JordanPower(mgdScript, it, itHalf, itEven, jordanUpdate, restrictedVersionPossible);
            tmp = PolynomialTermMatrix.multiplication(mgdScript, PolynomialTermMatrix.rationalMatrix2TermMatrix(script, modalUpdate), jordanUpdatePower);
            closedFormMatrix = PolynomialTermMatrix.multiplication(mgdScript, tmp, PolynomialTermMatrix.rationalMatrix2TermMatrix(script, inverseModalUpdate));
            denom = AffineTerm.constructConstant((Sort)sort, (Rational)Rational.valueOf((BigInteger)BigInteger.ONE, (BigInteger)closedFormMatrix.getDenominator()));
            i = 0;
            while (i < n) {
                j = 0;
                while (j < n) {
                    constant = closedFormMatrix.getEntry(i, j).getConstant();
                    for (Rational coeff : closedFormMatrix.getEntry(i, j).getMonomial2Coefficient().values()) {
                        if (coeff.numerator().intValue() % closedFormMatrix.getDenominator().intValue() != 0) {
                            restrictedVersionPossible = false;
                            throw new AssertionError((Object)"Case should never occur");
                        }
                        if (constant.numerator().intValue() % closedFormMatrix.getDenominator().intValue() == 0) continue;
                        restrictedVersionPossible = false;
                        throw new AssertionError((Object)"Case should never occur");
                    }
                    closedFormMatrix.setEntry(i, j, PolynomialTerm.mulPolynomials((IPolynomialTerm)closedFormMatrix.getEntry(i, j), (IPolynomialTerm)denom));
                    ++j;
                }
                ++i;
            }
        }
        if (!restrictedVersionPossible) {
            jordanUpdatePower = PolynomialTermMatrix.jordan2JordanPower(mgdScript, it, itHalf, itEven, jordanUpdate, restrictedVersionPossible);
            tmp = PolynomialTermMatrix.multiplication(mgdScript, PolynomialTermMatrix.rationalMatrix2TermMatrix(script, modalUpdate), jordanUpdatePower);
            closedFormMatrix = PolynomialTermMatrix.multiplication(mgdScript, tmp, PolynomialTermMatrix.rationalMatrix2TermMatrix(script, inverseModalUpdate));
            denom = AffineTerm.constructConstant((Sort)sort, (Rational)Rational.valueOf((BigInteger)BigInteger.ONE, (BigInteger)closedFormMatrix.getDenominator()));
            i = 0;
            while (i < n) {
                j = 0;
                while (j < n) {
                    constant = closedFormMatrix.getEntry(i, j).getConstant();
                    for (Rational coeff : closedFormMatrix.getEntry(i, j).getMonomial2Coefficient().values()) {
                        if (coeff.numerator().intValue() % closedFormMatrix.getDenominator().intValue() != 0) {
                            throw new AssertionError((Object)"Non-integer value found. Computation of closed form notpossible.");
                        }
                        if (constant.numerator().intValue() % closedFormMatrix.getDenominator().intValue() != 0) {
                            throw new AssertionError((Object)"Non-integer value found. Computation of closed form notpossible.");
                        }
                    }
                    closedFormMatrix.setEntry(i, j, PolynomialTerm.mulPolynomials((IPolynomialTerm)closedFormMatrix.getEntry(i, j), (IPolynomialTerm)denom));
                    ++j;
                }
                ++i;
            }
        }
        closedFormMatrix.mDenominator = BigInteger.ONE;
        return closedFormMatrix;
    }

    public static PolynomialTermMatrix multiplication(ManagedScript mgdScript, PolynomialTermMatrix matrix1, PolynomialTermMatrix matrix2) {
        if (matrix1.mDimension != matrix2.mDimension) {
            throw new AssertionError((Object)"Some matrices for multiplication are not of the same dimension.");
        }
        int n = matrix1.mDimension;
        PolynomialTermMatrix product = PolynomialTermMatrix.constructConstantZeroMatrix(mgdScript, n);
        Sort sort = SmtSortUtils.getIntSort((ManagedScript)mgdScript);
        int i = 0;
        while (i < n) {
            int k = 0;
            while (k < n) {
                AffineTerm sum = AffineTerm.constructConstant((Sort)sort, (Rational)Rational.ZERO);
                int j = 0;
                while (j < n) {
                    IPolynomialTerm summand = PolynomialTerm.mulPolynomials((IPolynomialTerm)matrix1.mEntries[i][j], (IPolynomialTerm)matrix2.mEntries[j][k]);
                    sum = PolynomialTerm.sum((IPolynomialTerm[])new IPolynomialTerm[]{sum, summand});
                    ++j;
                }
                product.mEntries[i][k] = sum;
                ++k;
            }
            ++i;
        }
        product.mDenominator = matrix1.mDenominator.multiply(matrix2.mDenominator);
        return product;
    }

    public IPolynomialTerm getEntry(int i, int j) {
        return this.mEntries[i][j];
    }

    public void setEntry(int i, int j, IPolynomialTerm value) {
        this.mEntries[i][j] = value;
    }

    public BigInteger getDenominator() {
        return this.mDenominator;
    }

    public int getDimension() {
        return this.mDimension;
    }
}

