/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.jordan;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.jordan.RationalMatrix;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class QuadraticMatrix {
    private final int mDimension;
    private final BigInteger[][] mEntries;

    public QuadraticMatrix(BigInteger[][] matrixEntries) {
        int numberOfRows = matrixEntries.length;
        int i = 0;
        while (i < numberOfRows) {
            if (numberOfRows != matrixEntries[i].length) {
                throw new AssertionError((Object)"Some matrix is not quadratic");
            }
            ++i;
        }
        this.mEntries = matrixEntries;
        this.mDimension = numberOfRows;
    }

    public static QuadraticMatrix constructIdentityMatrix(int n) {
        BigInteger[][] identityEntries = new BigInteger[n][n];
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                identityEntries[i][j] = i == j ? BigInteger.valueOf(1L) : BigInteger.valueOf(0L);
                ++j;
            }
            ++i;
        }
        QuadraticMatrix identity = new QuadraticMatrix(identityEntries);
        return identity;
    }

    public static QuadraticMatrix constructZeroMatrix(int n) {
        BigInteger[][] zeroEntries = new BigInteger[n][n];
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                zeroEntries[i][j] = BigInteger.valueOf(0L);
                ++j;
            }
            ++i;
        }
        QuadraticMatrix zero = new QuadraticMatrix(zeroEntries);
        return zero;
    }

    public static QuadraticMatrix copyMatrix(QuadraticMatrix matrix) {
        int n = matrix.mDimension;
        BigInteger[][] copiedEntries = new BigInteger[n][n];
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                copiedEntries[i][j] = matrix.mEntries[i][j];
                ++j;
            }
            ++i;
        }
        QuadraticMatrix matrixCopied = new QuadraticMatrix(copiedEntries);
        return matrixCopied;
    }

    public static QuadraticMatrix addition(QuadraticMatrix matrix1, QuadraticMatrix matrix2) {
        if (matrix1.mDimension != matrix2.mDimension) {
            throw new AssertionError((Object)"Some matrices for addition are not of the same dimension.");
        }
        int n = matrix1.mDimension;
        BigInteger[][] sumEntries = new BigInteger[n][n];
        QuadraticMatrix matrixSum = new QuadraticMatrix(sumEntries);
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                matrixSum.mEntries[i][j] = matrix1.mEntries[i][j].add(matrix2.mEntries[i][j]);
                ++j;
            }
            ++i;
        }
        return matrixSum;
    }

    public static QuadraticMatrix scalarMultiplication(BigInteger a, QuadraticMatrix matrix) {
        int n = matrix.mDimension;
        BigInteger[][] scMultEntries = new BigInteger[n][n];
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                scMultEntries[i][j] = a.multiply(matrix.mEntries[i][j]);
                ++j;
            }
            ++i;
        }
        QuadraticMatrix scMult = new QuadraticMatrix(scMultEntries);
        return scMult;
    }

    public static QuadraticMatrix multiplication(QuadraticMatrix matrix1, QuadraticMatrix matrix2) {
        if (matrix1.mDimension != matrix2.mDimension) {
            throw new AssertionError((Object)"Some matrices for multiplication are not of the same dimension");
        }
        int n = matrix1.mDimension;
        QuadraticMatrix productMatrix = QuadraticMatrix.constructZeroMatrix(n);
        int i = 0;
        while (i < n) {
            int k = 0;
            while (k < n) {
                int j = 0;
                while (j < n) {
                    productMatrix.mEntries[i][k] = productMatrix.mEntries[i][k].add(matrix1.mEntries[i][j].multiply(matrix2.mEntries[j][k]));
                    ++j;
                }
                ++k;
            }
            ++i;
        }
        return productMatrix;
    }

    public static QuadraticMatrix power(QuadraticMatrix matrix, int s) {
        int n = matrix.mDimension;
        if (s == 0) {
            return QuadraticMatrix.constructIdentityMatrix(n);
        }
        if (s == 1) {
            return matrix;
        }
        QuadraticMatrix powerMatrix = QuadraticMatrix.copyMatrix(matrix);
        int i = 2;
        while (i <= s) {
            powerMatrix = QuadraticMatrix.multiplication(powerMatrix, matrix);
            ++i;
        }
        return powerMatrix;
    }

    public BigInteger computeDet() {
        int n = this.mDimension;
        if (n == 1) {
            return this.mEntries[0][0];
        }
        if (n == 1) {
            return this.mEntries[0][0].multiply(this.mEntries[1][1]).subtract(this.mEntries[0][1].multiply(this.mEntries[1][0]));
        }
        if (n == 3) {
            return this.mEntries[0][0].multiply(this.mEntries[1][1]).multiply(this.mEntries[2][2]).add(this.mEntries[0][1].multiply(this.mEntries[1][2]).multiply(this.mEntries[2][0])).add(this.mEntries[0][2].multiply(this.mEntries[1][0]).multiply(this.mEntries[2][1])).subtract(this.mEntries[2][0].multiply(this.mEntries[1][1]).multiply(this.mEntries[0][2])).subtract(this.mEntries[2][1].multiply(this.mEntries[1][2]).multiply(this.mEntries[0][0])).subtract(this.mEntries[2][2].multiply(this.mEntries[1][0]).multiply(this.mEntries[0][1]));
        }
        BigInteger det = BigInteger.valueOf(0L);
        int k = 0;
        while (k < n) {
            BigInteger[][] kTmp = new BigInteger[n - 1][n - 1];
            int i = 0;
            while (i < n - 1) {
                int j = 0;
                while (j < k) {
                    kTmp[i][j] = this.mEntries[i][j];
                    ++j;
                }
                j = k + 1;
                while (j < n) {
                    kTmp[i][j - 1] = this.mEntries[i][j];
                    ++j;
                }
                ++i;
            }
            QuadraticMatrix kMatrix = new QuadraticMatrix(kTmp);
            det = (n + k - 1) % 2 == 0 ? det.add(this.mEntries[n - 1][k].multiply(kMatrix.computeDet())) : det.subtract(this.mEntries[n - 1][k].multiply(kMatrix.computeDet()));
            ++k;
        }
        return det;
    }

    public static RationalMatrix computeInverse(QuadraticMatrix matrix) {
        int n = matrix.mDimension;
        if (matrix.computeDet().equals(BigInteger.valueOf(0L))) {
            throw new AssertionError((Object)"Matrix is not invertible");
        }
        QuadraticMatrix inverseInt = QuadraticMatrix.constructZeroMatrix(n);
        RationalMatrix inverse = new RationalMatrix(BigInteger.valueOf(1L), inverseInt);
        int k = 0;
        while (k < n) {
            BigInteger[][] lesEntries = new BigInteger[n + 1][n + 1];
            int i = 0;
            while (i < n) {
                int j = 0;
                while (j < n) {
                    lesEntries[i][j] = matrix.mEntries[i][j];
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < n) {
                lesEntries[i][n] = i == k ? BigInteger.valueOf(1L) : BigInteger.valueOf(0L);
                ++i;
            }
            int j = 0;
            while (j < n) {
                lesEntries[n][j] = BigInteger.valueOf(0L);
                ++j;
            }
            lesEntries[n][n] = BigInteger.valueOf(1L);
            QuadraticMatrix lesMatrix = new QuadraticMatrix(lesEntries);
            QuadraticMatrix lesMatrixGauss = QuadraticMatrix.gaussElimination(lesMatrix);
            Rational[] xk = QuadraticMatrix.backwardSubstitution(lesMatrixGauss, 1);
            inverse.addColumnToMatrix(k, xk);
            ++k;
        }
        return inverse;
    }

    public boolean[] computeSmallEigenvalues() {
        boolean[] eigenvalues = new boolean[3];
        int i = 0;
        while (i < 3) {
            eigenvalues[i] = false;
            ++i;
        }
        int n = this.mDimension;
        QuadraticMatrix identity = QuadraticMatrix.constructIdentityMatrix(n);
        int i2 = -1;
        while (i2 < 2) {
            if (QuadraticMatrix.addition(this, QuadraticMatrix.scalarMultiplication(BigInteger.valueOf(-i2), identity)).computeDet().equals(BigInteger.valueOf(0L))) {
                eigenvalues[i2 + 1] = true;
            }
            ++i2;
        }
        return eigenvalues;
    }

    public void swapRows(int i, int j) {
        int n = this.mDimension;
        BigInteger[] iRow = new BigInteger[n];
        int k = 0;
        while (k < n) {
            iRow[k] = this.mEntries[i][k];
            this.mEntries[i][k] = this.mEntries[j][k];
            this.mEntries[j][k] = iRow[k];
            ++k;
        }
    }

    public static QuadraticMatrix gaussElimination(QuadraticMatrix matrix) {
        int j;
        int n = matrix.mDimension;
        QuadraticMatrix nMatrix = QuadraticMatrix.copyMatrix(matrix);
        int h = 0;
        int k = 0;
        while (h < n && k < n) {
            int i_max = h;
            int i = h;
            while (i < n) {
                if (nMatrix.mEntries[i][k].abs().compareTo(nMatrix.mEntries[i_max][k].abs()) > 0) {
                    i_max = i;
                }
                ++i;
            }
            if (nMatrix.mEntries[i_max][k].equals(BigInteger.valueOf(0L))) {
                ++k;
                continue;
            }
            nMatrix.swapRows(h, i_max);
            i = h + 1;
            while (i < n) {
                BigInteger f1 = BigInteger.valueOf(0L);
                BigInteger f2 = BigInteger.valueOf(0L);
                BigInteger gcd = BigInteger.valueOf(0L);
                f1 = nMatrix.mEntries[i][k];
                f2 = nMatrix.mEntries[h][k];
                gcd = Rational.gcd((BigInteger)f1, (BigInteger)f2);
                f1 = f1.divide(gcd);
                f2 = f2.divide(gcd);
                nMatrix.mEntries[i][k] = BigInteger.valueOf(0L);
                j = k + 1;
                while (j < n) {
                    nMatrix.mEntries[i][j] = f2.multiply(nMatrix.mEntries[i][j]).subtract(f1.multiply(nMatrix.mEntries[h][j]));
                    ++j;
                }
                ++i;
            }
            ++h;
            ++k;
        }
        int l = 1;
        while (l < n) {
            BigInteger[][] entriesL = new BigInteger[n - l][n - l];
            int i = 0;
            while (i < n - l) {
                int j2 = 0;
                while (j2 < n - l) {
                    entriesL[i][j2] = nMatrix.mEntries[i + l][j2 + l];
                    ++j2;
                }
                ++i;
            }
            QuadraticMatrix nL = new QuadraticMatrix(entriesL);
            QuadraticMatrix nLGauss = QuadraticMatrix.gaussElimination(nL);
            int i2 = 0;
            while (i2 < n - l) {
                j = 0;
                while (j < n - l) {
                    nMatrix.mEntries[i2 + l][j + l] = nLGauss.mEntries[i2][j];
                    ++j;
                }
                ++i2;
            }
            ++l;
        }
        return nMatrix;
    }

    public static Rational[] backwardSubstitution(QuadraticMatrix matrix, int s) {
        QuadraticMatrix N = QuadraticMatrix.copyMatrix(matrix);
        int n = N.mDimension;
        if (!N.mEntries[N.computeRank() - 1][n - 1].equals(BigInteger.valueOf(1L))) {
            throw new AssertionError((Object)"LES unsolvable.");
        }
        Rational[] p = new Rational[n - 1];
        int expected = n - 2;
        int i = 0;
        while (i < n - 1) {
            p[i] = Rational.valueOf((BigInteger)BigInteger.valueOf(0L), (BigInteger)BigInteger.valueOf(1L));
            ++i;
        }
        int s0 = 0;
        int i2 = N.computeRank() - 2;
        while (i2 >= 0) {
            int j = i2;
            int l = i2;
            while (l < n) {
                if (!N.mEntries[i2][l].equals(BigInteger.valueOf(0L))) {
                    j = l;
                    break;
                }
                ++l;
            }
            while (j < expected) {
                if (++s0 == s) {
                    p[expected] = Rational.valueOf((BigInteger)BigInteger.valueOf(1L), (BigInteger)BigInteger.valueOf(1L));
                }
                --expected;
            }
            expected = j - 1;
            p[j] = Rational.valueOf((BigInteger)N.mEntries[i2][n - 1], (BigInteger)BigInteger.valueOf(1L));
            int k = j + 1;
            while (k < n - 1) {
                Rational tmp = Rational.valueOf((BigInteger)N.mEntries[i2][k].negate().multiply(p[k].numerator()), (BigInteger)p[k].denominator());
                p[j] = p[j].add(tmp);
                p[j] = Rational.valueOf((BigInteger)p[j].numerator(), (BigInteger)p[j].denominator());
                ++k;
            }
            p[j] = Rational.valueOf((BigInteger)p[j].numerator(), (BigInteger)p[j].denominator().multiply(N.mEntries[i2][j]));
            --i2;
        }
        while (expected > -1) {
            if (++s0 == s) {
                p[expected] = Rational.valueOf((BigInteger)BigInteger.valueOf(1L), (BigInteger)BigInteger.valueOf(1L));
            }
            --expected;
        }
        return p;
    }

    public int computeRank() {
        QuadraticMatrix matrixCopy = QuadraticMatrix.copyMatrix(this);
        QuadraticMatrix matrixGauss = QuadraticMatrix.gaussElimination(matrixCopy);
        int n = matrixGauss.mDimension;
        int zeroRows = 0;
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                if (!matrixGauss.mEntries[i][j].equals(BigInteger.valueOf(0L))) break;
                if (j == n - 1 && matrixGauss.mEntries[i][j].equals(BigInteger.valueOf(0L))) {
                    ++zeroRows;
                }
                ++j;
            }
            ++i;
        }
        return n - zeroRows;
    }

    public int computeGeometricMultiplicity(int lambda) {
        int n = this.mDimension;
        QuadraticMatrix identity = QuadraticMatrix.constructIdentityMatrix(n);
        QuadraticMatrix eigenvalueMatrix = QuadraticMatrix.addition(this, QuadraticMatrix.scalarMultiplication(BigInteger.valueOf(-lambda), identity));
        return n - eigenvalueMatrix.computeRank();
    }

    public int computeNumberOfBlocks(int lambda, int s) {
        int n = this.mDimension;
        QuadraticMatrix identity = QuadraticMatrix.constructIdentityMatrix(n);
        QuadraticMatrix eigenvalueMatrix = QuadraticMatrix.addition(this, QuadraticMatrix.scalarMultiplication(BigInteger.valueOf(-lambda), identity));
        return 2 * QuadraticMatrix.power(eigenvalueMatrix, s).computeGeometricMultiplicity(0) - QuadraticMatrix.power(eigenvalueMatrix, s + 1).computeGeometricMultiplicity(0) - QuadraticMatrix.power(eigenvalueMatrix, s - 1).computeGeometricMultiplicity(0);
    }

    public static QuadraticMatrix createJordanBlock(int lambda, int s) {
        QuadraticMatrix block = QuadraticMatrix.constructZeroMatrix(s);
        int i = 0;
        while (i < s) {
            block.mEntries[i][i] = BigInteger.valueOf(lambda);
            if (i != s - 1) {
                block.mEntries[i][i + 1] = BigInteger.valueOf(1L);
            }
            ++i;
        }
        return block;
    }

    public void addJordanBlock(QuadraticMatrix block, int start) {
        if (this.mDimension < block.mDimension + start) {
            throw new AssertionError((Object)"Block does not fit into Jordan matrix");
        }
        int s = block.mDimension;
        int i = 0;
        while (i < s) {
            int j = 0;
            while (j < s) {
                this.mEntries[i + start][j + start] = block.mEntries[i][j];
                ++j;
            }
            ++i;
        }
    }

    private NestedMap2<Integer, Integer, Integer> computeJordanBlockSizes() {
        NestedMap2 jordanBlockSizes = new NestedMap2();
        boolean[] eigenvalues = this.computeSmallEigenvalues();
        int n = this.mDimension;
        int e = -1;
        while (e <= 1) {
            if (eigenvalues[e + 1]) {
                int geomMult = this.computeGeometricMultiplicity(e);
                int[] numberOfBlocks = new int[n + 1];
                int sum = 0;
                while (sum < geomMult) {
                    int sE = 1;
                    while (sE <= n) {
                        numberOfBlocks[sE] = this.computeNumberOfBlocks(e, sE);
                        sum += numberOfBlocks[sE];
                        ++sE;
                    }
                }
                int s = 1;
                while (s <= n) {
                    if (numberOfBlocks[s] != 0) {
                        jordanBlockSizes.put((Object)e, (Object)s, (Object)numberOfBlocks[s]);
                    }
                    ++s;
                }
            }
            ++e;
        }
        return jordanBlockSizes;
    }

    public JordanTransformationResult constructJordanTransformation() {
        JordanTransformationResult jtr;
        int n = this.mDimension;
        QuadraticMatrix jordanMatrix = QuadraticMatrix.constructZeroMatrix(n);
        NestedMap2<Integer, Integer, Integer> jordanBlockSizes = this.computeJordanBlockSizes();
        int current = 0;
        int e = -1;
        while (e <= 1) {
            if (jordanBlockSizes.get((Object)e) != null) {
                for (Integer blockSize : jordanBlockSizes.get((Object)e).keySet()) {
                    if (blockSize == null) continue;
                    int occ = 1;
                    while (occ <= (Integer)jordanBlockSizes.get((Object)e, (Object)blockSize)) {
                        QuadraticMatrix block = QuadraticMatrix.createJordanBlock(e, blockSize);
                        jordanMatrix.addJordanBlock(block, current);
                        current += blockSize.intValue();
                        ++occ;
                    }
                }
            }
            ++e;
        }
        if (current != n) {
            JordanTransformationResult.JordanTransformationStatus status = JordanTransformationResult.JordanTransformationStatus.UNSUPPORTED_EIGENVALUES;
            jtr = new JordanTransformationResult(status, null, null, null, null);
        } else {
            JordanTransformationResult.JordanTransformationStatus status = JordanTransformationResult.JordanTransformationStatus.SUCCESS;
            RationalMatrix modal = QuadraticMatrix.computeModalMatrix(this, jordanMatrix);
            RationalMatrix inverseModal = RationalMatrix.computeInverse(modal);
            assert (QuadraticMatrix.checkCorrectnessofJordanDecomposition(this, modal, jordanMatrix, inverseModal));
            jtr = new JordanTransformationResult(status, jordanMatrix, modal, inverseModal, jordanBlockSizes);
        }
        return jtr;
    }

    public static RationalMatrix constructLes(QuadraticMatrix matrix, Rational[] b) {
        int n = matrix.mDimension;
        QuadraticMatrix intLes = QuadraticMatrix.constructZeroMatrix(n + 1);
        RationalMatrix les = new RationalMatrix(BigInteger.valueOf(1L), intLes);
        int j = 0;
        while (j < n) {
            Rational[] p = new Rational[n + 1];
            int i = 0;
            while (i < n) {
                p[i] = Rational.valueOf((BigInteger)matrix.mEntries[i][j], (BigInteger)BigInteger.valueOf(1L));
                ++i;
            }
            p[n] = Rational.valueOf((BigInteger)BigInteger.valueOf(0L), (BigInteger)BigInteger.valueOf(1L));
            les.addColumnToMatrix(j, p);
            ++j;
        }
        les.addColumnToMatrix(n, b);
        les.getIntMatrix().mEntries[n][n] = BigInteger.valueOf(1L);
        return les;
    }

    public static Rational[] matrixVectorMultiplication(QuadraticMatrix matrix, Rational[] vector) {
        if (matrix.mDimension != vector.length) {
            throw new AssertionError((Object)"Matrix dimension is not vector length.");
        }
        int n = matrix.mDimension;
        Rational[] result = new Rational[n];
        int i = 0;
        while (i < n) {
            result[i] = Rational.valueOf((BigInteger)BigInteger.valueOf(0L), (BigInteger)BigInteger.valueOf(1L));
            int j = 0;
            while (j < n) {
                result[i] = result[i].add(Rational.valueOf((BigInteger)matrix.mEntries[i][j].multiply(vector[j].numerator()), (BigInteger)vector[j].denominator()));
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static RationalMatrix computeModalMatrix(QuadraticMatrix matrix, QuadraticMatrix jordanMatrix) {
        int n = matrix.mDimension;
        QuadraticMatrix modalIntMatrix = QuadraticMatrix.constructZeroMatrix(n);
        RationalMatrix modalMatrix = new RationalMatrix(BigInteger.valueOf(1L), modalIntMatrix);
        HashMap columnOrder = new HashMap();
        int current = n;
        Rational[] zeroVector = new Rational[n];
        int i = 0;
        while (i < n) {
            zeroVector[i] = Rational.valueOf((BigInteger)BigInteger.valueOf(0L), (BigInteger)BigInteger.valueOf(1L));
            ++i;
        }
        int lambda = 1;
        while (lambda >= -1) {
            if (matrix.computeSmallEigenvalues()[lambda + 1]) {
                QuadraticMatrix eigenvalueMatrix = QuadraticMatrix.addition(matrix, QuadraticMatrix.scalarMultiplication(BigInteger.valueOf(-lambda), QuadraticMatrix.constructIdentityMatrix(n)));
                int blockSize = n;
                while (matrix.computeNumberOfBlocks(lambda, blockSize) == 0) {
                    --blockSize;
                }
                int order = 1;
                while (order <= blockSize) {
                    ArrayList orderList = new ArrayList();
                    columnOrder.put(order, orderList);
                    ++order;
                }
                while (blockSize > 0) {
                    int numberOfBlocks = matrix.computeNumberOfBlocks(lambda, blockSize);
                    if (numberOfBlocks == 0) {
                        --blockSize;
                        continue;
                    }
                    RationalMatrix lesMatrix = QuadraticMatrix.constructLes(QuadraticMatrix.power(eigenvalueMatrix, blockSize), zeroVector);
                    ArrayList constrainingColumns = (ArrayList)columnOrder.get(blockSize);
                    int numberOfConstraints = constrainingColumns.size();
                    ArrayList<Integer> freeChoice = new ArrayList<Integer>();
                    int c = 1;
                    while (c <= n) {
                        freeChoice.add(c);
                        ++c;
                    }
                    int k = 0;
                    while (k < numberOfBlocks) {
                        int j;
                        Rational[][] constraints = new Rational[numberOfConstraints + numberOfBlocks - 1][n];
                        int i2 = 0;
                        while (i2 < numberOfConstraints) {
                            j = 0;
                            while (j < n) {
                                constraints[i2][j] = Rational.valueOf((BigInteger)modalMatrix.getIntMatrix().mEntries[j][(Integer)constrainingColumns.get(i2)], (BigInteger)modalMatrix.getDenominator());
                                ++j;
                            }
                            ++i2;
                        }
                        i2 = numberOfConstraints;
                        while (i2 < numberOfConstraints + numberOfBlocks - 1) {
                            j = 0;
                            while (j < n) {
                                constraints[i2][j] = Rational.valueOf((BigInteger)BigInteger.valueOf(0L), (BigInteger)BigInteger.valueOf(1L));
                                ++j;
                            }
                            ++i2;
                        }
                        int choice = 0;
                        boolean isGeneralizedEigenvector = false;
                        QuadraticMatrix checkMatrix = QuadraticMatrix.power(eigenvalueMatrix, blockSize - 1);
                        Rational[] solution = RationalMatrix.solveLes(lesMatrix, constraints, (Integer)freeChoice.get(choice));
                        while (!isGeneralizedEigenvector) {
                            int i3 = 0;
                            while (i3 < solution.length) {
                                Rational[] next = QuadraticMatrix.matrixVectorMultiplication(checkMatrix, solution);
                                if (!next[i3].equals((Object)Rational.ZERO)) {
                                    isGeneralizedEigenvector = true;
                                    freeChoice.remove(choice);
                                    break;
                                }
                                ++i3;
                            }
                            if (i3 != solution.length || isGeneralizedEigenvector) continue;
                            solution = RationalMatrix.solveLes(lesMatrix, constraints, (Integer)freeChoice.get(++choice));
                        }
                        modalMatrix.addColumnToMatrix(current - k * blockSize - 1, solution);
                        ((ArrayList)columnOrder.get(blockSize)).add(current - k * blockSize - 1);
                        int l = blockSize - 1;
                        while (l > 0) {
                            solution = QuadraticMatrix.matrixVectorMultiplication(eigenvalueMatrix, solution);
                            modalMatrix.addColumnToMatrix(current - k * blockSize - blockSize + l - 1, solution);
                            ((ArrayList)columnOrder.get(l)).add(current - k * blockSize - blockSize + l - 1);
                            --l;
                        }
                        ++k;
                    }
                    current -= numberOfBlocks * blockSize;
                    --blockSize;
                }
            }
            --lambda;
        }
        return modalMatrix;
    }

    public static boolean checkCorrectnessofJordanDecomposition(QuadraticMatrix matrix, RationalMatrix modalMatrix, QuadraticMatrix jordanMatrix, RationalMatrix inverseModalMatrix) {
        QuadraticMatrix decomposition = QuadraticMatrix.multiplication(QuadraticMatrix.multiplication(modalMatrix.getIntMatrix(), jordanMatrix), inverseModalMatrix.getIntMatrix());
        if (matrix.getDimension() != decomposition.getDimension()) {
            throw new AssertionError((Object)"Mistake in Jordan decomposition!");
        }
        BigInteger denominator = modalMatrix.getDenominator().multiply(inverseModalMatrix.getDenominator());
        int i = 0;
        while (i < matrix.getDimension()) {
            int j = 0;
            while (j < matrix.getDimension()) {
                if (matrix.getEntry(i, j).intValue() != decomposition.getEntry(i, j).divide(denominator).intValue()) {
                    throw new AssertionError((Object)"Mistake in Jordan decomposition.");
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public int getDimension() {
        return this.mDimension;
    }

    public BigInteger getEntry(int i, int j) {
        return this.mEntries[i][j];
    }

    public void setEntry(int i, int j, BigInteger value) {
        this.mEntries[i][j] = value;
    }

    public String toString() {
        return Arrays.deepToString((Object[])this.mEntries);
    }

    static class JordanTransformationResult {
        private final JordanTransformationStatus mStatus;
        private final QuadraticMatrix mJnf;
        private final RationalMatrix mModal;
        private final RationalMatrix mInverseModal;
        private final NestedMap2<Integer, Integer, Integer> mJordanBlockSizes;

        public JordanTransformationResult(JordanTransformationStatus status, QuadraticMatrix jnf, RationalMatrix modal, RationalMatrix inverseModal, NestedMap2<Integer, Integer, Integer> jordanBlockSizes) {
            assert (status == JordanTransformationStatus.SUCCESS ^ jnf == null) : "provide JNF iff success";
            assert (jnf == null == (jordanBlockSizes == null)) : "all or nothing";
            if (jordanBlockSizes != null) assert (jordanBlockSizes.keySet().stream().allMatch(x -> x == -1 || x == 0 || x == 1)) : "only supported eigenvalues as keys";
            this.mStatus = status;
            this.mJnf = jnf;
            this.mModal = modal;
            this.mInverseModal = inverseModal;
            this.mJordanBlockSizes = jordanBlockSizes;
        }

        public JordanTransformationStatus getStatus() {
            return this.mStatus;
        }

        public QuadraticMatrix getJnf() {
            return this.mJnf;
        }

        public RationalMatrix getModal() {
            return this.mModal;
        }

        public RationalMatrix getInverseModal() {
            return this.mInverseModal;
        }

        public NestedMap2<Integer, Integer, Integer> getJordanBlockSizes() {
            return this.mJordanBlockSizes;
        }

        static void reportJordanBlock(NestedMap2<Integer, Integer, Integer> jordanBlockSizes, int eigenvalue, int blockSize) {
            Integer occurence = (Integer)jordanBlockSizes.get((Object)eigenvalue, (Object)blockSize);
            occurence = occurence == null ? Integer.valueOf(1) : Integer.valueOf(occurence + 1);
            jordanBlockSizes.put((Object)eigenvalue, (Object)blockSize, (Object)occurence);
        }

        static enum JordanTransformationStatus {
            SUCCESS,
            UNSUPPORTED_EIGENVALUES;

        }
    }
}

