/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.jordan;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.jordan.QuadraticMatrix;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import java.math.BigInteger;

public class RationalMatrix {
    private final QuadraticMatrix mIntMatrix;
    private BigInteger mDenominator;

    public RationalMatrix(BigInteger matrixDenominator, QuadraticMatrix matrix) {
        this.mDenominator = matrixDenominator;
        this.mIntMatrix = matrix;
    }

    public static RationalMatrix computeInverse(RationalMatrix matrix) {
        int n = matrix.mIntMatrix.getDimension();
        RationalMatrix matrixInverse = QuadraticMatrix.computeInverse(matrix.mIntMatrix);
        Rational factorInverse = Rational.valueOf((BigInteger)matrix.mDenominator, (BigInteger)matrixInverse.mDenominator);
        factorInverse = Rational.valueOf((BigInteger)factorInverse.numerator(), (BigInteger)factorInverse.denominator());
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                matrix.mIntMatrix.setEntry(i, j, matrix.mIntMatrix.getEntry(i, j).multiply(factorInverse.numerator()));
                ++j;
            }
            ++i;
        }
        matrixInverse.mDenominator = factorInverse.denominator();
        return matrixInverse;
    }

    public void addColumnToMatrix(int j, Rational[] vector) {
        QuadraticMatrix intMatrix = this.mIntMatrix;
        int n = intMatrix.getDimension();
        int i = 0;
        while (i < vector.length) {
            vector[i] = Rational.valueOf((BigInteger)vector[i].numerator(), (BigInteger)vector[i].denominator());
            BigInteger gcd = Rational.gcd((BigInteger)vector[i].denominator(), (BigInteger)this.mDenominator);
            intMatrix.setEntry(i, j, vector[i].numerator().multiply(this.mDenominator.divide(gcd)));
            this.mDenominator = this.mDenominator.multiply(vector[i].denominator().divide(gcd));
            int l = 0;
            while (l < n) {
                int k = 0;
                while (k < n) {
                    intMatrix.setEntry(l, k, intMatrix.getEntry(l, k).multiply(vector[i].denominator().divide(gcd)));
                    ++k;
                }
                ++l;
            }
            intMatrix.setEntry(i, j, intMatrix.getEntry(i, j).divide(vector[i].denominator().divide(gcd)));
            ++i;
        }
    }

    public void addRowToMatrix(int i, Rational[] vector) {
        QuadraticMatrix intMatrix = this.mIntMatrix;
        int n = intMatrix.getDimension();
        int j = 0;
        while (j < vector.length) {
            vector[j] = Rational.valueOf((BigInteger)vector[j].numerator(), (BigInteger)vector[j].denominator());
            BigInteger gcd = Rational.gcd((BigInteger)vector[j].denominator(), (BigInteger)this.mDenominator);
            intMatrix.setEntry(i, j, vector[j].numerator().multiply(this.mDenominator.divide(gcd)));
            this.mDenominator = this.mDenominator.multiply(vector[j].denominator().divide(gcd));
            int k = 0;
            while (k < n) {
                int l = 0;
                while (l < n) {
                    intMatrix.setEntry(k, l, intMatrix.getEntry(k, l).multiply(vector[j].denominator().divide(gcd)));
                    ++l;
                }
                ++k;
            }
            intMatrix.setEntry(i, j, intMatrix.getEntry(i, j).divide(vector[j].denominator().divide(gcd)));
            ++j;
        }
    }

    public static Rational[] solveLes(RationalMatrix les, Rational[][] constraints, int k) {
        int numberOfConstraints = constraints.length;
        RationalMatrix lesGauss1 = new RationalMatrix(BigInteger.valueOf(1L), QuadraticMatrix.gaussElimination(les.mIntMatrix));
        int rank = lesGauss1.mIntMatrix.computeRank();
        int i = 0;
        while (i < numberOfConstraints) {
            lesGauss1.addRowToMatrix(rank + i, constraints[i]);
            ++i;
        }
        lesGauss1.mIntMatrix.setEntry(lesGauss1.mIntMatrix.computeRank() - 1, lesGauss1.mIntMatrix.getDimension() - 1, BigInteger.valueOf(1L));
        QuadraticMatrix lesGauss2 = QuadraticMatrix.gaussElimination(lesGauss1.mIntMatrix);
        Rational[] solution = QuadraticMatrix.backwardSubstitution(lesGauss2, k);
        return solution;
    }

    public QuadraticMatrix getIntMatrix() {
        return this.mIntMatrix;
    }

    public BigInteger getDenominator() {
        return this.mDenominator;
    }
}

