/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.mohr;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class IcfgLoop<INLOC extends IcfgLocation> {
    private final Map<INLOC, IcfgLoop<INLOC>> mNestedLoops = new HashMap<INLOC, IcfgLoop<INLOC>>();
    private final Set<INLOC> mLoopbody;
    private final INLOC mHead;
    private final Set<INLOC> mNestedNodes;
    private final Set<ArrayList<IcfgEdge>> mPaths;
    private final IUltimateServiceProvider mServices;
    private final List<Pair<List<UnmodifiableTransFormula>, INLOC>> mLoopExits;

    public IcfgLoop(IUltimateServiceProvider services) {
        this(services, new HashSet(), null);
    }

    public IcfgLoop(IUltimateServiceProvider services, Set<INLOC> loopNodes, INLOC head) {
        this.mLoopbody = new HashSet<INLOC>(loopNodes);
        this.mHead = head;
        this.mNestedNodes = new HashSet<INLOC>();
        this.mPaths = new HashSet<ArrayList<IcfgEdge>>();
        this.mLoopExits = new ArrayList<Pair<List<UnmodifiableTransFormula>, INLOC>>();
        this.mServices = services;
    }

    public void addAll(Set<INLOC> loopNodes) {
        this.mLoopbody.addAll(loopNodes);
    }

    public void addNestedLoop(IcfgLoop<INLOC> loop) {
        if (loop.getLoopbody().equals(this.mLoopbody)) {
            return;
        }
        for (IcfgLoop<INLOC> nestedLoop : this.mNestedLoops.values()) {
            if (!nestedLoop.contains(loop.getHead())) continue;
            nestedLoop.addNestedLoop(loop);
            this.mNestedNodes.addAll(loop.getLoopbody());
            return;
        }
        this.mNestedLoops.put(loop.getHead(), loop);
        this.mNestedNodes.addAll(loop.getLoopbody());
        this.mNestedNodes.remove(loop.getHead());
    }

    public boolean hasNestedLoops() {
        return !this.mNestedLoops.isEmpty();
    }

    public IcfgLoop<INLOC> getNestedLoop(INLOC loopHead) {
        return this.mNestedLoops.get(loopHead);
    }

    public Set<INLOC> getNestedLoopHeads() {
        return this.mNestedLoops.keySet();
    }

    public Set<INLOC> getLoopbody() {
        return this.mLoopbody;
    }

    public INLOC getHead() {
        return this.mHead;
    }

    public List<Pair<List<UnmodifiableTransFormula>, INLOC>> getLoopExits() {
        return this.mLoopExits;
    }

    public boolean contains(INLOC node) {
        return this.mLoopbody.contains(node);
    }

    public Set<ArrayList<IcfgEdge>> getPaths() {
        if (this.mPaths.isEmpty()) {
            this.loopPaths();
        }
        return this.mPaths;
    }

    private void loopPaths() {
        ArrayDeque queue = new ArrayDeque();
        ArrayList breakPaths = new ArrayList();
        HashMap<INLOC, List<Pair<List<UnmodifiableTransFormula>, INLOC>>> nestedBreakPaths = new HashMap<INLOC, List<Pair<List<UnmodifiableTransFormula>, INLOC>>>();
        for (IcfgLoop<INLOC> icfgLoop : this.mNestedLoops.values()) {
            icfgLoop.getPaths();
            nestedBreakPaths.put(icfgLoop.getHead(), icfgLoop.getLoopExits());
        }
        for (IcfgEdge icfgEdge : this.mHead.getOutgoingEdges()) {
            if (!this.mLoopbody.contains(icfgEdge.getTarget())) continue;
            ArrayList<IcfgEdge> a = new ArrayList<IcfgEdge>();
            a.add(icfgEdge);
            queue.add(a);
        }
        while (!queue.isEmpty()) {
            ArrayList<IcfgEdge> addPath;
            ArrayList arrayList = (ArrayList)queue.removeFirst();
            IcfgLocation destination = (IcfgLocation)((IcfgEdge)arrayList.get(arrayList.size() - 1)).getTarget();
            if (destination.equals(this.mHead)) {
                this.mPaths.add(arrayList);
                continue;
            }
            if (nestedBreakPaths.containsKey(destination)) {
                for (Pair p : (List)nestedBreakPaths.get(destination)) {
                    if (this.mLoopbody.contains(p.getSecond())) {
                        addPath = new ArrayList<IcfgEdge>(arrayList);
                        addPath.addAll((Collection)p.getFirst());
                        queue.add(addPath);
                        continue;
                    }
                    addPath = new ArrayList(arrayList);
                    addPath.addAll((Collection)p.getFirst());
                    breakPaths.add(addPath);
                }
            }
            for (IcfgEdge edge3 : destination.getOutgoingEdges()) {
                if (!this.mNestedNodes.contains(edge3.getTarget()) && this.mLoopbody.contains(edge3.getTarget()) && !destination.equals((Object)edge3.getTarget())) {
                    addPath = new ArrayList(arrayList);
                    addPath.add(edge3);
                    queue.add(addPath);
                    continue;
                }
                if (this.mNestedNodes.contains(edge3.getTarget()) || destination.equals((Object)edge3.getTarget())) continue;
                addPath = new ArrayList(arrayList);
                addPath.add(edge3);
                breakPaths.add(addPath);
            }
        }
        for (List list : breakPaths) {
            ArrayList bPathFormula = new ArrayList();
            list.forEach(edge -> {
                boolean bl = bPathFormula.add(edge.getTransformula());
            });
            IcfgLocation target = (IcfgLocation)((IcfgEdge)list.get(list.size() - 1)).getTarget();
            this.mLoopExits.add(new Pair(bPathFormula, (Object)target));
        }
    }
}

