/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.mohr;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.mohr.IcfgLoop;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.TermClassifier;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class IcfgLoopDetection<INLOC extends IcfgLocation> {
    private final Set<IcfgLoop<INLOC>> mLoops;
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;

    public IcfgLoopDetection(ILogger logger, IUltimateServiceProvider services, IIcfg<INLOC> icfg) {
        this.mLogger = logger;
        this.mServices = services;
        this.mLoops = this.loopExtraction(icfg);
    }

    private Set<IcfgLoop<INLOC>> loopExtraction(IIcfg<INLOC> originalIcfg) {
        Set init = originalIcfg.getInitialNodes();
        if (init.size() > 1) {
            this.mLogger.info((Object)"Unable to accelerate with more than one entries");
            return new HashSet<IcfgLoop<INLOC>>();
        }
        ArrayDeque<Object> open = new ArrayDeque<Object>();
        HashMap dom = new HashMap();
        for (IcfgLocation entry : init) {
            HashSet<IcfgLocation> newDom = new HashSet<IcfgLocation>();
            newDom.add(entry);
            dom.put(entry, newDom);
            for (Object successor : entry.getOutgoingNodes()) {
                if (open.contains(successor)) continue;
                open.add(successor);
            }
        }
        while (!open.isEmpty()) {
            IcfgLocation node = (IcfgLocation)open.removeFirst();
            HashSet<IcfgLocation> newDom = new HashSet<IcfgLocation>();
            for (IcfgLocation predecessor : node.getIncomingNodes()) {
                if (!dom.containsKey(predecessor)) continue;
                if (newDom.isEmpty()) {
                    newDom.addAll((Collection)dom.get(predecessor));
                    continue;
                }
                newDom.retainAll((Collection)dom.get(predecessor));
            }
            if (!newDom.isEmpty()) {
                newDom.add(node);
            }
            if (newDom.equals(dom.get(node))) continue;
            for (IcfgLocation successor : node.getOutgoingNodes()) {
                if (open.contains(successor)) continue;
                open.add(successor);
            }
            if (dom.containsKey(node)) {
                ((Set)dom.get(node)).addAll(newDom);
                continue;
            }
            dom.put(node, newDom);
        }
        HashSet<IcfgEdge> backedges = new HashSet<IcfgEdge>();
        HashSet<IcfgLocation> visited = new HashSet<IcfgLocation>();
        open.addAll(originalIcfg.getInitialNodes());
        while (!open.isEmpty()) {
            IcfgLocation node = (IcfgLocation)open.removeFirst();
            visited.add(node);
            for (IcfgEdge edge : node.getOutgoingEdges()) {
                if (((Set)dom.get(node)).contains(edge.getTarget())) {
                    backedges.add(edge);
                }
                if (visited.contains(edge.getTarget())) continue;
                open.add((IcfgLocation)edge.getTarget());
            }
        }
        HashMap<IcfgLocation, IcfgLoop<IcfgLocation>> loopbodies = new HashMap<IcfgLocation, IcfgLoop<IcfgLocation>>();
        HashSet<IcfgLocation> badLoops = new HashSet<IcfgLocation>();
        for (IcfgEdge edge : backedges) {
            TermClassifier tc = new TermClassifier();
            IcfgLocation head = (IcfgLocation)edge.getTarget();
            HashSet<IcfgLocation> body = new HashSet<IcfgLocation>();
            body.add(head);
            ArrayDeque<IcfgLocation> queue = new ArrayDeque<IcfgLocation>();
            queue.add((IcfgLocation)edge.getSource());
            tc.checkTerm(edge.getTransformula().getFormula());
            while (!queue.isEmpty()) {
                IcfgLocation node = (IcfgLocation)queue.removeFirst();
                if (body.contains(node)) continue;
                body.add(node);
                queue.addAll(node.getIncomingNodes());
                node.getIncomingEdges().forEach(e -> tc.checkTerm(e.getTransformula().getFormula()));
            }
            if (tc.hasArrays()) {
                badLoops.add(head);
                this.mLogger.info((Object)("Unable to accelerate loop at node " + head + " since it contains array access."));
                continue;
            }
            if (loopbodies.containsKey(head)) {
                ((IcfgLoop)loopbodies.get(head)).addAll(body);
                continue;
            }
            loopbodies.put(head, new IcfgLoop<IcfgLocation>(this.mServices, body, head));
        }
        badLoops.forEach(loopbodies::remove);
        ArrayList heads = new ArrayList(loopbodies.keySet());
        for (IcfgLocation nestedhead : heads) {
            for (IcfgLocation head : heads) {
                if (nestedhead.equals((Object)head) || !loopbodies.containsKey(nestedhead) || !loopbodies.containsKey(head) || !((IcfgLoop)loopbodies.get(head)).contains(nestedhead)) continue;
                ((IcfgLoop)loopbodies.get(head)).addNestedLoop((IcfgLoop)loopbodies.get(nestedhead));
                loopbodies.remove(nestedhead);
                this.mLogger.info((Object)"Unable to accelerate, since loop contains nested loops");
                return new HashSet<IcfgLoop<INLOC>>();
            }
        }
        if (loopbodies.isEmpty() && badLoops.isEmpty()) {
            return this.altLoopExtraction(originalIcfg);
        }
        return new HashSet<IcfgLoop<INLOC>>(loopbodies.values());
    }

    private Set<IcfgLoop<INLOC>> altLoopExtraction(IIcfg<INLOC> originalIcfg) {
        HashSet<IcfgLoop<INLOC>> result = new HashSet<IcfgLoop<INLOC>>();
        Set loopHeaders = originalIcfg.getLoopLocations();
        for (IcfgLocation head : loopHeaders) {
            HashSet loopBody = new HashSet();
            ArrayDeque paths = new ArrayDeque();
            for (IcfgEdge e : head.getOutgoingEdges()) {
                paths.addLast(new ArrayList<IcfgEdge>(Arrays.asList(e)));
            }
            while (!paths.isEmpty()) {
                List path = (List)paths.pop();
                if (((IcfgLocation)((IcfgEdge)path.get(path.size() - 1)).getTarget()).equals((Object)head)) {
                    path.forEach(edge -> {
                        boolean bl = loopBody.add((IcfgLocation)edge.getSource());
                    });
                    continue;
                }
                for (IcfgEdge e : ((IcfgLocation)((IcfgEdge)path.get(path.size() - 1)).getTarget()).getOutgoingEdges()) {
                    ArrayList<IcfgEdge> newPath = new ArrayList<IcfgEdge>(path);
                    newPath.add(e);
                    paths.addLast(newPath);
                }
            }
            result.add(new IcfgLoop<IcfgLocation>(this.mServices, loopBody, head));
        }
        return result;
    }

    public Set<IcfgLoop<INLOC>> getResult() {
        this.mLoops.forEach(l -> this.mLogger.info((Object)("Loop @" + l.getHead() + ": " + l.getLoopbody() + "; nested @" + l.getNestedLoopHeads())));
        return this.mLoops;
    }
}

