/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.mohr;

import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.Overapprox;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.IIcfgTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.ILocationFactory;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.IcfgTransformationBacktranslator;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.TransformedIcfgBuilder;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.IdentityTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.mohr.IcfgLoop;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.mohr.IcfgLoopDetection;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.mohr.SymbolicMemory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.BasicIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgCallTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgReturnTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgInternalTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.SimultaneousUpdate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class IcfgLoopTransformerMohr<INLOC extends IcfgLocation, OUTLOC extends IcfgLocation>
implements IIcfgTransformer<OUTLOC> {
    private final IIcfg<OUTLOC> mResult;
    private final TransformedIcfgBuilder<INLOC, OUTLOC> mTib;
    private final ManagedScript mManagedScript;
    private final IIcfgSymbolTable mSymbolTable;
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private final Map<INLOC, Boolean> mOverApproximation = new HashMap<INLOC, Boolean>();

    public IcfgLoopTransformerMohr(ILogger logger, IUltimateServiceProvider services, IIcfg<INLOC> originalIcfg, ILocationFactory<INLOC, OUTLOC> funLocFac, IcfgTransformationBacktranslator backtranslationTracker, Class<OUTLOC> outLocationClass, String newIcfgIdentifier) {
        this.mManagedScript = originalIcfg.getCfgSmtToolkit().getManagedScript();
        this.mServices = services;
        this.mLogger = logger;
        this.mSymbolTable = originalIcfg.getCfgSmtToolkit().getSymbolTable();
        BasicIcfg resultIcfg = new BasicIcfg(newIcfgIdentifier, originalIcfg.getCfgSmtToolkit(), outLocationClass);
        IdentityTransformer identityTransformer = new IdentityTransformer(originalIcfg.getCfgSmtToolkit());
        this.mTib = new TransformedIcfgBuilder<INLOC, OUTLOC>(this.mLogger, funLocFac, backtranslationTracker, identityTransformer, originalIcfg, resultIcfg);
        this.transform(originalIcfg);
        this.mTib.finish();
        this.mResult = resultIcfg;
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug(this.mResult);
        }
    }

    private void transform(IIcfg<INLOC> origIcfg) {
        IcfgLoopDetection<INLOC> loopDetector = new IcfgLoopDetection<INLOC>(this.mLogger, this.mServices, origIcfg);
        Set<IcfgLoop<INLOC>> loops = loopDetector.getResult();
        HashSet<INLOC> loopHeads = new HashSet<INLOC>();
        HashSet<INLOC> loopNodes = new HashSet<INLOC>();
        HashMap<INLOC, UnmodifiableTransFormula> loopSummaries = new HashMap<INLOC, UnmodifiableTransFormula>();
        HashMap loopExits = new HashMap();
        if (!loops.isEmpty()) {
            for (IcfgLoop<INLOC> loop : loops) {
                loopHeads.add(loop.getHead());
                loopNodes.addAll(loop.getLoopbody());
                loopSummaries.put(loop.getHead(), this.transformLoop(loop));
                loopExits.put(loop.getHead(), new HashSet());
                for (Pair<List<UnmodifiableTransFormula>, INLOC> exitPath : loop.getLoopExits()) {
                    UnmodifiableTransFormula exitUtf = TransFormulaUtils.sequentialComposition((ILogger)this.mLogger, (IUltimateServiceProvider)this.mServices, (ManagedScript)this.mManagedScript, (boolean)false, (boolean)false, (boolean)false, (SmtUtils.XnfConversionTechnique)SmtUtils.XnfConversionTechnique.BOTTOM_UP_WITH_LOCAL_SIMPLIFICATION, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA, (List)((List)exitPath.getFirst()));
                    this.mLogger.info((Object)("Found exit path: " + exitUtf));
                    ((Set)loopExits.get(loop.getHead())).add(new Pair((Object)exitUtf, (Object)((IcfgLocation)exitPath.getSecond())));
                }
            }
        }
        ArrayDeque<IcfgLocation> queue = new ArrayDeque<IcfgLocation>();
        HashSet<IcfgLocation> visited = new HashSet<IcfgLocation>();
        queue.add((IcfgLocation)origIcfg.getInitialNodes().iterator().next());
        ArrayList<Triple> rtrTransitions = new ArrayList<Triple>();
        while (!queue.isEmpty()) {
            IcfgLocation node = (IcfgLocation)queue.removeFirst();
            visited.add(node);
            OUTLOC newSource = this.mTib.createNewLocation(node);
            for (IcfgEdge edge : node.getOutgoingEdges()) {
                if (loopNodes.contains(edge.getTarget()) && !loopHeads.contains(edge.getTarget()) || node.equals((Object)edge.getTarget())) continue;
                if (!visited.contains(edge.getTarget())) {
                    queue.add((IcfgLocation)edge.getTarget());
                }
                OUTLOC newTarget = this.mTib.createNewLocation((IcfgLocation)edge.getTarget());
                if (loopHeads.contains(node)) {
                    UnmodifiableTransFormula loopSummary = (UnmodifiableTransFormula)loopSummaries.get(node);
                    UnmodifiableTransFormula utf = TransFormulaUtils.sequentialComposition((ILogger)this.mLogger, (IUltimateServiceProvider)this.mServices, (ManagedScript)this.mManagedScript, (boolean)false, (boolean)false, (boolean)false, (SmtUtils.XnfConversionTechnique)SmtUtils.XnfConversionTechnique.BOTTOM_UP_WITH_LOCAL_SIMPLIFICATION, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA, Arrays.asList(loopSummary, edge.getTransformula()));
                    this.mLogger.info((Object)("Loop Summary Transformula: " + utf));
                    IcfgInternalTransition e = this.mTib.createNewInternalTransition(newSource, newTarget, utf, this.mOverApproximation.get(node));
                    new Overapprox("Because of loop acceleration", null).annotate((IElement)e);
                    for (Pair exit : (Set)loopExits.get(node)) {
                        OUTLOC exitTarget = this.mTib.createNewLocation((IcfgLocation)exit.getSecond());
                        UnmodifiableTransFormula exitSummary = TransFormulaUtils.sequentialComposition((ILogger)this.mLogger, (IUltimateServiceProvider)this.mServices, (ManagedScript)this.mManagedScript, (boolean)false, (boolean)false, (boolean)false, (SmtUtils.XnfConversionTechnique)SmtUtils.XnfConversionTechnique.BOTTOM_UP_WITH_LOCAL_SIMPLIFICATION, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA, Arrays.asList(loopSummary, (UnmodifiableTransFormula)exit.getFirst()));
                        IcfgInternalTransition o = this.mTib.createNewInternalTransition(newSource, exitTarget, exitSummary, this.mOverApproximation.get(node));
                        new Overapprox("Because of loop acceleration", null).annotate((IElement)o);
                    }
                    continue;
                }
                if (edge instanceof IIcfgReturnTransition) {
                    this.mLogger.info((Object)("Return: " + newSource + " - " + edge + " -> " + newTarget));
                    rtrTransitions.add(new Triple(newSource, newTarget, (Object)edge));
                    continue;
                }
                if (edge instanceof IIcfgCallTransition) {
                    this.mLogger.info((Object)("Call: " + newSource + " - " + edge + " -> " + newTarget));
                }
                this.mLogger.info((Object)("Internal: " + newSource + " - " + edge + " -> " + newTarget));
                this.mTib.createNewTransition(newSource, newTarget, edge);
            }
        }
        rtrTransitions.forEach(a -> {
            IcfgEdge icfgEdge = this.mTib.createNewTransition((IcfgLocation)a.getFirst(), (IcfgLocation)a.getSecond(), (IcfgEdge)a.getThird());
        });
    }

    private UnmodifiableTransFormula transformLoop(IcfgLoop<INLOC> loop) {
        ArrayList pathSymbolicMemory = new ArrayList();
        ArrayList<UnmodifiableTransFormula> pathGuards = new ArrayList<UnmodifiableTransFormula>();
        SymbolicMemory symbolicMemory = new SymbolicMemory(this.mManagedScript, this.mLogger);
        int pathCount = 0;
        ArrayDeque<TransFormula> queue = new ArrayDeque<TransFormula>();
        for (ArrayList<IcfgEdge> arrayList : loop.getPaths()) {
            ArrayList<UnmodifiableTransFormula> formulas = new ArrayList<UnmodifiableTransFormula>();
            for (IcfgEdge edge : arrayList) {
                if (loop.getNestedLoopHeads().contains(edge.getSource())) {
                    formulas.add(this.transformLoop(loop.getNestedLoop((IcfgLocation)edge.getSource())));
                    this.mLogger.debug((Object)("nested Loop @" + edge.getSource() + " : " + formulas.get(formulas.size() - 1)));
                }
                formulas.add(edge.getTransformula());
            }
            UnmodifiableTransFormula composition = TransFormulaUtils.sequentialComposition((ILogger)this.mLogger, (IUltimateServiceProvider)this.mServices, (ManagedScript)this.mManagedScript, (boolean)false, (boolean)false, (boolean)false, null, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.NONE, formulas);
            this.mLogger.debug((Object)("Path formulas: " + formulas));
            this.mLogger.debug((Object)("Composition: " + composition));
            queue.addAll(this.getDisjunctsFromTransformula((TransFormula)composition));
        }
        while (!queue.isEmpty()) {
            SimultaneousUpdate su;
            TransFormula transFormula = (TransFormula)queue.remove();
            symbolicMemory.newPath();
            pathSymbolicMemory.add(new HashMap());
            try {
                su = SimultaneousUpdate.fromTransFormula((IUltimateServiceProvider)this.mServices, (TransFormula)transFormula, (ManagedScript)this.mManagedScript);
            }
            catch (SimultaneousUpdate.SimultaneousUpdateException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
            Map varUpdates = su.getDeterministicAssignment();
            Set havocVars = su.getHavocedVars();
            this.mLogger.debug((Object)("Updates: " + varUpdates + " havocs: " + havocVars));
            if (!havocVars.isEmpty()) {
                this.mOverApproximation.put(loop.getHead(), true);
            }
            pathGuards.add(TransFormulaUtils.computeGuard((UnmodifiableTransFormula)((UnmodifiableTransFormula)transFormula), (ManagedScript)this.mManagedScript, (IUltimateServiceProvider)this.mServices));
            for (Map.Entry newValue : varUpdates.entrySet()) {
                if (newValue.getValue() instanceof ConstantTerm || newValue.getValue() instanceof TermVariable) {
                    symbolicMemory.updateConst((IProgramVar)newValue.getKey(), (Term)newValue.getValue(), this.mSymbolTable);
                    continue;
                }
                if (newValue.getValue() instanceof ApplicationTerm && ("+".equals(((ApplicationTerm)newValue.getValue()).getFunction().getName()) || "-".equals(((ApplicationTerm)newValue.getValue()).getFunction().getName()))) {
                    HashSet<TermVariable> freeVars = new HashSet<TermVariable>(Arrays.asList(((Term)newValue.getValue()).getFreeVars()));
                    if (freeVars.contains(((IProgramVar)newValue.getKey()).getTermVariable())) {
                        symbolicMemory.updateInc((IProgramVar)newValue.getKey(), (Term)newValue.getValue(), this.mSymbolTable);
                        continue;
                    }
                    symbolicMemory.updateConst((IProgramVar)newValue.getKey(), (Term)newValue.getValue(), this.mSymbolTable);
                    continue;
                }
                symbolicMemory.updateUndefined((IProgramVar)newValue.getKey(), this.mSymbolTable);
            }
            ++pathCount;
        }
        ArrayList<Term> arrayList = new ArrayList<Term>();
        int i = 0;
        while (i < pathCount) {
            arrayList.add(symbolicMemory.getFormula(i, (TransFormula)pathGuards.get(i)));
            ++i;
        }
        Term varUpdate = symbolicMemory.getVarUpdateTerm();
        if (varUpdate != null) {
            arrayList.add(varUpdate);
        }
        arrayList.add(symbolicMemory.getKappaMin());
        Term loopSummary = SmtUtils.and((Script)this.mManagedScript.getScript(), (Term[])arrayList.toArray(new Term[arrayList.size()]));
        Map<IProgramVar, TermVariable> inVars = symbolicMemory.getInVars();
        Map<IProgramVar, TermVariable> outVars = symbolicMemory.getOutVars();
        TransFormulaBuilder tfb = new TransFormulaBuilder(inVars, outVars, true, null, true, null, false);
        Set<TermVariable> aux = symbolicMemory.getKappas();
        aux.addAll(symbolicMemory.getTaus());
        Term quantFreeFormula = PartialQuantifierElimination.eliminateCompat((IUltimateServiceProvider)this.mServices, (ManagedScript)this.mManagedScript, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA, (Term)loopSummary);
        tfb.setFormula(quantFreeFormula);
        tfb.addAuxVarsButRenameToFreshCopies(aux, this.mManagedScript);
        tfb.setInfeasibility(UnmodifiableTransFormula.Infeasibility.NOT_DETERMINED);
        if (symbolicMemory.containsUndefined().booleanValue()) {
            this.mOverApproximation.put(loop.getHead(), true);
        } else {
            this.mOverApproximation.put(loop.getHead(), false);
        }
        return tfb.finishConstruction(this.mManagedScript);
    }

    private List<TransFormula> getDisjunctsFromTransformula(TransFormula originalTf) {
        Term[] disjuncts;
        Term dnf = SmtUtils.toDnf((IUltimateServiceProvider)this.mServices, (ManagedScript)this.mManagedScript, (Term)originalTf.getFormula(), (SmtUtils.XnfConversionTechnique)SmtUtils.XnfConversionTechnique.BOTTOM_UP_WITH_LOCAL_SIMPLIFICATION);
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("DNF: " + dnf.toStringDirect()));
        }
        if ((disjuncts = SmtUtils.getDisjuncts((Term)dnf)).length == 1) {
            return Collections.singletonList(originalTf);
        }
        ArrayList<TransFormula> rtr = new ArrayList<TransFormula>(disjuncts.length);
        Map inVars = originalTf.getInVars();
        Map outVars = originalTf.getOutVars();
        Set nonTheoryConsts = originalTf.getNonTheoryConsts();
        Set branchEncoders = Collections.emptySet();
        boolean emptyAuxVars = originalTf.getAuxVars().isEmpty();
        Term[] termArray = disjuncts;
        int n = disjuncts.length;
        int n2 = 0;
        while (n2 < n) {
            Term disjunct = termArray[n2];
            Term simpl = SmtUtils.simplify((ManagedScript)this.mManagedScript, (Term)disjunct, (IUltimateServiceProvider)this.mServices, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA);
            TransFormulaBuilder tfBuilder = new TransFormulaBuilder(inVars, outVars, nonTheoryConsts.isEmpty(), nonTheoryConsts, branchEncoders.isEmpty(), branchEncoders, emptyAuxVars);
            tfBuilder.setFormula(simpl);
            tfBuilder.setInfeasibility(UnmodifiableTransFormula.Infeasibility.NOT_DETERMINED);
            UnmodifiableTransFormula disjunctTf = tfBuilder.finishConstruction(this.mManagedScript);
            rtr.add((TransFormula)disjunctTf);
            ++n2;
        }
        return rtr;
    }

    @Override
    public IIcfg<OUTLOC> getResult() {
        return this.mResult;
    }
}

