/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.mohr;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SymbolicMemory {
    private final ManagedScript mManagedScript;
    private final ILogger mLogger;
    private final Map<IProgramVar, List<Term>> mSymbolicMemory;
    private final Map<IProgramVar, Term> mIteratedSymbolicMemory;
    private final Map<IProgramVar, UpdateType> mUpdateTypeMap;
    private final List<TermVariable> mKappas;
    private final Map<TermVariable, TermVariable> mKappa2Tau;
    private final List<Term> mRangeTerms;
    private final List<Term> mRangeExTerms;
    private final Map<Integer, Set<IProgramVar>> mAssignedVars;
    private final Map<TermVariable, Set<Integer>> mAssigningPaths;
    private final Map<IProgramVar, TermVariable> mInVars;
    private final Map<Term, Term> mReplaceInV;
    private final Map<IProgramVar, TermVariable> mOutVars;
    private int mCurrentPath;

    public SymbolicMemory(ManagedScript manScript, ILogger logger) {
        this.mManagedScript = manScript;
        this.mLogger = logger;
        this.mSymbolicMemory = new HashMap<IProgramVar, List<Term>>();
        this.mIteratedSymbolicMemory = new HashMap<IProgramVar, Term>();
        this.mUpdateTypeMap = new HashMap<IProgramVar, UpdateType>();
        this.mKappas = new ArrayList<TermVariable>();
        this.mKappa2Tau = new HashMap<TermVariable, TermVariable>();
        this.mRangeTerms = new ArrayList<Term>();
        this.mRangeExTerms = new ArrayList<Term>();
        this.mAssignedVars = new HashMap<Integer, Set<IProgramVar>>();
        this.mAssigningPaths = new HashMap<TermVariable, Set<Integer>>();
        this.mInVars = new HashMap<IProgramVar, TermVariable>();
        this.mOutVars = new HashMap<IProgramVar, TermVariable>();
        this.mReplaceInV = new HashMap<Term, Term>();
        this.mCurrentPath = -1;
    }

    public void newPath() {
        ++this.mCurrentPath;
        this.mAssignedVars.put(this.mCurrentPath, new HashSet());
        TermVariable k = this.mManagedScript.variable("kappa" + this.mCurrentPath, this.mManagedScript.getScript().sort("Int", new Sort[0]));
        this.mKappas.add(k);
        TermVariable t = this.mManagedScript.variable("tau" + this.mCurrentPath, this.mManagedScript.getScript().sort("Int", new Sort[0]));
        this.mKappa2Tau.put(k, t);
        Term range = SmtUtils.and((Script)this.mManagedScript.getScript(), (Term[])new Term[]{this.mManagedScript.getScript().term("<=", new Term[]{Rational.ZERO.toTerm(this.mManagedScript.getScript().sort("Int", new Sort[0])), t}), this.mManagedScript.getScript().term("<", new Term[]{t, k})});
        this.mRangeTerms.add(range);
        Term rangeEx = SmtUtils.and((Script)this.mManagedScript.getScript(), (Term[])new Term[]{this.mManagedScript.getScript().term("<=", new Term[]{Rational.ZERO.toTerm(this.mManagedScript.getScript().sort("Int", new Sort[0])), t}), this.mManagedScript.getScript().term("<=", new Term[]{t, k})});
        this.mRangeExTerms.add(rangeEx);
    }

    public void updateInc(IProgramVar variable, Term value, IIcfgSymbolTable st) {
        if (((ApplicationTerm)value).getParameters().length <= 1) {
            if (((ApplicationTerm)value).getFunction().toString().equals("-")) {
                this.updateConst(variable, value, st);
                return;
            }
            return;
        }
        this.updateInOutVars(variable, st, value.getFreeVars());
        Term repValue = Substitution.apply((ManagedScript)this.mManagedScript, this.mReplaceInV, (Term)value);
        this.mAssignedVars.get(this.mCurrentPath).add(variable);
        UpdateType ut = this.mUpdateTypeMap.get(variable);
        if (ut != null) {
            switch (ut) {
                case INCREMENTATION: {
                    this.mSymbolicMemory.get(variable).add(this.insertPathCounter((ApplicationTerm)repValue, this.mKappa2Tau.get(this.mKappas.get(this.mCurrentPath)), variable.getTermVariable()));
                    break;
                }
                case CONSTANT: {
                    this.updateUndefined(variable, st);
                    break;
                }
                case CONSTANT_WITH_SINGLE_PATHCOUNTER: {
                    this.updateUndefined(variable, st);
                    break;
                }
            }
        } else {
            this.mSymbolicMemory.put(variable, new ArrayList());
            this.mSymbolicMemory.get(variable).add(this.insertPathCounter((ApplicationTerm)repValue, this.mKappa2Tau.get(this.mKappas.get(this.mCurrentPath)), variable.getTermVariable()));
            this.mUpdateTypeMap.put(variable, UpdateType.INCREMENTATION);
        }
    }

    public void updateConst(IProgramVar variable, Term value, IIcfgSymbolTable st) {
        block8: {
            Term repValue;
            block7: {
                this.updateInOutVars(variable, st, value.getFreeVars());
                repValue = Substitution.apply((ManagedScript)this.mManagedScript, this.mReplaceInV, (Term)value);
                this.mAssignedVars.get(this.mCurrentPath).add(variable);
                UpdateType ut = this.mUpdateTypeMap.get(variable);
                if (ut == null) break block7;
                switch (ut) {
                    case INCREMENTATION: {
                        this.updateUndefined(variable, st);
                        break;
                    }
                    case CONSTANT: {
                        if (!repValue.equals(this.mSymbolicMemory.get(variable).get(0))) {
                            this.updateUndefined(variable, st);
                            break;
                        }
                        break block8;
                    }
                    case CONSTANT_WITH_SINGLE_PATHCOUNTER: {
                        if (!repValue.equals(this.mSymbolicMemory.get(variable).get(0))) {
                            this.updateUndefined(variable, st);
                            break;
                        }
                        this.mUpdateTypeMap.put(variable, UpdateType.CONSTANT);
                        break;
                    }
                }
                break block8;
            }
            this.mSymbolicMemory.put(variable, new ArrayList());
            this.mSymbolicMemory.get(variable).add(repValue);
            this.mUpdateTypeMap.put(variable, UpdateType.CONSTANT_WITH_SINGLE_PATHCOUNTER);
        }
    }

    public void updateUndefined(IProgramVar variable, IIcfgSymbolTable st) {
        this.mInVars.remove(variable.getTermVariable());
        this.updateInOutVars(variable, st, new TermVariable[0]);
        this.mAssignedVars.get(this.mCurrentPath).add(variable);
        this.mSymbolicMemory.put(variable, null);
        this.mUpdateTypeMap.put(variable, UpdateType.UNDEFINED);
    }

    public Term getFormula(int path, TransFormula guard) {
        if (this.mIteratedSymbolicMemory.isEmpty()) {
            this.generateTerms();
        }
        for (IProgramVar iv : guard.getInVars().keySet()) {
            if (this.mReplaceInV.containsKey(iv.getTermVariable())) continue;
            TermVariable cp = this.mManagedScript.constructFreshCopy(iv.getTermVariable());
            this.mInVars.put(iv, cp);
            this.mReplaceInV.put((Term)iv.getTermVariable(), (Term)cp);
        }
        for (IProgramVar ov : guard.getOutVars().keySet()) {
            if (this.mOutVars.containsKey(ov)) continue;
            this.mOutVars.put(ov, this.mManagedScript.constructFreshCopy(ov.getTermVariable()));
        }
        Map revInVars = TransFormulaUtils.constructReverseMapping((Map)guard.getInVars());
        HashMap<TermVariable, Term> symValueSubMap = new HashMap<TermVariable, Term>();
        TermVariable[] termVariableArray = guard.getFormula().getFreeVars();
        int n = termVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            TermVariable freeVar = termVariableArray[n2];
            IProgramVar pv = (IProgramVar)revInVars.get(freeVar);
            if (this.mUpdateTypeMap.get(pv) != UpdateType.UNDEFINED && this.mUpdateTypeMap.get(pv) != null) {
                symValueSubMap.put(freeVar, this.mIteratedSymbolicMemory.get(pv));
            } else if (this.mUpdateTypeMap.get(pv) != UpdateType.UNDEFINED) {
                this.mOutVars.put(pv, this.mInVars.get(pv));
            }
            ++n2;
        }
        Term varReplacedGuard = symValueSubMap.size() > 0 ? Substitution.apply((ManagedScript)this.mManagedScript, symValueSubMap, (Term)guard.getFormula()) : guard.getFormula();
        HashMap<Term, Term> cleanSubMap = new HashMap<Term, Term>();
        for (Map.Entry entry : revInVars.entrySet()) {
            cleanSubMap.put((Term)entry.getKey(), this.mReplaceInV.get(((IProgramVar)entry.getValue()).getTermVariable()));
        }
        Term term = Substitution.apply((ManagedScript)this.mManagedScript, cleanSubMap, (Term)varReplacedGuard);
        ArrayList<Term> conjTerms = new ArrayList<Term>();
        TermVariable[] exitsTaus = new TermVariable[this.mKappas.size() - 1];
        int arrayIndex = 0;
        int i = 0;
        while (i < this.mKappas.size()) {
            if (i != path) {
                conjTerms.add(this.mRangeExTerms.get(i));
                exitsTaus[arrayIndex] = this.mKappa2Tau.get(this.mKappas.get(i));
                ++arrayIndex;
            }
            ++i;
        }
        conjTerms.add(term);
        Term formulaTerm = SmtUtils.and((Script)this.mManagedScript.getScript(), (Term[])conjTerms.toArray(new Term[conjTerms.size()]));
        Term ex = this.mCurrentPath > 0 ? this.mManagedScript.getScript().quantifier(0, exitsTaus, formulaTerm, (Term[][])new Term[0][]) : formulaTerm;
        TermVariable[] allTaus = new TermVariable[]{this.mKappa2Tau.get(this.mKappas.get(path))};
        Term allTerm = this.mManagedScript.getScript().quantifier(1, allTaus, Util.implies((Script)this.mManagedScript.getScript(), (Term[])new Term[]{this.mRangeTerms.get(path), ex}), (Term[][])new Term[0][]);
        this.mLogger.debug((Object)allTerm.toStringDirect());
        return allTerm;
    }

    public Term getVarUpdateTerm() {
        ArrayList<Term> terms = new ArrayList<Term>();
        for (Map.Entry<IProgramVar, Term> e : this.mIteratedSymbolicMemory.entrySet()) {
            terms.add(this.mManagedScript.getScript().term("=", new Term[]{(Term)this.mOutVars.get(e.getKey()), e.getValue()}));
        }
        if (terms.isEmpty()) {
            return null;
        }
        HashMap tau2Kappa = new HashMap();
        this.mKappa2Tau.forEach((k, v) -> {
            TermVariable termVariable = tau2Kappa.put(v, k);
        });
        Term result = SmtUtils.and((Script)this.mManagedScript.getScript(), (Term[])terms.toArray(new Term[terms.size()]));
        return Substitution.apply((ManagedScript)this.mManagedScript, tau2Kappa, (Term)result);
    }

    public Boolean containsUndefined() {
        for (UpdateType ut : this.mUpdateTypeMap.values()) {
            if (ut != UpdateType.UNDEFINED) continue;
            return true;
        }
        return false;
    }

    public Map<IProgramVar, TermVariable> getInVars() {
        return this.mInVars;
    }

    public Map<IProgramVar, TermVariable> getOutVars() {
        return this.mOutVars;
    }

    public Set<TermVariable> getKappas() {
        return new HashSet<TermVariable>(this.mKappas);
    }

    public Set<TermVariable> getTaus() {
        return new HashSet<TermVariable>(this.mKappa2Tau.values());
    }

    public Term getKappaMin() {
        Term kappasAdd = this.mKappas.size() > 1 ? this.mManagedScript.getScript().term("+", this.mKappas.toArray(new Term[this.mKappas.size()])) : (Term)this.mKappas.get(0);
        return this.mManagedScript.getScript().term("<=", new Term[]{Rational.ZERO.toTerm(this.mManagedScript.getScript().sort("Int", new Sort[0])), kappasAdd});
    }

    private void updateInOutVars(IProgramVar outVar, IIcfgSymbolTable symbolTable, TermVariable[] inVars) {
        TermVariable[] termVariableArray = inVars;
        int n = inVars.length;
        int n2 = 0;
        while (n2 < n) {
            TermVariable iv = termVariableArray[n2];
            if (!this.mReplaceInV.containsKey(iv)) {
                TermVariable cp = this.mManagedScript.constructFreshCopy(iv);
                this.mReplaceInV.put((Term)iv, (Term)cp);
                this.mInVars.put(symbolTable.getProgramVar(iv), cp);
            }
            ++n2;
        }
        if (!this.mOutVars.containsKey(outVar)) {
            this.mOutVars.put(outVar, this.mManagedScript.constructFreshCopy(outVar.getTermVariable()));
            this.mAssigningPaths.put(outVar.getTermVariable(), new HashSet());
        }
        this.mAssigningPaths.get(outVar.getTermVariable()).add(this.mCurrentPath);
    }

    private void generateTerms() {
        for (Map.Entry<IProgramVar, List<Term>> symEntry : this.mSymbolicMemory.entrySet()) {
            IProgramVar pv = symEntry.getKey();
            switch (this.mUpdateTypeMap.get(pv)) {
                case INCREMENTATION: {
                    List<Term> params = symEntry.getValue();
                    params.add(this.mReplaceInV.get(pv.getTermVariable()));
                    this.mIteratedSymbolicMemory.put(pv, this.mManagedScript.getScript().term("+", params.toArray(new Term[params.size()])));
                    break;
                }
                case CONSTANT: {
                    this.mIteratedSymbolicMemory.put(pv, this.generateConstantAssignment(UpdateType.CONSTANT, pv, symEntry.getValue()));
                    break;
                }
                case CONSTANT_WITH_SINGLE_PATHCOUNTER: {
                    Term assignedTerm = symEntry.getValue().iterator().next();
                    int p = this.mAssigningPaths.get(symEntry.getKey().getTermVariable()).iterator().next();
                    boolean cwsp = assignedTerm.getFreeVars().length > 0;
                    boolean pathAssignsOtherVar = false;
                    TermVariable[] termVariableArray = assignedTerm.getFreeVars();
                    int n = termVariableArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TermVariable tv = termVariableArray[n2];
                        if (this.mAssigningPaths.containsKey(tv)) {
                            if (this.mAssigningPaths.get(tv).size() > 1 || !this.mAssigningPaths.get(tv).contains(p)) {
                                cwsp = false;
                            }
                            pathAssignsOtherVar = true;
                        }
                        ++n2;
                    }
                    if (cwsp && pathAssignsOtherVar) {
                        this.mIteratedSymbolicMemory.put(pv, this.generateConstantAssignment(UpdateType.CONSTANT_WITH_SINGLE_PATHCOUNTER, pv, symEntry.getValue()));
                        break;
                    }
                    this.mUpdateTypeMap.put(pv, UpdateType.CONSTANT);
                    this.mIteratedSymbolicMemory.put(pv, this.generateConstantAssignment(UpdateType.CONSTANT, pv, symEntry.getValue()));
                    break;
                }
            }
        }
    }

    private Term generateConstantAssignment(UpdateType type, IProgramVar pv, List<Term> symEntry) {
        Term result;
        if (!this.mInVars.containsKey(pv)) {
            TermVariable cp = this.mManagedScript.constructFreshCopy(pv.getTermVariable());
            this.mInVars.put(pv, cp);
            this.mReplaceInV.put((Term)pv.getTermVariable(), (Term)cp);
        }
        if (type == UpdateType.CONSTANT) {
            ArrayList<TermVariable> assignTaus = new ArrayList<TermVariable>();
            int i = 0;
            while (i < this.mKappas.size()) {
                if (this.mAssignedVars.get(i).contains(pv)) {
                    assignTaus.add(this.mKappa2Tau.get(this.mKappas.get(i)));
                }
                ++i;
            }
            Term tauAdd = assignTaus.size() > 1 ? this.mManagedScript.getScript().term("+", assignTaus.toArray(new Term[assignTaus.size()])) : (Term)assignTaus.iterator().next();
            Term cond = this.mManagedScript.getScript().term("<", new Term[]{Rational.ZERO.toTerm(this.mManagedScript.getScript().sort("Int", new Sort[0])), tauAdd});
            result = Util.ite((Script)this.mManagedScript.getScript(), (Term)cond, (Term)symEntry.get(0), (Term)((Term)this.mInVars.get(pv)));
        } else if (type == UpdateType.CONSTANT_WITH_SINGLE_PATHCOUNTER) {
            int path = -1;
            int i = 0;
            while (i <= this.mCurrentPath) {
                if (this.mAssignedVars.get(i).contains(pv)) {
                    path = i;
                }
                ++i;
            }
            Term cond = this.mManagedScript.getScript().term(">", new Term[]{(Term)this.mKappa2Tau.get(this.mKappas.get(path)), Rational.ZERO.toTerm(this.mManagedScript.getScript().sort("Int", new Sort[0]))});
            result = Util.ite((Script)this.mManagedScript.getScript(), (Term)cond, (Term)this.mSymbolicMemory.get(pv).get(0), (Term)((Term)this.mInVars.get(pv)));
        } else {
            result = null;
        }
        return result;
    }

    private Term insertPathCounter(ApplicationTerm t, TermVariable pathCounter, TermVariable assignedVar) {
        ArrayList<Object> incValue = new ArrayList<Object>();
        incValue.add(pathCounter);
        Term[] termArray = t.getParameters();
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            Term parameter = termArray[n2];
            if (!parameter.equals(this.mReplaceInV.get(assignedVar))) {
                incValue.add(parameter);
            }
            ++n2;
        }
        return this.mManagedScript.getScript().term("*", incValue.toArray(new Term[incValue.size()]));
    }

    private static enum UpdateType {
        UNDEFINED,
        INCREMENTATION,
        CONSTANT,
        CONSTANT_WITH_SINGLE_PATHCOUNTER;

    }
}

