/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr.IVasr;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.HashSet;
import java.util.Set;

public class Qvasr
implements IVasr<Rational> {
    private final Set<Pair<Rational[], Rational[]>> mTransformer;
    private Integer mDimension;

    public Qvasr(Rational[] resetVector, Rational[] additionVector) {
        Pair initialTransformer = new Pair((Object)resetVector, (Object)additionVector);
        HashSet<Pair<Rational[], Rational[]>> initialTransformerSet = new HashSet<Pair<Rational[], Rational[]>>();
        initialTransformerSet.add(initialTransformer);
        this.mDimension = resetVector.length;
        this.mTransformer = initialTransformerSet;
    }

    public Qvasr() {
        this.mDimension = 0;
        this.mTransformer = new HashSet<Pair<Rational[], Rational[]>>();
    }

    @Override
    public int getDimension() {
        return this.mDimension;
    }

    @Override
    public Set<Pair<Rational[], Rational[]>> getTransformer() {
        return this.mTransformer;
    }

    @Override
    public void addTransformer(Pair<Rational[], Rational[]> transformer) {
        this.mDimension = ((Rational[])transformer.getFirst()).length;
        this.mTransformer.add(transformer);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Pair<Rational[], Rational[]> transformer : this.mTransformer) {
            sb.append("  R  A  \n");
            int i = 0;
            while (i < ((Rational[])transformer.getFirst()).length) {
                sb.append("[ " + ((Rational[])transformer.getFirst())[i].toString() + "  " + ((Rational[])transformer.getSecond())[i].toString() + " ]");
                sb.append("\n");
                ++i;
            }
        }
        return sb.toString();
    }
}

