/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr.Qvasr;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr.QvasrAbstraction;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import java.util.Arrays;

public final class QvasrAbstractionBuilder {
    private QvasrAbstractionBuilder() {
    }

    public static QvasrAbstraction constructQvasrAbstraction(Rational[][] simulationMatrix, Qvasr qvasr) {
        return new QvasrAbstraction(simulationMatrix, qvasr);
    }

    public static QvasrAbstraction constructQvasrAbstraction(Rational[][] resetsBasis, Rational[][] additionsBasis) {
        int resetBasisSize = resetsBasis.length;
        int additionBasisSize = additionsBasis.length;
        int d = resetBasisSize + additionBasisSize;
        int n = resetBasisSize > additionBasisSize ? resetsBasis[0].length - 1 : additionsBasis[0].length - 1;
        Rational[][] simulationMatrix = new Rational[d][n];
        Rational[] abstractionResetVector = new Rational[d];
        Rational[] abstractionAdditionVector = new Rational[d];
        int i = 0;
        while (i < resetBasisSize) {
            Rational[] resetBasisVector = resetsBasis[i];
            simulationMatrix[i] = Arrays.copyOf(resetBasisVector, n);
            abstractionResetVector[i] = Rational.ZERO;
            abstractionAdditionVector[i] = resetBasisVector[resetBasisVector.length - 1];
            ++i;
        }
        i = 0;
        while (i < additionBasisSize) {
            Rational[] additionsBasisVector = additionsBasis[i];
            simulationMatrix[i + resetBasisSize] = Arrays.copyOf(additionsBasisVector, n);
            abstractionResetVector[i + resetBasisSize] = Rational.ONE;
            abstractionAdditionVector[i + resetBasisSize] = additionsBasisVector[additionsBasisVector.length - 1];
            ++i;
        }
        Qvasr qvasr = new Qvasr(abstractionResetVector, abstractionAdditionVector);
        return new QvasrAbstraction(simulationMatrix, qvasr);
    }
}

