/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr.IVasr;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr.Qvasr;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr.QvasrAbstraction;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr.QvasrAbstractor;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr.QvasrUtils;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr.QvasrVectorSpaceBasisConstructor;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public final class QvasrAbstractionJoin {
    private QvasrAbstractionJoin() {
    }

    public static Triple<Rational[][], Rational[][], QvasrAbstraction> join(ManagedScript script, QvasrAbstraction abstractionOne, QvasrAbstraction abstractionTwo) {
        Integer concreteDimensionTwo;
        if (abstractionOne.getVasr().getTransformer().isEmpty()) {
            return new Triple((Object)abstractionTwo.getSimulationMatrix(), (Object)abstractionTwo.getSimulationMatrix(), (Object)abstractionTwo);
        }
        Integer concreteDimensionOne = abstractionOne.getConcreteDimension();
        if (!concreteDimensionOne.equals(concreteDimensionTwo = Integer.valueOf(abstractionTwo.getConcreteDimension()))) {
            throw new UnsupportedOperationException();
        }
        Rational[][] simulationMatrixJoined = new Rational[0][0];
        Rational[][] tOne = new Rational[0][0];
        Rational[][] tTwo = new Rational[0][0];
        Set<Set<Integer>> abstractionOneCoherenceClasses = QvasrAbstractionJoin.getCoherenceClasses(abstractionOne);
        Set<Set<Integer>> abstractionTwoCoherenceClasses = QvasrAbstractionJoin.getCoherenceClasses(abstractionTwo);
        Integer qvasrDimensionOne = abstractionOne.getVasr().getDimension();
        Integer qvasrDimensionTwo = abstractionTwo.getVasr().getDimension();
        for (Set<Integer> coherenceClassOne : abstractionOneCoherenceClasses) {
            Rational[][] piOne = QvasrUtils.getCoherenceIdentityMatrix(coherenceClassOne, qvasrDimensionOne);
            Rational[][] piOneSOne = QvasrUtils.rationalMatrixMultiplication(piOne, abstractionOne.getSimulationMatrix());
            for (Set<Integer> coherenceClassTwo : abstractionTwoCoherenceClasses) {
                Rational[][] piTwo = QvasrUtils.getCoherenceIdentityMatrix(coherenceClassTwo, qvasrDimensionTwo);
                Rational[][] piTwoSTwo = QvasrUtils.rationalMatrixMultiplication(piTwo, abstractionTwo.getSimulationMatrix());
                Pair<Rational[][], Rational[][]> pushedOut = QvasrAbstractionJoin.pushout(script, piOneSOne, piTwoSTwo);
                Rational[][] toBeAppendedToS = QvasrUtils.rationalMatrixMultiplication((Rational[][])pushedOut.getFirst(), piOneSOne);
                Rational[][] toBeAppendedToTOne = QvasrUtils.rationalMatrixMultiplication((Rational[][])pushedOut.getFirst(), piOne);
                Rational[][] toBeAppendedToTTwo = QvasrUtils.rationalMatrixMultiplication((Rational[][])pushedOut.getSecond(), piTwo);
                simulationMatrixJoined = QvasrAbstractionJoin.joinRationalMatricesHorizontally(simulationMatrixJoined, toBeAppendedToS);
                tOne = QvasrAbstractionJoin.joinRationalMatricesHorizontally(tOne, toBeAppendedToTOne);
                tTwo = QvasrAbstractionJoin.joinRationalMatricesHorizontally(tTwo, toBeAppendedToTTwo);
            }
        }
        Qvasr imageOne = QvasrAbstractionJoin.image(abstractionOne.getVasr(), tOne);
        Qvasr imageTwo = QvasrAbstractionJoin.image(abstractionTwo.getVasr(), tTwo);
        Qvasr joinedImages = QvasrAbstractionJoin.joinQvasr(imageOne, imageTwo);
        return new Triple((Object)tOne, (Object)tTwo, (Object)new QvasrAbstraction(simulationMatrixJoined, joinedImages));
    }

    private static Pair<Rational[][], Rational[][]> pushout(ManagedScript script, Rational[][] abstractionOne, Rational[][] abstractionTwo) {
        TermVariable newVar;
        HashMap<Integer, TermVariable> columnToVar = new HashMap<Integer, TermVariable>();
        HashMap<TermVariable, Integer> varToColumnOne = new HashMap<TermVariable, Integer>();
        HashMap<TermVariable, Integer> varToColumnTwo = new HashMap<TermVariable, Integer>();
        Term[] newVarsOne = new Term[abstractionOne.length];
        Term[] newVarsTwo = new Term[abstractionTwo.length];
        Integer colCnt = 0;
        int i = 0;
        while (i < abstractionOne.length) {
            newVar = script.constructFreshTermVariable("t", SmtSortUtils.getRealSort((Script)script.getScript()));
            newVarsOne[i] = newVar;
            columnToVar.put(colCnt, newVar);
            varToColumnOne.put(newVar, i);
            colCnt = colCnt + 1;
            ++i;
        }
        i = 0;
        while (i < abstractionTwo.length) {
            newVar = script.constructFreshTermVariable("t", SmtSortUtils.getRealSort((Script)script.getScript()));
            newVarsTwo[i] = newVar;
            columnToVar.put(colCnt, newVar);
            varToColumnTwo.put(newVar, i);
            colCnt = colCnt + 1;
            ++i;
        }
        Term[][] lhs = QvasrUtils.vectorMatrixMultiplicationWithVariables(script, newVarsOne, abstractionOne);
        Term[][] rhs = QvasrUtils.vectorMatrixMultiplicationWithVariables(script, newVarsTwo, abstractionTwo);
        lhs = QvasrAbstractionJoin.termMatrixRemoveVariables(script, lhs, varToColumnOne);
        rhs = QvasrAbstractionJoin.termMatrixRemoveVariables(script, rhs, varToColumnTwo);
        Term[][] joinedMatrix = QvasrAbstractionJoin.joinTermMatricesVertically(lhs, QvasrAbstractionJoin.changeTermMatrixEntrySign(script, rhs = QvasrAbstractionJoin.addColumnTerm(rhs, script.getScript().decimal("0"))));
        if (joinedMatrix.length > 1) {
            joinedMatrix = QvasrAbstractor.gaussianSolve(script, joinedMatrix);
        }
        Rational[][] vectorBasis = QvasrVectorSpaceBasisConstructor.computeVectorSpaceBasis(script, joinedMatrix);
        if ((vectorBasis = QvasrAbstractionJoin.removeLastColumnRational(vectorBasis)).length == 0 || vectorBasis[0].length == 0) {
            throw new UnsupportedOperationException("Matrices are not coherent!");
        }
        Pair<Rational[][], Rational[][]> splitVectorBase = QvasrAbstractionJoin.splitRationalMatricesVertically(vectorBasis, lhs[0].length);
        Rational[][] lhsRational = (Rational[][])splitVectorBase.getFirst();
        Rational[][] rhsRational = (Rational[][])splitVectorBase.getSecond();
        return new Pair((Object)lhsRational, (Object)rhsRational);
    }

    public static Qvasr image(IVasr<Rational> v, Rational[][] t) {
        Qvasr abstractionImage = new Qvasr();
        for (Pair<Rational[], Rational[]> resetAdditionPair : v.getTransformer()) {
            Rational[][] resetVectorTransposed = QvasrUtils.transposeRowToColumnVector((Rational[])resetAdditionPair.getFirst());
            Rational[][] additionVectorTransposed = QvasrUtils.transposeRowToColumnVector((Rational[])resetAdditionPair.getSecond());
            Rational[][] resetVectorTranslated = QvasrAbstractionJoin.translateVectorAlongMatrix(t, resetVectorTransposed);
            Rational[][] additionVectorTranslated = QvasrUtils.rationalMatrixVectorMultiplication(t, additionVectorTransposed);
            Rational[] backTransposedResetTranslated = QvasrUtils.transposeColumnToRowVector(resetVectorTranslated);
            Rational[] backTransposedAdditionTranslated = QvasrUtils.transposeColumnToRowVector(additionVectorTranslated);
            abstractionImage.addTransformer((Pair<Rational[], Rational[]>)new Pair((Object)backTransposedResetTranslated, (Object)backTransposedAdditionTranslated));
        }
        return abstractionImage;
    }

    private static Rational[][] translateVectorAlongMatrix(Rational[][] t, Rational[][] v) {
        Rational[][] translatedVector = new Rational[t.length][1];
        int i = 0;
        while (i < t.length) {
            int j = 0;
            while (j < t[0].length) {
                if (t[i][j] != Rational.ZERO) {
                    translatedVector[i][0] = v[j][0];
                    break;
                }
                ++j;
            }
            ++i;
        }
        return translatedVector;
    }

    public static Rational[][] changeRationalMatrixEntrySign(Rational[][] matrix) {
        Rational[][] changedSignMatrix = new Rational[matrix.length][matrix[0].length];
        int i = 0;
        while (i < matrix.length) {
            int j = 0;
            while (j < matrix[0].length) {
                changedSignMatrix[i][j] = matrix[i][j].negate();
                ++j;
            }
            ++i;
        }
        return changedSignMatrix;
    }

    public static Term[][] changeTermMatrixEntrySign(ManagedScript script, Term[][] matrix) {
        Term[][] changedSignMatrix = new Term[matrix.length][matrix[0].length];
        int i = 0;
        while (i < matrix.length) {
            int j = 0;
            while (j < matrix[0].length) {
                changedSignMatrix[i][j] = SmtUtils.neg((Script)script.getScript(), (Term)matrix[i][j]);
                ++j;
            }
            ++i;
        }
        return changedSignMatrix;
    }

    public static Qvasr joinQvasr(Qvasr qvasrOne, Qvasr qvasrTwo) {
        if (qvasrOne.getDimension() != qvasrTwo.getDimension()) {
            throw new UnsupportedOperationException("QVasr must have same dimension!");
        }
        for (Pair<Rational[], Rational[]> transformer : qvasrTwo.getTransformer()) {
            qvasrOne.addTransformer(transformer);
        }
        return qvasrOne;
    }

    public static Term[][] joinTermMatricesVertically(Term[][] leftSide, Term[][] rightSide) {
        if (leftSide.length != rightSide.length) {
            return new Term[0][0];
        }
        Term[][] joinedMatrix = new Term[leftSide.length][leftSide[0].length + rightSide[0].length];
        int i = 0;
        while (i < leftSide.length) {
            int cnt = 0;
            int j = 0;
            while (j < leftSide[0].length) {
                joinedMatrix[i][cnt] = leftSide[i][j];
                ++cnt;
                ++j;
            }
            int k = 0;
            while (k < rightSide[0].length) {
                joinedMatrix[i][cnt] = rightSide[i][k];
                ++cnt;
                ++k;
            }
            ++i;
        }
        return joinedMatrix;
    }

    public static Rational[][] joinRationalMatricesHorizontally(Rational[][] upperMatrix, Rational[][] lowerMatrix) {
        if (upperMatrix.length == 0 || upperMatrix[0].length == 0) {
            return lowerMatrix;
        }
        if (lowerMatrix.length == 0 || lowerMatrix[0].length == 0) {
            return upperMatrix;
        }
        int joinedMatrixLength = upperMatrix.length + lowerMatrix.length;
        Rational[][] horizontallyJoinedMatrix = new Rational[joinedMatrixLength][upperMatrix[0].length];
        int i = 0;
        while (i < upperMatrix.length) {
            horizontallyJoinedMatrix[i] = Arrays.copyOf(upperMatrix[i], upperMatrix[0].length);
            ++i;
        }
        while (i < joinedMatrixLength) {
            horizontallyJoinedMatrix[i] = Arrays.copyOf(lowerMatrix[i - upperMatrix.length], upperMatrix[0].length);
            ++i;
        }
        return horizontallyJoinedMatrix;
    }

    public static Rational[][] joinRationalMatricesVertically(Rational[][] leftSide, Rational[][] rightSide) {
        if (leftSide.length != rightSide.length) {
            return new Rational[0][0];
        }
        Rational[][] joinedMatrix = new Rational[leftSide.length][leftSide[0].length + rightSide[0].length];
        int i = 0;
        while (i < leftSide.length) {
            int cnt = 0;
            int j = 0;
            while (j < leftSide[0].length) {
                joinedMatrix[i][cnt] = leftSide[i][j];
                ++cnt;
                ++j;
            }
            int k = 0;
            while (k < rightSide[0].length) {
                joinedMatrix[i][cnt] = rightSide[i][k];
                ++cnt;
                ++k;
            }
            ++i;
        }
        return joinedMatrix;
    }

    public static Pair<Rational[][], Rational[][]> splitRationalMatricesVertically(Rational[][] matrix, int splitPoint) {
        Rational[][] leftSide = new Rational[matrix.length][splitPoint];
        Rational[][] rightSide = new Rational[matrix.length][splitPoint];
        int i = 0;
        while (i < matrix.length) {
            leftSide[i] = Arrays.copyOfRange(matrix[i], 0, splitPoint);
            rightSide[i] = Arrays.copyOfRange(matrix[i], splitPoint, matrix[0].length);
            ++i;
        }
        return new Pair((Object)leftSide, (Object)rightSide);
    }

    public static Term[][] addColumnTerm(Term[][] matrix, Term newColumnValue) {
        Term[][] result = new Term[matrix.length][matrix[0].length + 1];
        int i = 0;
        while (i < matrix.length) {
            result[i] = Arrays.copyOf(matrix[i], matrix[i].length + 1);
            result[i][matrix[i].length] = newColumnValue;
            ++i;
        }
        return result;
    }

    public static Rational[][] removeLastColumnRational(Rational[][] matrix) {
        Rational[][] result = new Rational[matrix.length][matrix[0].length - 1];
        int i = 0;
        while (i < matrix.length) {
            result[i] = Arrays.copyOf(matrix[i], matrix[i].length - 1);
            ++i;
        }
        return result;
    }

    private static Term[][] termMatrixRemoveVariables(ManagedScript script, Term[][] termMatrix, Map<TermVariable, Integer> varToColumn) {
        Set<TermVariable> tvs = varToColumn.keySet();
        int newMatrixLength = tvs.size();
        Term[][] matrixNoVars = new Term[termMatrix[0].length][newMatrixLength];
        int i = 0;
        while (i < termMatrix[0].length) {
            Term equation = termMatrix[0][i];
            if (QvasrUtils.isApplicationTerm(equation) || equation instanceof TermVariable) {
                for (Term term : tvs) {
                    Term term2;
                    HashSet<TermVariable> zeroTvs = new HashSet<TermVariable>(tvs);
                    zeroTvs.remove(term);
                    HashMap<Term, Term> subMap = new HashMap<Term, Term>();
                    subMap.put(term, script.getScript().decimal("1.0"));
                    for (Term term3 : zeroTvs) {
                        subMap.put(term3, script.getScript().decimal("0"));
                    }
                    matrixNoVars[i][varToColumn.get((Object)term).intValue()] = term2 = Substitution.apply((ManagedScript)script, subMap, (Term)equation);
                }
            } else {
                for (Term term : tvs) {
                    matrixNoVars[i][varToColumn.get((Object)term).intValue()] = script.getScript().decimal("0");
                }
            }
            ++i;
        }
        return matrixNoVars;
    }

    private static Rational[][] termMatrixToRational(ManagedScript script, Term[][] termMatrix, Map<TermVariable, Integer> varToColumn) {
        Set<TermVariable> tvs = varToColumn.keySet();
        int newMatrixLength = tvs.size();
        Rational[][] rationalMatrix = new Rational[termMatrix.length][newMatrixLength];
        int i = 0;
        while (i < termMatrix.length) {
            int j = 0;
            while (j < termMatrix[0].length) {
                Term equation = termMatrix[i][j];
                if (QvasrUtils.isApplicationTerm(equation)) {
                    for (Term term : tvs) {
                        Rational entryAsRational;
                        HashSet<TermVariable> zeroTvs = new HashSet<TermVariable>(tvs);
                        zeroTvs.remove(term);
                        HashMap<Term, Term> subMap = new HashMap<Term, Term>();
                        subMap.put(term, script.getScript().decimal("1.0"));
                        for (Term term2 : zeroTvs) {
                            subMap.put(term2, script.getScript().decimal("0"));
                        }
                        ConstantTerm constantTerm = (ConstantTerm)Substitution.apply((ManagedScript)script, subMap, (Term)equation);
                        rationalMatrix[i][varToColumn.get((Object)term).intValue()] = entryAsRational = (Rational)constantTerm.getValue();
                    }
                }
                ++j;
            }
            ++i;
        }
        return rationalMatrix;
    }

    public static Set<Set<Integer>> getCoherenceClasses(QvasrAbstraction qvasrAbstraction) {
        HashSet<Set<Integer>> coherenceClasses = new HashSet<Set<Integer>>();
        int dimension = qvasrAbstraction.getVasr().getDimension();
        coherenceClasses.add(IntStream.range(0, dimension).boxed().collect(Collectors.toSet()));
        IVasr<Rational> qvasr = qvasrAbstraction.getVasr();
        for (Pair<Rational[], Rational[]> transformer : qvasr.getTransformer()) {
            for (Set set : coherenceClasses) {
                Integer[] coherenceAsArray = set.toArray(new Integer[set.size()]);
                int i = 1;
                while (i < coherenceAsArray.length) {
                    if (((Rational[])transformer.getFirst())[i] != ((Rational[])transformer.getFirst())[0]) {
                        set.remove(coherenceAsArray[i]);
                        HashSet<Integer> newCoherenceClass = new HashSet<Integer>();
                        newCoherenceClass.add(coherenceAsArray[i]);
                        coherenceClasses.add(newCoherenceClass);
                    }
                    ++i;
                }
            }
        }
        return coherenceClasses;
    }
}

