/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr.QvasrAbstraction;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr.QvasrAbstractionBuilder;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr.QvasrUtils;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr.QvasrVectorSpaceBasisConstructor;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.SimultaneousUpdate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.HashDeque;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class QvasrAbstractor {
    public static QvasrAbstraction computeAbstraction(IUltimateServiceProvider services, ManagedScript script, UnmodifiableTransFormula transitionFormula) {
        if (!SmtUtils.isArrayFree((Term)transitionFormula.getFormula()) || !SmtUtils.containsArrayVariables((Term[])new Term[]{transitionFormula.getFormula()})) {
            throw new UnsupportedOperationException("Cannot deal with arrays.");
        }
        Map<TermVariable, Term> updatesInFormulaAdditions = QvasrAbstractor.getUpdates(services, script, transitionFormula, BaseType.ADDITIONS);
        Map<TermVariable, Term> updatesInFormulaResets = QvasrAbstractor.getUpdates(services, script, transitionFormula, BaseType.RESETS);
        Term[][] newUpdatesMatrixResets = QvasrAbstractor.constructBaseMatrix(script, updatesInFormulaResets, transitionFormula);
        Term[][] newUpdatesMatrixAdditions = QvasrAbstractor.constructBaseMatrix(script, updatesInFormulaAdditions, transitionFormula);
        Term[][] solutionsAdditionsGaussJordan = QvasrAbstractor.gaussianSolve(script, newUpdatesMatrixAdditions);
        Term[][] solutionsResetGaussJordan = QvasrAbstractor.gaussianSolve(script, newUpdatesMatrixResets);
        Rational[][] resetVectorSpaceBasis = QvasrVectorSpaceBasisConstructor.computeVectorSpaceBasis(script, solutionsResetGaussJordan);
        Rational[][] additionVectorSpaceBasis = QvasrVectorSpaceBasisConstructor.computeVectorSpaceBasis(script, solutionsAdditionsGaussJordan);
        return QvasrAbstractionBuilder.constructQvasrAbstraction(resetVectorSpaceBasis, additionVectorSpaceBasis);
    }

    public static Term[][] gaussianSolve(ManagedScript script, Term[][] matrix) {
        Term[][] gaussPartialPivot = QvasrAbstractor.gaussPartialPivot(script, matrix);
        Term[][] gaussedAdditionsPruned = QvasrAbstractor.removeZeroRows(script, gaussPartialPivot);
        gaussedAdditionsPruned = QvasrAbstractor.removeDuplicateRows(script, gaussedAdditionsPruned);
        gaussedAdditionsPruned = QvasrAbstractor.gaussRowEchelonFormJordan(script, gaussedAdditionsPruned);
        gaussedAdditionsPruned = QvasrAbstractor.removeZeroRows(script, gaussedAdditionsPruned);
        return gaussedAdditionsPruned;
    }

    private static Term[][] gaussPartialPivot(ManagedScript script, Term[][] matrix) {
        int k = 0;
        while (k < matrix.length - 1) {
            int max = -1;
            if (k + 1 < matrix.length && k + 1 < matrix[0].length) {
                max = QvasrAbstractor.findPivot(script, matrix, k);
            }
            if (max == -1) {
                return matrix;
            }
            if (max != 0) {
                matrix = QvasrAbstractor.swap(matrix, k, max);
            }
            Term pivot = matrix[k][k];
            int i = k + 1;
            while (i < matrix.length) {
                Term toBeEliminated = matrix[i][k];
                matrix[i][k] = script.getScript().decimal("0");
                Term newDiv = QvasrAbstractor.simplifyRealDivision(script, toBeEliminated, pivot);
                int j = k + 1;
                while (j < matrix[0].length) {
                    Term newSub;
                    Term currentColumn = matrix[k][j];
                    Term currentEntry = matrix[i][j];
                    Term newMul = QvasrAbstractor.simplifyRealMultiplication(script, newDiv, currentColumn);
                    matrix[i][j] = newSub = QvasrAbstractor.simplifyRealSubtraction(script, currentEntry, newMul);
                    ++j;
                }
                ++i;
            }
            ++k;
        }
        return matrix;
    }

    private static Term[][] gaussRowEchelonFormJordan(ManagedScript script, Term[][] matrix) {
        int i = matrix.length - 1;
        while (i >= 0) {
            int j = 0;
            while (j < matrix[0].length) {
                if (!QvasrUtils.checkTermEquiv(script, matrix[i][j], script.getScript().decimal("0"))) {
                    Term dividerInverse = QvasrAbstractor.getDivisionInverse(script, matrix[i][j]);
                    int k = j;
                    while (k < matrix[0].length) {
                        Term mult;
                        Term toBeDivided = matrix[i][k];
                        matrix[i][k] = mult = QvasrAbstractor.simplifyRealMultiplication(script, toBeDivided, dividerInverse);
                        ++k;
                    }
                    int l = i - 1;
                    while (l >= 0) {
                        Term toBeEliminatedMult = matrix[l][j];
                        int m = j;
                        while (m < matrix[0].length) {
                            Term subRow;
                            Term rowEntry = matrix[i][m];
                            Term rowEntryToBeEliminated = matrix[l][m];
                            Term multRow = QvasrAbstractor.simplifyRealMultiplication(script, toBeEliminatedMult, rowEntry);
                            matrix[l][m] = subRow = QvasrAbstractor.simplifyRealSubtraction(script, rowEntryToBeEliminated, multRow);
                            ++m;
                        }
                        --l;
                    }
                    break;
                }
                ++j;
            }
            --i;
        }
        return matrix;
    }

    public static Term getDivisionInverse(ManagedScript script, Term term) {
        Term result;
        if (QvasrUtils.isApplicationTerm(term) && "/".equals(((ApplicationTerm)term).getFunction().getName())) {
            ApplicationTerm appTerm = (ApplicationTerm)term;
            Term dividend = appTerm.getParameters()[0];
            Term divisor = appTerm.getParameters()[1];
            result = SmtUtils.divReal((Script)script.getScript(), (Term[])new Term[]{divisor, dividend});
        } else {
            result = SmtUtils.divReal((Script)script.getScript(), (Term[])new Term[]{script.getScript().decimal("1"), term});
        }
        return result;
    }

    private static Term[][] removeZeroRows(ManagedScript script, Term[][] matrix) {
        HashSet<Integer> toBeEliminated = new HashSet<Integer>();
        int i = 0;
        while (i < matrix.length) {
            int j = 0;
            while (j < matrix[0].length) {
                if (!QvasrUtils.checkTermEquiv(script, matrix[i][j], script.getScript().decimal("0"))) break;
                if (j == matrix[0].length - 1) {
                    toBeEliminated.add(i);
                }
                ++j;
            }
            ++i;
        }
        int prunedLength = matrix.length - toBeEliminated.size();
        if (prunedLength > 0) {
            Term[][] prunedMatrix = new Term[prunedLength][matrix[0].length];
            int cnt = 0;
            int k = 0;
            while (k < matrix.length) {
                if (!toBeEliminated.contains(k)) {
                    int l = 0;
                    while (l < matrix[0].length) {
                        prunedMatrix[cnt][l] = matrix[k][l];
                        ++l;
                    }
                    ++cnt;
                }
                ++k;
            }
            return prunedMatrix;
        }
        return matrix;
    }

    private static Term[][] removeDuplicateRows(ManagedScript script, Term[][] matrix) {
        HashSet<Integer> toBeEliminated = new HashSet<Integer>();
        int i = 0;
        while (i < matrix.length) {
            HashSet<Integer> possibleDuplicates = new HashSet<Integer>();
            int j = i + 1;
            while (j < matrix.length) {
                if (QvasrUtils.checkTermEquiv(script, matrix[i][0], matrix[j][0])) {
                    possibleDuplicates.add(j);
                }
                HashSet trueDuplicates = new HashSet(possibleDuplicates);
                for (Integer k : possibleDuplicates) {
                    int l = 0;
                    while (l < matrix[0].length) {
                        if (!QvasrUtils.checkTermEquiv(script, matrix[k][l], matrix[i][l])) {
                            trueDuplicates.remove(k);
                        }
                        ++l;
                    }
                }
                for (Integer m : trueDuplicates) {
                    toBeEliminated.add(m);
                }
                ++j;
            }
            ++i;
        }
        int prunedLength = matrix.length - toBeEliminated.size();
        if (prunedLength > 0) {
            Term[][] prunedMatrix = new Term[prunedLength][matrix[0].length];
            int cnt = 0;
            int k = 0;
            while (k < matrix.length) {
                if (!toBeEliminated.contains(k)) {
                    int l = 0;
                    while (l < matrix[0].length) {
                        prunedMatrix[cnt][l] = matrix[k][l];
                        ++l;
                    }
                    ++cnt;
                }
                ++k;
            }
            return prunedMatrix;
        }
        return matrix;
    }

    private static Term factorOutRealSum(ManagedScript script, Term sum) {
        if (QvasrUtils.isApplicationTerm(sum)) {
            ApplicationTerm sumAppTerm = (ApplicationTerm)sum;
            List<Term> summands = QvasrAbstractor.getApplicationTermSumParams(sumAppTerm);
            ArrayList<Term> simplifiedSummands = new ArrayList<Term>();
            for (Term summandOne : summands) {
                if (!QvasrUtils.isApplicationTerm(summandOne) || !"+".equals(((ApplicationTerm)summandOne).getFunction().getName())) continue;
                List<Term> factors = QvasrAbstractor.getApplicationTermMultiplicationParams(script, summandOne);
                Term occurencesMult = script.getScript().decimal(String.valueOf(Integer.toString(Collections.frequency(factors, summandOne))) + 1);
                int occurences = 1;
                Term factorToBeFactored = summandOne;
                Term factorNotToBeFactored = summandOne;
                Iterator<Term> iterator = factors.iterator();
                while (iterator.hasNext()) {
                    Term factor;
                    factorToBeFactored = factor = iterator.next();
                    if (occurences > 1) continue;
                    occurences = Collections.frequency(summands, factor) + 1;
                    factorNotToBeFactored = factor;
                }
                Term summandOneSimplified = SmtUtils.mul((Script)script.getScript(), (String)"*", (Term[])new Term[]{occurencesMult, factorNotToBeFactored, SmtUtils.sum((Script)script.getScript(), (String)"+", (Term[])new Term[]{script.getScript().decimal(Integer.toString(occurences)), factorToBeFactored})});
                simplifiedSummands.add(summandOneSimplified);
            }
            return SmtUtils.sum((Script)script.getScript(), (String)"+", (Term[])simplifiedSummands.toArray(new Term[simplifiedSummands.size()]));
        }
        return sum;
    }

    /*
     * WARNING - void declaration
     */
    public static Term expandRealMultiplication(ManagedScript script, Term factorOne, Term factorTwo) {
        ApplicationTerm factorOneAppTerm;
        ArrayList<Object> factorOneVars = new ArrayList<Object>();
        ArrayList<Object> factorTwoVars = new ArrayList<Object>();
        if (QvasrUtils.isApplicationTerm(factorOne) && QvasrUtils.isApplicationTerm(factorTwo)) {
            int n;
            Term[] termArray;
            factorOneAppTerm = (ApplicationTerm)factorOne;
            ApplicationTerm applicationTerm = (ApplicationTerm)factorTwo;
            if ("+".equals(factorOneAppTerm.getFunction().getName())) {
                void var8_19;
                termArray = factorOneAppTerm.getParameters();
                n = termArray.length;
                boolean bl = false;
                while (var8_19 < n) {
                    Term param2 = termArray[var8_19];
                    if (QvasrUtils.isApplicationTerm(param2)) {
                        factorOneVars.addAll(QvasrAbstractor.getApplicationTermSumParams((ApplicationTerm)param2));
                    } else {
                        factorOneVars.add(param2);
                    }
                    ++var8_19;
                }
            } else {
                factorOneVars.add(factorOneAppTerm);
            }
            if ("+".equals(applicationTerm.getFunction().getName())) {
                void var8_21;
                termArray = applicationTerm.getParameters();
                n = termArray.length;
                boolean bl = false;
                while (var8_21 < n) {
                    Term param = termArray[var8_21];
                    if (QvasrUtils.isApplicationTerm(param)) {
                        factorTwoVars.addAll(QvasrAbstractor.getApplicationTermSumParams((ApplicationTerm)param));
                    } else {
                        factorTwoVars.add(param);
                    }
                    ++var8_21;
                }
            } else {
                factorTwoVars.add(applicationTerm);
            }
        }
        if (!QvasrUtils.isApplicationTerm(factorOne) && QvasrUtils.isApplicationTerm(factorTwo)) {
            ApplicationTerm factorTwoAppTerm = (ApplicationTerm)factorTwo;
            factorOneVars.add(factorOne);
            if ("+".equals(factorTwoAppTerm.getFunction().getName())) {
                Term[] termArray = factorTwoAppTerm.getParameters();
                int n = termArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Term term = termArray[n2];
                    if (QvasrUtils.isApplicationTerm(term)) {
                        factorTwoVars.addAll(QvasrAbstractor.getApplicationTermSumParams((ApplicationTerm)term));
                    } else {
                        factorTwoVars.add(term);
                    }
                    ++n2;
                }
            } else {
                factorTwoVars.add(factorTwoAppTerm);
            }
        }
        if (QvasrUtils.isApplicationTerm(factorOne) && !QvasrUtils.isApplicationTerm(factorTwo)) {
            factorOneAppTerm = (ApplicationTerm)factorOne;
            factorTwoVars.add(factorTwo);
            if ("+".equals(factorOneAppTerm.getFunction().getName())) {
                Term[] termArray = factorOneAppTerm.getParameters();
                int n = termArray.length;
                int n3 = 0;
                while (n3 < n) {
                    Term term = termArray[n3];
                    if (QvasrUtils.isApplicationTerm(term)) {
                        factorOneVars.addAll(QvasrAbstractor.getApplicationTermSumParams((ApplicationTerm)term));
                    } else {
                        factorOneVars.add(term);
                    }
                    ++n3;
                }
            } else {
                factorOneVars.add(factorOneAppTerm);
            }
        }
        if (!QvasrUtils.isApplicationTerm(factorOne) && !QvasrUtils.isApplicationTerm(factorTwo)) {
            factorOneVars.add(factorOne);
            factorTwoVars.add(factorTwo);
        }
        Term result = script.getScript().decimal("0");
        for (Term term : factorOneVars) {
            for (Term term2 : factorTwoVars) {
                Term mult = SmtUtils.mul((Script)script.getScript(), (String)"*", (Term[])new Term[]{term, term2});
                result = SmtUtils.sum((Script)script.getScript(), (String)"+", (Term[])new Term[]{result, mult});
            }
        }
        return result;
    }

    public static Term expandRealMultiplication(ManagedScript script, List<Term> factors) {
        if (factors.size() < 2) {
            return factors.get(0);
        }
        Term result = script.getScript().decimal("0");
        ArrayDeque<Term> factorStack = new ArrayDeque<Term>(factors);
        while (!factorStack.isEmpty()) {
            Term factorOne = (Term)factorStack.pop();
            for (Term factorTwo : factorStack) {
                Term mult;
                int n;
                if (QvasrUtils.isApplicationTerm(factorOne)) {
                    ApplicationTerm factorOneAppTerm = (ApplicationTerm)factorOne;
                    if (QvasrUtils.isApplicationTerm(factorTwo)) {
                        ApplicationTerm factorTwoAppTerm = (ApplicationTerm)factorTwo;
                        Term[] termArray = factorOneAppTerm.getParameters();
                        int n2 = termArray.length;
                        n = 0;
                        while (n < n2) {
                            Term paramFactorOne = termArray[n];
                            Term[] termArray2 = factorTwoAppTerm.getParameters();
                            int n3 = termArray2.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                Term paramFactorTwo = termArray2[n4];
                                Term mult2 = SmtUtils.mul((Script)script.getScript(), (String)"*", (Term[])new Term[]{paramFactorOne, paramFactorTwo});
                                result = SmtUtils.sum((Script)script.getScript(), (String)"+", (Term[])new Term[]{result, mult2});
                                ++n4;
                            }
                            ++n;
                        }
                        continue;
                    }
                    Term[] termArray = factorOneAppTerm.getParameters();
                    n = termArray.length;
                    int n5 = 0;
                    while (n5 < n) {
                        Term paramFactorOne = termArray[n5];
                        mult = SmtUtils.mul((Script)script.getScript(), (String)"*", (Term[])new Term[]{paramFactorOne, factorTwo});
                        result = SmtUtils.sum((Script)script.getScript(), (String)"+", (Term[])new Term[]{result, mult});
                        ++n5;
                    }
                    continue;
                }
                if (QvasrUtils.isApplicationTerm(factorTwo)) {
                    ApplicationTerm factorTwoAppTerm = (ApplicationTerm)factorTwo;
                    Term[] termArray = factorTwoAppTerm.getParameters();
                    n = termArray.length;
                    int n6 = 0;
                    while (n6 < n) {
                        Term paramFactorTwo = termArray[n6];
                        mult = SmtUtils.mul((Script)script.getScript(), (String)"*", (Term[])new Term[]{paramFactorTwo, factorOne});
                        result = SmtUtils.sum((Script)script.getScript(), (String)"+", (Term[])new Term[]{result, mult});
                        ++n6;
                    }
                    continue;
                }
                Term mult3 = SmtUtils.mul((Script)script.getScript(), (String)"*", (Term[])new Term[]{factorOne, factorTwo});
                result = SmtUtils.sum((Script)script.getScript(), (String)"+", (Term[])new Term[]{result, mult3});
            }
        }
        return result;
    }

    public static Term simplifyRealDivision(ManagedScript script, Term dividend, Term divisor) {
        Pair<Term, Term> resultReduced;
        Term dividendDividend;
        Term dividendDivisor;
        ApplicationTerm dividendAppTerm;
        Term zero = script.getScript().decimal("0");
        if (QvasrUtils.checkTermEquiv(script, divisor, zero)) {
            throw new UnsupportedOperationException("cannot divide by 0!");
        }
        if (QvasrUtils.checkTermEquiv(script, divisor, script.getScript().decimal("1"))) {
            return dividend;
        }
        if (QvasrUtils.checkTermEquiv(script, dividend, zero)) {
            return zero;
        }
        Term one = script.getScript().decimal("1");
        if (QvasrUtils.checkTermEquiv(script, dividend, divisor)) {
            return one;
        }
        Term result = SmtUtils.divReal((Script)script.getScript(), (Term[])new Term[]{dividend, divisor});
        if (QvasrUtils.isApplicationTerm(dividend) && QvasrUtils.isApplicationTerm(divisor)) {
            ApplicationTerm divisorDividend;
            dividendAppTerm = (ApplicationTerm)dividend;
            ApplicationTerm divisorAppTerm = (ApplicationTerm)divisor;
            dividendDivisor = one;
            Term divisorDivisor = one;
            if ("/".equals(dividendAppTerm.getFunction().getName())) {
                dividendDividend = dividendAppTerm.getParameters()[0];
                dividendDivisor = dividendAppTerm.getParameters()[1];
            } else {
                dividendDividend = dividendAppTerm;
            }
            if ("/".equals(divisorAppTerm.getFunction().getName())) {
                divisorDividend = divisorAppTerm.getParameters()[0];
                divisorDivisor = divisorAppTerm.getParameters()[1];
            } else {
                divisorDividend = divisorAppTerm;
            }
            if ("/".equals(divisorAppTerm.getFunction().getName()) || "/".equals(dividendAppTerm.getFunction().getName())) {
                Term commonDividend = SmtUtils.mul((Script)script.getScript(), (String)"*", (Term[])new Term[]{dividendDividend, divisorDivisor});
                Term commonDivisor = SmtUtils.mul((Script)script.getScript(), (String)"*", (Term[])new Term[]{dividendDivisor, divisorDividend});
                Pair<Term, Term> resultReduced2 = QvasrAbstractor.reduceRealDivision(script, commonDividend, commonDivisor);
                result = SmtUtils.divReal((Script)script.getScript(), (Term[])new Term[]{(Term)resultReduced2.getFirst(), (Term)resultReduced2.getSecond()});
            }
            if (!"/".equals(divisorAppTerm.getFunction().getName()) && !"/".equals(dividendAppTerm.getFunction().getName())) {
                Pair<Term, Term> resultReduced3 = QvasrAbstractor.reduceRealDivision(script, dividend, divisor);
                result = SmtUtils.divReal((Script)script.getScript(), (Term[])new Term[]{(Term)resultReduced3.getFirst(), (Term)resultReduced3.getSecond()});
            }
        }
        if (QvasrUtils.isApplicationTerm(dividend) && !QvasrUtils.isApplicationTerm(divisor)) {
            dividendAppTerm = (ApplicationTerm)dividend;
            if ("/".equals(dividendAppTerm.getFunction().getName())) {
                dividendDividend = dividendAppTerm.getParameters()[0];
                dividendDivisor = dividendAppTerm.getParameters()[1];
                Term commonDivisor = SmtUtils.mul((Script)script.getScript(), (String)"*", (Term[])new Term[]{dividendDivisor, divisor});
                resultReduced = QvasrAbstractor.reduceRealDivision(script, dividendDividend, commonDivisor);
                result = SmtUtils.divReal((Script)script.getScript(), (Term[])new Term[]{(Term)resultReduced.getFirst(), (Term)resultReduced.getSecond()});
            } else {
                resultReduced = QvasrAbstractor.reduceRealDivision(script, dividend, divisor);
                result = SmtUtils.divReal((Script)script.getScript(), (Term[])new Term[]{(Term)resultReduced.getFirst(), (Term)resultReduced.getSecond()});
            }
        }
        if (!QvasrUtils.isApplicationTerm(dividend) && QvasrUtils.isApplicationTerm(divisor)) {
            ApplicationTerm divisorAppTerm = (ApplicationTerm)divisor;
            if ("/".equals(divisorAppTerm.getFunction().getName())) {
                Term divisorDividend = divisorAppTerm.getParameters()[0];
                Term divisorDivisor = divisorAppTerm.getParameters()[1];
                Term commonDividend = SmtUtils.mul((Script)script.getScript(), (String)"*", (Term[])new Term[]{dividend, divisorDivisor});
                resultReduced = QvasrAbstractor.reduceRealDivision(script, commonDividend, divisorDividend);
                result = SmtUtils.divReal((Script)script.getScript(), (Term[])new Term[]{(Term)resultReduced.getFirst(), (Term)resultReduced.getSecond()});
            } else {
                resultReduced = QvasrAbstractor.reduceRealDivision(script, dividend, divisor);
                result = SmtUtils.divReal((Script)script.getScript(), (Term[])new Term[]{(Term)resultReduced.getFirst(), (Term)resultReduced.getSecond()});
            }
        }
        if (!QvasrUtils.isApplicationTerm(dividend) && !QvasrUtils.isApplicationTerm(divisor)) {
            Pair<Term, Term> resultReduced4 = QvasrAbstractor.reduceRealDivision(script, dividend, divisor);
            result = SmtUtils.divReal((Script)script.getScript(), (Term[])new Term[]{(Term)resultReduced4.getFirst(), (Term)resultReduced4.getSecond()});
        }
        return result;
    }

    public static Term simplifyRealMultiplication(ManagedScript script, Term factorOne, Term factorTwo) {
        Term commonDividend;
        ApplicationTerm factorTwoAppTerm;
        ApplicationTerm factorOneAppTerm;
        Term zero = script.getScript().decimal("0");
        if (QvasrUtils.checkTermEquiv(script, factorOne, zero) || QvasrUtils.checkTermEquiv(script, factorTwo, zero)) {
            return zero;
        }
        Term one = script.getScript().decimal("1");
        if (QvasrUtils.checkTermEquiv(script, factorOne, one)) {
            return factorTwo;
        }
        if (QvasrUtils.checkTermEquiv(script, factorTwo, one)) {
            return factorOne;
        }
        Term result = SmtUtils.mul((Script)script.getScript(), (String)"*", (Term[])new Term[]{factorOne, factorTwo});
        if (QvasrUtils.isApplicationTerm(factorOne) && QvasrUtils.isApplicationTerm(factorTwo)) {
            Term commonDividend2;
            factorOneAppTerm = (ApplicationTerm)factorOne;
            ApplicationTerm factorTwoAppTerm2 = (ApplicationTerm)factorTwo;
            if ("/".equals(factorOneAppTerm.getFunction().getName()) && "/".equals(factorTwoAppTerm2.getFunction().getName())) {
                Term commonDivisor = script.getScript().term("*", new Term[]{factorOneAppTerm.getParameters()[1], factorTwoAppTerm2.getParameters()[1]});
                Term commonDividend3 = script.getScript().term("*", new Term[]{factorOneAppTerm.getParameters()[0], factorTwoAppTerm2.getParameters()[0]});
                result = QvasrAbstractor.simplifyRealDivision(script, commonDividend3, commonDivisor);
            }
            if (!"/".equals(factorOneAppTerm.getFunction().getName()) && "/".equals(factorTwoAppTerm2.getFunction().getName())) {
                commonDividend2 = SmtUtils.mul((Script)script.getScript(), (String)"*", (Term[])new Term[]{factorOneAppTerm, factorTwoAppTerm2.getParameters()[0]});
                result = QvasrAbstractor.simplifyRealDivision(script, commonDividend2, factorTwoAppTerm2.getParameters()[1]);
            }
            if ("/".equals(factorOneAppTerm.getFunction().getName()) && !"/".equals(factorTwoAppTerm2.getFunction().getName())) {
                commonDividend2 = SmtUtils.mul((Script)script.getScript(), (String)"*", (Term[])new Term[]{factorOneAppTerm.getParameters()[0], factorTwoAppTerm2});
                result = QvasrAbstractor.simplifyRealDivision(script, commonDividend2, factorOneAppTerm.getParameters()[1]);
            }
        }
        if (!QvasrUtils.isApplicationTerm(factorOne) && QvasrUtils.isApplicationTerm(factorTwo) && "/".equals((factorTwoAppTerm = (ApplicationTerm)factorTwo).getFunction().getName())) {
            commonDividend = SmtUtils.mul((Script)script.getScript(), (String)"*", (Term[])new Term[]{factorOne, factorTwoAppTerm.getParameters()[0]});
            result = QvasrAbstractor.simplifyRealDivision(script, commonDividend, factorTwoAppTerm.getParameters()[1]);
        }
        if (QvasrUtils.isApplicationTerm(factorOne) && !QvasrUtils.isApplicationTerm(factorTwo) && "/".equals((factorOneAppTerm = (ApplicationTerm)factorOne).getFunction().getName())) {
            commonDividend = SmtUtils.mul((Script)script.getScript(), (String)"*", (Term[])new Term[]{factorTwo, factorOneAppTerm.getParameters()[0]});
            result = QvasrAbstractor.simplifyRealDivision(script, commonDividend, factorOneAppTerm.getParameters()[1]);
        }
        return result;
    }

    public static Term simplifyRealSubtraction(ManagedScript script, Term minuend, Term subtrahend) {
        Term simplifiedMinuend;
        Term commonDenominatorSubtrahend;
        List<Term> paramsDividentSubtrahend;
        Term commonDenominatorMinuend;
        ApplicationTerm appTermMinuend;
        ApplicationTerm appTermSubrahend;
        Term result = SmtUtils.minus((Script)script.getScript(), (Term[])new Term[]{minuend, subtrahend});
        if (QvasrUtils.isApplicationTerm(subtrahend) && QvasrUtils.isApplicationTerm(minuend)) {
            appTermSubrahend = (ApplicationTerm)subtrahend;
            ApplicationTerm appTermMinuend2 = (ApplicationTerm)minuend;
            if ("/".equals(appTermSubrahend.getFunction().getName())) {
                Term dividentSubtrahend = appTermSubrahend.getParameters()[0];
                Term divisorSubtrahend = appTermSubrahend.getParameters()[1];
                if (!"/".equals(appTermMinuend2.getFunction().getName())) {
                    List<Term> paramsMinuend = QvasrAbstractor.getApplicationTermMultiplicationParams(script, (Term)appTermMinuend2);
                    paramsMinuend.addAll(QvasrAbstractor.getApplicationTermMultiplicationParams(script, divisorSubtrahend));
                    List<Term> paramsDividentSubtrahend2 = QvasrAbstractor.getApplicationTermMultiplicationParams(script, dividentSubtrahend);
                    Term divSubMul = QvasrAbstractor.expandRealMultiplication(script, paramsMinuend);
                    Term minSubMul = QvasrAbstractor.expandRealMultiplication(script, paramsDividentSubtrahend2);
                    Term simplifiedMinuend2 = SmtUtils.minus((Script)script.getScript(), (Term[])new Term[]{divSubMul, minSubMul});
                    result = QvasrAbstractor.simplifyRealDivision(script, simplifiedMinuend2, divisorSubtrahend);
                    result.toStringDirect();
                } else {
                    Term dividentMinuend = appTermMinuend2.getParameters()[0];
                    Term divisorMinuend = appTermMinuend2.getParameters()[1];
                    if (QvasrUtils.checkTermEquiv(script, divisorSubtrahend, divisorMinuend)) {
                        Term subMinuendSubtrahend = SmtUtils.minus((Script)script.getScript(), (Term[])new Term[]{dividentMinuend, dividentSubtrahend});
                        result = QvasrAbstractor.simplifyRealDivision(script, subMinuendSubtrahend, divisorMinuend);
                    } else {
                        Term commonDenominator = QvasrAbstractor.expandRealMultiplication(script, divisorMinuend, divisorSubtrahend);
                        Term commonDenominatorDividentMinuend = QvasrAbstractor.expandRealMultiplication(script, dividentMinuend, divisorSubtrahend);
                        Term commonDenominatorDividentSubtrahend = QvasrAbstractor.expandRealMultiplication(script, dividentSubtrahend, divisorMinuend);
                        Term commonDenominatorSub = SmtUtils.minus((Script)script.getScript(), (Term[])new Term[]{commonDenominatorDividentMinuend, commonDenominatorDividentSubtrahend});
                        result = QvasrAbstractor.simplifyRealDivision(script, commonDenominatorSub, commonDenominator);
                    }
                }
            }
        }
        if (!QvasrUtils.isApplicationTerm(subtrahend) && QvasrUtils.isApplicationTerm(minuend) && "/".equals((appTermMinuend = (ApplicationTerm)minuend).getFunction().getName())) {
            Term dividendMinuend = appTermMinuend.getParameters()[0];
            Term divisorMinuend = appTermMinuend.getParameters()[1];
            commonDenominatorMinuend = QvasrAbstractor.expandRealMultiplication(script, subtrahend, divisorMinuend);
            paramsDividentSubtrahend = QvasrAbstractor.getApplicationTermMultiplicationParams(script, dividendMinuend);
            commonDenominatorSubtrahend = QvasrAbstractor.expandRealMultiplication(script, paramsDividentSubtrahend);
            simplifiedMinuend = SmtUtils.minus((Script)script.getScript(), (Term[])new Term[]{commonDenominatorSubtrahend, commonDenominatorMinuend});
            result = QvasrAbstractor.simplifyRealDivision(script, simplifiedMinuend, divisorMinuend);
            result.toStringDirect();
        }
        if (QvasrUtils.isApplicationTerm(subtrahend) && !QvasrUtils.isApplicationTerm(minuend) && "/".equals((appTermSubrahend = (ApplicationTerm)subtrahend).getFunction().getName())) {
            Term dividentSubtrahend = appTermSubrahend.getParameters()[0];
            Term divisorSubtrahend = appTermSubrahend.getParameters()[1];
            commonDenominatorMinuend = QvasrAbstractor.expandRealMultiplication(script, minuend, divisorSubtrahend);
            paramsDividentSubtrahend = QvasrAbstractor.getApplicationTermMultiplicationParams(script, dividentSubtrahend);
            commonDenominatorSubtrahend = QvasrAbstractor.expandRealMultiplication(script, paramsDividentSubtrahend);
            simplifiedMinuend = SmtUtils.minus((Script)script.getScript(), (Term[])new Term[]{commonDenominatorMinuend, commonDenominatorSubtrahend});
            result = QvasrAbstractor.simplifyRealDivision(script, simplifiedMinuend, divisorSubtrahend);
        }
        return result;
    }

    public static Term reduceNegativeRealSubtraction(ManagedScript script, Term minuend, Term subtrahend) {
        if (QvasrUtils.isApplicationTerm(minuend) && QvasrUtils.isApplicationTerm(subtrahend)) {
            Term factor;
            ArrayDeque<Object> subtrahendQueue;
            ArrayDeque<Term> minuendTemp;
            ArrayDeque<Object> minuendQueue;
            ApplicationTerm minuendAppTerm = (ApplicationTerm)minuend;
            ApplicationTerm subtrahendAppTerm = (ApplicationTerm)subtrahend;
            List<Term> minuendParams = Arrays.asList(minuendAppTerm.getParameters());
            List<Term> subtrahendParams = Arrays.asList(subtrahendAppTerm.getParameters());
            if ("+".equals(minuendAppTerm.getFunction().getName()) && "+".equals(subtrahendAppTerm.getFunction().getName())) {
                minuendQueue = new ArrayDeque<Object>();
                minuendTemp = new ArrayDeque<Term>();
                minuendQueue.addAll(minuendParams);
                minuendTemp.addAll(minuendParams);
                subtrahendQueue = new ArrayDeque<Object>();
                subtrahendQueue.addAll(subtrahendParams);
                block0: while (!minuendQueue.isEmpty()) {
                    factor = (Term)minuendQueue.pop();
                    for (Term term : subtrahendQueue) {
                        if (!QvasrUtils.checkTermEquiv(script, factor, term)) continue;
                        subtrahendQueue.remove(term);
                        minuendTemp.remove(factor);
                        continue block0;
                    }
                }
                minuendParams = new ArrayList<Term>(minuendTemp);
                subtrahendParams = new ArrayList<Term>(subtrahendQueue);
            }
            if (!"+".equals(minuendAppTerm.getFunction().getName()) && "+".equals(subtrahendAppTerm.getFunction().getName())) {
                minuendQueue = new ArrayDeque();
                minuendQueue.add(minuendAppTerm);
                ArrayDeque<Term> subtrahendQueue2 = new ArrayDeque<Term>();
                ArrayDeque<Term> subtrahendTemp = new ArrayDeque<Term>();
                subtrahendQueue2.addAll(subtrahendParams);
                subtrahendTemp.addAll(subtrahendParams);
                while (!subtrahendQueue2.isEmpty()) {
                    factor = (Term)subtrahendQueue2.pop();
                    if (!QvasrUtils.checkTermEquiv(script, factor, (Term)minuendAppTerm)) continue;
                    minuendQueue.remove(minuendAppTerm);
                    subtrahendTemp.remove(factor);
                    break;
                }
                minuendParams = new ArrayList<Term>(minuendQueue);
                subtrahendParams = new ArrayList<Term>(subtrahendTemp);
            }
            if ("+".equals(minuendAppTerm.getFunction().getName()) && !"+".equals(subtrahendAppTerm.getFunction().getName())) {
                minuendQueue = new ArrayDeque();
                minuendTemp = new ArrayDeque();
                minuendQueue.addAll(minuendParams);
                minuendTemp.addAll(minuendParams);
                subtrahendQueue = new ArrayDeque();
                subtrahendQueue.add(subtrahendAppTerm);
                while (!minuendQueue.isEmpty()) {
                    factor = (Term)minuendQueue.pop();
                    if (!QvasrUtils.checkTermEquiv(script, factor, (Term)subtrahendAppTerm)) continue;
                    minuendQueue.remove(subtrahendAppTerm);
                    minuendTemp.remove(factor);
                    break;
                }
                minuendParams = new ArrayList<Term>(minuendTemp);
                subtrahendParams = new ArrayList<Term>(subtrahendQueue);
            }
            Term minuendReduced = script.getScript().decimal("0");
            Term subtrahendReduced = script.getScript().decimal("0");
            Term[] minuendParamsArr = minuendParams.toArray(new Term[minuendParams.size()]);
            Term[] subtrahendParamsArr = subtrahendParams.toArray(new Term[subtrahendParams.size()]);
            if (minuendParams.size() > 1) {
                minuendReduced = SmtUtils.sum((Script)script.getScript(), (String)"+", (Term[])minuendParamsArr);
            }
            if (minuendParams.size() == 1) {
                minuendReduced = minuendParamsArr[0];
            }
            if (subtrahendParams.size() > 1) {
                subtrahendReduced = SmtUtils.sum((Script)script.getScript(), (String)"+", (Term[])subtrahendParamsArr);
            }
            if (subtrahendParams.size() == 1) {
                subtrahendReduced = subtrahendParamsArr[0];
            }
            return SmtUtils.minus((Script)script.getScript(), (Term[])new Term[]{minuendReduced, subtrahendReduced});
        }
        return SmtUtils.minus((Script)script.getScript(), (Term[])new Term[]{minuend, subtrahend});
    }

    public static Pair<Term, Term> reduceRealDivision(ManagedScript script, Term dividend, Term divisor) {
        Term simplifiedDividendPre;
        Term one = script.getScript().decimal("1");
        Term simplifiedDividend = dividend;
        Term simplifiedDivisor = divisor;
        do {
            ApplicationTerm divisorAppTerm;
            Term[] termArray;
            ApplicationTerm dividendAppTerm;
            simplifiedDividendPre = simplifiedDividend;
            if (QvasrUtils.isApplicationTerm(simplifiedDividend) && QvasrUtils.isApplicationTerm(simplifiedDivisor)) {
                Term[] divisorArray;
                Term[] dividendArray;
                ArrayList<Object> reducedParamsDivisor;
                ArrayList<Object> reducedParamsDividend;
                List<Term> paramsDividend;
                dividendAppTerm = (ApplicationTerm)simplifiedDividend;
                ApplicationTerm divisorAppTerm2 = (ApplicationTerm)simplifiedDivisor;
                if ("*".equals(dividendAppTerm.getFunction().getName()) && "*".equals(divisorAppTerm2.getFunction().getName())) {
                    paramsDividend = QvasrAbstractor.getApplicationTermMultiplicationParams(script, (Term)dividendAppTerm);
                    List<Term> paramsDivisor = QvasrAbstractor.getApplicationTermMultiplicationParams(script, (Term)divisorAppTerm2);
                    ArrayList<Term> reducedParamsDividend2 = new ArrayList<Term>(paramsDividend);
                    ArrayList<Term> reducedParamsDivisor2 = new ArrayList<Term>(paramsDivisor);
                    for (Term dividendFactor : paramsDividend) {
                        for (Term divisorFactor : paramsDivisor) {
                            if (!QvasrUtils.checkTermEquiv(script, dividendFactor, divisorFactor)) continue;
                            reducedParamsDividend2.remove(dividendFactor);
                            reducedParamsDivisor2.remove(divisorFactor);
                        }
                    }
                    if (reducedParamsDividend2.isEmpty()) {
                        reducedParamsDividend2.add(one);
                    }
                    if (reducedParamsDivisor2.isEmpty()) {
                        reducedParamsDivisor2.add(one);
                    }
                    Term[] dividendArray2 = reducedParamsDividend2.toArray(new Term[reducedParamsDividend2.size()]);
                    Term[] divisorArray2 = reducedParamsDivisor2.toArray(new Term[reducedParamsDivisor2.size()]);
                    simplifiedDividend = SmtUtils.mul((Script)script.getScript(), (String)"*", (Term[])dividendArray2);
                    simplifiedDivisor = SmtUtils.mul((Script)script.getScript(), (String)"*", (Term[])divisorArray2);
                }
                if ("*".equals(dividendAppTerm.getFunction().getName()) && !"*".equals(divisorAppTerm2.getFunction().getName())) {
                    paramsDividend = QvasrAbstractor.getApplicationTermMultiplicationParams(script, (Term)dividendAppTerm);
                    reducedParamsDividend = new ArrayList<Term>(paramsDividend);
                    reducedParamsDivisor = new ArrayList<ApplicationTerm>();
                    reducedParamsDivisor.add(divisorAppTerm2);
                    for (Term dividendFactor : paramsDividend) {
                        if (!QvasrUtils.checkTermEquiv(script, dividendFactor, (Term)divisorAppTerm2)) continue;
                        reducedParamsDividend.remove(dividendFactor);
                        reducedParamsDivisor.remove(divisorAppTerm2);
                    }
                    if (reducedParamsDividend.isEmpty()) {
                        reducedParamsDividend.add(one);
                    }
                    if (reducedParamsDivisor.isEmpty()) {
                        reducedParamsDivisor.add(one);
                    }
                    dividendArray = reducedParamsDividend.toArray(new Term[reducedParamsDividend.size()]);
                    divisorArray = reducedParamsDivisor.toArray(new Term[reducedParamsDivisor.size()]);
                    simplifiedDividend = SmtUtils.mul((Script)script.getScript(), (String)"*", (Term[])dividendArray);
                    simplifiedDivisor = SmtUtils.mul((Script)script.getScript(), (String)"*", (Term[])divisorArray);
                }
                if (!"*".equals(dividendAppTerm.getFunction().getName()) && "*".equals(divisorAppTerm2.getFunction().getName())) {
                    List<Term> paramsDivisor = QvasrAbstractor.getApplicationTermMultiplicationParams(script, (Term)divisorAppTerm2);
                    reducedParamsDividend = new ArrayList();
                    reducedParamsDivisor = new ArrayList<Term>(paramsDivisor);
                    reducedParamsDividend.add((Term)dividendAppTerm);
                    for (Term divisorFactor : paramsDivisor) {
                        if (!QvasrUtils.checkTermEquiv(script, divisorFactor, (Term)dividendAppTerm)) continue;
                        reducedParamsDividend.remove(divisorFactor);
                        reducedParamsDivisor.remove(dividendAppTerm);
                    }
                    if (reducedParamsDividend.isEmpty()) {
                        reducedParamsDividend.add(one);
                    }
                    if (reducedParamsDivisor.isEmpty()) {
                        reducedParamsDivisor.add(one);
                    }
                    dividendArray = reducedParamsDividend.toArray(new Term[reducedParamsDividend.size()]);
                    divisorArray = reducedParamsDivisor.toArray(new Term[reducedParamsDivisor.size()]);
                    simplifiedDividend = SmtUtils.mul((Script)script.getScript(), (String)"*", (Term[])dividendArray);
                    simplifiedDivisor = SmtUtils.mul((Script)script.getScript(), (String)"*", (Term[])divisorArray);
                }
            }
            if (QvasrUtils.isApplicationTerm(simplifiedDividend) && !QvasrUtils.isApplicationTerm(simplifiedDivisor) && "*".equals((dividendAppTerm = (ApplicationTerm)simplifiedDividend).getFunction().getName())) {
                HashSet<Term> simplifiedDividendParamSet = new HashSet<Term>(Arrays.asList(dividendAppTerm.getParameters()));
                termArray = dividendAppTerm.getParameters();
                int n = termArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Term dividendFactor = termArray[n2];
                    if (QvasrUtils.checkTermEquiv(script, dividendFactor, simplifiedDivisor)) {
                        simplifiedDividendParamSet.remove(dividendFactor);
                        simplifiedDivisor = one;
                    }
                    ++n2;
                }
                Term[] dividendArray = simplifiedDividendParamSet.toArray(new Term[simplifiedDividendParamSet.size()]);
                simplifiedDividend = SmtUtils.mul((Script)script.getScript(), (String)"*", (Term[])dividendArray);
            }
            if (QvasrUtils.isApplicationTerm(simplifiedDividend) || !QvasrUtils.isApplicationTerm(simplifiedDivisor) || !"*".equals((divisorAppTerm = (ApplicationTerm)simplifiedDivisor).getFunction().getName())) continue;
            HashSet<Term> simplifiedDivisorParamSet = new HashSet<Term>(Arrays.asList(divisorAppTerm.getParameters()));
            termArray = divisorAppTerm.getParameters();
            int n = termArray.length;
            int n3 = 0;
            while (n3 < n) {
                Term divisorFactor = termArray[n3];
                if (QvasrUtils.checkTermEquiv(script, divisorFactor, simplifiedDividend)) {
                    simplifiedDividend = one;
                    simplifiedDivisorParamSet.remove(divisorFactor);
                }
                ++n3;
            }
            Term[] divisorArray = simplifiedDivisorParamSet.toArray(new Term[simplifiedDivisorParamSet.size()]);
            simplifiedDivisor = SmtUtils.mul((Script)script.getScript(), (String)"*", (Term[])divisorArray);
        } while (!QvasrUtils.checkTermEquiv(script, simplifiedDividendPre, simplifiedDividend));
        return new Pair((Object)simplifiedDividend, (Object)simplifiedDivisor);
    }

    public static List<Term> getApplicationTermMultiplicationParams(ManagedScript script, Term appTerm) {
        ArrayList<Term> params = new ArrayList<Term>();
        if (QvasrUtils.isApplicationTerm(appTerm)) {
            if ("*".equals(((ApplicationTerm)appTerm).getFunction().getName())) {
                Term[] termArray = ((ApplicationTerm)appTerm).getParameters();
                int n = termArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Term param = termArray[n2];
                    if (QvasrUtils.isApplicationTerm(param) && "*".equals(((ApplicationTerm)param).getFunction().getName())) {
                        params.addAll(QvasrAbstractor.getApplicationTermMultiplicationParams(script, param));
                    } else {
                        params.add(param);
                    }
                    ++n2;
                }
            } else {
                params.add(appTerm);
            }
        } else {
            params.add(appTerm);
        }
        return params;
    }

    public static List<Term> getApplicationTermSumParams(ApplicationTerm appTerm) {
        ArrayList<Term> params = new ArrayList<Term>();
        if ("+".equals(appTerm.getFunction().getName())) {
            Term[] termArray = appTerm.getParameters();
            int n = termArray.length;
            int n2 = 0;
            while (n2 < n) {
                Term param = termArray[n2];
                if (QvasrUtils.isApplicationTerm(param) && "+".endsWith(((ApplicationTerm)param).getFunction().getName())) {
                    params.addAll(QvasrAbstractor.getApplicationTermSumParams((ApplicationTerm)param));
                } else {
                    params.add(param);
                }
                ++n2;
            }
        } else {
            params.add((Term)appTerm);
        }
        return params;
    }

    private static int findPivot(ManagedScript script, Term[][] matrix, int col) {
        int maxRow = -1;
        int row = col;
        while (row < matrix.length) {
            if (!QvasrUtils.checkTermEquiv(script, matrix[row][col], script.getScript().decimal("0"))) {
                maxRow = row;
                break;
            }
            ++row;
        }
        return maxRow;
    }

    private static Term[][] swap(Term[][] matrix, int col, int row) {
        int i = col;
        while (i < matrix[col].length) {
            Term temp = matrix[col][i];
            matrix[col][i] = matrix[row][i];
            matrix[row][i] = temp;
            ++i;
        }
        return matrix;
    }

    private static Map<TermVariable, Term> getUpdates(IUltimateServiceProvider services, ManagedScript script, UnmodifiableTransFormula transitionFormula, BaseType baseType) {
        SimultaneousUpdate su;
        try {
            su = SimultaneousUpdate.fromTransFormula((IUltimateServiceProvider)services, (TransFormula)transitionFormula, (ManagedScript)script);
        }
        catch (Exception exception) {
            throw new UnsupportedOperationException("Could not compute Simultaneous Update!");
        }
        HashMap<TermVariable, TermVariable> realTvs = new HashMap<TermVariable, TermVariable>();
        Map updates = su.getDeterministicAssignment();
        for (IProgramVar readOnlyVar : su.getReadonlyVars()) {
            updates.put(readOnlyVar, readOnlyVar.getTermVariable());
        }
        for (IProgramVar pv : updates.keySet()) {
            TermVariable inVar = script.constructFreshTermVariable(String.valueOf(pv.getGloballyUniqueId()) + "_real", SmtSortUtils.getRealSort((ManagedScript)script));
            realTvs.put(pv.getTermVariable(), inVar);
        }
        HashMap<IProgramVar, Term> realUpdates = new HashMap<IProgramVar, Term>();
        for (Map.Entry update : updates.entrySet()) {
            Term intUpdate = (Term)update.getValue();
            Term realUpdate = Substitution.apply((ManagedScript)script, realTvs, (Term)intUpdate);
            realUpdates.put((IProgramVar)update.getKey(), realUpdate);
        }
        LinkedHashMap<TermVariable, Term> assignments = new LinkedHashMap<TermVariable, Term>();
        for (Map.Entry varUpdate : realUpdates.entrySet()) {
            Term realTerm;
            IProgramVar progVar = (IProgramVar)varUpdate.getKey();
            Term varUpdateTerm = (Term)varUpdate.getValue();
            HashMap<Term, Term> subMappingTerm = new HashMap<Term, Term>();
            if (QvasrUtils.isApplicationTerm(varUpdateTerm)) {
                ApplicationTerm varUpdateAppterm = (ApplicationTerm)varUpdateTerm;
                subMappingTerm.putAll(QvasrAbstractor.appTermToReal(script, varUpdateAppterm));
                realTerm = Substitution.apply((ManagedScript)script, subMappingTerm, (Term)varUpdateAppterm);
            } else if (varUpdateTerm instanceof ConstantTerm) {
                Rational value = SmtUtils.toRational((ConstantTerm)((ConstantTerm)varUpdateTerm));
                realTerm = value.toTerm(SmtSortUtils.getRealSort((ManagedScript)script));
            } else {
                realTerm = (Term)realTvs.get(progVar.getTermVariable());
            }
            if (baseType == BaseType.ADDITIONS) {
                Term realVar = (Term)realTvs.get(progVar.getTermVariable());
                realTerm = SmtUtils.minus((Script)script.getScript(), (Term[])new Term[]{realTerm, realVar});
            }
            assignments.put((TermVariable)realTvs.get(progVar.getTermVariable()), realTerm);
        }
        return assignments;
    }

    private static Map<Term, Term> appTermToReal(ManagedScript script, ApplicationTerm appTerm) {
        HashMap<Term, Term> subMap = new HashMap<Term, Term>();
        Term[] termArray = appTerm.getParameters();
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            Term param = termArray[n2];
            if (param.getSort() != SmtSortUtils.getRealSort((ManagedScript)script)) {
                if (param instanceof ConstantTerm) {
                    ConstantTerm paramConst = (ConstantTerm)param;
                    Rational paramValue = (Rational)paramConst.getValue();
                    subMap.put(param, paramValue.toTerm(SmtSortUtils.getRealSort((ManagedScript)script)));
                } else if (param instanceof TermVariable) {
                    subMap.put(param, (Term)script.constructFreshTermVariable(((TermVariable)param).getName(), SmtSortUtils.getRealSort((ManagedScript)script)));
                } else {
                    subMap.putAll(QvasrAbstractor.appTermToReal(script, (ApplicationTerm)param));
                }
            }
            ++n2;
        }
        return subMap;
    }

    /*
     * WARNING - void declaration
     */
    private static Term[][] constructBaseMatrix(ManagedScript script, Map<TermVariable, Term> updates, UnmodifiableTransFormula transitionFormula) {
        void var6_12;
        int columnDimension = transitionFormula.getOutVars().size();
        HashSet<Object> setToZero = new HashSet<Object>();
        HashMap intToReal = new HashMap();
        for (Term term : updates.keySet()) {
            HashSet inVar = new HashSet();
            inVar.add(term);
            setToZero.add(inVar);
        }
        HashSet hashSet = new HashSet(setToZero);
        for (Set set : setToZero) {
            Set<Set<Term>> set2 = QvasrUtils.joinSet((Set<Set<Term>>)var6_12, set);
        }
        Term[][] termArray = new Term[var6_12.size() + 1][columnDimension + 1];
        int i = 0;
        while (i < var6_12.size() + 1) {
            int j = 0;
            while (j < columnDimension + 1) {
                termArray[i][j] = script.getScript().decimal("0");
                ++j;
            }
            ++i;
        }
        HashDeque zeroStack = new HashDeque();
        zeroStack.addAll(var6_12);
        Term one = script.getScript().decimal("1");
        Term zero = script.getScript().decimal("0");
        int j = 0;
        while (!zeroStack.isEmpty()) {
            int i2 = 0;
            termArray[j][columnDimension] = one;
            HashMap<Term, Term> subMapping = new HashMap<Term, Term>();
            if (j > 0) {
                Set toBeSetZero = (Set)zeroStack.pop();
                for (Term tv : toBeSetZero) {
                    subMapping.put(tv, zero);
                }
            }
            for (Map.Entry<TermVariable, Term> update : updates.entrySet()) {
                Term toBeUpdatedReal;
                Term updateTerm = update.getValue();
                Term toBeUpdated = Substitution.apply((ManagedScript)script, subMapping, (Term)updateTerm);
                termArray[j][i2] = toBeUpdatedReal = Substitution.apply((ManagedScript)script, intToReal, (Term)toBeUpdated);
                ++i2;
            }
            ++j;
        }
        return termArray;
    }

    private Term constructBaseFormula(ManagedScript script, Map<TermVariable, Set<Term>> updates, UnmodifiableTransFormula transitionFormula, BaseType baseType) {
        int sCount = 0;
        HashSet<Term> newUpdates = new HashSet<Term>();
        for (Map.Entry<TermVariable, Set<Term>> variableUpdate : updates.entrySet()) {
            TermVariable s = script.constructFreshTermVariable("s" + sCount, SmtSortUtils.getRealSort((ManagedScript)script));
            for (Term update : variableUpdate.getValue()) {
                Term mult = SmtUtils.mul((Script)script.getScript(), (String)"*", (Term[])new Term[]{s, update});
                newUpdates.add(mult);
            }
            ++sCount;
        }
        Term addition = script.getScript().decimal("1");
        for (Term update : newUpdates) {
            addition = SmtUtils.sum((Script)script.getScript(), (String)"+", (Term[])new Term[]{addition, update});
        }
        addition = SmtUtils.equality((Script)script.getScript(), (Term[])new Term[]{addition, script.constructFreshTermVariable("a", SmtSortUtils.getRealSort((ManagedScript)script))});
        return addition;
    }

    private static enum BaseType {
        RESETS,
        ADDITIONS;

    }
}

