/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.IIcfgTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.ILocationFactory;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.ITransformulaTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.IcfgTransformationBacktranslator;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.IcfgTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.CopyingTransformulaTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr.QvasrSummarizer;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Term;

public class QvasrIcfgTransformer<INLOC extends IcfgLocation, OUTLOC extends IcfgLocation>
implements IIcfgTransformer<OUTLOC> {
    private final ILogger mLogger;
    private final ManagedScript mScript;
    private final IIcfg<INLOC> mOriginalIcfg;
    private final ITransformulaTransformer mTransformer;
    private final IUltimateServiceProvider mServices;
    private final IIcfg<OUTLOC> mResult;

    public QvasrIcfgTransformer(ILogger logger, IIcfg<INLOC> originalIcfg, Class<OUTLOC> outLocationClass, ILocationFactory<INLOC, OUTLOC> funLocFac, String newIcfgIdentifier, IcfgTransformationBacktranslator backtranslationTracker, IUltimateServiceProvider services) {
        this.mLogger = logger;
        this.mOriginalIcfg = originalIcfg;
        this.mServices = services;
        this.mScript = originalIcfg.getCfgSmtToolkit().getManagedScript();
        this.mTransformer = new QvasrLoopAccelerationTransformer(this.mLogger, originalIcfg.getCfgSmtToolkit().getManagedScript(), originalIcfg.getCfgSmtToolkit());
        this.mResult = new IcfgTransformer<INLOC, OUTLOC>(this.mLogger, originalIcfg, funLocFac, backtranslationTracker, outLocationClass, newIcfgIdentifier, this.mTransformer).getResult();
    }

    @Override
    public IIcfg<OUTLOC> getResult() {
        return this.mResult;
    }

    private final class QvasrLoopAccelerationTransformer
    extends CopyingTransformulaTransformer {
        public QvasrLoopAccelerationTransformer(ILogger logger, ManagedScript managedScript, CfgSmtToolkit oldToolkit) {
            super(logger, managedScript, oldToolkit);
        }

        @Override
        public ITransformulaTransformer.TransformulaTransformationResult transform(IIcfgTransition<? extends IcfgLocation> oldEdge, UnmodifiableTransFormula tf) {
            QvasrSummarizer qvasrSummarizer = new QvasrSummarizer(QvasrIcfgTransformer.this.mLogger, QvasrIcfgTransformer.this.mServices, QvasrIcfgTransformer.this.mScript);
            if (oldEdge.getSource() == oldEdge.getTarget()) {
                QvasrIcfgTransformer.this.mLogger.debug((Object)"Found loop, starting Qvasr summarization.");
                UnmodifiableTransFormula oldTf = oldEdge.getTransformula();
                if (!SmtUtils.containsArrayVariables((Term[])new Term[]{oldTf.getFormula()}) || !SmtUtils.isArrayFree((Term)oldTf.getFormula())) {
                    return super.transform(oldEdge, tf);
                }
                UnmodifiableTransFormula loopAccel = qvasrSummarizer.summarizeLoop(oldTf);
                return new ITransformulaTransformer.TransformulaTransformationResult(loopAccel);
            }
            return super.transform(oldEdge, tf);
        }
    }
}

