/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr.QvasrSummarizer;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Term;

public class QvasrLoopSummarization {
    private final ILogger mLogger;
    private final IUltimateServiceProvider mServices;
    private final ManagedScript mScript;
    private final IPredicateUnifier mPredUnifier;
    private boolean mIsOverapprox;

    public QvasrLoopSummarization(ILogger logger, IUltimateServiceProvider services, ManagedScript script, IPredicateUnifier predUnifier) {
        this.mLogger = logger;
        this.mServices = services;
        this.mScript = script;
        this.mPredUnifier = predUnifier;
        this.mIsOverapprox = false;
    }

    public UnmodifiableTransFormula getQvasrAcceleration(UnmodifiableTransFormula loopTransitionFormula) {
        if (!SmtUtils.isArrayFree((Term)loopTransitionFormula.getFormula())) {
            throw new UnsupportedOperationException("Qvasr do not support arrays.");
        }
        QvasrSummarizer qvasrSummarizer = new QvasrSummarizer(this.mLogger, this.mServices, this.mScript);
        UnmodifiableTransFormula loopSummary = qvasrSummarizer.summarizeLoop(loopTransitionFormula);
        this.mIsOverapprox = qvasrSummarizer.isOverapprox();
        return loopSummary;
    }

    public boolean isOverapprox() {
        return this.mIsOverapprox;
    }
}

