/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr.IntvasrAbstraction;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr.Qvasr;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr.QvasrAbstraction;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr.QvasrAbstractionJoin;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr.QvasrAbstractor;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr.QvasrUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ITransitionRelation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IAbstractPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IDomainSpecificOperationProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateTransformer;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.TermDomainOperationProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class QvasrSummarizer {
    private final ILogger mLogger;
    private final ManagedScript mScript;
    private final IUltimateServiceProvider mServices;
    private boolean mIsOverapprox;

    public QvasrSummarizer(ILogger logger, IUltimateServiceProvider services, ManagedScript script) {
        this.mLogger = logger;
        this.mScript = script;
        this.mServices = services;
        this.mIsOverapprox = false;
    }

    public UnmodifiableTransFormula summarizeLoop(UnmodifiableTransFormula transitionFormula) {
        HashMap<IProgramVar, TermVariable> inVarsReal = new HashMap<IProgramVar, TermVariable>();
        HashMap<IProgramVar, TermVariable> outVarsReal = new HashMap<IProgramVar, TermVariable>();
        for (IProgramVar assVar : transitionFormula.getOutVars().keySet()) {
            if (transitionFormula.getInVars().containsKey(assVar)) {
                inVarsReal.put(assVar, (TermVariable)transitionFormula.getInVars().get(assVar));
            } else if (transitionFormula.getOutVars().containsKey(assVar)) {
                inVarsReal.put(assVar, (TermVariable)transitionFormula.getOutVars().get(assVar));
            }
            if (!transitionFormula.getOutVars().containsKey(assVar)) continue;
            outVarsReal.put(assVar, (TermVariable)transitionFormula.getOutVars().get(assVar));
        }
        int tfDimension = transitionFormula.getOutVars().size();
        Rational[][] identityMatrix = QvasrUtils.getIdentityMatrix(tfDimension);
        QvasrAbstraction bestAbstraction = new QvasrAbstraction(identityMatrix, new Qvasr());
        Term transitionTerm = transitionFormula.getFormula();
        Term transitionTermDnf = SmtUtils.toDnf((IUltimateServiceProvider)this.mServices, (ManagedScript)this.mScript, (Term)transitionTerm, (SmtUtils.XnfConversionTechnique)SmtUtils.XnfConversionTechnique.BOTTOM_UP_WITH_LOCAL_SIMPLIFICATION);
        Set<Term> disjuncts = QvasrUtils.splitDisjunction(transitionTermDnf);
        for (Term disjunct : disjuncts) {
            UnmodifiableTransFormula disjunctTf = QvasrUtils.buildFormula(transitionFormula, disjunct, this.mScript);
            QvasrAbstraction qvasrAbstraction = QvasrAbstractor.computeAbstraction(this.mServices, this.mScript, disjunctTf);
            bestAbstraction = (QvasrAbstraction)QvasrAbstractionJoin.join(this.mScript, bestAbstraction, qvasrAbstraction).getThird();
        }
        if (bestAbstraction.getVasr().getTransformer().size() > 1) {
            this.mIsOverapprox = true;
        }
        PredicateTransformer predTransformer = new PredicateTransformer(this.mScript, (IDomainSpecificOperationProvider)new TermDomainOperationProvider(this.mServices, this.mScript));
        IntvasrAbstraction intVasrAbstraction = QvasrUtils.qvasrAbstractionToInt(bestAbstraction);
        return QvasrSummarizer.intVasrAbstractionToFormula(this.mScript, this.mServices, (PredicateTransformer<Term, IPredicate, TransFormula>)predTransformer, transitionFormula, intVasrAbstraction, inVarsReal, outVarsReal);
    }

    public static UnmodifiableTransFormula intVasrAbstractionToFormula(ManagedScript script, IUltimateServiceProvider services, PredicateTransformer<Term, IPredicate, TransFormula> predTransformer, UnmodifiableTransFormula tf, IntvasrAbstraction intvasrAbstraction, Map<IProgramVar, TermVariable> invars, Map<IProgramVar, TermVariable> outvars) {
        int transformerId;
        Term[] inVarsReal = invars.values().toArray(new Term[invars.size()]);
        Term[] outVarsReal = outvars.values().toArray(new Term[outvars.size()]);
        HashMap<TermVariable, TermVariable> defaultToOut = new HashMap<TermVariable, TermVariable>();
        for (Map.Entry<IProgramVar, TermVariable> invar : invars.entrySet()) {
            if (tf.getOutVars().containsKey(invar.getKey())) {
                defaultToOut.put(invar.getKey().getTermVariable(), (TermVariable)tf.getOutVars().get(invar.getKey()));
                continue;
            }
            defaultToOut.put(invar.getKey().getTermVariable(), invar.getValue());
        }
        Term[][] variableRelationsIn = QvasrUtils.matrixVectorMultiplicationWithVariables(script, intvasrAbstraction.getSimulationMatrix(), QvasrUtils.transposeRowToColumnTermVector(inVarsReal));
        Term[][] variableRelationsOut = QvasrUtils.matrixVectorMultiplicationWithVariables(script, intvasrAbstraction.getSimulationMatrix(), QvasrUtils.transposeRowToColumnTermVector(outVarsReal));
        ArrayList<Term> qvasrDimensionConjunction = new ArrayList<Term>();
        HashMap<Integer, TermVariable> kToTransformer = new HashMap<Integer, TermVariable>();
        int dimension = 0;
        while (dimension < intvasrAbstraction.getVasr().getDimension()) {
            HashSet dimensionDisjunction = new HashSet();
            Term dimensionSumTerm = variableRelationsIn[dimension][0];
            boolean incrementFlag = false;
            transformerId = 0;
            for (Pair<Integer[], Integer[]> transformer : intvasrAbstraction.getVasr().getTransformer()) {
                Integer dimensionReset = ((Integer[])transformer.getFirst())[dimension];
                Integer dimensionAddition = ((Integer[])transformer.getSecond())[dimension];
                if (dimensionReset == 0) {
                    Term equality = SmtUtils.binaryEquality((Script)script.getScript(), (Term)variableRelationsOut[dimension][0], (Term)script.getScript().numeral(dimensionAddition.toString()));
                    dimensionDisjunction.add(equality);
                } else {
                    TermVariable k;
                    if (kToTransformer.containsKey(transformerId)) {
                        k = (TermVariable)kToTransformer.get(transformerId);
                    } else {
                        k = script.constructFreshTermVariable("k", SmtSortUtils.getIntSort((ManagedScript)script));
                        kToTransformer.put(transformerId, k);
                    }
                    Term quantifiedAddition = SmtUtils.mul((Script)script.getScript(), (String)"*", (Term[])new Term[]{script.getScript().numeral(((Integer[])transformer.getSecond())[dimension].toString()), k});
                    dimensionSumTerm = SmtUtils.sum((Script)script.getScript(), (String)"+", (Term[])new Term[]{dimensionSumTerm, quantifiedAddition});
                    incrementFlag = true;
                }
                ++transformerId;
            }
            if (incrementFlag) {
                Term equality = SmtUtils.binaryEquality((Script)script.getScript(), (Term)variableRelationsOut[dimension][0], (Term)dimensionSumTerm);
                dimensionDisjunction.add(equality);
            }
            qvasrDimensionConjunction.add(SmtUtils.or((Script)script.getScript(), (Collection)dimensionDisjunction));
            ++dimension;
        }
        for (Term k : kToTransformer.values()) {
            Term kGeqZero = SmtUtils.geq((Script)script.getScript(), (Term)k, (Term)script.getScript().numeral("0"));
            qvasrDimensionConjunction.add(kGeqZero);
        }
        UnmodifiableTransFormula guard = TransFormulaUtils.computeGuard((UnmodifiableTransFormula)tf, (ManagedScript)script, (IUltimateServiceProvider)services);
        ArrayList<TermVariable> guardVars = new ArrayList<TermVariable>();
        if (QvasrUtils.isApplicationTerm(guard.getFormula())) {
            ApplicationTerm appTermGuard = (ApplicationTerm)guard.getFormula();
            Term[] termArray = appTermGuard.getParameters();
            int equality = termArray.length;
            transformerId = 0;
            while (transformerId < equality) {
                Term param = termArray[transformerId];
                if (param instanceof TermVariable) {
                    guardVars.add((TermVariable)param);
                }
                ++transformerId;
            }
        }
        BasicPredicate guardPred = new BasicPredicate(0, new String[0], script.getScript().term("true", new Term[0]), Collections.emptySet(), script.getScript().term("true", new Term[0]));
        Term post = (Term)predTransformer.strongestPostcondition((IAbstractPredicate)guardPred, (ITransitionRelation)tf);
        Term postSub = Substitution.apply((ManagedScript)script, defaultToOut, (Term)post);
        qvasrDimensionConjunction.add(postSub);
        Term loopSummary = SmtUtils.and((Script)script.getScript(), qvasrDimensionConjunction);
        loopSummary = SmtUtils.quantifier((Script)script.getScript(), (int)0, kToTransformer.values(), (Term)SmtUtils.and((Script)script.getScript(), (Term[])new Term[]{loopSummary}));
        loopSummary = PartialQuantifierElimination.eliminate((IUltimateServiceProvider)services, (ManagedScript)script, (Term)loopSummary, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.POLY_PAC);
        TransFormulaBuilder tfb = new TransFormulaBuilder(tf.getInVars(), tf.getOutVars(), true, null, true, null, true);
        tfb.setFormula(loopSummary);
        tfb.setInfeasibility(UnmodifiableTransFormula.Infeasibility.NOT_DETERMINED);
        return tfb.finishConstruction(script);
    }

    public boolean isOverapprox() {
        return this.mIsOverapprox;
    }
}

