/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr.Intvasr;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr.IntvasrAbstraction;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr.QvasrAbstraction;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasrs.IntVasrsAbstraction;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasrs.QvasrsAbstraction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.HashDeque;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class QvasrUtils {
    private QvasrUtils() {
    }

    public static Set<Term> splitDisjunction(Term term) {
        HashSet<Term> result = new HashSet<Term>();
        ApplicationTerm dnfAppTerm = (ApplicationTerm)term;
        if (!"or".equals(dnfAppTerm.getFunction().getName())) {
            result.add(term);
        } else {
            result.addAll(Arrays.asList(dnfAppTerm.getParameters()));
        }
        return result;
    }

    public static Set<Term> checkDisjoint(Set<Term> disjuncts, ManagedScript script, IUltimateServiceProvider services, SmtUtils.SimplificationTechnique simplificationTechnique) {
        HashDeque checkStack = new HashDeque();
        HashSet<Term> disjointSet = new HashSet<Term>();
        checkStack.addAll(disjuncts);
        while (!checkStack.isEmpty()) {
            Term toBeChecked = (Term)checkStack.pop();
            boolean isSat = false;
            for (Term conjunct : checkStack) {
                if (SmtUtils.checkSatTerm((Script)script.getScript(), (Term)SmtUtils.and((Script)script.getScript(), (Term[])new Term[]{toBeChecked, conjunct})) != Script.LBool.SAT) continue;
                checkStack.add(SmtUtils.simplify((ManagedScript)script, (Term)SmtUtils.or((Script)script.getScript(), (Term[])new Term[]{toBeChecked, conjunct}), (IUltimateServiceProvider)services, (SmtUtils.SimplificationTechnique)simplificationTechnique));
                isSat = true;
                break;
            }
            if (isSat) continue;
            disjointSet.add(toBeChecked);
        }
        return disjointSet;
    }

    public static Rational[][] getCoherenceIdentityMatrix(Set<Integer> coherenceClass, int d) {
        Rational[][] coherenceIdentityMatrix = new Rational[coherenceClass.size()][d];
        int i = 0;
        while (i < coherenceClass.size()) {
            int j = 0;
            while (j < d) {
                coherenceIdentityMatrix[i][j] = Rational.ZERO;
                ++j;
            }
            ++i;
        }
        int k = 0;
        for (Integer classLine : coherenceClass) {
            coherenceIdentityMatrix[k][classLine.intValue()] = Rational.ONE;
            ++k;
        }
        return coherenceIdentityMatrix;
    }

    public static Rational[][] getIdentityMatrix(int dimension) {
        Rational[][] identityMatrix = new Rational[dimension][dimension];
        int i = 0;
        while (i < dimension) {
            int j = 0;
            while (j < dimension) {
                identityMatrix[i][j] = i == j ? Rational.ONE : Rational.ZERO;
                ++j;
            }
            ++i;
        }
        return identityMatrix;
    }

    public static Term[][] vectorMatrixMultiplicationWithVariables(ManagedScript script, Term[] vector, Rational[][] matrixTwo) {
        int vectorLength = vector.length;
        int rowMatrixTwo = matrixTwo.length;
        if (vectorLength != rowMatrixTwo) {
            throw new UnsupportedOperationException();
        }
        int colMatrixTwo = matrixTwo[0].length;
        Term[][] resultMatrix = new Term[1][colMatrixTwo];
        int i = 0;
        while (i < colMatrixTwo) {
            resultMatrix[0][i] = script.getScript().decimal("0");
            ++i;
        }
        int j = 0;
        while (j < colMatrixTwo) {
            Term sum = script.getScript().decimal("0");
            int k = 0;
            while (k < rowMatrixTwo) {
                Term mult = SmtUtils.mul((Script)script.getScript(), (String)"*", (Term[])new Term[]{vector[k], matrixTwo[k][j].toTerm(SmtSortUtils.getRealSort((ManagedScript)script))});
                resultMatrix[0][j] = sum = SmtUtils.sum((Script)script.getScript(), (String)"+", (Term[])new Term[]{sum, mult});
                ++k;
            }
            ++j;
        }
        return resultMatrix;
    }

    public static Term[][] matrixVectorMultiplicationWithVariables(ManagedScript script, Integer[][] matrixTwo, Term[][] vector) {
        int vectorLength = vector.length;
        int colMatrixTwo = matrixTwo[0].length;
        assert (vectorLength == colMatrixTwo);
        int rowMatrixTwo = matrixTwo.length;
        Term[][] resultMatrix = new Term[rowMatrixTwo][1];
        int i = 0;
        while (i < rowMatrixTwo) {
            resultMatrix[i][0] = script.getScript().numeral("0");
            ++i;
        }
        int j = 0;
        while (j < rowMatrixTwo) {
            Term sum = script.getScript().numeral("0");
            int k = 0;
            while (k < colMatrixTwo) {
                Term mult = SmtUtils.mul((Script)script.getScript(), (String)"*", (Term[])new Term[]{vector[k][0], script.getScript().numeral(matrixTwo[j][k].toString())});
                resultMatrix[j][0] = sum = SmtUtils.sum((Script)script.getScript(), (String)"+", (Term[])new Term[]{sum, mult});
                ++k;
            }
            ++j;
        }
        return resultMatrix;
    }

    public static boolean checkTermEquiv(ManagedScript script, Term firstEntry, Term secondEntry) {
        return SmtUtils.areFormulasEquivalent((Term)firstEntry, (Term)secondEntry, (Script)script.getScript());
    }

    public static boolean isApplicationTerm(Term term) {
        return term instanceof ApplicationTerm && ((ApplicationTerm)term).getParameters().length > 0;
    }

    public static UnmodifiableTransFormula buildFormula(UnmodifiableTransFormula origin, Term term, ManagedScript managedScript) {
        TransFormulaBuilder tfb = new TransFormulaBuilder(origin.getInVars(), origin.getOutVars(), true, null, true, null, false);
        tfb.setFormula(term);
        tfb.addAuxVarsButRenameToFreshCopies(origin.getAuxVars(), managedScript);
        tfb.setInfeasibility(UnmodifiableTransFormula.Infeasibility.NOT_DETERMINED);
        return tfb.finishConstruction(managedScript);
    }

    public static UnmodifiableTransFormula buildFormula(ManagedScript managedScript, Term term, Map<IProgramVar, TermVariable> inVars, Map<IProgramVar, TermVariable> outVars) {
        TransFormulaBuilder tfb = new TransFormulaBuilder(inVars, outVars, true, null, true, null, true);
        tfb.setFormula(term);
        tfb.setInfeasibility(UnmodifiableTransFormula.Infeasibility.NOT_DETERMINED);
        return tfb.finishConstruction(managedScript);
    }

    public static Rational[][] rationalMatrixVectorMultiplication(Rational[][] matrix, Rational[][] vector) {
        int colMatrix;
        int vectorLength;
        if (vector.length == 1) {
            vector = QvasrUtils.transposeRowToColumnVector(vector);
        }
        if ((vectorLength = vector.length) != (colMatrix = matrix[0].length)) {
            throw new UnsupportedOperationException();
        }
        int rowMatrix = matrix.length;
        Rational[][] resultMatrix = new Rational[rowMatrix][1];
        int j = 0;
        while (j < rowMatrix) {
            Rational sum = Rational.ZERO;
            int k = 0;
            while (k < colMatrix) {
                Rational mult = vector[k][0].mul(matrix[j][k]);
                resultMatrix[j][0] = sum = sum.add(mult);
                ++k;
            }
            ++j;
        }
        return resultMatrix;
    }

    public static Rational[][] rationalMatrixMultiplication(Rational[][] matrixOne, Rational[][] matrixTwo) {
        int j;
        int colMatrixOne = matrixOne[0].length;
        int rowMatrixTwo = matrixTwo.length;
        if (colMatrixOne != rowMatrixTwo) {
            return new Rational[0][0];
        }
        int colMatrixTwo = matrixTwo[0].length;
        int rowMatrixOne = matrixOne.length;
        Rational[][] resultMatrix = new Rational[rowMatrixOne][colMatrixTwo];
        int i = 0;
        while (i < rowMatrixOne) {
            j = 0;
            while (j < colMatrixTwo) {
                resultMatrix[i][j] = Rational.ZERO;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < rowMatrixOne) {
            j = 0;
            while (j < colMatrixTwo) {
                int k = 0;
                while (k < colMatrixOne) {
                    Rational sum;
                    Rational mul = matrixOne[i][k].mul(matrixTwo[k][j]);
                    resultMatrix[i][j] = sum = resultMatrix[i][j].add(mul);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return resultMatrix;
    }

    public static Rational[][] transposeRowToColumnVector(Rational[][] vector) {
        Rational[][] transposedVector = new Rational[vector[0].length][1];
        int i = 0;
        while (i < vector[0].length) {
            transposedVector[i][0] = vector[0][i];
            ++i;
        }
        return transposedVector;
    }

    public static Rational[][] transposeRowToColumnVector(Rational[] vector) {
        Rational[][] transposedVector = new Rational[vector.length][1];
        int i = 0;
        while (i < vector.length) {
            transposedVector[i][0] = vector[i];
            ++i;
        }
        return transposedVector;
    }

    public static Term[][] transposeRowToColumnTermVector(Term[] vector) {
        Term[][] transposedVector = new Term[vector.length][1];
        int i = 0;
        while (i < vector.length) {
            transposedVector[i][0] = vector[i];
            ++i;
        }
        return transposedVector;
    }

    public static Rational[] transposeColumnToRowVector(Rational[][] vector) {
        Rational[] transposedVector = new Rational[vector.length];
        int i = 0;
        while (i < vector.length) {
            transposedVector[i] = vector[i][0];
            ++i;
        }
        return transposedVector;
    }

    public static Set<Set<Term>> joinSet(Set<Set<Term>> inSet, Set<Term> variable) {
        HashSet<Set<Term>> joinedSet = new HashSet<Set<Term>>(inSet);
        for (Set<Term> toBeJoined : inSet) {
            HashSet<Term> varJoin = new HashSet<Term>();
            varJoin.addAll(toBeJoined);
            varJoin.addAll(variable);
            joinedSet.add(varJoin);
        }
        return joinedSet;
    }

    public static BigInteger getLeastCommonMultiple(QvasrAbstraction qvasrAbstraction) {
        BigInteger lcm;
        BigInteger gcd = BigInteger.ZERO;
        BigInteger mult = BigInteger.ONE;
        int i = 0;
        while (i < qvasrAbstraction.getSimulationMatrix().length) {
            int j = 0;
            while (j < qvasrAbstraction.getSimulationMatrix()[0].length) {
                Rational rational = qvasrAbstraction.getSimulationMatrix()[i][j];
                if (!rational.isIntegral()) {
                    gcd = Rational.gcd((BigInteger)gcd, (BigInteger)rational.denominator());
                    mult = mult.multiply(rational.denominator());
                }
                ++j;
            }
            ++i;
        }
        for (Pair<Rational[], Rational[]> transformer : qvasrAbstraction.getVasr().getTransformer()) {
            Rational[] additionVector = (Rational[])transformer.getSecond();
            int k = 0;
            while (k < additionVector.length) {
                if (!additionVector[k].isIntegral()) {
                    gcd = Rational.gcd((BigInteger)gcd, (BigInteger)additionVector[k].denominator());
                    mult = mult.multiply(additionVector[k].denominator());
                }
                ++k;
            }
        }
        if (gcd == BigInteger.ZERO) {
            gcd = BigInteger.ONE;
        }
        if ((lcm = mult.divide(gcd)).equals(BigInteger.ONE)) {
            lcm = gcd;
        }
        return lcm;
    }

    public static IntvasrAbstraction qvasrAbstractionToInt(QvasrAbstraction qvasrAbstraction) {
        BigInteger lcm = QvasrUtils.getLeastCommonMultiple(qvasrAbstraction);
        Integer[][] integerSimulationMatrix = new Integer[qvasrAbstraction.getSimulationMatrix().length][qvasrAbstraction.getSimulationMatrix()[0].length];
        int i = 0;
        while (i < integerSimulationMatrix.length) {
            int j = 0;
            while (j < integerSimulationMatrix[0].length) {
                Rational oldRationalEntry = qvasrAbstraction.getSimulationMatrix()[i][j].mul(lcm);
                assert (oldRationalEntry.isIntegral());
                integerSimulationMatrix[i][j] = oldRationalEntry.numerator().intValue();
                ++j;
            }
            ++i;
        }
        Intvasr intVasr = new Intvasr();
        for (Pair<Rational[], Rational[]> transformer : qvasrAbstraction.getVasr().getTransformer()) {
            Integer[] resetVectorInt = new Integer[((Rational[])transformer.getFirst()).length];
            Integer[] additionVectorInt = new Integer[((Rational[])transformer.getFirst()).length];
            int i2 = 0;
            while (i2 < ((Rational[])transformer.getFirst()).length) {
                assert (((Rational[])transformer.getFirst())[i2].isIntegral());
                resetVectorInt[i2] = ((Rational[])transformer.getFirst())[i2].numerator().intValue();
                Rational oldRationalEntry = ((Rational[])transformer.getSecond())[i2].mul(lcm);
                assert (oldRationalEntry.isIntegral());
                additionVectorInt[i2] = oldRationalEntry.numerator().intValue();
                ++i2;
            }
            intVasr.addTransformer((Pair<Integer[], Integer[]>)new Pair((Object)resetVectorInt, (Object)additionVectorInt));
        }
        return new IntvasrAbstraction(integerSimulationMatrix, intVasr);
    }

    public static IntVasrsAbstraction qvasrsAbstactionToIntVasrsAbstraction(ManagedScript script, QvasrsAbstraction qvasrsAbstraction) {
        TermVariable intVar;
        BigInteger lcm = QvasrUtils.getLeastCommonMultiple(qvasrsAbstraction.getAbstraction());
        IntvasrAbstraction intVasrAbstraction = QvasrUtils.qvasrAbstractionToInt(qvasrsAbstraction.getAbstraction());
        HashMap<IProgramVar, TermVariable> intInVars = new HashMap<IProgramVar, TermVariable>();
        HashMap<IProgramVar, TermVariable> intOutVars = new HashMap<IProgramVar, TermVariable>();
        HashMap<Term, TermVariable> inVarSub = new HashMap<Term, TermVariable>();
        for (Map.Entry<IProgramVar, TermVariable> inVar : qvasrsAbstraction.getInVars().entrySet()) {
            intVar = script.constructFreshTermVariable(inVar.getValue().getName(), SmtSortUtils.getIntSort((ManagedScript)script));
            intInVars.put(inVar.getKey(), intVar);
            inVarSub.put((Term)inVar.getValue(), intVar);
        }
        for (Map.Entry<IProgramVar, TermVariable> outVar : qvasrsAbstraction.getOutVars().entrySet()) {
            intVar = script.constructFreshTermVariable(outVar.getValue().getName(), SmtSortUtils.getIntSort((ManagedScript)script));
            intOutVars.put(outVar.getKey(), intVar);
            inVarSub.put((Term)outVar.getValue(), intVar);
        }
        IntVasrsAbstraction intVasrsAbstraction = new IntVasrsAbstraction(intVasrAbstraction, qvasrsAbstraction.getStates(), intInVars, intOutVars, qvasrsAbstraction.getPreState(), qvasrsAbstraction.getPostState());
        HashSet<Term> intStates = new HashSet<Term>();
        for (Triple<Term, Pair<Rational[], Rational[]>, Term> transition : qvasrsAbstraction.getTransitions()) {
            Term intSource = Substitution.apply((ManagedScript)script, inVarSub, (Term)((Term)transition.getFirst()));
            Term intTarget = Substitution.apply((ManagedScript)script, inVarSub, (Term)((Term)transition.getThird()));
            intStates.add(intTarget);
            intStates.add(intSource);
            Integer[] resetVectorInt = new Integer[((Rational[])((Pair)transition.getSecond()).getFirst()).length];
            Integer[] additionVectorInt = new Integer[((Rational[])((Pair)transition.getSecond()).getFirst()).length];
            int i = 0;
            while (i < ((Rational[])((Pair)transition.getSecond()).getFirst()).length) {
                resetVectorInt[i] = ((Rational[])((Pair)transition.getSecond()).getFirst())[i].numerator().intValue();
                Rational oldRationalEntry = ((Rational[])((Pair)transition.getSecond()).getSecond())[i].mul(lcm);
                assert (oldRationalEntry.isIntegral());
                additionVectorInt[i] = oldRationalEntry.numerator().intValue();
                ++i;
            }
            Triple intTranstion = new Triple((Object)intSource, (Object)new Pair((Object)resetVectorInt, (Object)additionVectorInt), (Object)intTarget);
            intVasrsAbstraction.addTransition((Triple<Term, Pair<Integer[], Integer[]>, Term>)intTranstion);
        }
        intVasrsAbstraction.setStates(intStates);
        Term newPre = Substitution.apply((ManagedScript)script, inVarSub, (Term)qvasrsAbstraction.getPreState());
        Term newPost = Substitution.apply((ManagedScript)script, inVarSub, (Term)qvasrsAbstraction.getPostState());
        intVasrsAbstraction.setPreState(newPre);
        intVasrsAbstraction.setPostState(newPost);
        return intVasrsAbstraction;
    }
}

