/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr.QvasrUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public final class QvasrVectorSpaceBasisConstructor {
    private QvasrVectorSpaceBasisConstructor() {
    }

    public static Rational[][] computeVectorSpaceBasis(ManagedScript script, Term[][] basisVectors) {
        HashMap<Integer, TermVariable> tvsForColumns = new HashMap<Integer, TermVariable>();
        HashMap<TermVariable, Integer> columnsForTvs = new HashMap<TermVariable, Integer>();
        int i = 0;
        while (i < basisVectors[0].length - 1) {
            TermVariable newTv = script.constructFreshTermVariable("s", SmtSortUtils.getRealSort((ManagedScript)script));
            tvsForColumns.put(i, newTv);
            columnsForTvs.put(newTv, i);
            ++i;
        }
        HashMap equations = new HashMap();
        HashSet<Object> freeVars = new HashSet<Object>();
        Term[] lastRow = basisVectors[basisVectors.length - 1];
        boolean aIsZero = true;
        int i2 = 0;
        while (i2 < basisVectors.length) {
            if (!QvasrUtils.checkTermEquiv(script, basisVectors[i2][basisVectors[0].length - 1], script.getScript().decimal("0"))) {
                int j = 0;
                while (j < basisVectors[i2].length - 1) {
                    if (!QvasrUtils.checkTermEquiv(script, basisVectors[i2][j], script.getScript().decimal("0"))) {
                        aIsZero = false;
                        break;
                    }
                    ++j;
                }
            }
            ++i2;
        }
        TermVariable a = script.constructFreshTermVariable("a", SmtSortUtils.getRealSort((ManagedScript)script));
        ArrayList<Object> defaultInit = new ArrayList<Object>();
        if (!aIsZero) {
            defaultInit.add(a);
            freeVars.add(a);
        } else {
            defaultInit.add(script.getScript().decimal("0"));
        }
        tvsForColumns.put(lastRow.length - 1, a);
        columnsForTvs.put(a, lastRow.length - 1);
        equations.put(a, defaultInit);
        int j = 0;
        while (j < basisVectors.length) {
            Term[] row = basisVectors[j];
            int k = 0;
            while (k < row.length - 1) {
                if (!QvasrUtils.checkTermEquiv(script, row[k], script.getScript().decimal("0"))) {
                    Term term = (Term)tvsForColumns.get(k);
                    ArrayList<Term> arrayList = new ArrayList<Term>();
                    arrayList.add(SmtUtils.mul((Script)script.getScript(), (String)"*", (Term[])new Term[]{row[row.length - 1], (Term)tvsForColumns.get(basisVectors[0].length - 1)}));
                    int l = k + 1;
                    while (l < row.length - 1) {
                        Term correspondingVar = (Term)tvsForColumns.get(l);
                        Term mul = SmtUtils.mul((Script)script.getScript(), (String)"*", (Term[])new Term[]{row[l], correspondingVar});
                        arrayList.add(SmtUtils.minus((Script)script.getScript(), (Term[])new Term[]{script.getScript().decimal("0"), mul}));
                        ++l;
                    }
                    equations.put(term, arrayList);
                    break;
                }
                ++k;
            }
            ++j;
        }
        for (Term var : tvsForColumns.values()) {
            if (equations.containsKey(var)) continue;
            ArrayList<Term> defaultInitVars = new ArrayList<Term>();
            defaultInitVars.add(var);
            equations.put(var, defaultInitVars);
            freeVars.add(var);
        }
        ArrayDeque<Object> freeVarStack = new ArrayDeque<Object>();
        freeVarStack.addAll(freeVars);
        ArrayList<Term[]> vectors = new ArrayList<Term[]>();
        while (!freeVarStack.isEmpty()) {
            Term current = (Term)freeVarStack.pop();
            HashMap<Term, Term> hashMap = new HashMap<Term, Term>();
            for (Term term : freeVars) {
                if (term != current) {
                    hashMap.put(term, script.getScript().decimal("0"));
                    continue;
                }
                hashMap.put(term, term);
            }
            Term[] termArray = new Term[basisVectors[0].length];
            for (Map.Entry solution : equations.entrySet()) {
                Term tv = (Term)solution.getKey();
                int position = (Integer)columnsForTvs.get(tv);
                ArrayList<Term> summands = new ArrayList<Term>();
                for (Term equation : (List)solution.getValue()) {
                    Term equationUpdated = Substitution.apply((ManagedScript)script, hashMap, (Term)equation);
                    summands.add(equationUpdated);
                }
                Term sum = summands.size() > 1 ? SmtUtils.sum((Script)script.getScript(), (String)"+", (Term[])summands.toArray(new Term[summands.size()])) : (Term)summands.get(0);
                termArray[position] = sum;
            }
            vectors.add(termArray);
        }
        HashMap<Term, Term> assignments = new HashMap<Term, Term>();
        for (Term term : freeVars) {
            Term assignment = script.getScript().decimal("1");
            assignments.put(term, assignment);
        }
        ArrayList<Term[]> arrayList = new ArrayList<Term[]>();
        for (Term[] termArray : vectors) {
            Term[] vectorAssigned = new Term[termArray.length];
            int i3 = 0;
            while (i3 < termArray.length) {
                Term assigned;
                Term entry = termArray[i3];
                vectorAssigned[i3] = assigned = Substitution.apply((ManagedScript)script, assignments, (Term)entry);
                ++i3;
            }
            arrayList.add(vectorAssigned);
        }
        if (arrayList.isEmpty()) {
            return new Rational[0][0];
        }
        return QvasrVectorSpaceBasisConstructor.toRational(arrayList);
    }

    private static Rational[][] toRational(List<Term[]> basisVectors) {
        Rational[][] basisRational = new Rational[basisVectors.size()][basisVectors.get(0).length];
        int i = 0;
        while (i < basisVectors.size()) {
            Term[] basisVector = basisVectors.get(i);
            int j = 0;
            while (j < basisVector.length) {
                Rational entryAsRational;
                Term entry = basisVector[j];
                if (!(entry instanceof ConstantTerm)) {
                    throw new UnsupportedOperationException("Basisvector must contain only constants!");
                }
                ConstantTerm entryConst = (ConstantTerm)entry;
                basisRational[i][j] = entryAsRational = (Rational)entryConst.getValue();
                ++j;
            }
            ++i;
        }
        return basisRational;
    }

    private static boolean isConsistent(ManagedScript script, Term[][] basisVectors) {
        int i = 0;
        while (i < basisVectors.length) {
            Term[] row = basisVectors[i];
            if (!QvasrUtils.checkTermEquiv(script, row[row.length - 1], script.getScript().decimal("0"))) {
                int j = 0;
                while (j < row.length) {
                    if (j == row.length - 1 && row[j] instanceof ConstantTerm) {
                        return false;
                    }
                    if (!QvasrUtils.checkTermEquiv(script, row[j], script.getScript().decimal("0"))) break;
                    ++j;
                }
            }
            ++i;
        }
        return true;
    }
}

