/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasrs;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr.IntvasrAbstraction;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasrs.IVasrsAbstraction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class IntVasrsAbstraction
implements IVasrsAbstraction<Integer> {
    private final IntvasrAbstraction mIntVasrAbstraction;
    private final Integer[][] mSimulationMatrix;
    private Set<Term> mStates;
    private final Set<Triple<Term, Pair<Integer[], Integer[]>, Term>> mTransitions;
    private Term mPreCon;
    private Term mPostCon;
    private final Map<IProgramVar, TermVariable> mInVars;
    private final Map<IProgramVar, TermVariable> mOutVars;

    public IntVasrsAbstraction(IntvasrAbstraction abstraction, Set<Term> states, Map<IProgramVar, TermVariable> inVars, Map<IProgramVar, TermVariable> outVars) {
        this.mIntVasrAbstraction = abstraction;
        this.mSimulationMatrix = abstraction.getSimulationMatrix();
        this.mStates = states;
        this.mTransitions = new HashSet<Triple<Term, Pair<Integer[], Integer[]>, Term>>();
        this.mPreCon = null;
        this.mPostCon = null;
        this.mInVars = inVars;
        this.mOutVars = outVars;
    }

    public IntVasrsAbstraction(IntvasrAbstraction abstraction, Set<Term> states, Map<IProgramVar, TermVariable> inVars, Map<IProgramVar, TermVariable> outVars, Term preCondition, Term postCondition) {
        this.mIntVasrAbstraction = abstraction;
        this.mSimulationMatrix = abstraction.getSimulationMatrix();
        this.mStates = states;
        this.mTransitions = new HashSet<Triple<Term, Pair<Integer[], Integer[]>, Term>>();
        this.mPreCon = preCondition;
        this.mPostCon = postCondition;
        this.mInVars = inVars;
        this.mOutVars = outVars;
    }

    @Override
    public void addTransition(Triple<Term, Pair<Integer[], Integer[]>, Term> transition) {
        this.mTransitions.add(transition);
    }

    @Override
    public Set<Term> getStates() {
        return this.mStates;
    }

    public IntvasrAbstraction getAbstraction() {
        return this.mIntVasrAbstraction;
    }

    @Override
    public Set<Triple<Term, Pair<Integer[], Integer[]>, Term>> getTransitions() {
        return this.mTransitions;
    }

    public Integer[][] getSimulationMatrix() {
        return this.mSimulationMatrix;
    }

    public void setStates(Set<Term> states) {
        this.mStates = states;
    }

    @Override
    public void setPreState(Term pre) {
        this.mPreCon = pre;
    }

    @Override
    public void setPostState(Term post) {
        this.mPostCon = post;
    }

    @Override
    public Term getPreState() {
        return this.mPreCon;
    }

    @Override
    public Term getPostState() {
        return this.mPostCon;
    }

    @Override
    public Map<IProgramVar, TermVariable> getInVars() {
        return this.mInVars;
    }

    @Override
    public Map<IProgramVar, TermVariable> getOutVars() {
        return this.mOutVars;
    }

    @Override
    public void setPrePostStates() {
        HashSet<Term> possiblePreStates = new HashSet<Term>(this.mStates);
        HashSet<Term> possiblePostStates = new HashSet<Term>(this.mStates);
        for (Triple<Term, Pair<Integer[], Integer[]>, Term> transition : this.mTransitions) {
            if (transition.getFirst() == transition.getThird()) continue;
            possiblePreStates.remove(transition.getFirst());
            possiblePostStates.remove(transition.getThird());
        }
        this.mPreCon = possiblePreStates.toArray(new Term[1])[0];
        this.mPostCon = possiblePostStates.toArray(new Term[1])[0];
    }
}

