/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasrs;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr.QvasrAbstraction;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasrs.IVasrsAbstraction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class QvasrsAbstraction
implements IVasrsAbstraction<Rational> {
    private final QvasrAbstraction mQvasrAbstraction;
    private final Rational[][] mSimulationMatrix;
    private final Set<Term> mStates;
    private final Set<Triple<Term, Pair<Rational[], Rational[]>, Term>> mTransitions;
    private Term mPreCon;
    private Term mPostCon;
    private final Map<IProgramVar, TermVariable> mInVars;
    private final Map<IProgramVar, TermVariable> mOutVars;

    public QvasrsAbstraction(QvasrAbstraction abstraction, Set<Term> states, Map<IProgramVar, TermVariable> inVars, Map<IProgramVar, TermVariable> outVars) {
        this.mQvasrAbstraction = abstraction;
        this.mSimulationMatrix = abstraction.getSimulationMatrix();
        this.mStates = states;
        this.mTransitions = new HashSet<Triple<Term, Pair<Rational[], Rational[]>, Term>>();
        this.mPreCon = null;
        this.mPostCon = null;
        this.mInVars = inVars;
        this.mOutVars = outVars;
    }

    @Override
    public void addTransition(Triple<Term, Pair<Rational[], Rational[]>, Term> transition) {
        this.mTransitions.add(transition);
    }

    public QvasrAbstraction getAbstraction() {
        return this.mQvasrAbstraction;
    }

    @Override
    public Set<Term> getStates() {
        return this.mStates;
    }

    @Override
    public Set<Triple<Term, Pair<Rational[], Rational[]>, Term>> getTransitions() {
        return this.mTransitions;
    }

    public Rational[][] getSimulationMatrix() {
        return this.mSimulationMatrix;
    }

    @Override
    public Term getPreState() {
        return this.mPreCon;
    }

    @Override
    public Term getPostState() {
        return this.mPostCon;
    }

    @Override
    public void setPreState(Term pre) {
        this.mPreCon = pre;
    }

    @Override
    public void setPostState(Term post) {
        this.mPostCon = post;
    }

    @Override
    public Map<IProgramVar, TermVariable> getInVars() {
        return this.mInVars;
    }

    @Override
    public Map<IProgramVar, TermVariable> getOutVars() {
        return this.mOutVars;
    }

    @Override
    public void setPrePostStates() {
        HashSet<Term> possiblePreStates = new HashSet<Term>(this.mStates);
        HashSet<Term> possiblePostStates = new HashSet<Term>(this.mStates);
        for (Triple<Term, Pair<Rational[], Rational[]>, Term> transition : this.mTransitions) {
            if (transition.getFirst() == transition.getThird()) continue;
            possiblePreStates.remove(transition.getFirst());
            possiblePostStates.remove(transition.getThird());
        }
        this.mPreCon = possiblePreStates.toArray(new Term[1])[0];
        this.mPostCon = possiblePostStates.toArray(new Term[1])[0];
    }
}

