/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasrs;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.IIcfgTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.ILocationFactory;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.ITransformulaTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.IcfgTransformationBacktranslator;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.TransformedIcfgBuilder;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr.QvasrUtils;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasrs.IntVasrsAbstraction;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasrs.QvasrsSummarizer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.werner.Backbone;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.werner.Loop;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.werner.LoopDetector;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.BasicIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgReturnTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocationIterator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.debugidentifiers.DebugIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.debugidentifiers.StringDebugIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class QvasrsIcfgTransformer<INLOC extends IcfgLocation, OUTLOC extends IcfgLocation>
implements IIcfgTransformer<OUTLOC> {
    private final ILogger mLogger;
    private final ManagedScript mScript;
    private final IUltimateServiceProvider mServices;
    private final IIcfg<OUTLOC> mResult;
    private final IcfgTransformationBacktranslator mBackTranslationTracker;

    public QvasrsIcfgTransformer(ILogger logger, IIcfg<INLOC> originalIcfg, Class<OUTLOC> outLocationClass, ILocationFactory<INLOC, OUTLOC> funLocFac, String newIcfgIdentifier, ITransformulaTransformer transformer, IcfgTransformationBacktranslator backtranslationTracker, IUltimateServiceProvider services) {
        this.mLogger = logger;
        this.mServices = services;
        this.mScript = originalIcfg.getCfgSmtToolkit().getManagedScript();
        this.mBackTranslationTracker = backtranslationTracker;
        this.mResult = this.transform(originalIcfg, funLocFac, backtranslationTracker, outLocationClass, newIcfgIdentifier, transformer);
    }

    private IIcfg<OUTLOC> transform(IIcfg<INLOC> originalIcfg, ILocationFactory<INLOC, OUTLOC> funLocFac, IcfgTransformationBacktranslator backtranslationTracker, Class<OUTLOC> outLocationClass, String newIcfgIdentifier, ITransformulaTransformer transformer) {
        transformer.preprocessIcfg(originalIcfg);
        BasicIcfg resultIcfg = new BasicIcfg(newIcfgIdentifier, originalIcfg.getCfgSmtToolkit(), outLocationClass);
        TransformedIcfgBuilder<INLOC, OUTLOC> lst = new TransformedIcfgBuilder<INLOC, OUTLOC>(this.mLogger, funLocFac, backtranslationTracker, transformer, originalIcfg, resultIcfg);
        this.processLocations(originalIcfg, originalIcfg.getInitialNodes(), lst, funLocFac);
        lst.finish();
        return resultIcfg;
    }

    private void processLocations(IIcfg<INLOC> originalIcfg, Set<INLOC> init, TransformedIcfgBuilder<INLOC, OUTLOC> lst, ILocationFactory<INLOC, OUTLOC> funLocFac) {
        Set loopHeads = originalIcfg.getLoopLocations();
        HashMap<IcfgLocation, IntVasrsAbstraction> qvasrsAbstractions = new HashMap<IcfgLocation, IntVasrsAbstraction>();
        LoopDetector<INLOC> detecWerner = new LoopDetector<INLOC>(this.mLogger, originalIcfg, originalIcfg.getLoopLocations(), this.mScript, this.mServices, 0);
        Map<IcfgLocation, Loop> loopWer = detecWerner.getLoopBodies();
        HashMap<IcfgLocation, UnmodifiableTransFormula> loopsWithLoopHead = new HashMap<IcfgLocation, UnmodifiableTransFormula>();
        for (Map.Entry<IcfgLocation, Loop> loopMap : loopWer.entrySet()) {
            Deque<Backbone> distinctLoopPaths = loopMap.getValue().getBackbones();
            UnmodifiableTransFormula[] distinctPathsFormulas = new UnmodifiableTransFormula[distinctLoopPaths.size()];
            int i = 0;
            Iterator iterator = distinctLoopPaths.iterator();
            while (iterator.hasNext()) {
                Backbone distinctLoopPath = (Backbone)iterator.next();
                distinctPathsFormulas[i] = (UnmodifiableTransFormula)distinctLoopPath.getFormula();
                ++i;
            }
            UnmodifiableTransFormula loopDisjunction = TransFormulaUtils.parallelComposition((ILogger)this.mLogger, (IUltimateServiceProvider)this.mServices, (ManagedScript)this.mScript, null, (boolean)false, (SmtUtils.XnfConversionTechnique)SmtUtils.XnfConversionTechnique.BOTTOM_UP_WITH_LOCAL_SIMPLIFICATION, (boolean)false, (UnmodifiableTransFormula[])distinctPathsFormulas);
            this.mLogger.warn((Object)loopDisjunction.toStringDirect());
            loopsWithLoopHead.put(loopMap.getKey(), loopDisjunction);
        }
        QvasrsSummarizer qvasrsSummarizer = new QvasrsSummarizer(this.mLogger, this.mServices, this.mScript);
        for (Map.Entry entry : loopsWithLoopHead.entrySet()) {
            qvasrsAbstractions.put((IcfgLocation)entry.getKey(), QvasrUtils.qvasrsAbstactionToIntVasrsAbstraction(this.mScript, qvasrsSummarizer.computeQvasrsAbstraction((UnmodifiableTransFormula)entry.getValue(), true)));
        }
        IcfgLocationIterator icfgLocationIterator = new IcfgLocationIterator(init);
        ArrayList<Triple> rtrTransitions = new ArrayList<Triple>();
        while (icfgLocationIterator.hasNext()) {
            IcfgLocation oldSource = icfgLocationIterator.next();
            if (loopHeads.contains(oldSource)) {
                IcfgLocation stateState;
                int i = 0;
                IntVasrsAbstraction abstraction = (IntVasrsAbstraction)qvasrsAbstractions.get(oldSource);
                HashMap<Term, IcfgLocation> qvasrsStateToLoc = new HashMap<Term, IcfgLocation>();
                for (Term state : abstraction.getStates()) {
                    StringDebugIdentifier id = new StringDebugIdentifier("QVASRSnode " + Integer.toString(i));
                    IcfgLocation newLoc = new IcfgLocation((DebugIdentifier)id, oldSource.getProcedure());
                    qvasrsStateToLoc.put(state, newLoc);
                    ++i;
                }
                Term[] inVarsReal = abstraction.getInVars().values().toArray(new Term[abstraction.getInVars().size()]);
                Term[] outVarsReal = abstraction.getOutVars().values().toArray(new Term[abstraction.getOutVars().size()]);
                Term[][] variableRelationsIn = QvasrUtils.matrixVectorMultiplicationWithVariables(this.mScript, abstraction.getSimulationMatrix(), QvasrUtils.transposeRowToColumnTermVector(inVarsReal));
                Term[][] variableRelationsOut = QvasrUtils.matrixVectorMultiplicationWithVariables(this.mScript, abstraction.getSimulationMatrix(), QvasrUtils.transposeRowToColumnTermVector(outVarsReal));
                for (Triple<Term, Pair<Integer[], Integer[]>, Term> transformer : abstraction.getTransitions()) {
                    IcfgLocation newStart = (IcfgLocation)qvasrsStateToLoc.get(transformer.getFirst());
                    IcfgLocation newTarget = (IcfgLocation)qvasrsStateToLoc.get(transformer.getThird());
                    int dimension = 0;
                    while (dimension < ((Integer[])((Pair)transformer.getSecond()).getFirst()).length) {
                        TermVariable freshVar;
                        HashSet<Term> dimensionConjunction = new HashSet<Term>();
                        Integer dimensionReset = ((Integer[])((Pair)transformer.getSecond()).getFirst())[dimension];
                        Integer dimensionAddition = ((Integer[])((Pair)transformer.getSecond()).getSecond())[dimension];
                        if (dimensionReset == 0) {
                            Term equality = SmtUtils.binaryEquality((Script)this.mScript.getScript(), (Term)variableRelationsOut[dimension][0], (Term)this.mScript.getScript().numeral(dimensionAddition.toString()));
                            dimensionConjunction.add(equality);
                        } else {
                            Term addition = SmtUtils.sum((Script)this.mScript.getScript(), (String)"+", (Term[])new Term[]{variableRelationsIn[dimension][0], this.mScript.getScript().decimal(dimensionAddition.toString())});
                            Term equality = SmtUtils.binaryEquality((Script)this.mScript.getScript(), (Term)variableRelationsOut[dimension][0], (Term)addition);
                            dimensionConjunction.add(equality);
                        }
                        Term transitionConjunction = SmtUtils.and((Script)this.mScript.getScript(), dimensionConjunction);
                        transitionConjunction = SmtUtils.and((Script)this.mScript.getScript(), (Term[])new Term[]{transitionConjunction, (Term)transformer.getThird()});
                        HashMap<IProgramVar, TermVariable> freshInvars = new HashMap<IProgramVar, TermVariable>();
                        HashMap<IProgramVar, TermVariable> freshOutvars = new HashMap<IProgramVar, TermVariable>();
                        HashMap<Term, TermVariable> freshVars = new HashMap<Term, TermVariable>();
                        for (Map.Entry<IProgramVar, TermVariable> oldInvars : abstraction.getInVars().entrySet()) {
                            freshVar = this.mScript.constructFreshCopy(oldInvars.getValue());
                            freshInvars.put(oldInvars.getKey(), freshVar);
                            freshVars.put((Term)oldInvars.getValue(), freshVar);
                        }
                        for (Map.Entry<IProgramVar, TermVariable> oldOutvars : abstraction.getOutVars().entrySet()) {
                            freshVar = this.mScript.constructFreshCopy(oldOutvars.getValue());
                            freshOutvars.put(oldOutvars.getKey(), freshVar);
                            freshVars.put((Term)oldOutvars.getValue(), freshVar);
                        }
                        TransFormulaBuilder tfb = new TransFormulaBuilder(freshInvars, freshOutvars, true, null, true, null, true);
                        tfb.setFormula(Substitution.apply((ManagedScript)this.mScript, freshVars, (Term)transitionConjunction));
                        tfb.setInfeasibility(UnmodifiableTransFormula.Infeasibility.NOT_DETERMINED);
                        UnmodifiableTransFormula transtition = tfb.finishConstruction(this.mScript);
                        lst.createNewInternalTransition(newStart, newTarget, transtition, false);
                        ++dimension;
                    }
                }
                IcfgLocation newSource = lst.createNewLocation(oldSource);
                IcfgLocation possibleExits = loopWer.get(oldSource).getLoopExit();
                IcfgLocation newTarget = lst.createNewLocation(possibleExits);
                UnmodifiableTransFormula exitTranstition = QvasrUtils.buildFormula(this.mScript, abstraction.getPostState(), abstraction.getOutVars(), abstraction.getOutVars());
                lst.createNewInternalTransition(newSource, newTarget, exitTranstition, false);
                for (Term state : abstraction.getStates()) {
                    UnmodifiableTransFormula entryTransition = QvasrUtils.buildFormula(this.mScript, abstraction.getPreState(), abstraction.getInVars(), abstraction.getInVars());
                    stateState = (IcfgLocation)qvasrsStateToLoc.get(state);
                    lst.createNewInternalTransition(newSource, stateState, entryTransition, false);
                }
                for (Term state : abstraction.getStates()) {
                    UnmodifiableTransFormula exitTransition = QvasrUtils.buildFormula(this.mScript, abstraction.getPostState(), abstraction.getOutVars(), abstraction.getOutVars());
                    stateState = (IcfgLocation)qvasrsStateToLoc.get(state);
                    lst.createNewInternalTransition(stateState, newTarget, exitTransition, false);
                }
                continue;
            }
            for (IcfgEdge oldTransition : oldSource.getOutgoingEdges()) {
                IcfgLocation newSource = lst.createNewLocation(oldSource);
                IcfgLocation newTarget = lst.createNewLocation((IcfgLocation)oldTransition.getTarget());
                if (oldTransition instanceof IIcfgReturnTransition) {
                    rtrTransitions.add(new Triple((Object)newSource, (Object)newTarget, (Object)oldTransition));
                    continue;
                }
                lst.createNewTransition(newSource, newTarget, oldTransition);
            }
        }
        rtrTransitions.forEach(a -> {
            IcfgEdge icfgEdge = lst.createNewTransition((IcfgLocation)a.getFirst(), (IcfgLocation)a.getSecond(), (IcfgEdge)a.getThird());
        });
    }

    private UnmodifiableTransFormula edgesToFormula(Deque<IcfgEdge> loopEdges) {
        ArrayList<UnmodifiableTransFormula> edgeTransitions = new ArrayList<UnmodifiableTransFormula>();
        for (IcfgEdge edge : loopEdges) {
            edgeTransitions.add(edge.getTransformula());
        }
        return TransFormulaUtils.sequentialComposition((ILogger)this.mLogger, (IUltimateServiceProvider)this.mServices, (ManagedScript)this.mScript, (boolean)true, (boolean)true, (boolean)false, (SmtUtils.XnfConversionTechnique)SmtUtils.XnfConversionTechnique.BOTTOM_UP_WITH_LOCAL_SIMPLIFICATION, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.POLY_PAC, edgeTransitions);
    }

    @Override
    public IIcfg<OUTLOC> getResult() {
        return this.mResult;
    }
}

