/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasrs;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasrs.QvasrsReach;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasrs.QvasrsSummarizer;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Term;

public class QvasrsLoopSummarization {
    private final ILogger mLogger;
    private final IUltimateServiceProvider mServices;
    private final ManagedScript mScript;

    public QvasrsLoopSummarization(ILogger logger, IUltimateServiceProvider services, ManagedScript script) {
        this.mLogger = logger;
        this.mServices = services;
        this.mScript = script;
    }

    public UnmodifiableTransFormula getQvasrsAcceleration(UnmodifiableTransFormula loopTransitionFormula, boolean usedInIcfgTransformation) {
        if (!SmtUtils.isArrayFree((Term)loopTransitionFormula.getFormula())) {
            throw new UnsupportedOperationException("Qvasrs do not support arrays.");
        }
        QvasrsSummarizer qvasrsSummarizer = new QvasrsSummarizer(this.mLogger, this.mServices, this.mScript);
        return QvasrsReach.reach(qvasrsSummarizer.computeQvasrsAbstraction(loopTransitionFormula, false), this.mScript);
    }
}

