/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasrs;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasrs.QvasrsAbstraction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class QvasrsReach {
    private QvasrsReach() {
    }

    public static UnmodifiableTransFormula reach(QvasrsAbstraction qvasrsAbstraction, ManagedScript script) {
        ArrayList<TermVariable> parikhVars = new ArrayList<TermVariable>();
        ArrayList<TermVariable> permutationVars = new ArrayList<TermVariable>();
        Set<Triple<Term, Pair<Rational[], Rational[]>, Term>> transitions = qvasrsAbstraction.getTransitions();
        int k = transitions.size();
        int i = 0;
        while (i < k) {
            int j = 0;
            while (j < k) {
                TermVariable alpha = script.constructFreshTermVariable("alpha " + i + " " + j, SmtSortUtils.getIntSort((ManagedScript)script));
                parikhVars.add(alpha);
                ++j;
            }
            TermVariable sigma = script.constructFreshTermVariable("sigma " + i, SmtSortUtils.getIntSort((ManagedScript)script));
            permutationVars.add(sigma);
            ++i;
        }
        QvasrsReach.computePhiPerm(permutationVars, script, k);
        ArrayList<TermVariable> stateSpaceVarsStart = new ArrayList<TermVariable>();
        ArrayList<TermVariable> stateSpaceVarsTarget = new ArrayList<TermVariable>();
        int i2 = 0;
        while (i2 < qvasrsAbstraction.getStates().size()) {
            TermVariable s = script.constructFreshTermVariable("s " + i2, SmtSortUtils.getIntSort((ManagedScript)script));
            TermVariable t = script.constructFreshTermVariable("s " + i2, SmtSortUtils.getIntSort((ManagedScript)script));
            stateSpaceVarsStart.add(s);
            stateSpaceVarsTarget.add(t);
            ++i2;
        }
        TermVariable p = script.constructFreshTermVariable("p", SmtSortUtils.getIntSort((ManagedScript)script));
        QvasrsReach.computePhiStates(permutationVars, p, qvasrsAbstraction, k, stateSpaceVarsStart, stateSpaceVarsTarget, script);
        ArrayList<List<TermVariable>> flows = new ArrayList<List<TermVariable>>();
        int i3 = 0;
        while (i3 < k) {
            ArrayList<TermVariable> flowI = new ArrayList<TermVariable>();
            int j = 0;
            while (j < transitions.size()) {
                TermVariable xI = script.constructFreshTermVariable("x " + i3 + " " + j, SmtSortUtils.getIntSort((ManagedScript)script));
                flowI.add(xI);
                ++j;
            }
            flows.add(flowI);
            ++i3;
        }
        QvasrsReach.computePhiFlows(permutationVars, p, qvasrsAbstraction, k, flows, script);
        return null;
    }

    private static Term computePhiPerm(List<TermVariable> permutationVars, ManagedScript script, int k) {
        HashSet<Term> phiPermConjuncts = new HashSet<Term>();
        Term kTerm = script.getScript().decimal(Integer.toString(k));
        int i = 0;
        while (i < k) {
            Term iTv = script.getScript().numeral(Integer.toString(i));
            HashSet<Term> iPermConjunctions = new HashSet<Term>();
            TermVariable sigma = permutationVars.get(i);
            Term leq = SmtUtils.leq((Script)script.getScript(), (Term)script.getScript().numeral("1"), (Term)sigma);
            Term req = SmtUtils.leq((Script)script.getScript(), (Term)sigma, (Term)kTerm);
            iPermConjunctions.add(req);
            iPermConjunctions.add(leq);
            int j = 0;
            while (j < k) {
                if (i != j) {
                    Term jTv = script.getScript().numeral(Integer.toString(j));
                    TermVariable sigmaJ = permutationVars.get(j);
                    Term iNeqJ = SmtUtils.not((Script)script.getScript(), (Term)script.getScript().term("=", new Term[]{iTv, jTv}));
                    Term sigINeqSigJ = SmtUtils.not((Script)script.getScript(), (Term)script.getScript().term("=", new Term[]{sigma, sigmaJ}));
                    iPermConjunctions.add(SmtUtils.implies((Script)script.getScript(), (Term)iNeqJ, (Term)sigINeqSigJ));
                }
                ++j;
            }
            Term iPermConjunction = SmtUtils.and((Script)script.getScript(), iPermConjunctions);
            phiPermConjuncts.add(iPermConjunction);
            ++i;
        }
        return SmtUtils.and((Script)script.getScript(), phiPermConjuncts);
    }

    private static Term computePhiStates(List<TermVariable> permutationVars, TermVariable p, QvasrsAbstraction qvasrsAbstraction, int k, List<TermVariable> stateSpaceVarsStart, List<TermVariable> stateSpaceVarsTarget, ManagedScript script) {
        ArrayList<TermVariable> transitions = new ArrayList<TermVariable>();
        int i = 0;
        while (i < qvasrsAbstraction.getTransitions().size()) {
            TermVariable transition = script.constructFreshTermVariable("a " + i, SmtSortUtils.getIntSort((ManagedScript)script));
            transitions.add(transition);
            ++i;
        }
        ArrayList<Term> phiStatesConjuncts = new ArrayList<Term>();
        int i2 = 1;
        while (i2 < k) {
            Term iTv = script.getScript().numeral(Integer.toString(i2));
            Term iLeqP = SmtUtils.leq((Script)script.getScript(), (Term)iTv, (Term)p);
            Term sPrevEqTPrev = SmtUtils.binaryBooleanEquality((Script)script.getScript(), (Term)((Term)stateSpaceVarsStart.get(i2 - 1)), (Term)((Term)stateSpaceVarsTarget.get(i2 - 1)));
            Term tPrevEqS = SmtUtils.binaryBooleanEquality((Script)script.getScript(), (Term)((Term)stateSpaceVarsTarget.get(i2 - 1)), (Term)((Term)stateSpaceVarsStart.get(i2)));
            Term lhs = SmtUtils.implies((Script)script.getScript(), (Term)iLeqP, (Term)SmtUtils.and((Script)script.getScript(), (Term[])new Term[]{sPrevEqTPrev, tPrevEqS}));
            Term pLessI = SmtUtils.less((Script)script.getScript(), (Term)p, (Term)iTv);
            Term rhs = SmtUtils.implies((Script)script.getScript(), (Term)pLessI, (Term)((Term)transitions.get(i2)));
            phiStatesConjuncts.add(SmtUtils.and((Script)script.getScript(), (Term[])new Term[]{lhs, rhs}));
            ++i2;
        }
        return SmtUtils.and((Script)script.getScript(), phiStatesConjuncts);
    }

    private static Term computePhiFlows(List<TermVariable> permutationVars, TermVariable p, QvasrsAbstraction qvasrsAbstraction, int k, List<List<TermVariable>> flows, ManagedScript script) {
        ArrayList<Term> lhs = new ArrayList<Term>();
        int i = 0;
        while (i < k) {
            Term iTv = script.getScript().numeral(Integer.toString(i));
            Term iLessP = SmtUtils.less((Script)script.getScript(), (Term)iTv, (Term)p);
            List<TermVariable> flowsI = flows.get(i);
            Term sumFlowsZero = flowsI.size() > 1 ? SmtUtils.sum((Script)script.getScript(), (String)"+", (Term[])((Term[])flowsI.toArray(new TermVariable[flowsI.size()]))) : (Term)flowsI.get(0);
            sumFlowsZero = script.getScript().term("=", new Term[]{sumFlowsZero, script.getScript().numeral("0")});
            Term lhsImplication = SmtUtils.implies((Script)script.getScript(), (Term)iLessP, (Term)sumFlowsZero);
            lhs.add(lhsImplication);
            ++i;
        }
        Set<Triple<Term, Pair<Rational[], Rational[]>, Term>> transitions = qvasrsAbstraction.getTransitions();
        ArrayList<Term> rhs = new ArrayList<Term>();
        int i2 = 0;
        while (i2 < k) {
            Term iTv = script.getScript().numeral(Integer.toString(i2));
            Term iLeqP = SmtUtils.leq((Script)script.getScript(), (Term)p, (Term)iTv);
            ArrayList<Term> rhsConjuncts = new ArrayList<Term>();
            int j = 1;
            while (j < i2) {
                ArrayList<Term> transitionConjunction = new ArrayList<Term>();
                Iterator<Triple<Term, Pair<Rational[], Rational[]>, Term>> iterator = transitions.iterator();
                while (iterator.hasNext()) {
                    iterator.next();
                    TermVariable a = script.constructFreshTermVariable("a", SmtSortUtils.getIntSort((ManagedScript)script));
                    Term aEqualsSigma = script.getScript().term("=", new Term[]{a, (Term)permutationVars.get(j)});
                    Term transitionVarEqZero = script.getScript().term("=", new Term[]{(Term)flows.get(i2).get(j)});
                    transitionConjunction.add(SmtUtils.implies((Script)script.getScript(), (Term)aEqualsSigma, (Term)transitionVarEqZero));
                    rhsConjuncts.add(transitionVarEqZero);
                }
                ++j;
            }
            rhs.add(SmtUtils.implies((Script)script.getScript(), (Term)iLeqP, (Term)SmtUtils.and((Script)script.getScript(), rhsConjuncts)));
            ++i2;
        }
        return SmtUtils.and((Script)script.getScript(), (Term[])new Term[]{SmtUtils.and((Script)script.getScript(), lhs), SmtUtils.and((Script)script.getScript(), rhs)});
    }
}

