/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasrs;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr.IVasr;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr.Qvasr;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr.QvasrAbstraction;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr.QvasrAbstractionJoin;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr.QvasrAbstractor;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr.QvasrUtils;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasrs.QvasrsAbstraction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class QvasrsSummarizer {
    private final ILogger mLogger;
    private final ManagedScript mScript;
    private final IUltimateServiceProvider mServices;

    public QvasrsSummarizer(ILogger logger, IUltimateServiceProvider services, ManagedScript script) {
        this.mLogger = logger;
        this.mScript = script;
        this.mServices = services;
    }

    public QvasrsAbstraction computeQvasrsAbstraction(UnmodifiableTransFormula transitionFormula, boolean usedInIcfgTransformation) {
        Set<Term> disjuncts = QvasrUtils.splitDisjunction(transitionFormula.getFormula());
        HashSet<Term> guards = new HashSet<Term>();
        for (Term disjunct : disjuncts) {
            UnmodifiableTransFormula disTf = QvasrUtils.buildFormula(transitionFormula, disjunct, this.mScript);
            guards.add(TransFormulaUtils.computeGuard((UnmodifiableTransFormula)disTf, (ManagedScript)this.mScript, (IUltimateServiceProvider)this.mServices).getFormula());
        }
        disjuncts = guards;
        disjuncts = QvasrUtils.checkDisjoint(disjuncts, this.mScript, this.mServices, SmtUtils.SimplificationTechnique.SIMPLIFY_DDA);
        HashMap<Term, Term> outToInMap = new HashMap<Term, Term>();
        for (Map.Entry entry : transitionFormula.getOutVars().entrySet()) {
            if (transitionFormula.getInVars().containsKey(entry.getKey())) {
                outToInMap.put((Term)entry.getValue(), (Term)transitionFormula.getInVars().get(entry.getKey()));
                continue;
            }
            outToInMap.put((Term)entry.getValue(), (Term)entry.getValue());
        }
        HashSet<Triple> hashSet = new HashSet<Triple>();
        int tfDimension = transitionFormula.getAssignedVars().size();
        Rational[][] identityMatrix = QvasrUtils.getIdentityMatrix(tfDimension);
        QvasrAbstraction bestAbstraction = new QvasrAbstraction(identityMatrix, new Qvasr());
        for (Term pre : disjuncts) {
            Term preInvar = Substitution.apply((ManagedScript)this.mScript, outToInMap, (Term)pre);
            for (Term post : disjuncts) {
                Term conjunctionPreTfPost = SmtUtils.and((Script)this.mScript.getScript(), (Term[])new Term[]{preInvar, transitionFormula.getFormula(), post});
                UnmodifiableTransFormula conjunctionFormula = QvasrUtils.buildFormula(transitionFormula, conjunctionPreTfPost, this.mScript);
                Term conjunctionDNF = SmtUtils.toDnf((IUltimateServiceProvider)this.mServices, (ManagedScript)this.mScript, (Term)conjunctionFormula.getFormula(), (SmtUtils.XnfConversionTechnique)SmtUtils.XnfConversionTechnique.BOTTOM_UP_WITH_LOCAL_SIMPLIFICATION);
                Set<Term> disjunctsAbtraction = QvasrUtils.splitDisjunction(conjunctionDNF);
                QvasrAbstraction preTfPostAbstraction = new QvasrAbstraction(identityMatrix, new Qvasr());
                for (Term disjunct : disjunctsAbtraction) {
                    this.mLogger.warn((Object)disjunct.toStringDirect());
                    UnmodifiableTransFormula disjunctTf = QvasrUtils.buildFormula(transitionFormula, disjunct, this.mScript);
                    QvasrAbstraction qvasrAbstraction = QvasrAbstractor.computeAbstraction(this.mServices, this.mScript, disjunctTf);
                    preTfPostAbstraction = (QvasrAbstraction)QvasrAbstractionJoin.join(this.mScript, bestAbstraction, qvasrAbstraction).getThird();
                }
                Triple<Rational[][], Rational[][], QvasrAbstraction> abstractionWithSimulations = QvasrAbstractionJoin.join(this.mScript, bestAbstraction, preTfPostAbstraction);
                Pair prePostPair = new Pair((Object)pre, (Object)post);
                hashSet.add(new Triple((Object)prePostPair, preTfPostAbstraction.getVasr(), (Object)((Rational[][])abstractionWithSimulations.getSecond())));
                bestAbstraction = (QvasrAbstraction)QvasrAbstractionJoin.join(this.mScript, bestAbstraction, preTfPostAbstraction).getThird();
            }
        }
        HashMap<IProgramVar, TermVariable> inVarsReal = new HashMap<IProgramVar, TermVariable>();
        HashMap<IProgramVar, TermVariable> outVarsReal = new HashMap<IProgramVar, TermVariable>();
        for (IProgramVar assVar : transitionFormula.getOutVars().keySet()) {
            if (transitionFormula.getInVars().containsKey(assVar)) {
                inVarsReal.put(assVar, (TermVariable)transitionFormula.getInVars().get(assVar));
            } else if (transitionFormula.getOutVars().containsKey(assVar)) {
                inVarsReal.put(assVar, (TermVariable)transitionFormula.getOutVars().get(assVar));
            }
            if (!transitionFormula.getOutVars().containsKey(assVar)) continue;
            outVarsReal.put(assVar, (TermVariable)transitionFormula.getOutVars().get(assVar));
        }
        QvasrsAbstraction qvasrsAbstraction = new QvasrsAbstraction(bestAbstraction, disjuncts, inVarsReal, outVarsReal);
        for (Triple qvasrSimulationPair : hashSet) {
            Term pre = (Term)((Pair)qvasrSimulationPair.getFirst()).getFirst();
            Term post = (Term)((Pair)qvasrSimulationPair.getFirst()).getSecond();
            Qvasr qvasrImage = QvasrAbstractionJoin.image((IVasr)qvasrSimulationPair.getSecond(), (Rational[][])qvasrSimulationPair.getThird());
            for (Pair<Rational[], Rational[]> translatedTransformer : qvasrImage.getTransformer()) {
                Triple transition = new Triple((Object)pre, translatedTransformer, (Object)post);
                if (!this.checkIfTransitionIsAbsent((Triple<Term, Pair<Rational[], Rational[]>, Term>)transition, qvasrsAbstraction)) continue;
                qvasrsAbstraction.addTransition((Triple<Term, Pair<Rational[], Rational[]>, Term>)transition);
            }
        }
        if (usedInIcfgTransformation) {
            UnmodifiableTransFormula guard = TransFormulaUtils.computeGuard((UnmodifiableTransFormula)transitionFormula, (ManagedScript)this.mScript, (IUltimateServiceProvider)this.mServices);
            qvasrsAbstraction.setPreState(guard.getFormula());
            HashMap<Term, Term> subMap = new HashMap<Term, Term>();
            for (Map.Entry invars : transitionFormula.getInVars().entrySet()) {
                if (!transitionFormula.getOutVars().containsKey(invars.getKey())) continue;
                subMap.put((Term)invars.getValue(), (Term)transitionFormula.getOutVars().get(invars.getKey()));
            }
            Term postLoop = Substitution.apply((ManagedScript)this.mScript, subMap, (Term)guard.getFormula());
            qvasrsAbstraction.setPostState(SmtUtils.not((Script)this.mScript.getScript(), (Term)postLoop));
        }
        return qvasrsAbstraction;
    }

    private final boolean checkIfTransitionIsAbsent(Triple<Term, Pair<Rational[], Rational[]>, Term> transition, QvasrsAbstraction qvasrsAbstraction) {
        boolean absent = true;
        block0: for (Triple<Term, Pair<Rational[], Rational[]>, Term> t : qvasrsAbstraction.getTransitions()) {
            if (!QvasrUtils.checkTermEquiv(this.mScript, (Term)t.getFirst(), (Term)transition.getFirst()) && !QvasrUtils.checkTermEquiv(this.mScript, (Term)t.getThird(), (Term)transition.getThird())) continue;
            int i = 0;
            while (i < ((Rational[])((Pair)t.getSecond()).getFirst()).length) {
                if (((Rational[])((Pair)transition.getSecond()).getFirst())[i] != ((Rational[])((Pair)t.getSecond()).getFirst())[i] || ((Rational[])((Pair)transition.getSecond()).getSecond())[i] != ((Rational[])((Pair)t.getSecond()).getSecond())[i]) continue block0;
                absent = false;
                ++i;
            }
        }
        return absent;
    }

    private final Term substituteVars(Term termToBeSubbed, Map<IProgramVar, TermVariable> toBeSubstituted) {
        HashMap<TermVariable, TermVariable> sub = new HashMap<TermVariable, TermVariable>();
        for (Map.Entry<IProgramVar, TermVariable> old : toBeSubstituted.entrySet()) {
            sub.put(old.getKey().getTermVariable(), old.getValue());
        }
        return Substitution.apply((ManagedScript)this.mScript, sub, (Term)termToBeSubbed);
    }
}

