/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.werner;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.werner.SymbolicMemory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;

public class Backbone {
    private final Deque<IcfgEdge> mPath;
    private final Deque<IcfgLocation> mNodes;
    private final List<IcfgLocation> mNestedLoops;
    private TransFormula mFormula;
    private TermVariable mPathCounter;
    private UnmodifiableTransFormula mCondition;
    private SymbolicMemory mSymbolicMemory;
    private Term mAbstractPathCondition;
    private Boolean mIsNested;

    public Backbone(IcfgEdge trans) {
        this.mPath = new ArrayDeque<IcfgEdge>();
        this.mPath.addLast(trans);
        this.mNodes = new ArrayDeque<IcfgLocation>();
        this.mNodes.add((IcfgLocation)trans.getSource());
        this.mFormula = null;
        this.mPathCounter = null;
        this.mCondition = null;
        this.mSymbolicMemory = null;
        this.mNestedLoops = new ArrayList<IcfgLocation>();
        this.mIsNested = false;
        this.mAbstractPathCondition = null;
    }

    public Backbone(UnmodifiableTransFormula trans) {
        this.mPath = null;
        this.mNodes = null;
        this.mFormula = trans;
        this.mPathCounter = null;
        this.mCondition = null;
        this.mSymbolicMemory = null;
        this.mNestedLoops = new ArrayList<IcfgLocation>();
        this.mIsNested = false;
        this.mAbstractPathCondition = null;
    }

    public Backbone(Backbone source) {
        this.mPath = new ArrayDeque<IcfgEdge>(source.getPath());
        this.mNodes = new ArrayDeque<IcfgLocation>(source.getNodes());
        this.mFormula = null;
        this.mPathCounter = null;
        this.mCondition = null;
        this.mSymbolicMemory = null;
        this.mNestedLoops = new ArrayList<IcfgLocation>();
        this.mIsNested = false;
        this.mAbstractPathCondition = null;
    }

    public void setPathCounter(TermVariable pathCounter) {
        this.mPathCounter = pathCounter;
    }

    public void setCondition(UnmodifiableTransFormula condition) {
        this.mCondition = condition;
    }

    public void setFormula(TransFormula formula) {
        this.mFormula = formula;
    }

    public void setSymbolicMemory(SymbolicMemory memory) {
        this.mSymbolicMemory = memory;
    }

    public void setAbstractPathCondition(Term condition) {
        this.mAbstractPathCondition = condition;
    }

    public void addNestedLoop(IcfgLocation loopHead) {
        this.mNestedLoops.add(loopHead);
        this.mIsNested = true;
    }

    public void addTransition(IcfgEdge transition) {
        this.mPath.addLast(transition);
        this.mNodes.addLast((IcfgLocation)transition.getSource());
    }

    public Deque<IcfgEdge> getPath() {
        return this.mPath;
    }

    public Deque<IcfgLocation> getNodes() {
        return this.mNodes;
    }

    public TermVariable getPathCounter() {
        return this.mPathCounter;
    }

    public TransFormula getFormula() {
        return this.mFormula;
    }

    public UnmodifiableTransFormula getCondition() {
        return this.mCondition;
    }

    public List<IcfgLocation> getNestedLoops() {
        return this.mNestedLoops;
    }

    public SymbolicMemory getSymbolicMemory() {
        return this.mSymbolicMemory;
    }

    public Term getAbstractPathCondition() {
        return this.mAbstractPathCondition;
    }

    public Boolean isNested() {
        return this.mIsNested;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(" { ");
        for (IcfgLocation node : this.mNodes) {
            b.append(node + " -> ");
        }
        b.append(this.mPath.getLast().getTarget() + " } ");
        return b.toString();
    }
}

