/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.werner;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.werner.Backbone;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.werner.Loop;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Util;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class IteratedSymbolicMemory {
    private final IUltimateServiceProvider mServices;
    private final Map<IProgramVar, Term> mIteratedMemory;
    private final Map<IProgramVar, Term> mMemoryMapping;
    private final Map<IProgramVar, TermVariable> mInVars;
    private final Map<IProgramVar, TermVariable> mOutVars;
    private final Loop mLoop;
    private final List<TermVariable> mPathCounters;
    private final Map<TermVariable, TermVariable> mNewPathCounters;
    private final ManagedScript mScript;
    private final ILogger mLogger;
    private Term mAbstractPathCondition;
    private UnmodifiableTransFormula mAbstractFormula;
    private boolean mOverapprox;
    private final List<Term> mTerms;
    private final List<IProgramVar> mIllegal;

    public IteratedSymbolicMemory(ManagedScript script, IUltimateServiceProvider services, ILogger logger, Loop loop, List<TermVariable> pathCounters, Map<TermVariable, TermVariable> newPathCounter) {
        this.mServices = services;
        this.mLogger = logger;
        this.mIteratedMemory = new HashMap<IProgramVar, Term>();
        this.mPathCounters = pathCounters;
        this.mNewPathCounters = newPathCounter;
        this.mScript = script;
        this.mAbstractPathCondition = this.mScript.getScript().term("true", new Term[0]);
        this.mLoop = loop;
        this.mInVars = this.mLoop.getInVars();
        this.mOutVars = this.mLoop.getOutVars();
        this.mAbstractFormula = null;
        this.mOverapprox = false;
        this.mTerms = new ArrayList<Term>();
        this.mIllegal = new ArrayList<IProgramVar>();
        if (pathCounters.size() > 1) {
            this.mOverapprox = true;
        }
        this.mMemoryMapping = new HashMap<IProgramVar, Term>();
        for (Map.Entry<IProgramVar, TermVariable> entry : this.mInVars.entrySet()) {
            this.mMemoryMapping.put(entry.getKey(), (Term)entry.getValue());
        }
        for (Map.Entry<IProgramVar, TermVariable> entry : this.mOutVars.entrySet()) {
            if (this.mMemoryMapping.containsKey(entry.getKey())) continue;
            this.mMemoryMapping.put(entry.getKey(), (Term)entry.getValue());
        }
        for (Map.Entry<IProgramVar, TermVariable> entry : this.mMemoryMapping.entrySet()) {
            this.mIteratedMemory.put(entry.getKey(), null);
        }
    }

    public void updateMemory() {
        for (Map.Entry<IProgramVar, Term> entry : this.mIteratedMemory.entrySet()) {
            Term symbol;
            Term update = symbol = this.mMemoryMapping.get(entry.getKey());
            caseType currentType = caseType.NOT_CHANGED;
            caseType prevCase = caseType.NOT_CHANGED;
            for (Backbone backbone : this.mLoop.getBackbones()) {
                if (!currentType.equals((Object)prevCase) && !prevCase.equals((Object)caseType.NOT_CHANGED)) {
                    update = null;
                    this.mLogger.debug((Object)("None of the cases applicable " + entry.getKey() + " value = unknown"));
                    break;
                }
                Term memory = backbone.getSymbolicMemory().getValue(entry.getKey());
                TransFormula backboneTf = backbone.getFormula();
                if (memory == null || memory.equals(symbol) || memory instanceof TermVariable) continue;
                if (memory instanceof ConstantTerm || !backboneTf.getAssignedVars().contains(entry.getKey())) {
                    update = memory;
                    prevCase = currentType;
                    currentType = caseType.CONSTANT_ASSIGNMENT;
                    this.mOverapprox = true;
                    this.mLogger.debug((Object)"Assignment");
                    continue;
                }
                if ("+".equals(((ApplicationTerm)memory).getFunction().getName())) {
                    this.mLogger.debug((Object)"Addition");
                    update = this.mScript.getScript().term("+", new Term[]{update, this.mScript.getScript().term("*", new Term[]{((ApplicationTerm)memory).getParameters()[1], backbone.getPathCounter()})});
                    prevCase = currentType;
                    currentType = caseType.ADDITION;
                }
                if ("-".equals(((ApplicationTerm)memory).getFunction().getName())) {
                    this.mLogger.debug((Object)"Subtraction");
                    update = this.mScript.getScript().term("-", new Term[]{update, this.mScript.getScript().term("*", new Term[]{((ApplicationTerm)memory).getParameters()[1], backbone.getPathCounter()})});
                    prevCase = currentType;
                    currentType = caseType.SUBTRACTION;
                }
                if ("*".equals(((ApplicationTerm)memory).getFunction().getName())) {
                    this.mIllegal.add(entry.getKey());
                    this.mLogger.debug((Object)"Multiplication");
                    update = this.mScript.getScript().term("*", new Term[]{update, this.mScript.getScript().term("*", new Term[]{((ApplicationTerm)memory).getParameters()[0], backbone.getPathCounter()})});
                    prevCase = currentType;
                    currentType = caseType.MULTIPLICATION;
                }
                if (Arrays.asList(((ApplicationTerm)memory).getParameters()).contains(symbol) || !Arrays.asList(((ApplicationTerm)memory).getParameters()).contains(backbone.getPathCounter())) continue;
                this.mLogger.debug((Object)"Constant assignment");
                HashMap<TermVariable, Term> mapping = new HashMap<TermVariable, Term>();
                Term newMapping = this.mScript.getScript().term("-", new Term[]{backbone.getPathCounter(), Rational.ONE.toTerm(SmtSortUtils.getIntSort((ManagedScript)this.mScript))});
                mapping.put(backbone.getPathCounter(), newMapping);
                update = Substitution.apply((ManagedScript)this.mScript, mapping, (Term)memory);
            }
            this.mIteratedMemory.replace(entry.getKey(), update);
        }
        for (IProgramVar var : this.mIllegal) {
            this.mOverapprox = true;
            this.mIteratedMemory.remove(var);
            this.mMemoryMapping.remove(var);
        }
    }

    public void updateCondition() {
        for (Backbone backbone : this.mLoop.getBackbones()) {
            ArrayList<TermVariable> freeVars = new ArrayList<TermVariable>();
            ArrayList<Term> terms = new ArrayList<Term>();
            Term condition = this.mLoop.updateVars(backbone.getCondition().getFormula(), backbone.getCondition().getInVars(), backbone.getCondition().getOutVars());
            TermVariable[] termVariableArray = condition.getFreeVars();
            int n = termVariableArray.length;
            int n2 = 0;
            while (n2 < n) {
                TermVariable var = termVariableArray[n2];
                if (this.mPathCounters.contains(var)) {
                    freeVars.add(var);
                }
                ++n2;
            }
            if (condition instanceof QuantifiedFormula) {
                condition = ((QuantifiedFormula)condition).getSubformula();
            }
            HashMap<Object, Term> mapping = new HashMap<Object, Term>();
            ApplicationTerm appTerm = (ApplicationTerm)condition;
            Term[] termArray = appTerm.getParameters();
            int n3 = termArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Term term = termArray[n4];
                mapping.putAll(this.termUnravel(term));
                ++n4;
            }
            Term newCondition = Substitution.apply((ManagedScript)this.mScript, mapping, (Term)appTerm);
            mapping.clear();
            mapping.put(backbone.getPathCounter(), (Term)this.mNewPathCounters.get(backbone.getPathCounter()));
            newCondition = Substitution.apply((ManagedScript)this.mScript, mapping, (Term)newCondition);
            ArrayList<TermVariable> tempPathCounters = new ArrayList<TermVariable>(this.mPathCounters);
            tempPathCounters.remove(backbone.getPathCounter());
            ArrayList<TermVariable> tempNewPathCounters = new ArrayList<TermVariable>(this.mNewPathCounters.values());
            tempNewPathCounters.remove(this.mNewPathCounters.get(backbone.getPathCounter()));
            Term t1 = this.mScript.getScript().term("<", new Term[]{(Term)this.mNewPathCounters.get(backbone.getPathCounter()), backbone.getPathCounter()});
            Term t2 = this.mScript.getScript().term("<=", new Term[]{Rational.ZERO.toTerm(SmtSortUtils.getIntSort((ManagedScript)this.mScript)), (Term)this.mNewPathCounters.get(backbone.getPathCounter())});
            Term tFirstPart = this.mScript.getScript().term("and", new Term[]{t1, t2});
            for (TermVariable var : tempPathCounters) {
                terms.add(this.mScript.getScript().term("<=", new Term[]{Rational.ZERO.toTerm(SmtSortUtils.getIntSort((ManagedScript)this.mScript)), (Term)this.mNewPathCounters.get(var), var}));
            }
            for (TermVariable var : freeVars) {
                terms.add(this.mScript.getScript().term("<=", new Term[]{Rational.ZERO.toTerm(SmtSortUtils.getIntSort((ManagedScript)this.mScript)), var}));
            }
            terms.add(newCondition);
            Term tBackPart = SmtUtils.and((Script)this.mScript.getScript(), terms);
            terms.clear();
            if (!freeVars.isEmpty()) {
                tBackPart = this.mScript.getScript().quantifier(0, freeVars.toArray(new TermVariable[freeVars.size()]), tBackPart, (Term[][])new Term[0][]);
            }
            terms.add(tBackPart);
            tBackPart = SmtUtils.and((Script)this.mScript.getScript(), terms);
            terms.clear();
            if (!tempNewPathCounters.isEmpty()) {
                tBackPart = this.mScript.getScript().quantifier(0, tempNewPathCounters.toArray(new TermVariable[tempNewPathCounters.size()]), tBackPart, (Term[][])new Term[0][]);
            }
            terms.add(tBackPart);
            tBackPart = SmtUtils.and((Script)this.mScript.getScript(), terms);
            tFirstPart = Util.implies((Script)this.mScript.getScript(), (Term[])new Term[]{tFirstPart, tBackPart});
            TermVariable[] vars = new TermVariable[]{this.mNewPathCounters.get(backbone.getPathCounter())};
            Term necessaryCondition = this.mScript.getScript().quantifier(1, vars, tFirstPart, (Term[][])new Term[0][]);
            this.mTerms.add(PartialQuantifierElimination.eliminateCompat((IUltimateServiceProvider)this.mServices, (ManagedScript)this.mScript, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA, (Term)necessaryCondition));
        }
        TransFormulaBuilder tfb = new TransFormulaBuilder(this.mInVars, this.mOutVars, true, null, true, null, false);
        ArrayList<Term> terms = new ArrayList<Term>();
        for (Map.Entry<IProgramVar, TermVariable> outvar : this.mOutVars.entrySet()) {
            if (IteratedSymbolicMemory.checkIfVarContained(outvar.getValue(), this.mAbstractPathCondition) || !this.mIteratedMemory.containsKey(outvar.getKey())) continue;
            terms.add(this.mScript.getScript().term("=", new Term[]{(Term)outvar.getValue(), this.mIteratedMemory.get(outvar.getKey())}));
        }
        for (TermVariable pathCounter : this.mPathCounters) {
            terms.add(this.mScript.getScript().term("<=", new Term[]{Rational.ZERO.toTerm(SmtSortUtils.getIntSort((ManagedScript)this.mScript)), pathCounter}));
        }
        this.mAbstractPathCondition = SmtUtils.or((Script)this.mScript.getScript(), (Term[])this.mTerms.toArray(new Term[this.mTerms.size()]));
        terms.add(this.mAbstractPathCondition);
        this.mAbstractPathCondition = SmtUtils.and((Script)this.mScript.getScript(), (Term[])terms.toArray(new Term[terms.size()]));
        tfb.setFormula(this.mAbstractPathCondition);
        tfb.setInfeasibility(UnmodifiableTransFormula.Infeasibility.NOT_DETERMINED);
        tfb.addAuxVarsButRenameToFreshCopies(this.mNewPathCounters.keySet(), this.mScript);
        HashSet<TermVariable> values = new HashSet<TermVariable>(this.mLoop.getVars());
        tfb.addAuxVarsButRenameToFreshCopies(values, this.mScript);
        this.mAbstractFormula = tfb.finishConstruction(this.mScript);
        this.mLogger.debug((Object)("ITERATEDSYMBOLIC MEMORY: " + this.mAbstractPathCondition));
    }

    public Term updateBackboneTerm(Backbone backbone) {
        Term condition = backbone.getFormula().getFormula();
        Map<Term, Term> subMapping = this.termUnravel(condition);
        return Substitution.apply((ManagedScript)this.mScript, subMapping, (Term)condition);
    }

    private static boolean checkIfVarContained(TermVariable tv, Term term) {
        Term t = term;
        if (t instanceof TermVariable) {
            return t.equals(tv);
        }
        if (t instanceof ConstantTerm) {
            return false;
        }
        if (t instanceof QuantifiedFormula) {
            t = ((QuantifiedFormula)t).getSubformula();
        }
        ArrayDeque<Term> stack = new ArrayDeque<Term>();
        stack.addAll(Arrays.asList(((ApplicationTerm)t).getParameters()));
        while (!stack.isEmpty()) {
            Term subTerm = (Term)stack.pop();
            if (subTerm instanceof ConstantTerm || subTerm instanceof TermVariable) continue;
            if (subTerm instanceof QuantifiedFormula) {
                subTerm = ((QuantifiedFormula)subTerm).getSubformula();
            }
            if (Arrays.asList(((ApplicationTerm)subTerm).getParameters()).contains(tv) && "=".equals(((ApplicationTerm)subTerm).getFunction().getName())) {
                return true;
            }
            stack.addAll(Arrays.asList(((ApplicationTerm)subTerm).getParameters()));
        }
        return false;
    }

    private Map<Term, Term> termUnravel(Term term) {
        HashMap<Term, Term> result = new HashMap<Term, Term>();
        if (term instanceof QuantifiedFormula || term instanceof ConstantTerm) {
            return result;
        }
        if (term instanceof TermVariable) {
            TermVariable tv = (TermVariable)term;
            for (Map.Entry<IProgramVar, Term> entry : this.mMemoryMapping.entrySet()) {
                if (!tv.equals(entry.getValue()) || this.mIteratedMemory.get(entry.getKey()) instanceof ConstantTerm) continue;
                result.put(term, this.mIteratedMemory.get(entry.getKey()));
                break;
            }
            return result;
        }
        ArrayDeque<Term> stack = new ArrayDeque<Term>();
        stack.add(term);
        while (!stack.isEmpty()) {
            Term subTerm = (Term)stack.pop();
            if (subTerm instanceof ConstantTerm || subTerm instanceof TermVariable) continue;
            if (subTerm instanceof QuantifiedFormula) {
                subTerm = ((QuantifiedFormula)subTerm).getSubformula();
            }
            for (Map.Entry<IProgramVar, Term> entry : this.mMemoryMapping.entrySet()) {
                if (!Arrays.asList(((ApplicationTerm)subTerm).getParameters()).contains(entry.getValue()) || this.mIteratedMemory.get(entry.getKey()) instanceof ConstantTerm) continue;
                Sort sort = subTerm.getSort();
                if (sort.equals(this.mScript.getScript().sort("Int", new Sort[0]))) {
                    result.put(subTerm, this.mIteratedMemory.get(entry.getKey()));
                }
                if (!sort.equals(this.mScript.getScript().sort("Bool", new Sort[0]))) continue;
                Term[] termArray = ((ApplicationTerm)subTerm).getParameters();
                int n = termArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Term t = termArray[n2];
                    result.putAll(this.termUnravel(t));
                    ++n2;
                }
            }
            stack.addAll(Arrays.asList(((ApplicationTerm)subTerm).getParameters()));
        }
        return result;
    }

    public Term updateBackboneTerm(TransFormula tf) {
        Term condition = tf.getFormula();
        Map<Term, Term> subMapping = this.termUnravel(condition);
        return Substitution.apply((ManagedScript)this.mScript, subMapping, (Term)condition);
    }

    public Map<IProgramVar, Term> getIteratedMemory() {
        return this.mIteratedMemory;
    }

    public List<TermVariable> getPathCounters() {
        return this.mPathCounters;
    }

    public Term getAbstractCondition() {
        return this.mAbstractPathCondition;
    }

    public UnmodifiableTransFormula getAbstractFormula() {
        return this.mAbstractFormula;
    }

    public boolean isOverapprox() {
        return this.mOverapprox;
    }

    private static enum caseType {
        NOT_CHANGED,
        ADDITION,
        SUBTRACTION,
        MULTIPLICATION,
        CONSTANT_ASSIGNMENT,
        CONSTANT_ASSIGNMENT_PATHCOUNTER;

    }
}

