/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.werner;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.werner.Backbone;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.werner.IteratedSymbolicMemory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Loop {
    private final IcfgLocation mLoopHead;
    private final ManagedScript mScript;
    private Term mCondition;
    private Set<IcfgEdge> mPath = null;
    private final Set<IcfgLocation> mNodes = new HashSet<IcfgLocation>();
    private Deque<Backbone> mBackbones;
    private IteratedSymbolicMemory mIteratedMemory;
    private final List<TermVariable> mAuxVars;
    private final Map<IcfgLocation, Backbone> mErrorPaths;
    private final Deque<Loop> mNestedLoops;
    private Map<IProgramVar, TermVariable> mInVars;
    private Map<IProgramVar, TermVariable> mOutVars;
    private IcfgLocation mLoopExit;
    private final List<IcfgEdge> mExitTransitions;
    private final List<UnmodifiableTransFormula> mExitConditions;
    private UnmodifiableTransFormula mFormula;

    public Loop(IcfgLocation loopHead, ManagedScript script) {
        this.mLoopHead = loopHead;
        this.mScript = script;
        this.mBackbones = new ArrayDeque<Backbone>();
        this.mCondition = null;
        this.mIteratedMemory = null;
        this.mAuxVars = new ArrayList<TermVariable>();
        this.mErrorPaths = new HashMap<IcfgLocation, Backbone>();
        this.mNestedLoops = new ArrayDeque<Loop>();
        this.mInVars = new HashMap<IProgramVar, TermVariable>();
        this.mOutVars = new HashMap<IProgramVar, TermVariable>();
        this.mLoopExit = null;
        this.mExitConditions = new ArrayList<UnmodifiableTransFormula>();
        this.mExitTransitions = new ArrayList<IcfgEdge>();
        this.mFormula = null;
    }

    public Term updateVars(Term t, Map<IProgramVar, TermVariable> inVars, Map<IProgramVar, TermVariable> outVars) {
        if (SmtUtils.isFalseLiteral((Term)t)) {
            return t;
        }
        HashMap<IProgramVar, TermVariable> newInVars = new HashMap<IProgramVar, TermVariable>(this.mInVars);
        HashMap<IProgramVar, TermVariable> newOutVars = new HashMap<IProgramVar, TermVariable>(this.mOutVars);
        HashMap<Term, Term> subMapping = new HashMap<Term, Term>();
        for (Map.Entry<IProgramVar, TermVariable> oldVar : inVars.entrySet()) {
            if (this.mInVars.containsKey(oldVar.getKey()) && this.mInVars.get(oldVar.getKey()).equals(this.mOutVars.get(oldVar.getKey())) && !outVars.get(oldVar.getKey()).equals(inVars.get(oldVar.getKey()))) {
                newInVars.put(oldVar.getKey(), this.mInVars.get(oldVar.getKey()));
                newOutVars.put(oldVar.getKey(), outVars.get(oldVar.getKey()));
                subMapping.put((Term)oldVar.getValue(), (Term)this.mInVars.get(oldVar.getKey()));
                continue;
            }
            if (!this.mInVars.containsKey(oldVar.getKey())) {
                newInVars.put(oldVar.getKey(), oldVar.getValue());
                subMapping.put((Term)oldVar.getValue(), (Term)oldVar.getValue());
                continue;
            }
            newInVars.put(oldVar.getKey(), this.mInVars.get(oldVar.getKey()));
            subMapping.put((Term)oldVar.getValue(), (Term)this.mInVars.get(oldVar.getKey()));
        }
        for (Map.Entry<IProgramVar, TermVariable> oldVar : outVars.entrySet()) {
            if (this.mInVars.containsKey(oldVar.getKey()) && this.mInVars.get(oldVar.getKey()).equals(this.mOutVars.get(oldVar.getKey())) && !outVars.get(oldVar.getKey()).equals(inVars.get(oldVar.getKey()))) continue;
            if (!this.mOutVars.containsKey(oldVar.getKey())) {
                newOutVars.put(oldVar.getKey(), oldVar.getValue());
                subMapping.put((Term)oldVar.getValue(), (Term)oldVar.getValue());
                continue;
            }
            newOutVars.put(oldVar.getKey(), this.mOutVars.get(oldVar.getKey()));
            subMapping.put((Term)oldVar.getValue(), (Term)this.mOutVars.get(oldVar.getKey()));
        }
        this.setInVars(newInVars);
        this.setOutVars(newOutVars);
        return Substitution.apply((ManagedScript)this.mScript, subMapping, (Term)t);
    }

    public void setBackbones(Deque<Backbone> backbones) {
        this.mBackbones = backbones;
    }

    public Set<IcfgEdge> getPath() {
        return this.mPath;
    }

    public Deque<Backbone> getBackbones() {
        return this.mBackbones;
    }

    public Term getCondition() {
        return this.mCondition;
    }

    public Map<IcfgLocation, Backbone> getErrorPaths() {
        return this.mErrorPaths;
    }

    public IteratedSymbolicMemory getIteratedMemory() {
        return this.mIteratedMemory;
    }

    public UnmodifiableTransFormula getFormula() {
        return this.mFormula;
    }

    public List<TermVariable> getVars() {
        return this.mAuxVars;
    }

    public Map<IProgramVar, TermVariable> getInVars() {
        return this.mInVars;
    }

    public Map<IProgramVar, TermVariable> getOutVars() {
        return this.mOutVars;
    }

    public IcfgLocation getLoopExit() {
        return this.mLoopExit;
    }

    public List<UnmodifiableTransFormula> getExitConditions() {
        return this.mExitConditions;
    }

    public List<IcfgEdge> getExitTransitions() {
        return this.mExitTransitions;
    }

    public IcfgLocation getLoophead() {
        return this.mLoopHead;
    }

    public Deque<Loop> getNestedLoops() {
        return this.mNestedLoops;
    }

    public void setPath(Set<IcfgEdge> path) {
        this.mPath = path;
        for (IcfgEdge edge : path) {
            this.mNodes.add((IcfgLocation)edge.getSource());
        }
    }

    public void setLoopExit(IcfgLocation icfgLocation) {
        for (IcfgEdge edge : icfgLocation.getIncomingEdges()) {
            if (!this.mNodes.contains(edge.getSource())) continue;
            this.mExitTransitions.add(edge);
        }
        this.mLoopExit = icfgLocation;
    }

    public void addExitCondition(UnmodifiableTransFormula exitCondition) {
        this.mExitConditions.add(exitCondition);
    }

    public void addErrorPath(IcfgLocation errorLocation, Backbone errorPath) {
        this.mErrorPaths.put(errorLocation, errorPath);
    }

    public void replaceErrorPath(IcfgLocation errorLocation, Backbone newErrorPath) {
        this.mErrorPaths.replace(errorLocation, newErrorPath);
    }

    public void addNestedLoop(Loop loop) {
        if (!this.mNestedLoops.contains(loop)) {
            this.mNestedLoops.addLast(loop);
        }
    }

    public void setFormula(UnmodifiableTransFormula tf) {
        this.mFormula = tf;
    }

    public void setCondition(Term condition) {
        this.mCondition = condition;
    }

    public void setInVars(Map<IProgramVar, TermVariable> inVars) {
        this.mInVars = inVars;
    }

    public void setOutVars(Map<IProgramVar, TermVariable> outVars) {
        this.mOutVars = outVars;
    }

    public void setIteratedSymbolicMemory(IteratedSymbolicMemory memory) {
        this.mIteratedMemory = memory;
    }

    public void addVar(List<TermVariable> vars) {
        this.mAuxVars.addAll(vars);
    }

    public String toString() {
        return this.mPath.toString();
    }

    public String backbonesToString() {
        StringBuilder str = new StringBuilder();
        for (Backbone backbone : this.mBackbones) {
            str.append(backbone.toString());
        }
        return str.toString();
    }
}

