/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.werner;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.werner.Backbone;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.werner.IteratedSymbolicMemory;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.werner.Loop;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.werner.SymbolicMemory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.SimultaneousUpdate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LoopAcceleratorLite {
    private final List<TermVariable> mPathCounter;
    private final Map<TermVariable, TermVariable> mNewPathCounter = new HashMap<TermVariable, TermVariable>();
    private final ManagedScript mScript;
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private final IIcfgSymbolTable mOldSymbolTable;

    public LoopAcceleratorLite(ManagedScript script, IUltimateServiceProvider services, ILogger logger, IIcfgSymbolTable oldSymbolTable) {
        this.mPathCounter = new ArrayList<TermVariable>();
        this.mScript = script;
        this.mServices = services;
        this.mLogger = logger;
        this.mOldSymbolTable = oldSymbolTable;
    }

    public UnmodifiableTransFormula summarizeLoop(Loop loop) {
        this.mPathCounter.clear();
        this.mNewPathCounter.clear();
        if (SmtUtils.isTrueLiteral((Term)loop.getFormula().getFormula()) || SmtUtils.isFalseLiteral((Term)loop.getFormula().getFormula())) {
            return null;
        }
        for (Backbone backbone : loop.getBackbones()) {
            this.calculateSymbolicMemory(backbone, loop);
            if (backbone.getCondition() != null) continue;
            return null;
        }
        int i = 0;
        while (i < this.mPathCounter.size()) {
            TermVariable newBackbonePathCounter = this.mScript.constructFreshTermVariable("tau", this.mScript.getScript().sort("Int", new Sort[0]));
            this.mNewPathCounter.put(this.mPathCounter.get(i), newBackbonePathCounter);
            ++i;
        }
        loop.addVar(this.mPathCounter);
        ArrayList<TermVariable> newPathCounterVals = new ArrayList<TermVariable>(this.mNewPathCounter.values());
        loop.addVar(newPathCounterVals);
        ArrayList<TermVariable> pathCounters = new ArrayList<TermVariable>(this.mPathCounter);
        IteratedSymbolicMemory iteratedSymbolicMemory = new IteratedSymbolicMemory(this.mScript, this.mServices, this.mLogger, loop, pathCounters, this.mNewPathCounter);
        iteratedSymbolicMemory.updateMemory();
        iteratedSymbolicMemory.updateCondition();
        Term loopSummary = iteratedSymbolicMemory.getAbstractCondition();
        if (!loop.getNestedLoops().isEmpty()) {
            for (Loop nestedLoop : loop.getNestedLoops()) {
                for (UnmodifiableTransFormula exitTerm : nestedLoop.getExitConditions()) {
                    loopSummary = SmtUtils.or((Script)this.mScript.getScript(), Arrays.asList(loopSummary, exitTerm.getFormula()));
                    ArrayList<TermVariable> newAuxVars = new ArrayList<TermVariable>(exitTerm.getAuxVars());
                    loop.addVar(newAuxVars);
                    loopSummary = loop.updateVars(loopSummary, exitTerm.getInVars(), exitTerm.getOutVars());
                }
                Map<IProgramVar, TermVariable> oldOutVars = loop.getOutVars();
                for (Map.Entry<IProgramVar, TermVariable> outVarNested : nestedLoop.getOutVars().entrySet()) {
                    if (oldOutVars.containsKey(outVarNested.getKey())) continue;
                    oldOutVars.put(outVarNested.getKey(), outVarNested.getValue());
                }
            }
        }
        HashSet<TermVariable> aux = new HashSet<TermVariable>(loop.getVars());
        UnmodifiableTransFormula exitFormula = LoopAcceleratorLite.buildFormula(this.mScript, loopSummary, loop.getInVars(), loop.getOutVars(), aux);
        return exitFormula;
    }

    private void calculateSymbolicMemory(Backbone backbone, Loop loop) {
        SimultaneousUpdate update;
        try {
            update = SimultaneousUpdate.fromTransFormula((IUltimateServiceProvider)this.mServices, (TransFormula)backbone.getFormula(), (ManagedScript)this.mScript);
        }
        catch (SimultaneousUpdate.SimultaneousUpdateException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        HashSet<TermVariable> aux = new HashSet<TermVariable>(loop.getVars());
        UnmodifiableTransFormula tf = LoopAcceleratorLite.buildFormula(this.mScript, loop.updateVars(backbone.getFormula().getFormula(), backbone.getFormula().getInVars(), backbone.getFormula().getOutVars()), loop.getInVars(), loop.getOutVars(), aux);
        backbone.setFormula((TransFormula)tf);
        SymbolicMemory symbolicMemory = new SymbolicMemory(this.mScript, this.mServices, (TransFormula)tf, this.mOldSymbolTable);
        symbolicMemory.updateVars(update.getDeterministicAssignment());
        UnmodifiableTransFormula condition = symbolicMemory.updateCondition(TransFormulaUtils.computeGuard((UnmodifiableTransFormula)tf, (ManagedScript)this.mScript, (IUltimateServiceProvider)this.mServices));
        TermVariable backbonePathCounter = this.mScript.constructFreshTermVariable("kappa", this.mScript.getScript().sort("Int", new Sort[0]));
        this.mPathCounter.add(backbonePathCounter);
        backbone.setPathCounter(backbonePathCounter);
        backbone.setCondition(condition);
        backbone.setSymbolicMemory(symbolicMemory);
    }

    public static UnmodifiableTransFormula buildFormula(ManagedScript script, Term term, Map<IProgramVar, TermVariable> inVars, Map<IProgramVar, TermVariable> outVars, Set<TermVariable> auxVars) {
        Boolean emptyAux = auxVars.isEmpty();
        TransFormulaBuilder tfb = new TransFormulaBuilder(inVars, outVars, true, null, true, null, emptyAux.booleanValue());
        tfb.setFormula(term);
        tfb.addAuxVarsButRenameToFreshCopies(auxVars, script);
        tfb.setInfeasibility(UnmodifiableTransFormula.Infeasibility.NOT_DETERMINED);
        return tfb.finishConstruction(script);
    }
}

